/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.jna;

import org.firebirdsql.encodings.IEncodingFactory;
import org.firebirdsql.gds.ng.DefaultDatatypeCoder;

public final class BigEndianDatatypeCoder
extends DefaultDatatypeCoder {
    public static BigEndianDatatypeCoder forEncodingFactory(IEncodingFactory encodingFactory) {
        return encodingFactory.getOrCreateDatatypeCoder(BigEndianDatatypeCoder.class);
    }

    public BigEndianDatatypeCoder(IEncodingFactory encodingFactory) {
        super(encodingFactory);
    }

    @Override
    public int sizeOfShort() {
        return 2;
    }

    @Override
    public byte[] encodeShort(short value) {
        byte[] ret = new byte[]{(byte)(value >>> 8 & 0xFF), (byte)(value & 0xFF)};
        return ret;
    }

    @Override
    public void encodeShort(int value, byte[] target, int fromIndex) {
        target[fromIndex] = (byte)(value >>> 8 & 0xFF);
        target[fromIndex + 1] = (byte)(value & 0xFF);
    }

    @Override
    public short decodeShort(byte[] byte_int) {
        return (short)(((byte_int[0] & 0xFF) << 8) + (byte_int[1] & 0xFF));
    }

    @Override
    public short decodeShort(byte[] bytes, int fromIndex) {
        return (short)(((bytes[fromIndex] & 0xFF) << 8) + (bytes[fromIndex + 1] & 0xFF));
    }
}

