/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.objects;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.ToDisplayStringFormat;
import com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import com.oracle.truffle.js.runtime.objects.JSCopyableObject;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSNonProxyObject;
import com.oracle.truffle.js.runtime.objects.JSObject;

public abstract class JSOrdinaryObject
extends JSNonProxyObject
implements JSCopyableObject {
    protected JSOrdinaryObject(Shape shape, JSDynamicObject proto) {
        super(shape, proto);
    }

    public static JSOrdinaryObject create(Shape shape, JSDynamicObject proto) {
        Class layout = shape.getLayoutClass();
        if (layout == DefaultLayout.class) {
            return new DefaultLayout(shape, proto);
        }
        if (layout == InternalFieldLayout.class) {
            return new InternalFieldLayout(shape, proto);
        }
        return new BareLayout(shape, proto);
    }

    public static JSOrdinaryObject createWithDefaultLayout(Shape shape, JSDynamicObject proto) {
        assert (DefaultLayout.class == shape.getLayoutClass()) : shape.getLayoutClass();
        return new DefaultLayout(shape, proto);
    }

    @Override
    public TruffleString getClassName() {
        return JSOrdinary.CLASS_NAME;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public TruffleString toDisplayStringImpl(boolean allowSideEffects, ToDisplayStringFormat format, int depth) {
        if (JavaScriptLanguage.get(null).getJSContext().isOptionNashornCompatibilityMode()) {
            return this.defaultToString();
        }
        return JSRuntime.objectToDisplayString(this, allowSideEffects, format, depth, null);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Object getValue(long index) {
        return this.getValue(Strings.fromLong(index));
    }

    @Override
    public final boolean hasOnlyShapeProperties() {
        return true;
    }

    public static final class DefaultLayout
    extends JSOrdinaryObject {
        @DynamicObject.DynamicField
        Object o0;
        @DynamicObject.DynamicField
        Object o1;
        @DynamicObject.DynamicField
        Object o2;
        @DynamicObject.DynamicField
        Object o3;
        @DynamicObject.DynamicField
        long p0;
        @DynamicObject.DynamicField
        long p1;
        @DynamicObject.DynamicField
        long p2;

        protected DefaultLayout(Shape shape, JSDynamicObject proto) {
            super(shape, proto);
        }

        @Override
        protected JSObject copyWithoutProperties(Shape shape) {
            return new DefaultLayout(shape, this.getPrototypeOf());
        }
    }

    public static final class InternalFieldLayout
    extends JSOrdinaryObject {
        @DynamicObject.DynamicField
        Object o0;
        @DynamicObject.DynamicField
        Object o1;
        @DynamicObject.DynamicField
        Object o2;
        private static final long[] EMPTY_LONG_ARRAY = new long[0];
        private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
        private long[] internalPointerFields = EMPTY_LONG_ARRAY;
        private Object[] internalObjectFields = EMPTY_OBJECT_ARRAY;

        protected InternalFieldLayout(Shape shape, JSDynamicObject proto) {
            super(shape, proto);
        }

        @Override
        protected JSObject copyWithoutProperties(Shape shape) {
            return new InternalFieldLayout(shape, this.getPrototypeOf());
        }

        public long getInternalFieldPointer(int index) {
            return this.internalPointerFields[index];
        }

        public void setInternalFieldPointer(int index, long value) {
            this.internalPointerFields[index] = value;
        }

        public Object getInternalFieldObject(int index) {
            if (index >= this.internalObjectFields.length) {
                return null;
            }
            return this.internalObjectFields[index];
        }

        public void setInternalFieldObject(int index, Object value) {
            if (this.internalObjectFields.length == 0) {
                this.internalObjectFields = new Object[this.getInternalFieldCount()];
            }
            this.internalObjectFields[index] = value;
        }

        public int getInternalFieldCount() {
            return this.internalPointerFields.length;
        }

        public void setInternalFieldCount(int internalFieldCount) {
            assert (this.getInternalFieldCount() == 0);
            this.internalPointerFields = new long[internalFieldCount];
        }
    }

    public static final class BareLayout
    extends JSOrdinaryObject {
        protected BareLayout(Shape shape, JSDynamicObject proto) {
            super(shape, proto);
        }

        @Override
        protected JSObject copyWithoutProperties(Shape shape) {
            return new BareLayout(shape, this.getPrototypeOf());
        }
    }
}

