/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.getsetdescriptor;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.getsetdescriptor.DescriptorBuiltins;
import com.oracle.graal.python.builtins.objects.getsetdescriptor.GetSetDescriptor;
import com.oracle.graal.python.builtins.objects.getsetdescriptor.MemberDescriptorBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.getsetdescriptor.MemberDescriptorBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.object.ObjectNodes;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotDescrGet;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotDescrSet;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.attributes.ReadAttributeFromObjectNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.MemberDescriptor})
public final class MemberDescriptorBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = MemberDescriptorBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return MemberDescriptorBuiltinsFactory.getFactories();
    }

    @Slot(value=Slot.SlotKind.tp_descr_set, isComplex=true)
    @GenerateNodeFactory
    static abstract class DescrSet
    extends TpSlotDescrSet.DescrSetBuiltinNode {
        DescrSet() {
        }

        @Specialization(guards={"!isNoValue(value)"})
        static void doGetSetDescriptorSet(VirtualFrame frame, GetSetDescriptor descr, Object obj, Object value, @Bind Node inliningTarget, @Cached.Shared @Cached DescriptorBuiltins.DescriptorCheckNode descriptorCheckNode, @Cached DescriptorBuiltins.DescrSetNode setNode) {
            descriptorCheckNode.execute(inliningTarget, descr.getType(), descr.getName(), obj);
            setNode.execute(frame, descr, obj, value);
        }

        @Specialization(guards={"isNoValue(value)"})
        static void doGetSetDescriptorDel(VirtualFrame frame, GetSetDescriptor descr, Object obj, Object value, @Bind Node inliningTarget, @Cached.Shared @Cached DescriptorBuiltins.DescriptorCheckNode descriptorCheckNode, @Cached DescriptorBuiltins.DescrDeleteNode deleteNode) {
            descriptorCheckNode.execute(inliningTarget, descr.getType(), descr.getName(), obj);
            deleteNode.execute(frame, descr, obj);
        }
    }

    @Slot(value=Slot.SlotKind.tp_descr_get, isComplex=true)
    @GenerateUncached
    @GenerateNodeFactory
    static abstract class MemberGetNode
    extends TpSlotDescrGet.DescrGetBuiltinNode {
        MemberGetNode() {
        }

        @Specialization(guards={"isNoValue(obj)"})
        static Object doNone(Object descr, PNone obj, Object type) {
            return descr;
        }

        @Specialization(guards={"!isNoValue(obj)"})
        static Object doGetSetDescriptor(VirtualFrame frame, GetSetDescriptor descr, Object obj, Object type, @Bind Node inliningTarget, @Cached DescriptorBuiltins.DescriptorCheckNode descriptorCheckNode, @Cached DescriptorBuiltins.DescrGetNode getNode) {
            descriptorCheckNode.execute(inliningTarget, descr.getType(), descr.getName(), obj);
            return getNode.execute(frame, descr, obj);
        }
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class MemberDescriptorReduceNode
    extends PythonUnaryBuiltinNode {
        MemberDescriptorReduceNode() {
        }

        @Specialization
        Object doGeneric(GetSetDescriptor descr, @Cached ReadAttributeFromObjectNode readAttributeFromObjectNode, @Cached ObjectNodes.GetIdNode getIdNode, @Bind PythonLanguage language) {
            Object getattr = readAttributeFromObjectNode.execute(this.getContext().getBuiltins(), BuiltinNames.T_GETATTR);
            Object id = getIdNode.execute(getattr);
            return PFactory.createTuple(language, new Object[]{id, PFactory.createTuple(language, new Object[]{descr.getType(), descr.getName()})});
        }
    }

    @Slot(value=Slot.SlotKind.tp_repr, isComplex=true)
    @GenerateNodeFactory
    static abstract class MemberDescriptorReprNode
    extends PythonUnaryBuiltinNode {
        MemberDescriptorReprNode() {
        }

        @Specialization
        static TruffleString repr(GetSetDescriptor descr, @Bind Node inliningTarget, @Cached TypeNodes.GetNameNode getName, @Cached StringUtils.SimpleTruffleStringFormatNode simpleTruffleStringFormatNode) {
            return simpleTruffleStringFormatNode.format("<member '%s' of '%s' objects>", descr.getName(), getName.execute(inliningTarget, descr.getType()));
        }
    }
}

