/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.compiler;

import com.oracle.graal.python.compiler.Block;
import com.oracle.graal.python.pegparser.sst.StmtTy;

class BlockInfo {
    BlockInfo outer;

    BlockInfo() {
    }

    AbstractExceptionHandler findExceptionHandler() {
        if (this.outer != null) {
            return this.outer.findExceptionHandler();
        }
        return null;
    }

    static class AbstractExceptionHandler
    extends BlockInfo {
        final Block tryBlock;
        final Block exceptionHandler;

        public AbstractExceptionHandler(Block tryBlock, Block exceptionHandler) {
            this.tryBlock = tryBlock;
            this.exceptionHandler = exceptionHandler;
        }

        @Override
        AbstractExceptionHandler findExceptionHandler() {
            return this;
        }
    }

    static class AsyncForLoopExit
    extends AbstractExceptionHandler {
        public AsyncForLoopExit(Block tryBlock, Block exceptionHandler) {
            super(tryBlock, exceptionHandler);
        }
    }

    static class AsyncForLoop
    extends Loop {
        public AsyncForLoop(Block start, Block after) {
            super(start, after);
        }
    }

    static class TryFinally
    extends AbstractExceptionHandler {
        final StmtTy[] body;

        public TryFinally(Block tryBlock, Block exceptionHandler, StmtTy[] body) {
            super(tryBlock, exceptionHandler);
            this.body = body;
        }
    }

    static class AsyncWith
    extends AbstractExceptionHandler {
        final StmtTy.AsyncWith node;

        public AsyncWith(Block tryBlock, Block exceptionHandler, StmtTy.AsyncWith node) {
            super(tryBlock, exceptionHandler);
            this.node = node;
        }
    }

    static class With
    extends AbstractExceptionHandler {
        final StmtTy.With node;

        public With(Block tryBlock, Block exceptionHandler, StmtTy.With node) {
            super(tryBlock, exceptionHandler);
            this.node = node;
        }
    }

    static class HandlerBindingCleanup
    extends AbstractExceptionHandler {
        final String bindingName;

        public HandlerBindingCleanup(Block tryBlock, Block exceptionHandler, String bindingName) {
            super(tryBlock, exceptionHandler);
            this.bindingName = bindingName;
        }
    }

    static class FinallyHandler
    extends AbstractExceptionHandler {
        public FinallyHandler(Block tryBlock, Block exceptionHandler) {
            super(tryBlock, exceptionHandler);
        }
    }

    static class TryExcept
    extends AbstractExceptionHandler {
        public TryExcept(Block tryBlock, Block exceptionHandler) {
            super(tryBlock, exceptionHandler);
        }
    }

    static class ExceptHandler
    extends AbstractExceptionHandler {
        public ExceptHandler(Block tryBlock, Block exceptionHandler) {
            super(tryBlock, exceptionHandler);
        }
    }

    static class PopValue
    extends BlockInfo {
        PopValue() {
        }
    }

    static class For
    extends Loop {
        public For(Block start, Block after) {
            super(start, after);
        }
    }

    static class While
    extends Loop {
        public While(Block start, Block after) {
            super(start, after);
        }
    }

    static abstract class Loop
    extends BlockInfo {
        final Block start;
        final Block after;

        public Loop(Block start, Block after) {
            this.start = start;
            this.after = after;
        }
    }
}

