/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.WarningsModuleBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAcquireLibrary;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotUnaryFunc;
import com.oracle.graal.python.lib.PyIndexCheckNode;
import com.oracle.graal.python.lib.PyLongCheckExactNode;
import com.oracle.graal.python.lib.PyLongCheckNode;
import com.oracle.graal.python.lib.PyLongCopy;
import com.oracle.graal.python.lib.PyLongFromDoubleNode;
import com.oracle.graal.python.lib.PyLongFromUnicodeObject;
import com.oracle.graal.python.lib.PyNumberIndexNode;
import com.oracle.graal.python.lib.PyNumberLongNodeGen;
import com.oracle.graal.python.lib.PyUnicodeCheckNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.attributes.LookupAttributeInMRONode;
import com.oracle.graal.python.nodes.call.special.CallUnaryMethodNode;
import com.oracle.graal.python.nodes.call.special.MaybeBindDescriptorNode;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;

@GenerateUncached
@GenerateCached(value=false)
@GenerateInline
public abstract class PyNumberLongNode
extends PNodeWithContext {
    public abstract Object execute(Frame var1, Node var2, Object var3);

    public static Object executeUncached(Object object) {
        return PyNumberLongNodeGen.getUncached().execute(null, null, object);
    }

    @Specialization
    static int doInt(int object) {
        return object;
    }

    @Specialization
    static long doLong(long object) {
        return object;
    }

    @Specialization(guards={"isBuiltinPInt(object)"})
    static PInt doPInt(PInt object) {
        return object;
    }

    @Specialization
    static Object doDouble(Node inliningTarget, double object, @Cached PyLongFromDoubleNode fromDoubleNode) {
        return fromDoubleNode.execute(inliningTarget, object);
    }

    @Specialization
    static Object doString(Node inliningTarget, TruffleString string, @Cached PyLongFromUnicodeObject fromUnicodeObject) {
        return fromUnicodeObject.execute(inliningTarget, string, 10);
    }

    @HostCompilerDirectives.InliningCutoff
    @Fallback
    static Object doOther(VirtualFrame frame, Node inliningTarget, Object object, @Cached GetClassNode getClassNode, @Cached TpSlots.GetCachedTpSlotsNode getSlots, @Cached TpSlotUnaryFunc.CallSlotUnaryNode callInt, @Cached PyLongCheckExactNode longCheckExactNode, @Cached PyNumberIndexNode indexNode, @Cached HandleIntResult handleIntResult, @Cached ComplexCasesHelperNode helperNode) {
        Object type = getClassNode.execute(inliningTarget, object);
        TpSlots slots = getSlots.execute(inliningTarget, type);
        if (slots.nb_int() != null) {
            Object result = callInt.execute(frame, inliningTarget, slots.nb_int(), object);
            if (longCheckExactNode.execute(inliningTarget, result)) {
                return result;
            }
            return PyNumberLongNode.handleIntResult(frame, object, handleIntResult, result);
        }
        if (slots.nb_index() != null) {
            return indexNode.execute((Frame)frame, inliningTarget, object);
        }
        return PyNumberLongNode.complexCase(frame, object, helperNode);
    }

    @HostCompilerDirectives.InliningCutoff
    private static Object handleIntResult(VirtualFrame frame, Object object, HandleIntResult handleIntResult, Object result) {
        return handleIntResult.execute(frame, object, result);
    }

    @HostCompilerDirectives.InliningCutoff
    private static Object complexCase(VirtualFrame frame, Object object, ComplexCasesHelperNode helperNode) {
        return helperNode.execute(frame, object);
    }

    @GenerateInline(value=false)
    @GenerateUncached
    static abstract class HandleIntResult
    extends Node {
        HandleIntResult() {
        }

        abstract Object execute(VirtualFrame var1, Object var2, Object var3);

        @Specialization
        static Object doGeneric(VirtualFrame frame, Object original, Object result, @Bind Node inliningTarget, @Cached GetClassNode getClassNode, @Cached IsSubtypeNode isSubtype, @Cached PRaiseNode raiseNode, @Cached WarningsModuleBuiltins.WarnNode warnNode, @Cached PyLongCopy copy) {
            if (!isSubtype.execute(getClassNode.execute(inliningTarget, result), (Object)PythonBuiltinClassType.PInt)) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.RETURNED_NON_INT, "__int__", result);
            }
            warnNode.warnFormat((Frame)frame, null, (Object)PythonBuiltinClassType.DeprecationWarning, 1, ErrorMessages.WARN_P_RETURNED_NON_P, original, "__int__", "int", result, "int");
            return copy.execute(inliningTarget, result);
        }
    }

    @GenerateInline(value=false)
    @GenerateUncached
    static abstract class ComplexCasesHelperNode
    extends Node {
        ComplexCasesHelperNode() {
        }

        abstract Object execute(VirtualFrame var1, Object var2);

        @Specialization
        static Object doGeneric(VirtualFrame frame, Object object, @Bind Node inliningTarget, @Cached GetClassNode getClassNode, @Cached LookupAttributeInMRONode.Dynamic lookup, @Cached WarningsModuleBuiltins.WarnNode warnNode, @Cached CallUnaryMethodNode call, @Cached MaybeBindDescriptorNode bindDescriptorNode, @Cached PyLongCheckExactNode longCheckExactNode, @Cached PyLongCheckNode longCheckNode, @Cached PyLongCopy longCopy, @Cached PyIndexCheckNode indexCheckNode, @Cached PyNumberIndexNode indexNode, @Cached PyUnicodeCheckNode unicodeCheckNode, @Cached PyLongFromUnicodeObject fromUnicodeObject, @Cached LongFromBufferNode fromBufferNode, @Cached PRaiseNode raiseNode) {
            Object type = getClassNode.execute(inliningTarget, object);
            Object truncMethod = lookup.execute(type, SpecialMethodNames.T___TRUNC__);
            if (truncMethod != PNone.NO_VALUE) {
                truncMethod = bindDescriptorNode.execute((Frame)frame, inliningTarget, truncMethod, object, type);
                warnNode.warnEx((Frame)frame, (Object)PythonBuiltinClassType.DeprecationWarning, ErrorMessages.WARN_DELEGATION_OF_INT_TO_TRUNC_IS_DEPRECATED, 1);
                Object result = call.executeObject((Frame)frame, truncMethod, object);
                if (longCheckExactNode.execute(inliningTarget, result)) {
                    return result;
                }
                if (longCheckNode.execute(inliningTarget, result)) {
                    return longCopy.execute(inliningTarget, result);
                }
                if (!indexCheckNode.execute(inliningTarget, result)) {
                    throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.RETURNED_NON_INTEGRAL, "__trunc__", result);
                }
                return indexNode.execute((Frame)frame, inliningTarget, result);
            }
            if (unicodeCheckNode.execute(inliningTarget, object)) {
                return fromUnicodeObject.execute(inliningTarget, object, 10);
            }
            Object result = fromBufferNode.execute(frame, object, 10);
            if (result != null) {
                return result;
            }
            throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.ARG_MUST_BE_STRING_OR_BYTELIKE_OR_NUMBER, "int()", object);
        }
    }

    @GenerateInline(value=false)
    @GenerateUncached
    public static abstract class LongFromBufferNode
    extends Node {
        public abstract Object execute(VirtualFrame var1, Object var2, int var3);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        @HostCompilerDirectives.InliningCutoff
        static Object doGeneric(VirtualFrame frame, Object object, int base, @Bind Node inliningTarget, @Cached TruffleString.FromByteArrayNode fromByteArrayNode, @Cached TruffleString.SwitchEncodingNode switchEncodingNode, @Cached PyLongFromUnicodeObject fromString, @Cached(value="createFor($node)") IndirectCallData indirectCallData, @CachedLibrary(limit="3") PythonBufferAcquireLibrary acquireLib, @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib) {
            Object buffer;
            try {
                buffer = acquireLib.acquireReadonly(object, frame, indirectCallData);
            }
            catch (AbstractTruffleException e) {
                return null;
            }
            try {
                byte[] bytes = bufferLib.getInternalOrCopiedByteArray(buffer);
                int len = bufferLib.getBufferLength(buffer);
                TruffleString string = fromByteArrayNode.execute(bytes, 0, len, TruffleString.Encoding.US_ASCII, false);
                string = switchEncodingNode.execute((AbstractTruffleString)string, PythonUtils.TS_ENCODING);
                Object object2 = fromString.execute(inliningTarget, string, base, bytes, len);
                return object2;
            }
            finally {
                bufferLib.release(buffer);
            }
        }
    }
}

