/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.bytecode;

import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.set.PBaseSet;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.lib.PyObjectIsTrueNode;
import com.oracle.graal.python.nodes.bytecode.NotNodeGen;
import com.oracle.graal.python.nodes.expression.UnaryOpNode;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.bytecode.OperationProxy;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;

@GenerateInline(value=false)
@OperationProxy.Proxyable
public abstract class NotNode
extends UnaryOpNode {
    @Specialization
    public static boolean doBoolean(boolean object) {
        return !object;
    }

    @Specialization
    public static boolean doNone(PNone object) {
        return true;
    }

    @Specialization
    public static boolean doInt(int object) {
        return object == 0;
    }

    @Specialization
    public static boolean doLong(long object) {
        return object == 0L;
    }

    @Specialization
    public static boolean doDouble(double object) {
        return object == 0.0;
    }

    @Specialization
    public static boolean doString(TruffleString object) {
        return object.isEmpty();
    }

    @Specialization(guards={"isBuiltinList(object)"})
    public static boolean doList(PList object) {
        return object.getSequenceStorage().length() == 0;
    }

    @Specialization(guards={"isBuiltinTuple(object)"})
    public static boolean doTuple(PTuple object) {
        return object.getSequenceStorage().length() == 0;
    }

    @Specialization(guards={"isBuiltinDict(object)"})
    public static boolean doDict(PDict object, @Bind Node inliningTarget, @Cached.Exclusive @Cached HashingStorageNodes.HashingStorageLen lenNode) {
        return lenNode.execute(inliningTarget, object.getDictStorage()) == 0;
    }

    @Specialization(guards={"isBuiltinAnySet(object)"})
    @HostCompilerDirectives.InliningCutoff
    public static boolean doSet(PBaseSet object, @Bind Node inliningTarget, @Cached.Exclusive @Cached HashingStorageNodes.HashingStorageLen lenNode) {
        return lenNode.execute(inliningTarget, object.getDictStorage()) == 0;
    }

    @Specialization(guards={"!isBoolean(object)", "!isPNone(object)", "!isInt(object)", "!isLong(object)", "!isDouble(object)", "!isTruffleString(object)"}, replaces={"doList", "doTuple", "doDict", "doSet"})
    @HostCompilerDirectives.InliningCutoff
    public static boolean doOthers(VirtualFrame frame, Object object, @Cached PyObjectIsTrueNode.PyObjectIsTrueNodeGeneric internalNode) {
        return !internalNode.execute((Frame)frame, object);
    }

    @NeverDefault
    public static NotNode create() {
        return NotNodeGen.create();
    }
}

