/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkLabelMapContourOverlayImageFilter_h
#define sitkLabelMapContourOverlayImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkDualImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkImageFilter.h"
#include "sitkDualMemberFunctionFactory.h"
#include "sitkBasicFilters.h"

namespace itk::simple {

    /**\class LabelMapContourOverlayImageFilter
\brief Apply a colormap to the contours (outlines) of each object in a label map and superimpose it on top of the feature image.

The feature image is typically the image from which the labeling was produced. Use the SetInput function to set the LabelMap , and the SetFeatureImage function to set the feature image.

Apply a colormap to a label map and put it on top of the input image. The set of colors is a good selection of distinct colors. The opacity of the label map can be defined by the user. A background label produce a gray pixel with the same intensity than the input one.

\author Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA de Jouy-en-Josas, France.


This implementation was taken from the Insight Journal paper: https://doi.org/10.54294/q6auw4 

\see LabelMapOverlayImageFilter , LabelOverlayImageFilter , LabelOverlayFunctor 


\see LabelMapToBinaryImageFilter , LabelMapToLabelImageFilter ,
\sa itk::simple::LabelMapContourOverlay for the procedural interface
\sa itk::LabelMapContourOverlayImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT LabelMapContourOverlayImageFilter : public ImageFilter {
    public:
      using Self = LabelMapContourOverlayImageFilter;

      /** Destructor */
      virtual ~LabelMapContourOverlayImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      LabelMapContourOverlayImageFilter();

      /** Define the pixels types supported by this filter */
      using PixelIDTypeList = LabelPixelIDTypeList;

\

      /**
       * Set/Get the opacity of the colored label image. The value must be between 0 and 1
       */
      SITK_RETURN_SELF_TYPE_HEADER SetOpacity ( double Opacity ) { this->m_Opacity = Opacity; return *this; }

      /**
       * Set/Get the opacity of the colored label image. The value must be between 0 and 1
       */
      double GetOpacity() const { return this->m_Opacity; }\

      /**
       * Set/Get the object dilation radius - 0 by default.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetDilationRadius ( std::vector<unsigned int> DilationRadius ) { this->m_DilationRadius = std::move(DilationRadius); return *this; }

      /** Set the values of the DilationRadius vector all to value */
      SITK_RETURN_SELF_TYPE_HEADER SetDilationRadius( unsigned int value ) { this->m_DilationRadius = std::vector<unsigned int>(3, value); return *this; }

      /**
       * Set/Get the object dilation radius - 0 by default.
       */
      std::vector<unsigned int> GetDilationRadius() const { return this->m_DilationRadius; }\

      /**
       * Set/Get the contour thickness - 1 by default.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetContourThickness ( std::vector<unsigned int> ContourThickness ) { this->m_ContourThickness = std::move(ContourThickness); return *this; }

      /**
       * Set/Get the contour thickness - 1 by default.
       */
      std::vector<unsigned int> GetContourThickness() const { return this->m_ContourThickness; }\

      /**
       * Set/Get the slice dimension - defaults to image dimension - 1.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetSliceDimension ( unsigned int SliceDimension ) { this->m_SliceDimension = SliceDimension; return *this; }

      /**
       * Set/Get the slice dimension - defaults to image dimension - 1.
       */
      unsigned int GetSliceDimension() const { return this->m_SliceDimension; }

      typedef enum {PLAIN,CONTOUR,SLICE_CONTOUR} ContourTypeType;\

      /**
       * Set/Get the overlay type - CONTOUR is used by default.

       */
      SITK_RETURN_SELF_TYPE_HEADER SetContourType ( ContourTypeType ContourType ) { this->m_ContourType = ContourType; return *this; }

      /**
       * Set/Get the overlay type - CONTOUR is used by default.

       */
      ContourTypeType GetContourType() const { return this->m_ContourType; }

      typedef enum {HIGH_LABEL_ON_TOP,LOW_LABEL_ON_TOP} PriorityType;\

      /**
       * Set/Get the object priority - HIGH_LABEL_ON_TOP by default.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetPriority ( PriorityType Priority ) { this->m_Priority = Priority; return *this; }

      /**
       * Set/Get the object priority - HIGH_LABEL_ON_TOP by default.
       */
      PriorityType GetPriority() const { return this->m_Priority; }\

      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetColormap ( std::vector<uint8_t> Colormap ) { this->m_Colormap = Colormap; return *this; }

      /**
       */
      std::vector<uint8_t> GetColormap() const { return this->m_Colormap; }

      /** Name of this class */
      std::string GetName() const { return std::string ("LabelMapContourOverlayImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */

      Image Execute ( const Image & labelMapImage, const Image & featureImage );


    private:
      /** Setup for member function dispatching */
      using MemberFunctionType = Image (Self::*)( const Image * labelMapImage, const Image * featureImage );

      friend struct detail::DualExecuteInternalAddressor<MemberFunctionType>;
      template <class TImageType1, class TImageType2> Image DualExecuteInternal ( const Image * labelMapImage, const Image * featureImage );


      std::unique_ptr<detail::DualMemberFunctionFactory<MemberFunctionType> > m_DualMemberFactory;



      double  m_Opacity{0.5};

      std::vector<unsigned int>  m_DilationRadius{std::vector<unsigned int>(3, 1)};

      std::vector<unsigned int>  m_ContourThickness{std::vector<unsigned int>(3, 1)};

      unsigned int  m_SliceDimension{0u};

      ContourTypeType  m_ContourType{itk::simple::LabelMapContourOverlayImageFilter::CONTOUR};

      PriorityType  m_Priority{itk::simple::LabelMapContourOverlayImageFilter::HIGH_LABEL_ON_TOP};

      std::vector<uint8_t>  m_Colormap{std::vector<uint8_t>()};


    };

    /**\
     * \brief Apply a colormap to the contours (outlines) of each object in a label map and superimpose it on top of the feature image.
     *
     * This function directly calls the execute method of LabelMapContourOverlayImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::LabelMapContourOverlayImageFilter for the object oriented interface
     * @{
     */

     SITKBasicFilters_EXPORT Image LabelMapContourOverlay ( const Image & labelMapImage, const Image & featureImage, double opacity = 0.5, std::vector<unsigned int> dilationRadius = std::vector<unsigned int>(3, 1), std::vector<unsigned int> contourThickness = std::vector<unsigned int>(3, 1), unsigned int sliceDimension = 0u, LabelMapContourOverlayImageFilter::ContourTypeType contourType = itk::simple::LabelMapContourOverlayImageFilter::CONTOUR, LabelMapContourOverlayImageFilter::PriorityType priority = itk::simple::LabelMapContourOverlayImageFilter::HIGH_LABEL_ON_TOP, std::vector<uint8_t> colormap = std::vector<uint8_t>() );

     /** @} */
}
#endif
