//
// Copyright 2023 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#ifndef PXR_IMAGING_HD_LEGACY_TASK_SCHEMA_H
#define PXR_IMAGING_HD_LEGACY_TASK_SCHEMA_H

/// \file

#include "pxr/imaging/hd/api.h"

#include "pxr/imaging/hd/schema.h"

// --(BEGIN CUSTOM CODE: Includes)--
#include "pxr/imaging/hd/rprimCollection.h"
// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

// --(BEGIN CUSTOM CODE: Declares)--

using HdRprimCollectionDataSource = HdTypedSampledDataSource<HdRprimCollection>;
using HdRprimCollectionDataSourceHandle = HdRprimCollectionDataSource::Handle;

using HdTokenVectorDataSource = HdTypedSampledDataSource<TfTokenVector>;
using HdTokenVectorDataSourceHandle = HdTokenVectorDataSource::Handle;

using HdLegacyTaskFactorySharedPtr = std::shared_ptr<class HdLegacyTaskFactory>;
using HdLegacyTaskFactoryDataSource =
    HdTypedSampledDataSource<HdLegacyTaskFactorySharedPtr>;
using HdLegacyTaskFactoryDataSourceHandle =
    HdLegacyTaskFactoryDataSource::Handle;


// --(END CUSTOM CODE: Declares)--

#define HD_LEGACY_TASK_SCHEMA_TOKENS \
    (task) \
    (factory) \
    (parameters) \
    (collection) \
    (renderTags) \

TF_DECLARE_PUBLIC_TOKENS(HdLegacyTaskSchemaTokens, HD_API,
    HD_LEGACY_TASK_SCHEMA_TOKENS);

//-----------------------------------------------------------------------------

// The HdLegacyTaskSchema specifies a Hydra task by providing a task factory
// and data.
//

class HdLegacyTaskSchema : public HdSchema
{
public:
    /// \name Schema retrieval
    /// @{

    HdLegacyTaskSchema(HdContainerDataSourceHandle container)
      : HdSchema(container) {}

    /// Retrieves a container data source with the schema's default name token
    /// "task" from the parent container and constructs a
    /// HdLegacyTaskSchema instance.
    /// Because the requested container data source may not exist, the result
    /// should be checked with IsDefined() or a bool comparison before use.
    HD_API
    static HdLegacyTaskSchema GetFromParent(
        const HdContainerDataSourceHandle &fromParentContainer);

    /// @}

// --(BEGIN CUSTOM CODE: Schema Methods)--
// --(END CUSTOM CODE: Schema Methods)--

    /// \name Member accessor
    /// @{

    HD_API
    HdLegacyTaskFactoryDataSourceHandle GetFactory() const;

    /// Parameters for task. Type depends on task type. E.g.
    /// HdxRenderTaskParams if the factory produces HdxRenderTask instances.
    HD_API
    HdSampledDataSourceHandle GetParameters() const;

    HD_API
    HdRprimCollectionDataSourceHandle GetCollection() const;

    HD_API
    HdTokenVectorDataSourceHandle GetRenderTags() const; 

    /// @}

    /// \name Schema location
    /// @{

    /// Returns a token where the container representing this schema is found in
    /// a container by default.
    HD_API
    static const TfToken &GetSchemaToken();

    /// Returns an HdDataSourceLocator (relative to the prim-level data source)
    /// where the container representing this schema is found by default.
    HD_API
    static const HdDataSourceLocator &GetDefaultLocator();

    /// @}

    /// \name Data source locators for members
    ///
    /// The following methods return an HdDataSourceLocator (relative to the
    /// prim-level data source) where the data source for a member can be found.
    ///
    /// This is often useful for checking intersection against the
    /// HdDataSourceLocatorSet sent with HdDataSourceObserver::PrimsDirtied.
    /// @{

    /// Prim-level relative data source locator to locate factory.
    HD_API
    static const HdDataSourceLocator &GetFactoryLocator();

    /// Prim-level relative data source locator to locate parameters.
    HD_API
    static const HdDataSourceLocator &GetParametersLocator();

    /// Prim-level relative data source locator to locate collection.
    HD_API
    static const HdDataSourceLocator &GetCollectionLocator();

    /// Prim-level relative data source locator to locate renderTags.
    HD_API
    static const HdDataSourceLocator &GetRenderTagsLocator();
    /// @} 

    /// \name Schema construction
    /// @{

    /// \deprecated Use Builder instead.
    ///
    /// Builds a container data source which includes the provided child data
    /// sources. Parameters with nullptr values are excluded. This is a
    /// low-level interface. For cases in which it's desired to define
    /// the container with a sparse set of child fields, the Builder class
    /// is often more convenient and readable.
    HD_API
    static HdContainerDataSourceHandle
    BuildRetained(
        const HdLegacyTaskFactoryDataSourceHandle &factory,
        const HdSampledDataSourceHandle &parameters,
        const HdRprimCollectionDataSourceHandle &collection,
        const HdTokenVectorDataSourceHandle &renderTags
    );

    /// \class HdLegacyTaskSchema::Builder
    /// 
    /// Utility class for setting sparse sets of child data source fields to be
    /// filled as arguments into BuildRetained. Because all setter methods
    /// return a reference to the instance, this can be used in the "builder
    /// pattern" form.
    class Builder
    {
    public:
        HD_API
        Builder &SetFactory(
            const HdLegacyTaskFactoryDataSourceHandle &factory);
        HD_API
        Builder &SetParameters(
            const HdSampledDataSourceHandle &parameters);
        HD_API
        Builder &SetCollection(
            const HdRprimCollectionDataSourceHandle &collection);
        HD_API
        Builder &SetRenderTags(
            const HdTokenVectorDataSourceHandle &renderTags);

        /// Returns a container data source containing the members set thus far.
        HD_API
        HdContainerDataSourceHandle Build();

    private:
        HdLegacyTaskFactoryDataSourceHandle _factory;
        HdSampledDataSourceHandle _parameters;
        HdRprimCollectionDataSourceHandle _collection;
        HdTokenVectorDataSourceHandle _renderTags;

    };

    /// @}
};

PXR_NAMESPACE_CLOSE_SCOPE

#endif