"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.definitions = void 0;
const fz = __importStar(require("../converters/fromZigbee"));
const tz = __importStar(require("../converters/toZigbee"));
const m = __importStar(require("../lib/modernExtend"));
const reporting = __importStar(require("../lib/reporting"));
const tuya = __importStar(require("../lib/tuya"));
exports.definitions = [
    {
        fingerprint: tuya.fingerprint("TS011F", ["_TZ3000_dd8wwzcy"]),
        model: "MG-AUZG01",
        vendor: "MakeGood",
        description: "Double Zigbee power point",
        extend: [tuya.modernExtend.tuyaOnOff({ powerOutageMemory: true, indicatorMode: true, endpoints: ["l1", "l2"], electricalMeasurements: true })],
        meta: { multiEndpointSkip: ["power", "current", "voltage", "energy"], multiEndpoint: true },
        endpoint: (device) => {
            return { l1: 1, l2: 2 };
        },
        configure: async (device, coordinatorEndpoint) => {
            const endpoint = device.getEndpoint(1);
            await tuya.configureMagicPacket(device, coordinatorEndpoint);
            await reporting.bind(endpoint, coordinatorEndpoint, ["genOnOff", "haElectricalMeasurement", "seMetering"]);
            await reporting.bind(device.getEndpoint(2), coordinatorEndpoint, ["genOnOff"]);
            await reporting.rmsVoltage(endpoint, { change: 5 });
            await reporting.rmsCurrent(endpoint, { change: 50 });
            await reporting.activePower(endpoint, { change: 10 });
            await reporting.currentSummDelivered(endpoint);
            endpoint.saveClusterAttributeKeyValue("haElectricalMeasurement", { acCurrentDivisor: 1000, acCurrentMultiplier: 1 });
            endpoint.saveClusterAttributeKeyValue("seMetering", { divisor: 100, multiplier: 1 });
            device.save();
        },
    },
    {
        fingerprint: tuya.fingerprint("TS011F", ["_TZ3210_bep7ccew"]),
        model: "MG-GPO01",
        vendor: "MakeGood",
        description: "Double Zigbee power point",
        fromZigbee: [fz.identify, fz.on_off, fz.electrical_measurement, fz.metering, fz.power_on_behavior],
        toZigbee: [tz.on_off, tz.power_on_behavior, tz.electrical_measurement_power],
        extend: [
            m.deviceEndpoints({ endpoints: { right: 1, left: 2 } }),
            m.identify(),
            tuya.modernExtend.tuyaOnOff({
                endpoints: ["right", "left"],
                powerOutageMemory: true,
                indicatorMode: true,
                childLock: true,
                onOffCountdown: true,
                electricalMeasurements: true,
            }),
        ],
        configure: async (device, coordinatorEndpoint) => {
            const endpoint1 = device.getEndpoint(1);
            const endpoint2 = device.getEndpoint(2);
            await tuya.configureMagicPacket(device, coordinatorEndpoint);
            await reporting.bind(endpoint1, coordinatorEndpoint, ["genOnOff", "haElectricalMeasurement", "seMetering"]);
            await reporting.onOff(endpoint1);
            await reporting.rmsVoltage(endpoint1, { min: 5, max: 3600, change: 1 });
            await reporting.rmsCurrent(endpoint1, { min: 5, max: 3600, change: 1 });
            await reporting.activePower(endpoint1, { min: 5, max: 3600, change: 1 });
            await reporting.currentSummDelivered(endpoint1, { min: 5, max: 3600, change: 5 });
            await reporting.bind(endpoint2, coordinatorEndpoint, ["genOnOff"]);
            endpoint1.saveClusterAttributeKeyValue("haElectricalMeasurement", {
                acCurrentDivisor: 1000,
                acCurrentMultiplier: 1,
                acPowerDivisor: 1,
                acPowerMultiplier: 1,
                acVoltageDivisor: 1,
                acVoltageMultiplier: 1,
            });
            endpoint1.saveClusterAttributeKeyValue("seMetering", {
                divisor: 100,
                multiplier: 1,
            });
            device.save();
        },
        meta: {
            multiEndpoint: true,
            multiEndpointSkip: ["power", "current", "voltage", "energy"],
        },
    },
];
//# sourceMappingURL=makegood.js.map