"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.INSTALL_CODE_CRC_SIZE = exports.INSTALL_CODE_SIZES = exports.AES_MMO_128_BLOCK_SIZE = exports.DEFAULT_ENCRYPTION_KEY_SIZE = exports.EXTENDED_PAN_ID_SIZE = exports.PAN_ID_SIZE = exports.EUI64_SIZE = exports.PERMIT_JOIN_MAX_TIMEOUT = exports.PERMIT_JOIN_FOREVER = exports.INTEROPERABILITY_LINK_KEY = exports.NULL_BINDING = exports.NULL_NODE_ID = exports.INVALID_PAN_ID = exports.INVALID_CLUSTER_ID = exports.INVALID_PROFILE_ID = exports.BLANK_EXTENDED_PAN_ID = exports.BLANK_EUI64 = exports.PREFERRED_802_15_4_CHANNELS = exports.ALL_802_15_4_CHANNELS = exports.PREFERRED_802_15_4_CHANNELS_MASK = exports.ALL_802_15_4_CHANNELS_MASK = exports.NUM_802_15_4_CHANNELS = exports.MIN_802_15_4_CHANNEL_NUMBER = exports.MAX_802_15_4_CHANNEL_NUMBER = exports.GP_GROUP_ID = exports.GP_ENDPOINT = exports.HA_ENDPOINT = exports.CUSTOM_SHELLY_PROFILE_ID = exports.WILDCARD_PROFILE_ID = exports.TOUCHLINK_PROFILE_ID = exports.GP_PROFILE_ID = exports.SE_PROFILE_ID = exports.HA_PROFILE_ID = exports.COORDINATOR_ADDRESS = exports.ZIGBEE_REVISION = void 0;
/** Current supported Zigbee revision: https://csa-iot.org/wp-content/uploads/2023/04/05-3474-23-csg-zigbee-specification-compressed.pdf */
exports.ZIGBEE_REVISION = 23;
/** The network ID of the coordinator in a ZigBee network is 0x0000. */
exports.COORDINATOR_ADDRESS = 0x0000;
/** Endpoint profile ID for Zigbee 3.0. "Home Automation" */
exports.HA_PROFILE_ID = 0x0104;
/** Endpoint profile ID for Smart Energy */
exports.SE_PROFILE_ID = 0x0109;
/** Endpoint profile ID for Green Power */
exports.GP_PROFILE_ID = 0xa1e0;
/** The touchlink (ZigBee Light Link/ZLL) Profile ID. */
exports.TOUCHLINK_PROFILE_ID = 0xc05e;
/** The profile ID used to address all the public profiles. */
exports.WILDCARD_PROFILE_ID = 0xffff;
/** The profile ID used to access Shelly devices custom clusters. */
exports.CUSTOM_SHELLY_PROFILE_ID = 0xc001;
/** The default HA endpoint. */
exports.HA_ENDPOINT = 0x01;
/** The GP endpoint, as defined in the ZigBee spec. */
exports.GP_ENDPOINT = 0xf2;
exports.GP_GROUP_ID = 0x0b84;
/** The maximum 802.15.4 channel number is 26. */
exports.MAX_802_15_4_CHANNEL_NUMBER = 26;
/** The minimum 2.4GHz 802.15.4 channel number is 11. */
exports.MIN_802_15_4_CHANNEL_NUMBER = 11;
/** There are sixteen 802.15.4 channels. */
exports.NUM_802_15_4_CHANNELS = exports.MAX_802_15_4_CHANNEL_NUMBER - exports.MIN_802_15_4_CHANNEL_NUMBER + 1;
/** A bitmask to scan all 2.4 GHz 802.15.4 channels. */
exports.ALL_802_15_4_CHANNELS_MASK = 0x07fff800;
/** A bitmask of the preferred 2.4 GHz 802.15.4 channels to scan. */
exports.PREFERRED_802_15_4_CHANNELS_MASK = 0x0318c800;
/** List of all Zigbee channels */
exports.ALL_802_15_4_CHANNELS = [11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26];
/** List of preferred Zigbee channels */
exports.PREFERRED_802_15_4_CHANNELS = [11, 14, 15, 19, 20, 24, 25];
/** A blank (also used as "wildcard") EUI64 hex string prefixed with 0x */
exports.BLANK_EUI64 = "0xFFFFFFFFFFFFFFFF";
/** A blank extended PAN ID. (null/not present) */
exports.BLANK_EXTENDED_PAN_ID = [0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00];
/** An invalid profile ID. This is a reserved profileId. */
exports.INVALID_PROFILE_ID = 0xffff;
/** An invalid cluster ID. */
exports.INVALID_CLUSTER_ID = 0xffff;
/** An invalid PAN ID. */
exports.INVALID_PAN_ID = 0xffff;
/** A distinguished network ID that will never be assigned to any node. It is used to indicate the absence of a node ID. */
exports.NULL_NODE_ID = 0xffff;
/** A distinguished binding index used to indicate the absence of a binding. */
exports.NULL_BINDING = 0xff;
/** This key is "ZigBeeAlliance09" */
exports.INTEROPERABILITY_LINK_KEY = [
    0x5a, 0x69, 0x67, 0x42, 0x65, 0x65, 0x41, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x30, 0x39,
];
exports.PERMIT_JOIN_FOREVER = 0xff;
exports.PERMIT_JOIN_MAX_TIMEOUT = 0xfe;
/** Size of EUI64 (an IEEE address) in bytes. */
exports.EUI64_SIZE = 8;
/** Size of an PAN identifier in bytes. */
exports.PAN_ID_SIZE = 2;
/** Size of an extended PAN identifier in bytes. */
exports.EXTENDED_PAN_ID_SIZE = 8;
/** Size of an encryption key in bytes. */
exports.DEFAULT_ENCRYPTION_KEY_SIZE = 16;
/** Size of a AES-128-MMO (Matyas-Meyer-Oseas) block in bytes. */
exports.AES_MMO_128_BLOCK_SIZE = 16;
/**
 * Valid install code sizes, including `INSTALL_CODE_CRC_SIZE`.
 *
 * NOTE: 18 is now standard, first for iterations, order after is important (8 before 10)!
 */
exports.INSTALL_CODE_SIZES = [18, 8, 10, 14];
/** Size of the CRC appended to install codes. */
exports.INSTALL_CODE_CRC_SIZE = 2;
//# sourceMappingURL=consts.js.map