﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/bedrock-agent-runtime/BedrockAgentRuntime_EXPORTS.h>
#include <aws/bedrock-agent-runtime/model/GeneratedQueryType.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace BedrockAgentRuntime {
namespace Model {

/**
 * <p>Contains information about a query generated for a natural language
 * query.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/GeneratedQuery">AWS
 * API Reference</a></p>
 */
class GeneratedQuery {
 public:
  AWS_BEDROCKAGENTRUNTIME_API GeneratedQuery() = default;
  AWS_BEDROCKAGENTRUNTIME_API GeneratedQuery(Aws::Utils::Json::JsonView jsonValue);
  AWS_BEDROCKAGENTRUNTIME_API GeneratedQuery& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_BEDROCKAGENTRUNTIME_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>An SQL query that corresponds to the natural language query.</p>
   */
  inline const Aws::String& GetSql() const { return m_sql; }
  inline bool SqlHasBeenSet() const { return m_sqlHasBeenSet; }
  template <typename SqlT = Aws::String>
  void SetSql(SqlT&& value) {
    m_sqlHasBeenSet = true;
    m_sql = std::forward<SqlT>(value);
  }
  template <typename SqlT = Aws::String>
  GeneratedQuery& WithSql(SqlT&& value) {
    SetSql(std::forward<SqlT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The type of transformed query.</p>
   */
  inline GeneratedQueryType GetType() const { return m_type; }
  inline bool TypeHasBeenSet() const { return m_typeHasBeenSet; }
  inline void SetType(GeneratedQueryType value) {
    m_typeHasBeenSet = true;
    m_type = value;
  }
  inline GeneratedQuery& WithType(GeneratedQueryType value) {
    SetType(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_sql;

  GeneratedQueryType m_type{GeneratedQueryType::NOT_SET};
  bool m_sqlHasBeenSet = false;
  bool m_typeHasBeenSet = false;
};

}  // namespace Model
}  // namespace BedrockAgentRuntime
}  // namespace Aws
