# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


@register_command(
    "sql mi start-stop-schedule create",
)
class Create(AAZCommand):
    """Create the managed instance's Start/Stop schedule.

    :example: Create schedule for managed instance.
        az sql mi start-stop-schedule create --mi miName -g resourceGroup --subscription subscriptionId --schedule-list "[{'startDay':'Monday','startTime':'10:00 AM','stopDay':'Monday','stopTime':'12:00 AM'}]"
    """

    _aaz_info = {
        "version": "2022-11-01-preview",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/resourcegroups/{}/providers/microsoft.sql/managedinstances/{}/startstopschedules/{}", "2022-11-01-preview"],
        ]
    }

    def _handler(self, command_args):
        super()._handler(command_args)
        self._execute_operations()
        return self._output()

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.managed_instance = AAZStrArg(
            options=["--mi", "--managed-instance"],
            help="The name of the managed instance.",
            required=True,
            id_part="name",
        )
        _args_schema.resource_group = AAZResourceGroupNameArg(
            help="Name of the resource group.",
            required=True,
        )

        # define Arg Group "Properties"

        _args_schema = cls._args_schema
        _args_schema.description = AAZStrArg(
            options=["--description"],
            arg_group="Properties",
            help="The description of the schedule.",
            default="",
        )
        _args_schema.schedule_list = AAZListArg(
            options=["--schedule-list"],
            arg_group="Properties",
            help="Schedule list.",
        )
        _args_schema.timezone_id = AAZStrArg(
            options=["--timezone-id"],
            arg_group="Properties",
            help="The time zone of the schedule.",
            default="UTC",
        )

        schedule_list = cls._args_schema.schedule_list
        schedule_list.Element = AAZObjectArg()

        _element = cls._args_schema.schedule_list.Element
        _element.start_day = AAZStrArg(
            options=["start-day"],
            help="Start day.",
            required=True,
            enum={"Friday": "Friday", "Monday": "Monday", "Saturday": "Saturday", "Sunday": "Sunday", "Thursday": "Thursday", "Tuesday": "Tuesday", "Wednesday": "Wednesday"},
        )
        _element.start_time = AAZStrArg(
            options=["start-time"],
            help="Start time.",
            required=True,
        )
        _element.stop_day = AAZStrArg(
            options=["stop-day"],
            help="Stop day.",
            required=True,
            enum={"Friday": "Friday", "Monday": "Monday", "Saturday": "Saturday", "Sunday": "Sunday", "Thursday": "Thursday", "Tuesday": "Tuesday", "Wednesday": "Wednesday"},
        )
        _element.stop_time = AAZStrArg(
            options=["stop-time"],
            help="Stop time.",
            required=True,
        )
        return cls._args_schema

    def _execute_operations(self):
        self.pre_operations()
        self.StartStopManagedInstanceSchedulesCreateOrUpdate(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance, client_flatten=True)
        return result

    class StartStopManagedInstanceSchedulesCreateOrUpdate(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [200, 201]:
                return self.on_200_201(session)

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/startStopSchedules/default",
                **self.url_parameters
            )

        @property
        def method(self):
            return "PUT"

        @property
        def error_format(self):
            return "MgmtErrorFormat"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "managedInstanceName", self.ctx.args.managed_instance,
                    required=True,
                ),
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2022-11-01-preview",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Content-Type", "application/json",
                ),
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        @property
        def content(self):
            _content_value, _builder = self.new_content_builder(
                self.ctx.args,
                typ=AAZObjectType,
                typ_kwargs={"flags": {"required": True, "client_flatten": True}}
            )
            _builder.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

            properties = _builder.get(".properties")
            if properties is not None:
                properties.set_prop("description", AAZStrType, ".description")
                properties.set_prop("scheduleList", AAZListType, ".schedule_list", typ_kwargs={"flags": {"required": True}})
                properties.set_prop("timeZoneId", AAZStrType, ".timezone_id")

            schedule_list = _builder.get(".properties.scheduleList")
            if schedule_list is not None:
                schedule_list.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.scheduleList[]")
            if _elements is not None:
                _elements.set_prop("startDay", AAZStrType, ".start_day", typ_kwargs={"flags": {"required": True}})
                _elements.set_prop("startTime", AAZStrType, ".start_time", typ_kwargs={"flags": {"required": True}})
                _elements.set_prop("stopDay", AAZStrType, ".stop_day", typ_kwargs={"flags": {"required": True}})
                _elements.set_prop("stopTime", AAZStrType, ".stop_time", typ_kwargs={"flags": {"required": True}})

            return self.serialize_content(_content_value)

        def on_200_201(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200_201
            )

        _schema_on_200_201 = None

        @classmethod
        def _build_schema_on_200_201(cls):
            if cls._schema_on_200_201 is not None:
                return cls._schema_on_200_201

            cls._schema_on_200_201 = AAZObjectType()

            _schema_on_200_201 = cls._schema_on_200_201
            _schema_on_200_201.id = AAZStrType(
                flags={"read_only": True},
            )
            _schema_on_200_201.name = AAZStrType(
                flags={"read_only": True},
            )
            _schema_on_200_201.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _schema_on_200_201.system_data = AAZObjectType(
                serialized_name="systemData",
                flags={"read_only": True},
            )
            _schema_on_200_201.type = AAZStrType(
                flags={"read_only": True},
            )

            properties = cls._schema_on_200_201.properties
            properties.description = AAZStrType()
            properties.next_execution_time = AAZStrType(
                serialized_name="nextExecutionTime",
                flags={"read_only": True},
            )
            properties.next_run_action = AAZStrType(
                serialized_name="nextRunAction",
                flags={"read_only": True},
            )
            properties.schedule_list = AAZListType(
                serialized_name="scheduleList",
                flags={"required": True},
            )
            properties.time_zone_id = AAZStrType(
                serialized_name="timeZoneId",
            )

            schedule_list = cls._schema_on_200_201.properties.schedule_list
            schedule_list.Element = AAZObjectType()

            _element = cls._schema_on_200_201.properties.schedule_list.Element
            _element.start_day = AAZStrType(
                serialized_name="startDay",
                flags={"required": True},
            )
            _element.start_time = AAZStrType(
                serialized_name="startTime",
                flags={"required": True},
            )
            _element.stop_day = AAZStrType(
                serialized_name="stopDay",
                flags={"required": True},
            )
            _element.stop_time = AAZStrType(
                serialized_name="stopTime",
                flags={"required": True},
            )

            system_data = cls._schema_on_200_201.system_data
            system_data.created_at = AAZStrType(
                serialized_name="createdAt",
            )
            system_data.created_by = AAZStrType(
                serialized_name="createdBy",
            )
            system_data.created_by_type = AAZStrType(
                serialized_name="createdByType",
            )
            system_data.last_modified_at = AAZStrType(
                serialized_name="lastModifiedAt",
            )
            system_data.last_modified_by = AAZStrType(
                serialized_name="lastModifiedBy",
            )
            system_data.last_modified_by_type = AAZStrType(
                serialized_name="lastModifiedByType",
            )

            return cls._schema_on_200_201


class _CreateHelper:
    """Helper class for Create"""


__all__ = ["Create"]
