/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tasks.ui.view;

import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskManager;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tasks.ui.internal.TaskUIViewMessages;
import org.jkiss.dbeaver.tasks.ui.view.DatabaseTasksTree;
import org.jkiss.dbeaver.tasks.ui.view.DatabaseTasksView;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.EnterNameDialog;
import org.jkiss.utils.BeanUtils;

public class TaskHandlerCopy
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        block5: {
            DBTTaskManager taskManager;
            String newTaskName;
            IStructuredSelection structSelection;
            Object firstElement;
            ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
            if (!(selection instanceof IStructuredSelection) || !((firstElement = (structSelection = (IStructuredSelection)selection).getFirstElement()) instanceof DBTTask)) break block5;
            DBTTask oldTask = (DBTTask)firstElement;
            while (true) {
                EnterNameDialog taskNameDialog;
                if ((newTaskName = (taskNameDialog = new EnterNameDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), TaskUIViewMessages.task_handler_copy_name_dialog_enter_task, oldTask.getName())).chooseName()) == null) {
                    return null;
                }
                taskManager = oldTask.getProject().getTaskManager();
                if (taskManager.getTaskByName(newTaskName) == null) break;
                UIUtils.showMessageBox((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)"Duplicate task name", (String)("Task '" + newTaskName + "' already exists"), (int)1);
            }
            try {
                DBTTask newTask = taskManager.createTask(oldTask.getType(), newTaskName, oldTask.getDescription(), oldTask.getTaskFolder() != null ? oldTask.getTaskFolder().getName() : null, BeanUtils.deepCopy((Map)oldTask.getProperties()));
                taskManager.updateTaskConfiguration(newTask);
                IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
                if (activePart instanceof DatabaseTasksView) {
                    UIUtils.asyncExec(() -> {
                        DatabaseTasksTree tasksTree = ((DatabaseTasksView)activePart).getTasksTree();
                        if (tasksTree == null) {
                            return;
                        }
                        tasksTree.getViewer().setSelection((ISelection)new StructuredSelection((Object)newTask), true);
                        ActionUtils.runCommand((String)"org.jkiss.dbeaver.task.edit", (IServiceLocator)activePart.getSite());
                    });
                }
            }
            catch (DBException e) {
                DBWorkbench.getPlatformUI().showError("Task copy error", "Error copying task '" + oldTask.getName() + "'", (Throwable)e);
            }
        }
        return null;
    }
}

