/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.edit.PostgreTableColumnManager;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableColumn;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableReal;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTrigger;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistActionComment;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndex;
import org.jkiss.dbeaver.model.struct.rdb.DBSView;
import org.jkiss.utils.CommonUtils;

public abstract class PostgreViewBase
extends PostgreTableReal
implements DBSView {
    private String source;

    public PostgreViewBase(PostgreSchema catalog) {
        super(catalog);
    }

    public PostgreViewBase(PostgreSchema catalog, ResultSet dbResult) {
        super(catalog, dbResult);
    }

    @Property(viewable=true, editable=true, valueTransformer=DBObjectNameCaseTransformer.class, order=1)
    @NotNull
    public String getName() {
        return super.getName();
    }

    public boolean isView() {
        return true;
    }

    public Collection<? extends DBSTableIndex> getIndexes(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    public String getSource() {
        return this.source;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Property(hidden=true, editable=true, updatable=true, order=-1)
    @NotNull
    public String getObjectDefinitionText(@NotNull DBRProgressMonitor monitor, @NotNull Map<String, Object> options) throws DBException {
        List<PostgreTrigger> triggers;
        boolean needRefresh = false;
        if (options != null) {
            needRefresh = CommonUtils.toBoolean((Object)options.get("refresh"));
        }
        if (this.source == null || needRefresh) {
            if (this.isPersisted()) {
                this.source = ((PostgreDataSource)this.getDataSource()).getServerType().readViewDDL(monitor, this);
                if (this.source == null) {
                    try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Read view definition");){
                        String definition = this.fetchViewQueryResultIfItNull(session);
                        this.source = PostgreUtils.getViewDDL(monitor, this, definition, options);
                        String extDefinition = this.readExtraDefinition(session, options);
                        if (extDefinition != null) {
                            this.source = this.source + "\n" + extDefinition;
                        }
                    }
                    catch (SQLException e) {
                        throw new DBException("Error reading view definition: " + e.getMessage(), (Throwable)e);
                    }
                }
            } else {
                this.source = "";
            }
        }
        ArrayList<DBEPersistAction> actions = new ArrayList<DBEPersistAction>();
        if (CommonUtils.getOption(options, (String)"ddl.includeComments")) {
            if (this.getDescription() != null) {
                actions.add((DBEPersistAction)new SQLDatabasePersistAction("Comment", "COMMENT ON " + this.getTableTypeName() + " " + this.getFullyQualifiedName(DBPEvaluationContext.DDL) + " IS " + SQLUtils.quoteString((DBSObject)this, (String)this.getDescription())));
            }
            for (PostgreTableColumn column : CommonUtils.safeCollection(this.getAttributes(monitor))) {
                if (CommonUtils.isEmpty((String)column.getDescription())) continue;
                PostgreTableColumnManager.addColumnCommentAction(actions, column);
            }
        }
        if (this.isPersisted() && !CommonUtils.isEmpty(triggers = this.getTriggers(monitor))) {
            if (((PostgreDataSource)this.getDataSource()).getContainer().getPreferenceStore().getBoolean("database.meta.extra.ddl.info")) {
                actions.add((DBEPersistAction)new SQLDatabasePersistActionComment(this.getDataSource(), "View Triggers"));
            }
            for (PostgreTrigger trigger : triggers) {
                actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create trigger", trigger.getObjectDefinitionText(monitor, options)));
            }
        }
        if (this.isPersisted() && CommonUtils.getOption(options, (String)"ddl.includePermissions")) {
            PostgreUtils.getObjectGrantPermissionActions(monitor, this, actions, options);
        }
        StringBuilder ddl = new StringBuilder(this.source);
        if (!actions.isEmpty()) {
            ddl.append("\n\n").append(SQLUtils.generateScript((DBPDataSource)this.getDataSource(), (DBEPersistAction[])actions.toArray(new DBEPersistAction[0]), (boolean)false));
        }
        return ddl.toString();
    }

    private String fetchViewQueryResultIfItNull(JDBCSession session) throws SQLException, DBException {
        String definition = JDBCUtils.queryString((Connection)session, (String)("SELECT pg_get_viewdef(" + this.getObjectId() + ", true)"), (Object[])new Object[0]);
        if (definition == null) {
            throw new DBException("View '" + this.getName() + "' doesn't exist");
        }
        return definition;
    }

    protected String readExtraDefinition(JDBCSession session, Map<String, Object> options) throws DBException {
        return null;
    }

    @Override
    public void setObjectDefinitionText(String sourceText) {
        this.source = sourceText;
    }

    @Override
    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.source = null;
        return super.refreshObject(monitor);
    }
}

