/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.n3.nanoxml;

import java.io.IOException;
import java.io.Reader;
import org.freeplane.n3.nanoxml.IXMLEntityResolver;
import org.freeplane.n3.nanoxml.IXMLReader;
import org.freeplane.n3.nanoxml.XMLParseException;
import org.freeplane.n3.nanoxml.XMLUtil;

class ContentReader
extends Reader {
    private String buffer;
    private int bufferIndex;
    private IXMLReader reader;
    private IXMLEntityResolver resolver;

    ContentReader(IXMLReader reader, IXMLEntityResolver resolver, String buffer) {
        this.reader = reader;
        this.resolver = resolver;
        this.buffer = buffer;
        this.bufferIndex = 0;
    }

    @Override
    public void close() throws IOException {
        try {
            int bufferLength = this.buffer.length();
            while (true) {
                char ch;
                String str = "";
                if (this.bufferIndex < bufferLength) {
                    ch = this.buffer.charAt(this.bufferIndex);
                    ++this.bufferIndex;
                    continue;
                }
                str = XMLUtil.read(this.reader, '&');
                ch = str.charAt(0);
                if (ch == '<') {
                    this.reader.unread(ch);
                    break;
                }
                if (ch != '&' || str.length() <= 1 || str.charAt(1) == '#') continue;
                XMLUtil.processEntity(str, this.reader, this.resolver);
            }
        }
        catch (XMLParseException e) {
            throw new IOException(e.getMessage());
        }
    }

    protected void finalize() throws Throwable {
        this.reader = null;
        this.resolver = null;
        this.buffer = null;
        super.finalize();
    }

    @Override
    public int read(char[] outputBuffer, int offset, int size) throws IOException {
        try {
            int charsRead = 0;
            int bufferLength = this.buffer.length();
            if (offset + size > outputBuffer.length) {
                size = outputBuffer.length - offset;
            }
            while (charsRead < size) {
                char ch;
                String str = "";
                if (this.bufferIndex < bufferLength) {
                    ch = this.buffer.charAt(this.bufferIndex);
                    ++this.bufferIndex;
                    outputBuffer[charsRead] = ch;
                    ++charsRead;
                    continue;
                }
                str = XMLUtil.read(this.reader, '&');
                ch = str.charAt(0);
                if (ch == '<') {
                    this.reader.unread(ch);
                    break;
                }
                if (ch == '&' && str.length() > 1) {
                    if (str.charAt(1) == '#') {
                        ch = XMLUtil.processCharLiteral(str);
                    } else {
                        XMLUtil.processEntity(str, this.reader, this.resolver);
                        continue;
                    }
                }
                outputBuffer[charsRead] = ch;
                ++charsRead;
            }
            if (charsRead == 0) {
                charsRead = -1;
            }
            return charsRead;
        }
        catch (XMLParseException e) {
            throw new IOException(e.getMessage(), e);
        }
    }
}

