/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.build.report.statistics;

import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.build.report.metrics.BuildAttribute;
import org.jetbrains.kotlin.build.report.metrics.BuildPerformanceMetric;
import org.jetbrains.kotlin.build.report.metrics.BuildTime;
import org.jetbrains.kotlin.build.report.statistics.CompileStatisticsDataKt;
import org.jetbrains.kotlin.build.report.statistics.StatTag;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\bf\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00042\u00020\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\n\u0010\b\u001a\u0004\u0018\u00010\tH&J\n\u0010\n\u001a\u0004\u0018\u00010\tH&J\b\u0010\u000b\u001a\u00020\tH&J\n\u0010\f\u001a\u0004\u0018\u00010\tH&J\b\u0010\r\u001a\u00020\u000eH&J\b\u0010\u000f\u001a\u00020\u000eH&J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H&J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u0014H&J\b\u0010\u0015\u001a\u00020\tH\u0016J\b\u0010\u0016\u001a\u00020\tH&J\n\u0010\u0017\u001a\u0004\u0018\u00010\tH&J\n\u0010\u0018\u001a\u0004\u0018\u00010\tH\u0016J\b\u0010\u0019\u001a\u00020\u000eH&J\b\u0010\u001a\u001a\u00020\tH\u0016J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\t0\u0014H&J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0011H&J\u0014\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000e0\u001fH&J\u0014\u0010 \u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u000e0\u001fH&J\u0016\u0010!\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u001fH&J\u0016\u0010\"\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u001fH&J\b\u0010#\u001a\u00020\tH\u0016J\u000f\u0010$\u001a\u0004\u0018\u00010%H&\u00a2\u0006\u0002\u0010&J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00020\t0\u0014H\u0016J\n\u0010(\u001a\u0004\u0018\u00010\tH&J\u000e\u0010)\u001a\b\u0012\u0004\u0012\u00020\t0\u0014H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006*\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/build/report/statistics/CompileStatisticsData;", "B", "Lorg/jetbrains/kotlin/build/report/metrics/BuildTime;", "P", "Lorg/jetbrains/kotlin/build/report/metrics/BuildPerformanceMetric;", "", "getVersion", "", "getProjectName", "", "getLabel", "getTaskName", "getTaskResult", "getStartTimeMs", "", "getDurationMs", "getTags", "", "Lorg/jetbrains/kotlin/build/report/statistics/StatTag;", "getChanges", "", "getBuildUuid", "getKotlinVersion", "getKotlinLanguageVersion", "getHostName", "getFinishTime", "getTimestamp", "getCompilerArguments", "getNonIncrementalAttributes", "Lorg/jetbrains/kotlin/build/report/metrics/BuildAttribute;", "getBuildTimesMetrics", "", "getPerformanceMetrics", "getGcTimeMetrics", "getGcCountMetrics", "getType", "getFromKotlinPlugin", "", "()Ljava/lang/Boolean;", "getCompiledSources", "getSkipMessage", "getIcLogLines", "kotlin-build-statistics"})
public interface CompileStatisticsData<B extends BuildTime, P extends BuildPerformanceMetric> {
    default public int getVersion() {
        return 4;
    }

    @Nullable
    public String getProjectName();

    @Nullable
    public String getLabel();

    @NotNull
    public String getTaskName();

    @Nullable
    public String getTaskResult();

    public long getStartTimeMs();

    public long getDurationMs();

    @NotNull
    public Set<StatTag> getTags();

    @NotNull
    public List<String> getChanges();

    @NotNull
    default public String getBuildUuid() {
        return "Unset";
    }

    @NotNull
    public String getKotlinVersion();

    @Nullable
    public String getKotlinLanguageVersion();

    @Nullable
    default public String getHostName() {
        return "Unset";
    }

    public long getFinishTime();

    @NotNull
    default public String getTimestamp() {
        String string = CompileStatisticsDataKt.getFormatter().format(this.getFinishTime());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    @NotNull
    public List<String> getCompilerArguments();

    @NotNull
    public Set<BuildAttribute> getNonIncrementalAttributes();

    @NotNull
    public Map<B, Long> getBuildTimesMetrics();

    @NotNull
    public Map<P, Long> getPerformanceMetrics();

    @Nullable
    public Map<String, Long> getGcTimeMetrics();

    @Nullable
    public Map<String, Long> getGcCountMetrics();

    @NotNull
    default public String getType() {
        return "TASK_DATA";
    }

    @Nullable
    public Boolean getFromKotlinPlugin();

    @NotNull
    default public List<String> getCompiledSources() {
        return CollectionsKt.emptyList();
    }

    @Nullable
    public String getSkipMessage();

    @NotNull
    public List<String> getIcLogLines();
}

