/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.base;

import com.intellij.codeInspection.util.IntentionName;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.intentions.GroovyIntentionsBundle;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;

public abstract class GrPsiUpdateIntention
implements ModCommandAction {
    private final Supplier<PsiElementPredicate> predicate = new SynchronizedClearableLazy(this::getElementPredicate);

    @NotNull
    public final ModCommand perform(@NotNull ActionContext context) {
        PsiElement matchingElement;
        if (context == null) {
            GrPsiUpdateIntention.$$$reportNull$$$0(0);
        }
        if ((matchingElement = this.findMatchingElement(context)) == null) {
            ModCommand modCommand = ModCommand.nop();
            if (modCommand == null) {
                GrPsiUpdateIntention.$$$reportNull$$$0(1);
            }
            return modCommand;
        }
        ModCommand modCommand = ModCommand.psiUpdate((PsiElement)matchingElement, (e, updater) -> this.processIntention((PsiElement)e, context, (ModPsiUpdater)updater));
        if (modCommand == null) {
            GrPsiUpdateIntention.$$$reportNull$$$0(2);
        }
        return modCommand;
    }

    protected abstract void processIntention(@NotNull PsiElement var1, @NotNull ActionContext var2, @NotNull ModPsiUpdater var3);

    @Nullable
    PsiElement findMatchingElement(@NotNull ActionContext context) {
        PsiElement element;
        PsiFile file;
        if (context == null) {
            GrPsiUpdateIntention.$$$reportNull$$$0(3);
        }
        if (!(file = context.file()).getViewProvider().getLanguages().contains((Object)GroovyLanguage.INSTANCE)) {
            return null;
        }
        TextRange selection = context.selection();
        if (!selection.isEmpty()) {
            int start = selection.getStartOffset();
            int end = selection.getEndOffset();
            if (0 <= start && start <= end) {
                TextRange selectionRange = new TextRange(start, end);
                for (PsiElement element2 = PsiImplUtil.findElementInRange(file, start, end, PsiElement.class); element2 != null && element2.getTextRange() != null && selectionRange.contains(element2.getTextRange()); element2 = element2.getParent()) {
                    if (!this.predicate.get().satisfiedBy(element2)) continue;
                    return element2;
                }
            }
        }
        for (element = context.findLeaf(); element != null; element = element.getParent()) {
            if (this.predicate.get().satisfiedBy(element)) {
                return element;
            }
            if (this.isStopElement(element)) break;
        }
        for (element = context.findLeafOnTheLeft(); element != null; element = element.getParent()) {
            if (this.predicate.get().satisfiedBy(element)) {
                return element;
            }
            if (!this.isStopElement(element)) continue;
            return null;
        }
        return null;
    }

    protected boolean isStopElement(PsiElement element) {
        return element instanceof PsiFile;
    }

    @Nullable
    public Presentation getPresentation(@NotNull ActionContext context) {
        PsiElement element;
        if (context == null) {
            GrPsiUpdateIntention.$$$reportNull$$$0(4);
        }
        if ((element = this.findMatchingElement(context)) == null) {
            return null;
        }
        return Presentation.of((String)this.getText(element));
    }

    @NotNull
    protected abstract PsiElementPredicate getElementPredicate();

    protected static void replaceExpressionWithNegatedExpressionString(@NotNull String newExpression, @NotNull GrExpression expression) throws IncorrectOperationException {
        if (newExpression == null) {
            GrPsiUpdateIntention.$$$reportNull$$$0(5);
        }
        if (expression == null) {
            GrPsiUpdateIntention.$$$reportNull$$$0(6);
        }
        Intention.replaceExpressionWithNegatedExpressionString(newExpression, expression);
    }

    private String getPrefix() {
        Class<?> aClass = this.getClass();
        String name = aClass.getSimpleName();
        StringBuilder buffer = new StringBuilder(name.length() + 10);
        buffer.append(Character.toLowerCase(name.charAt(0)));
        for (int i2 = 1; i2 < name.length(); ++i2) {
            char c = name.charAt(i2);
            if (Character.isUpperCase(c)) {
                buffer.append('.');
                buffer.append(Character.toLowerCase(c));
                continue;
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    @NotNull
    @IntentionName
    public String getText(@NotNull PsiElement element) {
        if (element == null) {
            GrPsiUpdateIntention.$$$reportNull$$$0(7);
        }
        String string = GroovyIntentionsBundle.message(this.getPrefix() + ".name", new Object[0]);
        if (string == null) {
            GrPsiUpdateIntention.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = GroovyIntentionsBundle.message(this.getPrefix() + ".family.name", new Object[0]);
        if (string == null) {
            GrPsiUpdateIntention.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/intentions/base/GrPsiUpdateIntention";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newExpression";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/intentions/base/GrPsiUpdateIntention";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "perform";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findMatchingElement";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "replaceExpressionWithNegatedExpressionString";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 8, 9 -> new IllegalStateException(string);
        };
    }
}

