/*
 * Decompiled with CFR 0.152.
 */
package kotlin.metadata.jvm.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.metadata.InconsistentKotlinMetadataException;
import kotlin.metadata.KmClass;
import kotlin.metadata.KmLambda;
import kotlin.metadata.KmPackage;
import kotlin.metadata.internal.ReadersKt;
import kotlin.metadata.internal.metadata.ProtoBuf;
import kotlin.metadata.internal.metadata.deserialization.MetadataVersion;
import kotlin.metadata.internal.metadata.jvm.deserialization.JvmNameResolver;
import kotlin.metadata.internal.metadata.jvm.deserialization.JvmProtoBufUtil;
import kotlin.metadata.internal.metadata.jvm.deserialization.ModuleMapping;
import kotlin.metadata.internal.metadata.jvm.deserialization.PackageParts;
import kotlin.metadata.jvm.JvmMetadataVersion;
import kotlin.metadata.jvm.KmModule;
import kotlin.metadata.jvm.KmPackageParts;
import kotlin.metadata.jvm.KotlinClassMetadata;
import kotlin.metadata.jvm.UnstableMetadataApi;
import kotlin.metadata.jvm.internal.JvmExceptionUtilsKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0015\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\nJ\u0015\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\rJ\u0017\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\u0010J\u001d\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\u0014J\u0015\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0001\u00a2\u0006\u0002\b\u0019J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0005H\u0002J\u001d\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0013\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\u001f\u00a8\u0006 "}, d2={"Lkotlin/metadata/jvm/internal/JvmReadUtils;", "", "<init>", "()V", "isLessThan14", "", "annotationData", "Lkotlin/Metadata;", "readKmClass", "Lkotlin/metadata/KmClass;", "readKmClass$kotlin_metadata_jvm", "readKmPackage", "Lkotlin/metadata/KmPackage;", "readKmPackage$kotlin_metadata_jvm", "readKmLambda", "Lkotlin/metadata/KmLambda;", "readKmLambda$kotlin_metadata_jvm", "readMetadataImpl", "Lkotlin/metadata/jvm/KotlinClassMetadata;", "lenient", "readMetadataImpl$kotlin_metadata_jvm", "readModuleMetadataImpl", "Lkotlin/metadata/jvm/KmModule;", "data", "Lkotlin/metadata/internal/metadata/jvm/deserialization/ModuleMapping;", "readModuleMetadataImpl$kotlin_metadata_jvm", "checkMetadataVersionForRead", "", "throwIfNotCompatible", "jvmMetadataVersion", "Lkotlin/metadata/internal/metadata/deserialization/MetadataVersion;", "throwIfNotCompatible$kotlin_metadata_jvm", "kotlin-metadata-jvm"})
@SourceDebugExtension(value={"SMAP\nJvmReadUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmReadUtils.kt\nkotlin/metadata/jvm/internal/JvmReadUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 JvmExceptionUtils.kt\nkotlin/metadata/jvm/internal/JvmExceptionUtilsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,99:1\n1#2:100\n15#3,8:101\n3301#4,10:109\n1285#4,2:119\n1299#4,4:121\n*S KotlinDebug\n*F\n+ 1 JvmReadUtils.kt\nkotlin/metadata/jvm/internal/JvmReadUtils\n*L\n48#1:101,8\n64#1:109,10\n67#1:119,2\n67#1:121,4\n*E\n"})
public final class JvmReadUtils {
    @NotNull
    public static final JvmReadUtils INSTANCE = new JvmReadUtils();

    private JvmReadUtils() {
    }

    private final boolean isLessThan14(Metadata annotationData) {
        return new JvmMetadataVersion(annotationData.mv()).compareTo(new JvmMetadataVersion(1, 4, 0)) < 0;
    }

    @NotNull
    public final KmClass readKmClass$kotlin_metadata_jvm(@NotNull Metadata annotationData) {
        Intrinsics.checkNotNullParameter((Object)annotationData, (String)"annotationData");
        Pair<JvmNameResolver, ProtoBuf.Class> pair = JvmProtoBufUtil.readClassDataFrom(JvmExceptionUtilsKt.requireNotEmpty(annotationData), annotationData.d2());
        JvmNameResolver strings = (JvmNameResolver)pair.component1();
        ProtoBuf.Class proto = (ProtoBuf.Class)pair.component2();
        return ReadersKt.toKmClass$default(proto, strings, this.isLessThan14(annotationData), null, 4, null);
    }

    @NotNull
    public final KmPackage readKmPackage$kotlin_metadata_jvm(@NotNull Metadata annotationData) {
        Intrinsics.checkNotNullParameter((Object)annotationData, (String)"annotationData");
        Pair<JvmNameResolver, ProtoBuf.Package> pair = JvmProtoBufUtil.readPackageDataFrom(JvmExceptionUtilsKt.requireNotEmpty(annotationData), annotationData.d2());
        JvmNameResolver strings = (JvmNameResolver)pair.component1();
        ProtoBuf.Package proto = (ProtoBuf.Package)pair.component2();
        return ReadersKt.toKmPackage$default(proto, strings, this.isLessThan14(annotationData), null, 4, null);
    }

    @Nullable
    public final KmLambda readKmLambda$kotlin_metadata_jvm(@NotNull Metadata annotationData) {
        Object object;
        block4: {
            block3: {
                Intrinsics.checkNotNullParameter((Object)annotationData, (String)"annotationData");
                Pair<JvmNameResolver, ProtoBuf.Function> pair = annotationData.d1();
                Object[] p0 = (Object[])pair;
                boolean bl = false;
                object = !(p0.length == 0) ? pair : null;
                if (object == null) break block3;
                Pair<JvmNameResolver, ProtoBuf.Function> data1 = object;
                boolean bl2 = false;
                Pair<JvmNameResolver, ProtoBuf.Function> pair2 = JvmProtoBufUtil.readFunctionDataFrom((String[])data1, annotationData.d2());
                object = pair2;
                if (pair2 != null) break block4;
            }
            return null;
        }
        Pair<JvmNameResolver, ProtoBuf.Function> functionData = object;
        JvmNameResolver strings = (JvmNameResolver)functionData.component1();
        ProtoBuf.Function proto = (ProtoBuf.Function)functionData.component2();
        return ReadersKt.toKmLambda(proto, strings, this.isLessThan14(annotationData));
    }

    @NotNull
    public final KotlinClassMetadata readMetadataImpl$kotlin_metadata_jvm(@NotNull Metadata annotationData, boolean lenient) {
        KotlinClassMetadata kotlinClassMetadata;
        Intrinsics.checkNotNullParameter((Object)annotationData, (String)"annotationData");
        this.checkMetadataVersionForRead(annotationData, lenient);
        boolean $i$f$wrapIntoMetadataExceptionWhenNeeded = false;
        try {
            KotlinClassMetadata kotlinClassMetadata2;
            boolean bl = false;
            switch (annotationData.k()) {
                case 1: {
                    kotlinClassMetadata2 = new KotlinClassMetadata.Class(annotationData, lenient);
                    break;
                }
                case 2: {
                    kotlinClassMetadata2 = new KotlinClassMetadata.FileFacade(annotationData, lenient);
                    break;
                }
                case 3: {
                    kotlinClassMetadata2 = new KotlinClassMetadata.SyntheticClass(annotationData, lenient);
                    break;
                }
                case 4: {
                    kotlinClassMetadata2 = new KotlinClassMetadata.MultiFileClassFacade(annotationData, lenient);
                    break;
                }
                case 5: {
                    kotlinClassMetadata2 = new KotlinClassMetadata.MultiFileClassPart(annotationData, lenient);
                    break;
                }
                default: {
                    kotlinClassMetadata2 = new KotlinClassMetadata.Unknown(annotationData, lenient);
                }
            }
            kotlinClassMetadata = kotlinClassMetadata2;
        }
        catch (Throwable e$iv) {
            Throwable throwable = e$iv;
            throw throwable instanceof IllegalArgumentException ? e$iv : (throwable instanceof VirtualMachineError || throwable instanceof ThreadDeath ? e$iv : (Throwable)new InconsistentKotlinMetadataException("Exception occurred when reading Kotlin metadata", e$iv));
        }
        return kotlinClassMetadata;
    }

    /*
     * WARNING - void declaration
     */
    @UnstableMetadataApi
    @NotNull
    public final KmModule readModuleMetadataImpl$kotlin_metadata_jvm(@NotNull ModuleMapping data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        KmModule v = new KmModule();
        for (Map.Entry<String, PackageParts> entry : data.getPackageFqName2Parts().entrySet()) {
            void $this$associateWith$iv;
            String fqName2 = entry.getKey();
            PackageParts parts = entry.getValue();
            Iterable $this$partition$iv = parts.getParts();
            boolean $i$f$partition = false;
            ArrayList first$iv = new ArrayList();
            Iterable<Object> second$iv = new ArrayList();
            for (Object element$iv : $this$partition$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                boolean bl2 = parts.getMultifileFacadeName(it) == null ? first$iv.add(element$iv) : second$iv.add(element$iv);
            }
            Pair pair = new Pair(first$iv, second$iv);
            List fileFacades = (List)pair.component1();
            List multiFileClassParts = (List)pair.component2();
            Map<String, KmPackageParts> map2 = v.getPackageParts();
            second$iv = multiFileClassParts;
            List list2 = CollectionsKt.toMutableList((Collection)fileFacades);
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            void $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                String string;
                void it;
                String string2 = (String)element$iv$iv;
                Object t = element$iv$iv;
                Map map3 = result$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)parts.getMultifileFacadeName((String)it));
                map3.put(t, string);
            }
            Map map4 = MapsKt.toMutableMap((Map)result$iv);
            List list3 = list2;
            KmPackageParts kmPackageParts = new KmPackageParts(list3, map4);
            map2.put(fqName2, kmPackageParts);
        }
        for (ProtoBuf.Class classProto : data.getModuleData().getOptionalAnnotations()) {
            v.getOptionalAnnotationClasses().add(ReadersKt.toKmClass$default(classProto, data.getModuleData().getNameResolver(), false, null, 4, null));
        }
        return v;
    }

    private final void checkMetadataVersionForRead(Metadata annotationData, boolean lenient) {
        if (annotationData.mv().length == 0) {
            throw new IllegalArgumentException("Provided Metadata instance does not have metadataVersion in it and therefore is malformed and cannot be read.");
        }
        MetadataVersion jvmMetadataVersion = new MetadataVersion(annotationData.mv(), (annotationData.xi() & 8) != 0);
        this.throwIfNotCompatible$kotlin_metadata_jvm(jvmMetadataVersion, lenient);
    }

    public final void throwIfNotCompatible$kotlin_metadata_jvm(@NotNull MetadataVersion jvmMetadataVersion, boolean lenient) {
        boolean isCompatible;
        Intrinsics.checkNotNullParameter((Object)jvmMetadataVersion, (String)"jvmMetadataVersion");
        boolean isAtLeast110 = jvmMetadataVersion.isAtLeast(1, 1, 0);
        boolean bl = isCompatible = lenient ? isAtLeast110 : jvmMetadataVersion.isCompatibleWithCurrentCompilerVersion();
        if (!isCompatible) {
            String postfix = !isAtLeast110 ? "while minimum supported version is 1.1.0 (Kotlin 1.0)." : "while maximum supported version is " + (jvmMetadataVersion.isStrictSemantics() ? MetadataVersion.INSTANCE : MetadataVersion.INSTANCE_NEXT) + ". To support newer versions, update the kotlin-metadata-jvm library.";
            throw new IllegalArgumentException("Provided Metadata instance has version " + jvmMetadataVersion + ", " + postfix);
        }
    }
}

