/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sa.jdi;

import com.jetbrains.sa.jdi.ClassLoaderReferenceImpl;
import com.jetbrains.sa.jdi.ReferenceTypeImpl;
import com.jetbrains.sa.jdi.TypeImpl;
import com.jetbrains.sa.jdi.VirtualMachineImpl;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.PrimitiveType;
import sun.jvm.hotspot.oops.ArrayKlass;
import sun.jvm.hotspot.oops.Instance;
import sun.jvm.hotspot.oops.InstanceKlass;
import sun.jvm.hotspot.oops.Klass;
import sun.jvm.hotspot.oops.ObjArrayKlass;
import sun.jvm.hotspot.oops.TypeArrayKlass;

public class ArrayTypeImpl
extends ReferenceTypeImpl {
    ArrayTypeImpl(VirtualMachineImpl aVm, ArrayKlass aRef) {
        super(aVm, (Klass)aRef);
    }

    @Override
    public byte tag() {
        return 3;
    }

    public String componentSignature() {
        return this.signature().substring(1);
    }

    @Override
    public ClassLoaderReferenceImpl classLoader() {
        if (this.ref() instanceof TypeArrayKlass) {
            return null;
        }
        Klass bottomKlass = ((ObjArrayKlass)this.ref()).getBottomKlass();
        if (bottomKlass instanceof TypeArrayKlass) {
            return null;
        }
        Instance xx = (Instance)((InstanceKlass)bottomKlass).getClassLoader();
        return this.vm.classLoaderMirror(xx);
    }

    public TypeImpl componentType() throws ClassNotLoadedException {
        ArrayKlass k = (ArrayKlass)this.ref();
        if (k instanceof ObjArrayKlass) {
            Klass elementKlass = ((ObjArrayKlass)k).getElementKlass();
            if (elementKlass == null) {
                throw new ClassNotLoadedException(this.componentSignature());
            }
            return this.vm.referenceType(elementKlass);
        }
        return this.vm.primitiveTypeMirror(this.signature().charAt(1));
    }

    static boolean isComponentAssignable(TypeImpl destination, TypeImpl source) {
        if (source instanceof PrimitiveType) {
            return source.equals(destination);
        }
        if (destination instanceof PrimitiveType) {
            return false;
        }
        ReferenceTypeImpl refSource = (ReferenceTypeImpl)source;
        ReferenceTypeImpl refDestination = (ReferenceTypeImpl)destination;
        return refSource.isAssignableTo(refDestination);
    }

    @Override
    boolean isAssignableTo(ReferenceTypeImpl destType) {
        if (destType instanceof ArrayTypeImpl) {
            try {
                TypeImpl destComponentType = ((ArrayTypeImpl)destType).componentType();
                return ArrayTypeImpl.isComponentAssignable(destComponentType, this.componentType());
            }
            catch (ClassNotLoadedException e) {
                return false;
            }
        }
        String typeName = destType.name();
        if (destType instanceof InterfaceType) {
            return this.vm.javaLangCloneable.equals(typeName) || this.vm.javaIoSerializable.equals(typeName);
        }
        return this.vm.javaLangObject.equals(typeName);
    }

    @Override
    int getModifiers() {
        try {
            TypeImpl t = this.componentType();
            if (t instanceof PrimitiveType) {
                return 17;
            }
            ReferenceTypeImpl rt = (ReferenceTypeImpl)t;
            return rt.modifiers();
        }
        catch (ClassNotLoadedException cnle) {
            cnle.printStackTrace();
            return -1;
        }
    }

    public String toString() {
        return "array class " + this.name() + " (" + this.loaderString() + ")";
    }

    @Override
    public boolean isPrepared() {
        return true;
    }

    @Override
    public boolean isAbstract() {
        return false;
    }
}

