/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword.digest.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jackson.NodeType;
import com.github.fge.jsonschema.keyword.digest.AbstractDigester;
import com.github.fge.jsonschema.keyword.digest.Digester;

public final class AdditionalItemsDigester
extends AbstractDigester {
    private static final Digester INSTANCE = new AdditionalItemsDigester();

    public static Digester getInstance() {
        return INSTANCE;
    }

    private AdditionalItemsDigester() {
        super("additionalItems", NodeType.ARRAY, new NodeType[0]);
    }

    @Override
    public JsonNode digest(JsonNode schema) {
        ObjectNode ret = FACTORY.objectNode();
        ret.put(this.keyword, true);
        ret.put("itemsSize", 0);
        if (schema.get(this.keyword).asBoolean(true)) {
            return ret;
        }
        JsonNode itemsNode = schema.path("items");
        if (!itemsNode.isArray()) {
            return ret;
        }
        ret.put(this.keyword, false);
        ret.put("itemsSize", itemsNode.size());
        return ret;
    }
}

