/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.proto.response.document.common;

import java.io.IOException;
import org.opensearch.action.DocWriteResponse;
import org.opensearch.protobufs.ResponseItem;
import org.opensearch.protobufs.ShardInfo;
import org.opensearch.transport.grpc.proto.response.document.common.ShardInfoProtoUtils;

public class DocWriteResponseProtoUtils {
    private DocWriteResponseProtoUtils() {
    }

    public static ResponseItem.Builder toProto(DocWriteResponse response) throws IOException {
        ResponseItem.Builder responseItem = ResponseItem.newBuilder();
        responseItem.setXIndex(response.getIndex());
        if (response.getId() != null && !response.getId().isEmpty()) {
            responseItem.setXId(response.getId());
        }
        responseItem.setXVersion(response.getVersion());
        responseItem.setResult(response.getResult().getLowercase());
        if (response.forcedRefresh()) {
            responseItem.setForcedRefresh(true);
        }
        ShardInfo shardInfo = ShardInfoProtoUtils.toProto(response.getShardInfo());
        responseItem.setXShards(shardInfo);
        if (response.getSeqNo() >= 0L) {
            responseItem.setXSeqNo(response.getSeqNo());
            responseItem.setXPrimaryTerm(response.getPrimaryTerm());
        }
        return responseItem;
    }
}

