/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.ast.tree;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import org.opensearch.sql.ast.AbstractNodeVisitor;
import org.opensearch.sql.ast.expression.Argument;
import org.opensearch.sql.ast.tree.UnresolvedPlan;
import org.opensearch.sql.common.utils.StringUtils;

public class Transpose
extends UnresolvedPlan {
    @NonNull
    private final Map<String, Argument> arguments;
    private UnresolvedPlan child;
    private static final int MAX_LIMIT_TRANSPOSE = 10000;
    private static final int DEFAULT_MAX_ROWS = 5;
    private static final String DEFAULT_COLUMN_NAME = "column";
    private final int maxRows;
    private final String columnName;

    public Transpose(Map<String, Argument> arguments) {
        this.arguments = arguments;
        int tempMaxRows = 5;
        if (arguments.containsKey("number") && arguments.get("number").getValue() != null) {
            try {
                tempMaxRows = Integer.parseInt(arguments.get("number").getValue().toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.maxRows = tempMaxRows;
        if (this.maxRows > 10000) {
            throw new IllegalArgumentException(StringUtils.format((String)"Maximum limit to transpose is %s", (Object[])new Object[]{10000}));
        }
        this.columnName = arguments.containsKey("columnName") && arguments.get("columnName").getValue() != null ? arguments.get("columnName").getValue().toString() : DEFAULT_COLUMN_NAME;
    }

    @Override
    public Transpose attach(UnresolvedPlan child) {
        this.child = child;
        return this;
    }

    public List<UnresolvedPlan> getChild() {
        return this.child == null ? ImmutableList.of() : ImmutableList.of((Object)this.child);
    }

    @Override
    public <T, C> T accept(AbstractNodeVisitor<T, C> nodeVisitor, C context) {
        return nodeVisitor.visitTranspose(this, context);
    }

    @NonNull
    @Generated
    public Map<String, Argument> getArguments() {
        return this.arguments;
    }

    @Generated
    public int getMaxRows() {
        return this.maxRows;
    }

    @Generated
    public String getColumnName() {
        return this.columnName;
    }

    @Generated
    public void setChild(UnresolvedPlan child) {
        this.child = child;
    }

    @Override
    @Generated
    public String toString() {
        return "Transpose(arguments=" + String.valueOf(this.getArguments()) + ", child=" + String.valueOf(this.getChild()) + ", maxRows=" + this.getMaxRows() + ", columnName=" + this.getColumnName() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Transpose)) {
            return false;
        }
        Transpose other = (Transpose)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxRows() != other.getMaxRows()) {
            return false;
        }
        Map<String, Argument> this$arguments = this.getArguments();
        Map<String, Argument> other$arguments = other.getArguments();
        if (this$arguments == null ? other$arguments != null : !((Object)this$arguments).equals(other$arguments)) {
            return false;
        }
        List<UnresolvedPlan> this$child = this.getChild();
        List<UnresolvedPlan> other$child = other.getChild();
        if (this$child == null ? other$child != null : !((Object)this$child).equals(other$child)) {
            return false;
        }
        String this$columnName = this.getColumnName();
        String other$columnName = other.getColumnName();
        return !(this$columnName == null ? other$columnName != null : !this$columnName.equals(other$columnName));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Transpose;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMaxRows();
        Map<String, Argument> $arguments = this.getArguments();
        result = result * 59 + ($arguments == null ? 43 : ((Object)$arguments).hashCode());
        List<UnresolvedPlan> $child = this.getChild();
        result = result * 59 + ($child == null ? 43 : ((Object)$child).hashCode());
        String $columnName = this.getColumnName();
        result = result * 59 + ($columnName == null ? 43 : $columnName.hashCode());
        return result;
    }
}

