/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.tree;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.store.IndexIntervalManager;
import com.amazon.randomcutforest.tree.AbstractNodeStore;
import com.amazon.randomcutforest.tree.BoundingBox;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Stack;

public class NodeStoreMedium
extends AbstractNodeStore {
    private final char[] parentIndex;
    private final int[] leftIndex;
    private final int[] rightIndex;
    public final char[] cutDimension;
    private final char[] mass;

    public NodeStoreMedium(AbstractNodeStore.Builder builder) {
        super(builder);
        this.mass = new char[this.capacity];
        Arrays.fill(this.mass, '\u0000');
        if (builder.storeParent) {
            this.parentIndex = new char[this.capacity];
            Arrays.fill(this.parentIndex, (char)this.capacity);
        } else {
            this.parentIndex = null;
        }
        if (builder.leftIndex == null) {
            this.leftIndex = new int[this.capacity];
            this.rightIndex = new int[this.capacity];
            this.cutDimension = new char[this.capacity];
            Arrays.fill(this.leftIndex, this.capacity);
            Arrays.fill(this.rightIndex, this.capacity);
        } else {
            int i;
            this.leftIndex = Arrays.copyOf(builder.leftIndex, builder.leftIndex.length);
            this.rightIndex = Arrays.copyOf(builder.rightIndex, builder.rightIndex.length);
            this.cutDimension = CommonUtils.toCharArray(builder.cutDimension);
            BitSet bits = new BitSet(this.capacity);
            if (builder.root != Null) {
                bits.set(builder.root);
            }
            for (i = 0; i < this.leftIndex.length; ++i) {
                if (!this.isInternal(this.leftIndex[i])) continue;
                bits.set(this.leftIndex[i]);
                if (this.parentIndex == null) continue;
                this.parentIndex[this.leftIndex[i]] = (char)i;
            }
            for (i = 0; i < this.rightIndex.length; ++i) {
                if (!this.isInternal(this.rightIndex[i])) continue;
                bits.set(this.rightIndex[i]);
                if (this.parentIndex == null) continue;
                this.parentIndex[this.rightIndex[i]] = (char)i;
            }
            this.freeNodeManager = new IndexIntervalManager(this.capacity, this.capacity, bits);
        }
    }

    @Override
    public int addNode(Stack<int[]> pathToRoot, float[] point, long sequenceIndex, int pointIndex, int childIndex, int childMassIfLeaf, int cutDimension, float cutValue, BoundingBox box) {
        int parentIndex;
        int index = this.freeNodeManager.takeIndex();
        this.cutValue[index] = cutValue;
        this.cutDimension[index] = (char)cutDimension;
        if (this.leftOf(cutValue, cutDimension, point)) {
            this.leftIndex[index] = pointIndex + this.capacity + 1;
            this.rightIndex[index] = childIndex;
        } else {
            this.rightIndex[index] = pointIndex + this.capacity + 1;
            this.leftIndex[index] = childIndex;
        }
        this.mass[index] = (char)(((childMassIfLeaf > 0 ? childMassIfLeaf : this.getMass(childIndex)) + 1) % (this.capacity + 1));
        int n = parentIndex = pathToRoot.size() == 0 ? Null : ((int[])pathToRoot.lastElement())[0];
        if (this.parentIndex != null) {
            this.parentIndex[index] = (char)parentIndex;
            if (!this.isLeaf(childIndex)) {
                this.parentIndex[childIndex] = (char)index;
            }
        }
        if (parentIndex != Null) {
            this.spliceEdge(parentIndex, childIndex, index);
        }
        return index;
    }

    @Override
    public void assignInPartialTree(int node, float[] point, int childReference) {
        if (this.leftOf(node, point)) {
            this.leftIndex[node] = childReference;
        } else {
            this.rightIndex[node] = childReference;
        }
    }

    @Override
    public int getLeftIndex(int index) {
        return this.leftIndex[index];
    }

    @Override
    public int getRightIndex(int index) {
        return this.rightIndex[index];
    }

    @Override
    public int getParentIndex(int index) {
        CommonUtils.checkArgument(this.parentIndex != null, "incorrect call");
        return this.parentIndex[index];
    }

    @Override
    public void setRoot(int index) {
        if (!this.isLeaf(index) && this.parentIndex != null) {
            this.parentIndex[index] = (char)this.capacity;
        }
    }

    @Override
    protected void decreaseMassOfInternalNode(int node) {
        this.mass[node] = (char)((this.mass[node] + this.capacity) % (this.capacity + 1));
    }

    @Override
    protected void increaseMassOfInternalNode(int node) {
        this.mass[node] = (char)((this.mass[node] + '\u0001') % (this.capacity + 1));
    }

    @Override
    public void deleteInternalNode(int index) {
        this.leftIndex[index] = this.capacity;
        this.rightIndex[index] = this.capacity;
        if (this.parentIndex != null) {
            this.parentIndex[index] = (char)this.capacity;
        }
        this.freeNodeManager.releaseIndex(index);
    }

    @Override
    public int getMass(int index) {
        return this.mass[index] != '\u0000' ? this.mass[index] : this.capacity + 1;
    }

    @Override
    public void spliceEdge(int parent, int node, int newNode) {
        assert (!this.isLeaf(newNode));
        if (node == this.leftIndex[parent]) {
            this.leftIndex[parent] = newNode;
        } else {
            this.rightIndex[parent] = newNode;
        }
        if (this.parentIndex != null && this.isInternal(node)) {
            this.parentIndex[node] = (char)newNode;
        }
    }

    @Override
    public void replaceParentBySibling(int grandParent, int parent, int node) {
        int sibling = this.getSibling(node, parent);
        if (parent == this.leftIndex[grandParent]) {
            this.leftIndex[grandParent] = sibling;
        } else {
            this.rightIndex[grandParent] = sibling;
        }
        if (this.parentIndex != null && this.isInternal(sibling)) {
            this.parentIndex[sibling] = (char)grandParent;
        }
    }

    @Override
    public int getCutDimension(int index) {
        return this.cutDimension[index];
    }

    @Override
    public int[] getCutDimension() {
        return CommonUtils.toIntArray(this.cutDimension);
    }

    @Override
    public int[] getLeftIndex() {
        return Arrays.copyOf(this.leftIndex, this.leftIndex.length);
    }

    @Override
    public int[] getRightIndex() {
        return Arrays.copyOf(this.rightIndex, this.rightIndex.length);
    }
}

