/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geospatial.action.upload.geojson;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.Strings;
import org.opensearch.geospatial.GeospatialParser;
import org.opensearch.geospatial.settings.GeospatialSettingsAccessor;

public final class UploadGeoJSONRequestContent {
    public static final String GEOSPATIAL_DEFAULT_FIELD_NAME = "location";
    public static final ParseField FIELD_INDEX = new ParseField("index", new String[0]);
    public static final ParseField FIELD_GEOSPATIAL = new ParseField("field", new String[0]);
    public static final ParseField FIELD_GEOSPATIAL_TYPE = new ParseField("type", new String[0]);
    public static final ParseField FIELD_DATA = new ParseField("data", new String[0]);
    public static final int MAX_SUPPORTED_GEOJSON_FEATURE_COUNT = 10000;
    private static volatile GeospatialSettingsAccessor settingsAccessor;
    private static final String GEOMETRY_TYPE_LINESTRING = "LineString";
    private static final String GEOMETRY_TYPE_POLYGON = "Polygon";
    private static final String GEOMETRY_TYPE_MULTILINESTRING = "MultiLineString";
    private static final String GEOMETRY_TYPE_MULTIPOLYGON = "MultiPolygon";
    private static final String GEOMETRY_TYPE_GEOMETRYCOLLECTION = "GeometryCollection";
    private final String indexName;
    private final String fieldName;
    private final String fieldType;
    private final List<Object> data;

    public static void initialize(GeospatialSettingsAccessor accessor) {
        settingsAccessor = accessor;
    }

    public static UploadGeoJSONRequestContent create(Map<String, Object> input) {
        String fieldType;
        Objects.requireNonNull(input, "input cannot be null");
        String index = UploadGeoJSONRequestContent.validateIndexName(input);
        String fieldName = GeospatialParser.extractValueAsString(input, FIELD_GEOSPATIAL.getPreferredName());
        if (!Strings.hasText((String)fieldName)) {
            fieldName = GEOSPATIAL_DEFAULT_FIELD_NAME;
        }
        if (!Strings.hasText((String)(fieldType = GeospatialParser.extractValueAsString(input, FIELD_GEOSPATIAL_TYPE.getPreferredName())))) {
            throw new IllegalArgumentException("field [ " + FIELD_GEOSPATIAL_TYPE.getPreferredName() + " ] cannot be empty");
        }
        Object geoJSONData = Objects.requireNonNull(input.get(FIELD_DATA.getPreferredName()), "field [ " + FIELD_DATA.getPreferredName() + " ] cannot be empty");
        if (!(geoJSONData instanceof List)) {
            throw new IllegalArgumentException(String.valueOf(geoJSONData) + " is not an instance of List, but of type [ " + geoJSONData.getClass().getName() + " ]");
        }
        UploadGeoJSONRequestContent.validateFeatureCount(geoJSONData);
        UploadGeoJSONRequestContent.validateGeometricComplexity(geoJSONData);
        return new UploadGeoJSONRequestContent(index, fieldName, fieldType, (List)geoJSONData);
    }

    private static void validateFeatureCount(Object geoJSONData) {
        long featureCount = UploadGeoJSONRequestContent.getFeatureCount(geoJSONData);
        if (featureCount > 10000L) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Received %d features, but, cannot upload more than %d features", featureCount, 10000));
        }
    }

    private static long getFeatureCount(Object geoJSONData) {
        return ((List)geoJSONData).stream().map(GeospatialParser::toStringObjectMap).map(GeospatialParser::getFeatures).flatMap(Collection::stream).count();
    }

    private static void validateGeometricComplexity(Object geoJSONData) {
        List dataList = (List)geoJSONData;
        for (Object item : dataList) {
            Map<String, Object> geoJSON = GeospatialParser.toStringObjectMap(item);
            List<Map<String, Object>> features = GeospatialParser.getFeatures(geoJSON);
            for (Map<String, Object> feature : features) {
                Object geometryObj = feature.get("geometry");
                if (geometryObj == null) continue;
                Map<String, Object> geometry = GeospatialParser.toStringObjectMap(geometryObj);
                UploadGeoJSONRequestContent.validateGeometryIterative(geometry);
            }
        }
    }

    private static void validateGeometryIterative(Map<String, Object> rootGeometry) {
        ArrayDeque<GeometryDepthPair> queue = new ArrayDeque<GeometryDepthPair>();
        queue.add(new GeometryDepthPair(rootGeometry, 0));
        while (!queue.isEmpty()) {
            GeometryDepthPair current = (GeometryDepthPair)queue.poll();
            if (current.depth > settingsAccessor.getMaxGeometryCollectionNestedDepth()) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "GeometryCollection nesting depth %d exceeds limit of %d", current.depth, settingsAccessor.getMaxGeometryCollectionNestedDepth()));
            }
            String type = GeospatialParser.extractValueAsString(current.geometry, "type");
            if (type == null) continue;
            if (GEOMETRY_TYPE_GEOMETRYCOLLECTION.equals(type)) {
                Object geometries = current.geometry.get("geometries");
                if (!(geometries instanceof List)) continue;
                List geometryList = (List)geometries;
                if (geometryList.size() > settingsAccessor.getMaxMultiGeometries()) {
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "GeometryCollection has %d geometries, exceeds limit of %d", geometryList.size(), settingsAccessor.getMaxMultiGeometries()));
                }
                for (Object geomObj : geometryList) {
                    if (!(geomObj instanceof Map)) continue;
                    Map childGeometry = (Map)geomObj;
                    queue.add(new GeometryDepthPair(childGeometry, current.depth + 1));
                }
                continue;
            }
            Object coordinates = current.geometry.get("coordinates");
            if (!(coordinates instanceof List)) continue;
            List coordList = (List)coordinates;
            switch (type) {
                case "LineString": {
                    UploadGeoJSONRequestContent.validateLineString(coordList);
                    break;
                }
                case "Polygon": {
                    UploadGeoJSONRequestContent.validatePolygon(coordList);
                    break;
                }
                case "MultiLineString": {
                    UploadGeoJSONRequestContent.validateMultiLineString(coordList);
                    break;
                }
                case "MultiPolygon": {
                    UploadGeoJSONRequestContent.validateMultiPolygon(coordList);
                    break;
                }
            }
        }
    }

    private static void validateLineString(List<?> coordinates) {
        if (coordinates.size() > settingsAccessor.getMaxCoordinatesPerGeometry()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "LineString has %d coordinates, exceeds limit of %d", coordinates.size(), settingsAccessor.getMaxCoordinatesPerGeometry()));
        }
    }

    private static void validatePolygon(List<?> rings) {
        List outerRing;
        int holes = rings.size() - 1;
        if (holes > settingsAccessor.getMaxHolesPerPolygon()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Polygon has %d holes, exceeds limit of %d", holes, settingsAccessor.getMaxHolesPerPolygon()));
        }
        if (!rings.isEmpty() && rings.get(0) instanceof List && (outerRing = (List)rings.get(0)).size() > settingsAccessor.getMaxCoordinatesPerGeometry()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Polygon outer ring has %d coordinates, exceeds limit of %d", outerRing.size(), settingsAccessor.getMaxCoordinatesPerGeometry()));
        }
        for (int i = 1; i < rings.size(); ++i) {
            List hole;
            if (!(rings.get(i) instanceof List) || (hole = (List)rings.get(i)).size() <= settingsAccessor.getMaxCoordinatesPerGeometry()) continue;
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Polygon hole %d has %d coordinates, exceeds limit of %d", i, hole.size(), settingsAccessor.getMaxCoordinatesPerGeometry()));
        }
    }

    private static void validateMultiLineString(List<?> lineStrings) {
        if (lineStrings.size() > settingsAccessor.getMaxMultiGeometries()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "MultiLineString has %d LineStrings, exceeds limit of %d", lineStrings.size(), settingsAccessor.getMaxMultiGeometries()));
        }
        for (Object lineObj : lineStrings) {
            if (!(lineObj instanceof List)) continue;
            UploadGeoJSONRequestContent.validateLineString((List)lineObj);
        }
    }

    private static void validateMultiPolygon(List<?> polygons) {
        if (polygons.size() > settingsAccessor.getMaxMultiGeometries()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "MultiPolygon has %d Polygons, exceeds limit of %d", polygons.size(), settingsAccessor.getMaxMultiGeometries()));
        }
        for (Object polyObj : polygons) {
            if (!(polyObj instanceof List)) continue;
            UploadGeoJSONRequestContent.validatePolygon((List)polyObj);
        }
    }

    private static String validateIndexName(Map<String, Object> input) {
        String index = GeospatialParser.extractValueAsString(input, FIELD_INDEX.getPreferredName());
        if (Strings.hasText((String)index)) {
            return index;
        }
        throw new IllegalArgumentException(String.format(Locale.getDefault(), "field [ %s ] cannot be empty", FIELD_INDEX.getPreferredName()));
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public List<Object> getData() {
        return this.data;
    }

    public String getFieldType() {
        return this.fieldType;
    }

    @Generated
    private UploadGeoJSONRequestContent(String indexName, String fieldName, String fieldType, List<Object> data) {
        this.indexName = indexName;
        this.fieldName = fieldName;
        this.fieldType = fieldType;
        this.data = data;
    }

    private static class GeometryDepthPair {
        final Map<String, Object> geometry;
        final int depth;

        GeometryDepthPair(Map<String, Object> geometry, int depth) {
            this.geometry = geometry;
            this.depth = depth;
        }
    }
}

