/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jooq.Configuration;
import org.jooq.Field;
import org.jooq.ForeignKey;
import org.jooq.Index;
import org.jooq.Key;
import org.jooq.Schema;
import org.jooq.Sequence;
import org.jooq.SortField;
import org.jooq.SortOrder;
import org.jooq.Table;
import org.jooq.UniqueKey;
import org.jooq.impl.DSL;
import org.jooq.tools.StringUtils;
import org.jooq.util.xml.jaxb.Column;
import org.jooq.util.xml.jaxb.IndexColumnUsage;
import org.jooq.util.xml.jaxb.InformationSchema;
import org.jooq.util.xml.jaxb.KeyColumnUsage;
import org.jooq.util.xml.jaxb.ReferentialConstraint;
import org.jooq.util.xml.jaxb.TableConstraint;
import org.jooq.util.xml.jaxb.TableConstraintType;

final class InformationSchemaExport {
    static final InformationSchema exportTables(Configuration configuration, List<Table<?>> tables) {
        InformationSchema result = new InformationSchema();
        LinkedHashSet<Schema> includedSchemas = new LinkedHashSet<Schema>();
        LinkedHashSet includedTables = new LinkedHashSet(tables);
        for (Table<Object> t : tables) {
            includedSchemas.add(t.getSchema());
        }
        for (Schema s : includedSchemas) {
            InformationSchemaExport.exportSchema0(result, s);
        }
        for (Table<Object> t : tables) {
            InformationSchemaExport.exportTable0(configuration, result, t, includedTables);
        }
        return result;
    }

    static final InformationSchema exportSchemas(Configuration configuration, List<Schema> schemas) {
        InformationSchema result = new InformationSchema();
        LinkedHashSet includedTables = new LinkedHashSet();
        for (Schema s : schemas) {
            for (Table<?> table : s.getTables()) {
                includedTables.add(table);
            }
        }
        for (Schema s : schemas) {
            InformationSchemaExport.exportSchema0(result, s);
            for (Table<?> table : s.getTables()) {
                InformationSchemaExport.exportTable0(configuration, result, table, includedTables);
            }
            for (Sequence sequence : s.getSequences()) {
                InformationSchemaExport.exportSequences0(configuration, result, sequence);
            }
        }
        return result;
    }

    private static final void exportSequences0(Configuration configuration, InformationSchema result, Sequence<?> q) {
        org.jooq.util.xml.jaxb.Sequence iq = new org.jooq.util.xml.jaxb.Sequence();
        if (!StringUtils.isBlank(q.getCatalog().getName())) {
            iq.setSequenceCatalog(q.getCatalog().getName());
        }
        if (!StringUtils.isBlank(q.getSchema().getName())) {
            iq.setSequenceSchema(q.getSchema().getName());
        }
        iq.setSequenceName(q.getName());
        iq.setDataType(q.getDataType().getTypeName(configuration));
        if (q.getDataType().hasLength()) {
            iq.setCharacterMaximumLength(q.getDataType().length());
        }
        if (q.getDataType().hasPrecision()) {
            iq.setNumericPrecision(q.getDataType().precision());
        }
        if (q.getDataType().hasScale()) {
            iq.setNumericScale(q.getDataType().scale());
        }
        result.getSequences().add(iq);
    }

    private static final void exportSchema0(InformationSchema result, Schema s) {
        org.jooq.util.xml.jaxb.Schema is = new org.jooq.util.xml.jaxb.Schema();
        if (!StringUtils.isBlank(s.getCatalog().getName())) {
            is.setCatalogName(s.getCatalog().getName());
        }
        if (!StringUtils.isBlank(s.getName())) {
            is.setSchemaName(s.getName());
            result.getSchemata().add(is);
        }
    }

    private static final void exportTable0(Configuration configuration, InformationSchema result, Table<?> t, Set<Table<?>> includedTables) {
        org.jooq.util.xml.jaxb.Table it = new org.jooq.util.xml.jaxb.Table();
        if (!StringUtils.isBlank(t.getCatalog().getName())) {
            it.setTableCatalog(t.getCatalog().getName());
        }
        if (!StringUtils.isBlank(t.getSchema().getName())) {
            it.setTableSchema(t.getSchema().getName());
        }
        it.setTableName(t.getName());
        result.getTables().add(it);
        Field<?>[] fields = t.fields();
        for (int i = 0; i < fields.length; ++i) {
            Field<?> field = fields[i];
            Column ic = new Column();
            if (!StringUtils.isBlank(t.getCatalog().getName())) {
                ic.setTableCatalog(t.getCatalog().getName());
            }
            if (!StringUtils.isBlank(t.getSchema().getName())) {
                ic.setTableSchema(t.getSchema().getName());
            }
            ic.setTableName(t.getName());
            ic.setColumnName(field.getName());
            ic.setDataType(field.getDataType().getTypeName(configuration));
            if (field.getDataType().hasLength()) {
                ic.setCharacterMaximumLength(field.getDataType().length());
            }
            if (field.getDataType().hasPrecision()) {
                ic.setNumericPrecision(field.getDataType().precision());
            }
            if (field.getDataType().hasScale()) {
                ic.setNumericScale(field.getDataType().scale());
            }
            ic.setColumnDefault(DSL.using(configuration).render(field.getDataType().defaultValue()));
            ic.setIsNullable(field.getDataType().nullable());
            ic.setOrdinalPosition(i + 1);
            result.getColumns().add(ic);
        }
        for (UniqueKey<?> uniqueKey : t.getKeys()) {
            InformationSchemaExport.exportKey0(result, t, uniqueKey, uniqueKey.isPrimary() ? TableConstraintType.PRIMARY_KEY : TableConstraintType.UNIQUE);
        }
        for (ForeignKey foreignKey : t.getReferences()) {
            if (!includedTables.contains(foreignKey.getKey().getTable())) continue;
            InformationSchemaExport.exportKey0(result, t, foreignKey, TableConstraintType.FOREIGN_KEY);
        }
        for (Index index : t.getIndexes()) {
            InformationSchemaExport.exportIndex0(result, t, index);
        }
    }

    private static final void exportIndex0(InformationSchema result, Table<?> t, Index index) {
        org.jooq.util.xml.jaxb.Index i = new org.jooq.util.xml.jaxb.Index();
        String catalogName = t.getCatalog().getName();
        String schemaName = t.getSchema().getName();
        if (!StringUtils.isBlank(catalogName)) {
            i.setIndexCatalog(catalogName);
            i.setTableCatalog(catalogName);
        }
        if (!StringUtils.isBlank(schemaName)) {
            i.setIndexSchema(schemaName);
            i.setTableSchema(schemaName);
        }
        i.setIndexName(index.getName());
        i.setTableName(t.getName());
        i.setIsUnique(index.getUnique());
        result.getIndexes().add(i);
        int position = 1;
        for (SortField<?> sortField : index.getFields()) {
            IndexColumnUsage ic = new IndexColumnUsage();
            if (!StringUtils.isBlank(catalogName)) {
                ic.setIndexCatalog(catalogName);
                ic.setTableCatalog(catalogName);
            }
            if (!StringUtils.isBlank(schemaName)) {
                ic.setIndexSchema(schemaName);
                ic.setTableSchema(schemaName);
            }
            ic.setIndexName(index.getName());
            ic.setTableName(t.getName());
            ic.setOrdinalPosition(position++);
            ic.setColumnName(sortField.getName());
            ic.setIsDescending(sortField.getOrder() == SortOrder.DESC);
            result.getIndexColumnUsages().add(ic);
        }
    }

    private static final void exportKey0(InformationSchema result, Table<?> t, Key<?> key, TableConstraintType constraintType) {
        TableConstraint tc = new TableConstraint();
        String catalogName = t.getCatalog().getName();
        String schemaName = t.getSchema().getName();
        tc.setConstraintName(key.getName());
        tc.setConstraintType(constraintType);
        if (!StringUtils.isBlank(catalogName)) {
            tc.setConstraintCatalog(catalogName);
            tc.setTableCatalog(catalogName);
        }
        if (!StringUtils.isBlank(schemaName)) {
            tc.setConstraintSchema(schemaName);
            tc.setTableSchema(schemaName);
        }
        tc.setTableName(t.getName());
        result.getTableConstraints().add(tc);
        int i = 0;
        for (Field field : key.getFields()) {
            KeyColumnUsage kc = new KeyColumnUsage();
            if (!StringUtils.isBlank(catalogName)) {
                kc.setConstraintCatalog(catalogName);
                kc.setTableCatalog(catalogName);
            }
            if (!StringUtils.isBlank(schemaName)) {
                kc.setConstraintSchema(schemaName);
                kc.setTableSchema(schemaName);
            }
            kc.setColumnName(field.getName());
            kc.setTableName(t.getName());
            kc.setOrdinalPosition(++i);
            kc.setConstraintName(key.getName());
            result.getKeyColumnUsages().add(kc);
        }
        if (constraintType == TableConstraintType.FOREIGN_KEY) {
            ReferentialConstraint rc = new ReferentialConstraint();
            UniqueKey uniqueKey = ((ForeignKey)key).getKey();
            String ukCatalogName = uniqueKey.getTable().getCatalog().getName();
            String ukSchemaName = uniqueKey.getTable().getSchema().getName();
            if (!StringUtils.isBlank(catalogName)) {
                rc.setConstraintCatalog(catalogName);
            }
            if (!StringUtils.isBlank(ukCatalogName)) {
                rc.setUniqueConstraintCatalog(ukCatalogName);
            }
            if (!StringUtils.isBlank(schemaName)) {
                rc.setConstraintSchema(schemaName);
            }
            if (!StringUtils.isBlank(ukSchemaName)) {
                rc.setUniqueConstraintSchema(ukSchemaName);
            }
            rc.setConstraintName(key.getName());
            rc.setUniqueConstraintName(uniqueKey.getName());
            result.getReferentialConstraints().add(rc);
        }
    }

    private InformationSchemaExport() {
    }
}

