/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage.serde;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.opensearch.sql.opensearch.storage.script.CompoundedScriptEngine;

public class SerializationWrapper {
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final TypeReference<LangScriptWrapper> TYPE_REF = new TypeReference<LangScriptWrapper>(){};
    public static final String LANG_TYPE = "langType";
    public static final String SCRIPT = "script";

    public static String wrapWithLangType(CompoundedScriptEngine.ScriptEngineType langType, String script) {
        try {
            return mapper.writeValueAsString((Object)new LangScriptWrapper(langType, script));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to wrap script with langType: " + String.valueOf((Object)langType), e);
        }
    }

    public static LangScriptWrapper unwrapLangType(String wrapped) {
        try {
            LangScriptWrapper unwrapped = (LangScriptWrapper)mapper.readValue(wrapped, TYPE_REF);
            if (unwrapped.langType == null || StringUtils.isBlank((CharSequence)unwrapped.script)) {
                throw new IllegalArgumentException("Missing required fields in language script wrapper.");
            }
            return unwrapped;
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to unwrap script with langType.", e);
        }
    }

    public static class LangScriptWrapper {
        public CompoundedScriptEngine.ScriptEngineType langType;
        public String script;

        @Generated
        public LangScriptWrapper() {
        }

        @Generated
        public LangScriptWrapper(CompoundedScriptEngine.ScriptEngineType langType, String script) {
            this.langType = langType;
            this.script = script;
        }
    }
}

