/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rex;

import java.util.Objects;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBiVisitor;
import org.apache.calcite.rex.RexVariable;
import org.apache.calcite.rex.RexVisitor;
import org.checkerframework.checker.nullness.qual.Nullable;

public class RexNodeAndFieldIndex
extends RexVariable {
    private final int nodeIndex;
    private final int fieldIndex;

    public RexNodeAndFieldIndex(int nodeIndex, int fieldIndex, String name, RelDataType type) {
        super(name, type);
        this.nodeIndex = nodeIndex;
        this.fieldIndex = fieldIndex;
    }

    public int getNodeIndex() {
        return this.nodeIndex;
    }

    public int getFieldIndex() {
        return this.fieldIndex;
    }

    @Override
    public <R> R accept(RexVisitor<R> visitor) {
        return visitor.visitNodeAndFieldIndex(this);
    }

    @Override
    public <R, P> R accept(RexBiVisitor<R, P> visitor, P arg) {
        return visitor.visitNodeAndFieldIndex(this, arg);
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof RexNodeAndFieldIndex && this.nodeIndex == ((RexNodeAndFieldIndex)obj).nodeIndex && this.fieldIndex == ((RexNodeAndFieldIndex)obj).fieldIndex;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.nodeIndex, this.fieldIndex);
    }

    @Override
    public String toString() {
        return "node(" + this.nodeIndex + ")_field(" + this.fieldIndex + ")";
    }
}

