/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite.utils;

import java.util.List;
import lombok.Generated;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttleImpl;
import org.apache.calcite.rel.logical.LogicalCorrelate;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalIntersect;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.logical.LogicalMinus;
import org.apache.calcite.rel.logical.LogicalUnion;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.sql.calcite.CalcitePlanContext;
import org.opensearch.sql.calcite.plan.rel.LogicalSystemLimit;
import org.opensearch.sql.calcite.utils.CalciteUtils;
import org.opensearch.sql.calcite.utils.PlanUtils;

public final class SubsearchUtils {
    private static RelNode insertSysLimitUnderCorrelateConditions(LogicalFilter logicalFilter, CalcitePlanContext context) {
        RexNode originalCondition = logicalFilter.getCondition();
        List conditions = RelOptUtil.conjunctions((RexNode)originalCondition);
        Pair<List<RexNode>, List<RexNode>> result = CalciteUtils.partition(conditions, PlanUtils::containsCorrelVariable);
        if (((List)result.getLeft()).isEmpty()) {
            return logicalFilter;
        }
        Object input = logicalFilter.getInput();
        if (!((List)result.getRight()).isEmpty()) {
            RexNode nonCorrelCondition = RexUtil.composeConjunction((RexBuilder)context.rexBuilder, (Iterable)((Iterable)result.getRight()));
            input = LogicalFilter.create((RelNode)input, (RexNode)nonCorrelCondition);
        }
        input = LogicalSystemLimit.create(LogicalSystemLimit.SystemLimitType.SUBSEARCH_MAXOUT, input, (RexNode)context.relBuilder.literal(context.sysLimit.subsearchLimit()));
        if (!((List)result.getLeft()).isEmpty()) {
            RexNode correlCondition = RexUtil.composeConjunction((RexBuilder)context.rexBuilder, (Iterable)((Iterable)result.getLeft()));
            input = LogicalFilter.create((RelNode)input, (RexNode)correlCondition);
        }
        return input;
    }

    @Generated
    private SubsearchUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class SystemLimitInsertionShuttle
    extends RelShuttleImpl {
        private final CalcitePlanContext context;
        private boolean correlatedConditionFound = false;

        public RelNode visit(LogicalFilter filter) {
            RelNode newFilter = SubsearchUtils.insertSysLimitUnderCorrelateConditions(filter, this.context);
            if (newFilter != filter) {
                this.correlatedConditionFound = true;
                return newFilter;
            }
            return super.visitChildren((RelNode)filter);
        }

        public RelNode visit(LogicalJoin node) {
            return node;
        }

        public RelNode visit(LogicalCorrelate node) {
            return node;
        }

        public RelNode visit(LogicalUnion node) {
            return node;
        }

        public RelNode visit(LogicalIntersect node) {
            return node;
        }

        public RelNode visit(LogicalMinus node) {
            return node;
        }

        @Generated
        public SystemLimitInsertionShuttle(CalcitePlanContext context) {
            this.context = context;
        }

        @Generated
        public boolean isCorrelatedConditionFound() {
            return this.correlatedConditionFound;
        }
    }
}

