/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Comparator;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.assertj.core.annotations.Beta;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.assertj.core.api.InstanceOfAssertFactory;
import org.assertj.core.api.RecursiveAssertionAssert;
import org.assertj.core.api.RecursiveComparisonAssert;
import org.assertj.core.api.recursive.assertion.RecursiveAssertionConfiguration;
import org.assertj.core.api.recursive.comparison.RecursiveComparisonConfiguration;
import org.assertj.core.error.OptionalShouldBeEmpty;
import org.assertj.core.error.OptionalShouldBePresent;
import org.assertj.core.error.OptionalShouldContain;
import org.assertj.core.error.OptionalShouldContainInstanceOf;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.FieldByFieldComparator;
import org.assertj.core.internal.StandardComparisonStrategy;
import org.assertj.core.util.CheckReturnValue;
import org.assertj.core.util.Preconditions;

public abstract class AbstractOptionalAssert<SELF extends AbstractOptionalAssert<SELF, VALUE>, VALUE>
extends AbstractAssert<SELF, Optional<VALUE>> {
    private ComparisonStrategy optionalValueComparisonStrategy = StandardComparisonStrategy.instance();

    protected AbstractOptionalAssert(Optional<VALUE> actual, Class<?> selfType) {
        super(actual, selfType);
    }

    public SELF isPresent() {
        this.assertValueIsPresent();
        return (SELF)((AbstractOptionalAssert)this.myself);
    }

    public SELF isNotEmpty() {
        return this.isPresent();
    }

    public SELF isEmpty() {
        this.isNotNull();
        if (((Optional)this.actual).isPresent()) {
            this.throwAssertionError(OptionalShouldBeEmpty.shouldBeEmpty((Optional)this.actual));
        }
        return (SELF)((AbstractOptionalAssert)this.myself);
    }

    public SELF isNotPresent() {
        return this.isEmpty();
    }

    public SELF contains(VALUE expectedValue) {
        this.isNotNull();
        this.checkNotNull(expectedValue);
        if (((Optional)this.actual).isEmpty()) {
            this.throwAssertionError(OptionalShouldContain.shouldContain(expectedValue));
        }
        if (!this.optionalValueComparisonStrategy.areEqual(((Optional)this.actual).get(), expectedValue)) {
            throw Failures.instance().failure(this.info, OptionalShouldContain.shouldContain((Optional)this.actual, expectedValue), ((Optional)this.actual).get(), expectedValue);
        }
        return (SELF)((AbstractOptionalAssert)this.myself);
    }

    public SELF hasValueSatisfying(Consumer<VALUE> requirement) {
        this.assertValueIsPresent();
        requirement.accept(((Optional)this.actual).get());
        return (SELF)((AbstractOptionalAssert)this.myself);
    }

    public SELF hasValueSatisfying(Condition<? super VALUE> condition) {
        this.assertValueIsPresent();
        this.conditions.assertIs(this.info, ((Optional)this.actual).get(), condition);
        return (SELF)((AbstractOptionalAssert)this.myself);
    }

    public SELF hasValue(VALUE expectedValue) {
        return this.contains(expectedValue);
    }

    public SELF containsInstanceOf(Class<?> clazz) {
        this.assertValueIsPresent();
        if (!clazz.isInstance(((Optional)this.actual).get())) {
            this.throwAssertionError(OptionalShouldContainInstanceOf.shouldContainInstanceOf(this.actual, clazz));
        }
        return (SELF)((AbstractOptionalAssert)this.myself);
    }

    @Deprecated(since="3", forRemoval=true)
    @CheckReturnValue
    public SELF usingFieldByFieldValueComparator() {
        return this.usingValueComparator(new FieldByFieldComparator());
    }

    @CheckReturnValue
    public SELF usingValueComparator(Comparator<? super VALUE> customComparator) {
        this.optionalValueComparisonStrategy = new ComparatorBasedComparisonStrategy(customComparator);
        return (SELF)((AbstractOptionalAssert)this.myself);
    }

    @CheckReturnValue
    public SELF usingDefaultValueComparator() {
        this.optionalValueComparisonStrategy = StandardComparisonStrategy.instance();
        return (SELF)((AbstractOptionalAssert)this.myself);
    }

    public SELF containsSame(VALUE expectedValue) {
        this.isNotNull();
        this.checkNotNull(expectedValue);
        if (((Optional)this.actual).isEmpty()) {
            this.throwAssertionError(OptionalShouldContain.shouldContain(expectedValue));
        }
        if (((Optional)this.actual).get() != expectedValue) {
            this.throwAssertionError(OptionalShouldContain.shouldContainSame((Optional)this.actual, expectedValue));
        }
        return (SELF)((AbstractOptionalAssert)this.myself);
    }

    @CheckReturnValue
    public <U> AbstractOptionalAssert<?, U> flatMap(Function<? super VALUE, Optional<U>> mapper) {
        this.isNotNull();
        return Assertions.assertThat(((Optional)this.actual).flatMap(mapper));
    }

    @CheckReturnValue
    public <U> AbstractOptionalAssert<?, U> map(Function<? super VALUE, ? extends U> mapper) {
        this.isNotNull();
        return Assertions.assertThat(((Optional)this.actual).map(mapper));
    }

    @CheckReturnValue
    public AbstractObjectAssert<?, VALUE> get() {
        return this.internalGet();
    }

    @CheckReturnValue
    public <ASSERT extends AbstractAssert<?, ?>> ASSERT get(InstanceOfAssertFactory<?, ASSERT> assertFactory) {
        return this.internalGet().asInstanceOf(assertFactory);
    }

    @Override
    @Beta
    public RecursiveComparisonAssert<?> usingRecursiveComparison() {
        return super.usingRecursiveComparison();
    }

    @Override
    public RecursiveComparisonAssert<?> usingRecursiveComparison(RecursiveComparisonConfiguration recursiveComparisonConfiguration) {
        return super.usingRecursiveComparison(recursiveComparisonConfiguration);
    }

    @Override
    public RecursiveAssertionAssert usingRecursiveAssertion() {
        return super.usingRecursiveAssertion();
    }

    @Override
    public RecursiveAssertionAssert usingRecursiveAssertion(RecursiveAssertionConfiguration recursiveAssertionConfiguration) {
        return super.usingRecursiveAssertion(recursiveAssertionConfiguration);
    }

    private AbstractObjectAssert<?, VALUE> internalGet() {
        this.isPresent();
        return ((AbstractObjectAssert)Assertions.assertThat(((Optional)this.actual).get())).withAssertionState(this.myself);
    }

    private void checkNotNull(Object expectedValue) {
        Preconditions.checkArgument(expectedValue != null, "The expected value should not be <null>.", new Object[0]);
    }

    private void assertValueIsPresent() {
        this.isNotNull();
        if (((Optional)this.actual).isEmpty()) {
            this.throwAssertionError(OptionalShouldBePresent.shouldBePresent(this.actual));
        }
    }
}

