/* Generated automatically by the program `genrecog' from the target
   machine description file.  */

#define IN_TARGET_CODE 1

#include "config.h"
#include "system.h"
#include "coretypes.h"
#include "backend.h"
#include "predict.h"
#include "rtl.h"
#include "memmodel.h"
#include "tm_p.h"
#include "emit-rtl.h"
#include "insn-config.h"
#include "recog.h"
#include "output.h"
#include "flags.h"
#include "df.h"
#include "resource.h"
#include "diagnostic-core.h"
#include "reload.h"
#include "regs.h"
#include "tm-constrs.h"
#include "insn-recog.h"


/* `recog' contains a decision tree that recognizes whether the rtx
   X0 is a valid instruction.

   recog returns -1 if the rtx is not valid.  If the rtx is valid, recog
   returns a nonnegative number which is the insn code number for the
   pattern that matched.  This is the same as the order in the machine
   description of the entry that matched.  This number can be used as an
   index into `insn_data' and other tables.
   The third parameter to recog is an optional pointer to an int.  If
   present, recog will accept a pattern if it matches except for missing
   CLOBBER expressions at the end.  In that case, the value pointed to by
   the optional pointer will be set to the number of CLOBBERs that need
   to be added (it should be initialized to zero by the caller).  If it   is set nonzero, the caller should allocate a PARALLEL of the
   appropriate size, copy the initial entries, and call add_clobbers
   (found in insn-emit.cc) to fill in the CLOBBERs.

   The function split_insns returns 0 if the rtl could not
   be split or the split rtl as an INSN list if it can be.

   The function peephole2_insns returns 0 if the rtl could not
   be matched. If there was a match, the new rtl is returned in an INSN list,
   and LAST_INSN will point to the last recognized insn in the old sequence.
*/




int
pattern2 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  operands[1] = x4;
  x5 = XEXP (x3, 1);
  operands[2] = x5;
  switch (GET_MODE (operands[0]))
    {
    case E_SImode:
      return pattern1 (x3, 
E_SImode); /* [-1, 0] */

    case E_V8QImode:
      if (GET_MODE (x3) != E_V8QImode)
        return -1;
      return 1;

    case E_V4HImode:
      if (GET_MODE (x3) != E_V4HImode)
        return -1;
      return 2;

    case E_V2SImode:
      if (GET_MODE (x3) != E_V2SImode)
        return -1;
      return 3;

    case E_V2SFmode:
      if (pattern1 (x3, 
E_V2SFmode) != 0)
        return -1;
      return 4;

    case E_V4QQmode:
      if (pattern1 (x3, 
E_V4QQmode) != 0)
        return -1;
      return 5;

    case E_V2HQmode:
      if (pattern1 (x3, 
E_V2HQmode) != 0)
        return -1;
      return 6;

    case E_QQmode:
      if (pattern1 (x3, 
E_QQmode) != 0)
        return -1;
      return 7;

    case E_HQmode:
      if (pattern1 (x3, 
E_HQmode) != 0)
        return -1;
      return 8;

    case E_V2HAmode:
      if (pattern1 (x3, 
E_V2HAmode) != 0)
        return -1;
      return 9;

    case E_HAmode:
      if (pattern1 (x3, 
E_HAmode) != 0)
        return -1;
      return 10;

    case E_SQmode:
      if (pattern1 (x3, 
E_SQmode) != 0)
        return -1;
      return 11;

    case E_SAmode:
      if (pattern1 (x3, 
E_SAmode) != 0)
        return -1;
      return 12;

    default:
      return -1;
    }
}

int
pattern24 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  if (GET_MODE (x3) != i1)
    return -1;
  x4 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x4) != CLOBBER)
    return -1;
  x5 = XVECEXP (x1, 0, 2);
  if (GET_CODE (x5) != CLOBBER)
    return -1;
  x6 = XVECEXP (x1, 0, 3);
  if (GET_CODE (x6) != CLOBBER)
    return -1;
  x7 = XEXP (x6, 0);
  if (GET_CODE (x7) != REG
      || REGNO (x7) != 100
      || GET_MODE (x7) != E_CCmode)
    return -1;
  x8 = XEXP (x2, 0);
  operands[0] = x8;
  if (!s_register_operand (operands[0], i1))
    return -1;
  x9 = XEXP (x3, 0);
  operands[1] = x9;
  if (!s_register_operand (operands[1], i1))
    return -1;
  x10 = XEXP (x3, 1);
  operands[2] = x10;
  if (!s_register_operand (operands[2], i1))
    return -1;
  x11 = XEXP (x4, 0);
  operands[3] = x11;
  if (!scratch_operand (operands[3], E_DImode))
    return -1;
  x12 = XEXP (x5, 0);
  operands[4] = x12;
  if (!scratch_operand (operands[4], E_SImode))
    return -1;
  return 0;
}

int
pattern41 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!s_register_operand (operands[0], i2)
      || GET_MODE (x1) != i2
      || !s_register_operand (operands[1], i2)
      || !s_register_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern44 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  x5 = XVECEXP (x3, 0, 1);
  operands[2] = x5;
  x6 = XVECEXP (x3, 0, 2);
  operands[3] = x6;
  if (!immediate_operand (operands[3], E_SImode))
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_V8QImode:
      return pattern42 (x3, 
E_V8QImode); /* [-1, 0] */

    case E_V16QImode:
      if (pattern42 (x3, 
E_V16QImode) != 0)
        return -1;
      return 1;

    case E_V4HImode:
      if (pattern42 (x3, 
E_V4HImode) != 0)
        return -1;
      return 2;

    case E_V8HImode:
      if (pattern42 (x3, 
E_V8HImode) != 0)
        return -1;
      return 3;

    case E_V2SImode:
      if (pattern42 (x3, 
E_V2SImode) != 0)
        return -1;
      return 4;

    case E_V4SImode:
      if (pattern42 (x3, 
E_V4SImode) != 0)
        return -1;
      return 5;

    case E_DImode:
      if (pattern42 (x3, 
E_DImode) != 0)
        return -1;
      return 6;

    case E_V2DImode:
      if (pattern42 (x3, 
E_V2DImode) != 0)
        return -1;
      return 7;

    default:
      return -1;
    }
}

int
pattern64 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  x5 = XVECEXP (x3, 0, 1);
  operands[2] = x5;
  x6 = XVECEXP (x3, 0, 2);
  operands[3] = x6;
  switch (GET_MODE (operands[0]))
    {
    case E_V16BImode:
      return pattern63 (x3, 
E_V16BImode, 
E_QImode, 
E_V16QImode); /* [-1, 0] */

    case E_V8BImode:
      if (pattern63 (x3, 
E_V8BImode, 
E_HImode, 
E_V8HImode) != 0)
        return -1;
      return 1;

    case E_V4BImode:
      if (pattern63 (x3, 
E_V4BImode, 
E_SImode, 
E_V4SImode) != 0)
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern73 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!s_register_operand (operands[0], i2)
      || GET_MODE (x1) != i2
      || !s_register_operand (operands[1], i2)
      || !vpr_register_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern79 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  x5 = XVECEXP (x3, 0, 1);
  operands[2] = x5;
  x6 = XVECEXP (x3, 0, 2);
  operands[3] = x6;
  switch (GET_MODE (operands[0]))
    {
    case E_V8BImode:
      return pattern63 (x3, 
E_V8BImode, 
E_HFmode, 
E_V8HFmode); /* [-1, 0] */

    case E_V4BImode:
      if (pattern63 (x3, 
E_V4BImode, 
E_SFmode, 
E_V4SFmode) != 0)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern87 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != i2)
    return -1;
  x3 = XEXP (x1, 0);
  operands[0] = x3;
  if (!s_register_operand (operands[0], i2))
    return -1;
  x4 = XVECEXP (x2, 0, 0);
  operands[1] = x4;
  if (!s_register_operand (operands[1], i2))
    return -1;
  x5 = XVECEXP (x2, 0, 1);
  operands[2] = x5;
  if (!s_register_operand (operands[2], i2))
    return -1;
  x6 = XVECEXP (x2, 0, 2);
  operands[3] = x6;
  if (!vpr_register_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern96 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x1, 0);
  operands[0] = x3;
  if (!register_operand (operands[0], i1))
    return -1;
  x4 = XVECEXP (x2, 0, 0);
  operands[1] = x4;
  switch (GET_MODE (operands[1]))
    {
    case E_V8QImode:
      if (!register_operand (operands[1], E_V8QImode))
        return -1;
      return 0;

    case E_V4HImode:
      if (!register_operand (operands[1], E_V4HImode))
        return -1;
      return 1;

    case E_V2SImode:
      if (!register_operand (operands[1], E_V2SImode))
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern105 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  switch (GET_MODE (operands[0]))
    {
    case E_V8QImode:
      if (!s_register_operand (operands[0], E_V8QImode)
          || GET_MODE (x3) != E_V8QImode
          || !s_register_operand (operands[1], E_V8QImode))
        return -1;
      return 0;

    case E_V16QImode:
      if (!s_register_operand (operands[0], E_V16QImode)
          || GET_MODE (x3) != E_V16QImode
          || !s_register_operand (operands[1], E_V16QImode))
        return -1;
      return 1;

    case E_V4HImode:
      if (!s_register_operand (operands[0], E_V4HImode)
          || GET_MODE (x3) != E_V4HImode
          || !s_register_operand (operands[1], E_V4HImode))
        return -1;
      return 2;

    case E_V8HImode:
      if (!s_register_operand (operands[0], E_V8HImode)
          || GET_MODE (x3) != E_V8HImode
          || !s_register_operand (operands[1], E_V8HImode))
        return -1;
      return 3;

    case E_V2SImode:
      if (!s_register_operand (operands[0], E_V2SImode)
          || GET_MODE (x3) != E_V2SImode
          || !s_register_operand (operands[1], E_V2SImode))
        return -1;
      return 4;

    case E_V4SImode:
      if (!s_register_operand (operands[0], E_V4SImode)
          || GET_MODE (x3) != E_V4SImode
          || !s_register_operand (operands[1], E_V4SImode))
        return -1;
      return 5;

    default:
      return -1;
    }
}

int
pattern126 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!s_register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !s_register_operand (operands[1], i1)
      || !imm_lshift_or_reg_neon (operands[2], i1))
    return -1;
  return 0;
}

int
pattern130 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != E_SImode)
    return -1;
  x3 = XVECEXP (x2, 0, 0);
  if (GET_CODE (x3) != FIX
      || GET_MODE (x3) != E_SImode)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_CODE (x4) != FIX
      || GET_MODE (x4) != E_SFmode)
    return -1;
  x5 = XEXP (x4, 0);
  if (GET_CODE (x5) != FLOAT_EXTEND
      || GET_MODE (x5) != E_SFmode)
    return -1;
  x6 = XEXP (x1, 0);
  operands[0] = x6;
  if (!s_register_operand (operands[0], E_SImode))
    return -1;
  x7 = XEXP (x5, 0);
  operands[1] = x7;
  if (!s_register_operand (operands[1], E_HFmode))
    return -1;
  x8 = XVECEXP (x2, 0, 1);
  operands[2] = x8;
  if (!immediate_operand (operands[2], E_SImode))
    return -1;
  return 0;
}

int
pattern143 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!s_register_operand (operands[0], i2)
      || GET_MODE (x1) != i2
      || !s_register_operand (operands[1], i1)
      || !reg_or_zero_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern148 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  x5 = XVECEXP (x3, 0, 1);
  operands[2] = x5;
  switch (GET_MODE (operands[0]))
    {
    case E_V4HImode:
      return pattern41 (x3, 
E_V8QImode, 
E_V4HImode); /* [-1, 0] */

    case E_V8HImode:
      if (pattern41 (x3, 
E_V16QImode, 
E_V8HImode) != 0)
        return -1;
      return 1;

    case E_V2SImode:
      if (pattern41 (x3, 
E_V4HImode, 
E_V2SImode) != 0)
        return -1;
      return 2;

    case E_V4SImode:
      if (pattern41 (x3, 
E_V8HImode, 
E_V4SImode) != 0)
        return -1;
      return 3;

    case E_DImode:
      if (pattern41 (x3, 
E_V2SImode, 
E_DImode) != 0)
        return -1;
      return 4;

    case E_V2DImode:
      if (pattern41 (x3, 
E_V4SImode, 
E_V2DImode) != 0)
        return -1;
      return 5;

    default:
      return -1;
    }
}

int
pattern160 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XVECEXP (x2, 0, 1);
  if (GET_CODE (x3) != UNSPEC
      || XVECLEN (x3, 0) != 1
      || XINT (x3, 1) != 335)
    return -1;
  x4 = XVECEXP (x3, 0, 0);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x5 = XEXP (x1, 0);
  operands[0] = x5;
  x6 = XVECEXP (x2, 0, 0);
  operands[1] = x6;
  switch (GET_MODE (operands[0]))
    {
    case E_TImode:
      return 0;

    case E_OImode:
      return 1;

    default:
      return -1;
    }
}

int
pattern165 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != i2)
    return -1;
  x3 = XVECEXP (x2, 0, 1);
  if (GET_CODE (x3) != UNSPEC
      || XVECLEN (x3, 0) != 1
      || XINT (x3, 1) != 335)
    return -1;
  x4 = XVECEXP (x3, 0, 0);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x5 = XEXP (x1, 0);
  operands[0] = x5;
  if (!neon_struct_operand (operands[0], i2))
    return -1;
  x6 = XVECEXP (x2, 0, 0);
  operands[1] = x6;
  if (!s_register_operand (operands[1], i1))
    return -1;
  switch (GET_MODE (x3))
    {
    case E_V16QImode:
      return 0;

    case E_V8HImode:
      return 1;

    case E_V8HFmode:
      return 2;

    case E_V8BFmode:
      return 3;

    case E_V4SImode:
      return 4;

    case E_V4SFmode:
      return 5;

    default:
      return -1;
    }
}

int
pattern177 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != E_SImode)
    return -1;
  x3 = XEXP (x1, 0);
  operands[0] = x3;
  if (!s_register_operand (operands[0], E_SImode))
    return -1;
  x4 = XVECEXP (x2, 0, 0);
  operands[1] = x4;
  x5 = XVECEXP (x2, 0, 1);
  operands[2] = x5;
  switch (GET_MODE (operands[1]))
    {
    case E_V16QImode:
      if (!s_register_operand (operands[1], E_V16QImode)
          || !vpr_register_operand (operands[2], E_V16BImode))
        return -1;
      return 0;

    case E_V8HImode:
      if (!s_register_operand (operands[1], E_V8HImode)
          || !vpr_register_operand (operands[2], E_V8BImode))
        return -1;
      return 1;

    case E_V4SImode:
      if (!s_register_operand (operands[1], E_V4SImode)
          || !vpr_register_operand (operands[2], E_V4BImode))
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern192 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XVECEXP (x2, 0, 1);
  if (GET_CODE (x3) != UNSPEC
      || XVECLEN (x3, 0) != 1
      || XINT (x3, 1) != 335)
    return -1;
  x4 = XVECEXP (x3, 0, 0);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x5 = XEXP (x1, 0);
  operands[0] = x5;
  x6 = XVECEXP (x2, 0, 0);
  operands[1] = x6;
  switch (GET_MODE (operands[0]))
    {
    case E_V2x16QImode:
      return 0;

    case E_V2x8HImode:
      return 1;

    case E_V2x4SImode:
      return 2;

    case E_V2x8HFmode:
      return 3;

    case E_V2x4SFmode:
      return 4;

    default:
      return -1;
    }
}

int
pattern205 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  x5 = XVECEXP (x3, 0, 1);
  operands[2] = x5;
  x6 = XVECEXP (x3, 0, 2);
  operands[3] = x6;
  x7 = XVECEXP (x3, 0, 3);
  operands[4] = x7;
  switch (GET_MODE (operands[0]))
    {
    case E_V16QImode:
      if (!s_register_operand (operands[0], E_V16QImode)
          || GET_MODE (x3) != E_V16QImode
          || !s_register_operand (operands[1], E_V16QImode)
          || !s_register_operand (operands[2], E_V16QImode)
          || !mve_imm_7 (operands[3], E_SImode)
          || !vpr_register_operand (operands[4], E_V16BImode))
        return -1;
      return 0;

    case E_V8HImode:
      if (!s_register_operand (operands[0], E_V8HImode)
          || GET_MODE (x3) != E_V8HImode
          || !s_register_operand (operands[1], E_V8HImode)
          || !s_register_operand (operands[2], E_V8HImode)
          || !mve_imm_15 (operands[3], E_SImode)
          || !vpr_register_operand (operands[4], E_V8BImode))
        return -1;
      return 1;

    case E_V4SImode:
      if (!s_register_operand (operands[0], E_V4SImode)
          || GET_MODE (x3) != E_V4SImode
          || !s_register_operand (operands[1], E_V4SImode)
          || !s_register_operand (operands[2], E_V4SImode)
          || !mve_imm_31 (operands[3], E_SImode)
          || !vpr_register_operand (operands[4], E_V4BImode))
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern227 (rtx x1, machine_mode i1, machine_mode i2, machine_mode i3, machine_mode i4)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!s_register_operand (operands[0], i4)
      || GET_MODE (x1) != i4
      || !s_register_operand (operands[1], i4)
      || !s_register_operand (operands[2], i3)
      || !s_register_operand (operands[3], i2)
      || !vpr_register_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern233 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XVECEXP (x2, 0, 3);
  if (GET_CODE (x3) != MEM
      || GET_MODE (x3) != E_BLKmode)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_CODE (x4) != SCRATCH)
    return -1;
  x5 = XEXP (x1, 0);
  operands[0] = x5;
  x6 = XVECEXP (x2, 0, 0);
  operands[1] = x6;
  if (!register_operand (operands[1], E_SImode))
    return -1;
  x7 = XVECEXP (x2, 0, 1);
  operands[2] = x7;
  x8 = XVECEXP (x2, 0, 2);
  operands[3] = x8;
  return 0;
}

int
pattern242 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  switch (GET_MODE (operands[0]))
    {
    case E_SImode:
      if (!s_register_operand (operands[0], E_SImode)
          || GET_MODE (x3) != E_SImode
          || !mem_noofs_operand (operands[1], E_SImode))
        return -1;
      return 0;

    case E_DImode:
      if (!s_register_operand (operands[0], E_DImode)
          || GET_MODE (x3) != E_DImode
          || !mem_noofs_operand (operands[1], E_DImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern250 (rtx x1, rtx_code i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19, x20;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != E_V4HImode)
    return -1;
  x3 = XEXP (x2, 1);
  if (GET_CODE (x3) != VEC_SELECT
      || GET_MODE (x3) != E_V4HImode)
    return -1;
  x4 = XEXP (x3, 1);
  if (GET_CODE (x4) != PARALLEL
      || XVECLEN (x4, 0) != 4)
    return -1;
  x5 = XVECEXP (x4, 0, 0);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return -1;
  x6 = XVECEXP (x4, 0, 1);
  if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x7 = XVECEXP (x4, 0, 2);
  if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 3])
    return -1;
  x8 = XVECEXP (x4, 0, 3);
  if (x8 != const_int_rtx[MAX_SAVED_CONST_INT + 2])
    return -1;
  x9 = XEXP (x1, 1);
  if (GET_CODE (x9) != i1
      || GET_MODE (x9) != E_V4HImode)
    return -1;
  x10 = XEXP (x9, 1);
  if (GET_CODE (x10) != VEC_SELECT
      || GET_MODE (x10) != E_V4HImode)
    return -1;
  x11 = XEXP (x10, 1);
  if (GET_CODE (x11) != PARALLEL
      || XVECLEN (x11, 0) != 4)
    return -1;
  x12 = XVECEXP (x11, 0, 0);
  if (x12 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return -1;
  x13 = XVECEXP (x11, 0, 1);
  if (x13 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x14 = XVECEXP (x11, 0, 2);
  if (x14 != const_int_rtx[MAX_SAVED_CONST_INT + 3])
    return -1;
  x15 = XVECEXP (x11, 0, 3);
  if (x15 != const_int_rtx[MAX_SAVED_CONST_INT + 2])
    return -1;
  x16 = XEXP (x1, 2);
  if (x16 != const_int_rtx[MAX_SAVED_CONST_INT + 10]
      || !register_operand (operands[0], E_V4HImode)
      || GET_MODE (x1) != E_V4HImode)
    return -1;
  x17 = XEXP (x2, 0);
  operands[1] = x17;
  if (!register_operand (operands[1], E_V4HImode))
    return -1;
  x18 = XEXP (x3, 0);
  operands[2] = x18;
  if (!register_operand (operands[2], E_V4HImode))
    return -1;
  x19 = XEXP (x9, 0);
  if (!rtx_equal_p (x19, operands[1]))
    return -1;
  x20 = XEXP (x10, 0);
  if (!rtx_equal_p (x20, operands[2]))
    return -1;
  return 0;
}

int
pattern269 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  operands[1] = x3;
  if (!s_register_operand (operands[1], E_SImode))
    return -1;
  x4 = XEXP (x1, 1);
  operands[2] = x4;
  if (!const_double_vcvt_power_of_two_reciprocal (operands[2], E_VOIDmode))
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_SFmode:
      if (!s_register_operand (operands[0], E_SFmode)
          || GET_MODE (x1) != E_SFmode
          || GET_MODE (x2) != E_SFmode)
        return -1;
      return 0;

    case E_DFmode:
      if (!s_register_operand (operands[0], E_DFmode)
          || GET_MODE (x1) != E_DFmode
          || GET_MODE (x2) != E_DFmode)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern277 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  if (!const_int_operand (operands[2], E_SImode))
    return -1;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  if (!s_register_operand (operands[0], E_SImode))
    return -1;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  operands[1] = x4;
  if (!s_register_operand (operands[1], E_SImode))
    return -1;
  x5 = XEXP (x3, 2);
  operands[3] = x5;
  if (!const_int_operand (operands[3], E_SImode))
    return -1;
  return 0;
}

int
pattern285 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  operands[1] = x3;
  x4 = XEXP (x1, 1);
  switch (XVECLEN (x4, 0))
    {
    case 4:
      x5 = XVECEXP (x4, 0, 0);
      if (GET_CODE (x5) != CONST_INT)
        return -1;
      x6 = XVECEXP (x4, 0, 1);
      if (GET_CODE (x6) != CONST_INT)
        return -1;
      x7 = XVECEXP (x4, 0, 2);
      if (GET_CODE (x7) != CONST_INT)
        return -1;
      x8 = XVECEXP (x4, 0, 3);
      if (GET_CODE (x8) != CONST_INT
          || !register_operand (operands[0], E_V4HImode)
          || GET_MODE (x1) != E_V4HImode
          || GET_MODE (x2) != E_V8HImode
          || !register_operand (operands[1], E_V8QImode))
        return -1;
      switch (XWINT (x5, 0))
        {
        case 4L:
          if (XWINT (x6, 0) != 5L
              || XWINT (x7, 0) != 6L
              || XWINT (x8, 0) != 7L)
            return -1;
          return 0;

        case 0L:
          if (XWINT (x6, 0) != 1L
              || XWINT (x7, 0) != 2L
              || XWINT (x8, 0) != 3L)
            return -1;
          return 1;

        default:
          return -1;
        }

    case 2:
      x5 = XVECEXP (x4, 0, 0);
      if (GET_CODE (x5) != CONST_INT)
        return -1;
      x6 = XVECEXP (x4, 0, 1);
      if (GET_CODE (x6) != CONST_INT
          || !register_operand (operands[0], E_V2SImode)
          || GET_MODE (x1) != E_V2SImode
          || GET_MODE (x2) != E_V4SImode
          || !register_operand (operands[1], E_V4HImode))
        return -1;
      switch (XWINT (x5, 0))
        {
        case 2L:
          if (XWINT (x6, 0) != 3L)
            return -1;
          return 2;

        case 0L:
          if (XWINT (x6, 0) != 1L)
            return -1;
          return 3;

        default:
          return -1;
        }

    case 1:
      x5 = XVECEXP (x4, 0, 0);
      if (GET_CODE (x5) != CONST_INT
          || !register_operand (operands[0], E_DImode)
          || GET_MODE (x1) != E_DImode
          || GET_MODE (x2) != E_V2DImode
          || !register_operand (operands[1], E_V2SImode))
        return -1;
      switch (XWINT (x5, 0))
        {
        case 1L:
          return 4;

        case 0L:
          return 5;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern311 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!s_register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !s_register_operand (operands[1], i1)
      || !s_register_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern318 (rtx x1, int i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (GET_CODE (x1) != UNSPEC
      || XVECLEN (x1, 0) != 1
      || XINT (x1, 1) != i1
      || GET_MODE (x1) != E_SImode)
    return -1;
  return 0;
}

int
pattern321 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 1);
  if (GET_MODE (x3) != E_SImode)
    return -1;
  x4 = XEXP (x1, 0);
  operands[3] = x4;
  x5 = XEXP (x4, 0);
  operands[4] = x5;
  x6 = XEXP (x2, 0);
  operands[0] = x6;
  if (!s_register_operand (operands[0], E_SImode))
    return -1;
  x7 = XEXP (x3, 0);
  operands[1] = x7;
  if (!s_register_operand (operands[1], E_SImode))
    return -1;
  x8 = XEXP (x3, 1);
  operands[2] = x8;
  if (!reg_or_int_operand (operands[2], E_SImode))
    return -1;
  return 0;
}

int
pattern329 (rtx x1, int i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x2) != SET)
    return -1;
  x3 = XEXP (x2, 1);
  if (GET_CODE (x3) != UNSPEC
      || XVECLEN (x3, 0) != 2
      || XINT (x3, 1) != i1)
    return -1;
  x4 = XVECEXP (x1, 0, 0);
  x5 = XEXP (x4, 1);
  x6 = XVECEXP (x5, 0, 0);
  operands[1] = x6;
  x7 = XVECEXP (x5, 0, 1);
  operands[3] = x7;
  x8 = XEXP (x2, 0);
  operands[2] = x8;
  x9 = XVECEXP (x3, 0, 0);
  if (!rtx_equal_p (x9, operands[1]))
    return -1;
  x10 = XVECEXP (x3, 0, 1);
  if (!rtx_equal_p (x10, operands[3]))
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_V8QImode:
      return pattern328 (x1, 
E_V8QImode); /* [-1, 0] */

    case E_V16QImode:
      if (pattern328 (x1, 
E_V16QImode) != 0)
        return -1;
      return 1;

    case E_V4HImode:
      if (pattern328 (x1, 
E_V4HImode) != 0)
        return -1;
      return 2;

    case E_V8HImode:
      if (pattern328 (x1, 
E_V8HImode) != 0)
        return -1;
      return 3;

    case E_V2SImode:
      if (pattern328 (x1, 
E_V2SImode) != 0)
        return -1;
      return 4;

    case E_V4SImode:
      if (pattern328 (x1, 
E_V4SImode) != 0)
        return -1;
      return 5;

    case E_V2SFmode:
      if (pattern328 (x1, 
E_V2SFmode) != 0)
        return -1;
      return 6;

    case E_V4SFmode:
      if (pattern328 (x1, 
E_V4SFmode) != 0)
        return -1;
      return 7;

    case E_V8HFmode:
      if (pattern328 (x1, 
E_V8HFmode) != 0)
        return -1;
      return 8;

    case E_V4HFmode:
      if (pattern328 (x1, 
E_V4HFmode) != 0)
        return -1;
      return 9;

    default:
      return -1;
    }
}

int
pattern349 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!s_register_operand (operands[1], E_SImode)
      || !s_register_operand (operands[0], E_SImode)
      || GET_MODE (x1) != E_SImode)
    return -1;
  x2 = XEXP (x1, 1);
  operands[2] = x2;
  if (!arm_rhs_operand (operands[2], E_SImode))
    return -1;
  return 0;
}

int
pattern355 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XVECEXP (x2, 0, 0);
  operands[1] = x3;
  x4 = XVECEXP (x2, 0, 1);
  operands[2] = x4;
  x5 = XEXP (x1, 1);
  operands[3] = x5;
  switch (GET_MODE (operands[0]))
    {
    case E_V2SImode:
      return pattern354 (x1, 
E_V2SImode, 
E_V8QImode); /* [-1, 0] */

    case E_V4SImode:
      if (pattern354 (x1, 
E_V4SImode, 
E_V16QImode) != 0)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern364 (rtx x1, int i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  x3 = XEXP (x2, 1);
  if (XVECLEN (x3, 0) != 3
      || XINT (x3, 1) != i1
      || GET_MODE (x3) != E_SImode)
    return -1;
  x4 = XVECEXP (x1, 0, 0);
  x5 = XEXP (x4, 0);
  operands[0] = x5;
  x6 = XEXP (x4, 1);
  x7 = XVECEXP (x6, 0, 0);
  operands[2] = x7;
  x8 = XVECEXP (x6, 0, 1);
  operands[3] = x8;
  if (!s_register_operand (operands[3], E_SImode))
    return -1;
  x9 = XVECEXP (x6, 0, 2);
  operands[4] = x9;
  if (!mve_imm_32 (operands[4], E_SImode))
    return -1;
  x10 = XEXP (x2, 0);
  operands[1] = x10;
  if (!s_register_operand (operands[1], E_SImode))
    return -1;
  x11 = XVECEXP (x3, 0, 0);
  if (!rtx_equal_p (x11, operands[2]))
    return -1;
  x12 = XVECEXP (x3, 0, 1);
  if (!rtx_equal_p (x12, operands[3]))
    return -1;
  x13 = XVECEXP (x3, 0, 2);
  if (!rtx_equal_p (x13, operands[4]))
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_V16QImode:
      if (!s_register_operand (operands[0], E_V16QImode)
          || GET_MODE (x6) != E_V16QImode
          || !s_register_operand (operands[2], E_V16QImode))
        return -1;
      return 0;

    case E_V8HImode:
      if (!s_register_operand (operands[0], E_V8HImode)
          || GET_MODE (x6) != E_V8HImode
          || !s_register_operand (operands[2], E_V8HImode))
        return -1;
      return 1;

    case E_V4SImode:
      if (!s_register_operand (operands[0], E_V4SImode)
          || GET_MODE (x6) != E_V4SImode
          || !s_register_operand (operands[2], E_V4SImode))
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern390 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x1, 1);
  if (GET_MODE (x3) != i1)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_MODE (x4) != i2)
    return -1;
  x5 = XEXP (x4, 0);
  x6 = XEXP (x5, 0);
  operands[2] = x6;
  if (!s_register_operand (operands[2], E_SImode))
    return -1;
  return 0;
}

int
pattern396 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!s_register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !s_register_operand (operands[1], i1)
      || !neon_inv_logic_op2 (operands[2], i1))
    return -1;
  return 0;
}

int
pattern402 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !register_operand (operands[1], i1)
      || !register_operand (operands[2], i1))
    return -1;
  x2 = XEXP (x1, 2);
  if (GET_MODE (x2) != i1
      || !register_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern409 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[2] = x2;
  x3 = XEXP (x2, 0);
  operands[3] = x3;
  x4 = XEXP (x1, 1);
  x5 = XEXP (x4, 1);
  x6 = XVECEXP (x5, 0, 0);
  operands[1] = x6;
  switch (GET_MODE (operands[0]))
    {
    case E_SFmode:
      if (!register_operand (operands[0], E_SFmode)
          || GET_MODE (x5) != E_SFmode
          || !register_operand (operands[1], E_SFmode))
        return -1;
      return 0;

    case E_DFmode:
      if (!register_operand (operands[0], E_DFmode)
          || GET_MODE (x5) != E_DFmode
          || !register_operand (operands[1], E_DFmode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern420 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 2);
  x3 = XEXP (x2, 1);
  if (GET_CODE (x3) != MEM
      || GET_MODE (x3) != E_SImode)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_CODE (x4) != PLUS
      || GET_MODE (x4) != E_SImode)
    return -1;
  x5 = XEXP (x4, 1);
  if (GET_CODE (x5) != CONST_INT)
    return -1;
  x6 = XVECEXP (x1, 0, 3);
  x7 = XEXP (x6, 1);
  if (GET_CODE (x7) != MEM
      || GET_MODE (x7) != E_SImode)
    return -1;
  return 0;
}

int
pattern431 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (!s_register_operand (operands[0], E_SImode)
      || GET_MODE (x1) != E_SImode
      || !s_register_operand (operands[1], E_SImode))
    return -1;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  operands[2] = x3;
  if (!s_register_operand (operands[2], E_SImode))
    return -1;
  x4 = XEXP (x2, 1);
  operands[3] = x4;
  if (!arm_rhs_operand (operands[3], E_SImode))
    return -1;
  return 0;
}

int
pattern439 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 1);
  if (GET_MODE (x3) != i1)
    return -1;
  x4 = XEXP (x1, 0);
  operands[4] = x4;
  x5 = XEXP (x4, 0);
  operands[5] = x5;
  if (!s_register_operand (operands[0], i1)
      || !s_register_operand (operands[1], E_SImode))
    return -1;
  x6 = XVECEXP (x3, 0, 1);
  operands[2] = x6;
  if (!s_register_operand (operands[2], E_SImode))
    return -1;
  x7 = XVECEXP (x3, 0, 2);
  operands[3] = x7;
  if (!s_register_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern448 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  x5 = XEXP (x4, 1);
  if (GET_MODE (x5) != E_DImode)
    return -1;
  x6 = XEXP (x3, 1);
  if (GET_CODE (x6) != SIGN_EXTEND
      || GET_MODE (x6) != E_DImode)
    return -1;
  x7 = XEXP (x6, 0);
  if (GET_CODE (x7) != MINUS
      || GET_MODE (x7) != E_SImode
      || pattern447 (x1, 
E_DImode, 
E_CC_Vmode) != 0)
    return -1;
  return 0;
}

int
pattern460 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!s_register_operand (operands[0], i2)
      || GET_MODE (x1) != i2
      || !mve_struct_operand (operands[1], i2))
    return -1;
  x2 = XVECEXP (x1, 0, 1);
  if (GET_MODE (x2) != i1)
    return -1;
  return 0;
}

int
pattern468 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!s_register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !s_register_operand (operands[2], i1)
      || !s_register_operand (operands[3], i1)
      || !s_register_operand (operands[1], i1))
    return -1;
  return 0;
}

int
pattern477 (rtx x1, rtx_code i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (GET_CODE (x1) != SIGN_EXTEND
      || GET_MODE (x1) != E_DImode)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_CODE (x2) != i1
      || GET_MODE (x2) != E_SImode)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != i1
      || GET_MODE (x3) != E_SImode)
    return -1;
  return 0;
}

int
pattern482 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], E_V16QImode)
      || GET_MODE (x1) != E_V16QImode
      || !register_operand (operands[2], E_V16QImode)
      || !register_operand (operands[3], E_V16QImode))
    return -1;
  return 0;
}

int
pattern489 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!s_register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  operands[1] = x2;
  if (!s_register_operand (operands[1], i1))
    return -1;
  x3 = XEXP (x1, 1);
  operands[2] = x3;
  if (!s_register_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern495 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!s_register_operand (operands[0], i2)
      || GET_MODE (x1) != i2
      || !s_register_operand (operands[1], i2)
      || !vpr_register_operand (operands[6], i1))
    return -1;
  return 0;
}

int
pattern501 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i2)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_MODE (x4) != i2)
    return -1;
  x5 = XEXP (x4, 0);
  if (GET_MODE (x5) != i2
      || !register_operand (operands[1], i1))
    return -1;
  x6 = XEXP (x4, 1);
  if (GET_MODE (x6) != i2
      || !register_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern508 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!neon_struct_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XVECEXP (x1, 0, 2);
  return pattern507 (x2, 
i1, 
i2); /* [-1, 1] */
}

int
pattern514 (rtx x1, machine_mode i1, machine_mode i2, machine_mode i3)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!s_register_operand (operands[0], i3)
      || GET_MODE (x1) != i3
      || !s_register_operand (operands[2], i2)
      || !vpr_register_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern522 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (GET_MODE (x1) != i1
      || !register_operand (operands[0], i1)
      || !register_operand (operands[1], i1)
      || !register_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern529 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  if (!arm_comparison_operator (operands[3], E_SImode))
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 1);
  if (!arm_comparison_operator (x4, E_SImode))
    return -1;
  operands[6] = x4;
  x5 = XVECEXP (x1, 0, 1);
  x6 = XEXP (x5, 0);
  if (GET_CODE (x6) != REG
      || REGNO (x6) != 100
      || GET_MODE (x6) != E_CCmode
      || pattern291 (x3) != 0)
    return -1;
  return 0;
}

int
pattern539 (rtx x1, machine_mode i1, machine_mode i2, rtx_code i3)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (GET_CODE (x1) != i3
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_CODE (x2) != VEC_SELECT
      || GET_MODE (x2) != i1)
    return -1;
  return 0;
}

int
pattern544 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!s_register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !s_register_operand (operands[1], i1)
      || !s_register_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern553 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (!s_register_operand (operands[0], E_SImode)
      || GET_MODE (x1) != E_SImode
      || !s_register_operand (operands[1], E_SImode))
    return -1;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  operands[2] = x3;
  if (!s_register_operand (operands[2], E_SImode))
    return -1;
  x4 = XEXP (x2, 1);
  operands[3] = x4;
  if (!arm_rhs_operand (operands[3], E_SImode))
    return -1;
  return 0;
}

int
pattern562 (rtx x1, rtx_code i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 1);
  x5 = XEXP (x4, 0);
  if (GET_CODE (x5) != i1
      || GET_MODE (x5) != E_SImode)
    return -1;
  x6 = XEXP (x5, 1);
  if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
    return -1;
  x7 = XEXP (x1, 0);
  operands[4] = x7;
  x8 = XEXP (x7, 0);
  operands[5] = x8;
  if (!register_operand (operands[0], E_SImode))
    return -1;
  x9 = XEXP (x3, 0);
  x10 = XEXP (x9, 0);
  x11 = XEXP (x10, 0);
  operands[1] = x11;
  if (!register_operand (operands[1], E_SImode))
    return -1;
  return 0;
}

int
pattern575 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 2);
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != MEM
      || GET_MODE (x3) != E_SImode)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_CODE (x4) != PLUS
      || GET_MODE (x4) != E_SImode)
    return -1;
  x5 = XEXP (x4, 1);
  if (GET_CODE (x5) != CONST_INT)
    return -1;
  x6 = XVECEXP (x1, 0, 3);
  x7 = XEXP (x6, 0);
  if (GET_CODE (x7) != MEM
      || GET_MODE (x7) != E_SImode)
    return -1;
  return 0;
}

int
pattern587 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (GET_CODE (x1) != MULT
      || GET_MODE (x1) != E_DImode)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_CODE (x2) != SIGN_EXTEND
      || GET_MODE (x2) != E_DImode)
    return -1;
  return 0;
}

int
pattern592 (rtx x1, rtx_code i1, rtx_code i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  switch (GET_CODE (x1))
    {
    case SET:
      x2 = XEXP (x1, 1);
      if (GET_CODE (x2) != i2
          || GET_MODE (x2) != E_SImode)
        return -1;
      x3 = XEXP (x2, 0);
      if (GET_CODE (x3) != i1
          || GET_MODE (x3) != E_SImode)
        return -1;
      x4 = XEXP (x1, 0);
      operands[0] = x4;
      if (!s_register_operand (operands[0], E_SImode))
        return -1;
      x5 = XEXP (x3, 0);
      if (!rtx_equal_p (x5, operands[2]))
        return -1;
      return 0;

    case CLOBBER:
      x4 = XEXP (x1, 0);
      operands[0] = x4;
      if (!scratch_operand (operands[0], E_SImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern604 (rtx x1, int i1, int i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  if (GET_CODE (x1) != MULT
      || GET_MODE (x1) != E_V2SImode)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_CODE (x2) != VEC_SELECT
      || GET_MODE (x2) != E_V2SImode)
    return -1;
  x3 = XEXP (x2, 1);
  if (GET_CODE (x3) != PARALLEL
      || XVECLEN (x3, 0) != 2)
    return -1;
  x4 = XVECEXP (x3, 0, 0);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + i2])
    return -1;
  x5 = XVECEXP (x3, 0, 1);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + i1])
    return -1;
  return 0;
}

int
pattern614 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  if (!s_register_operand (operands[0], i1))
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  if (GET_MODE (x3) != i1)
    return -1;
  x4 = XVECEXP (x1, 0, 1);
  x5 = XEXP (x4, 1);
  return pattern613 (x5, 
i1, 
i2); /* [-1, 0] */
}

int
pattern621 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!s_register_operand (operands[0], E_V4SImode)
      || GET_MODE (x1) != E_V4SImode)
    return -1;
  switch (GET_MODE (operands[3]))
    {
    case E_V4SImode:
      if (!s_register_operand (operands[3], E_V4SImode))
        return -1;
      return 0;

    case E_V4SFmode:
      if (!s_register_operand (operands[3], E_V4SFmode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern631 (rtx x1, int i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (GET_CODE (x1) != PLUS
      || GET_MODE (x1) != E_SImode)
    return -1;
  x2 = XEXP (x1, 1);
  if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + i1])
    return -1;
  x3 = XEXP (x1, 0);
  if (!rtx_equal_p (x3, operands[4]))
    return -1;
  return 0;
}

int
pattern635 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], E_V2SImode)
      || GET_MODE (x1) != E_V2SImode)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != E_V2SImode)
    return -1;
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  if (GET_MODE (x4) != E_V4SImode)
    return -1;
  x5 = XEXP (x2, 1);
  x6 = XEXP (x5, 0);
  if (GET_MODE (x6) != E_V4SImode)
    return -1;
  x7 = XEXP (x1, 1);
  x8 = XEXP (x7, 0);
  x9 = XEXP (x8, 0);
  if (GET_MODE (x9) != E_V4SImode)
    return -1;
  x10 = XEXP (x7, 1);
  x11 = XEXP (x10, 0);
  if (GET_MODE (x11) != E_V4SImode)
    return -1;
  switch (GET_CODE (x4))
    {
    case SIGN_EXTEND:
      return 0;

    case ZERO_EXTEND:
      return 1;

    default:
      return -1;
    }
}

int
pattern646 (rtx x1, rtx_code i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19, x20, x21;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  if (GET_CODE (x4) != i1)
    return -1;
  x5 = XEXP (x1, 1);
  x6 = XEXP (x5, 0);
  x7 = XEXP (x6, 0);
  if (GET_CODE (x7) != i1)
    return -1;
  x8 = XEXP (x5, 1);
  x9 = XEXP (x8, 0);
  if (GET_CODE (x9) != i1)
    return -1;
  x10 = XEXP (x2, 0);
  x11 = XEXP (x10, 0);
  x12 = XEXP (x11, 0);
  operands[1] = x12;
  if (!register_operand (operands[1], E_V4HImode))
    return -1;
  x13 = XEXP (x4, 0);
  operands[2] = x13;
  if (!register_operand (operands[2], E_V4HImode))
    return -1;
  x14 = XEXP (x7, 0);
  if (!rtx_equal_p (x14, operands[1]))
    return -1;
  x15 = XEXP (x9, 0);
  if (!rtx_equal_p (x15, operands[2]))
    return -1;
  x16 = XEXP (x3, 1);
  x17 = XVECEXP (x16, 0, 0);
  switch (XWINT (x17, 0))
    {
    case 1L:
      x18 = XVECEXP (x16, 0, 1);
      if (XWINT (x18, 0) != 3L)
        return -1;
      x19 = XEXP (x8, 1);
      x20 = XVECEXP (x19, 0, 0);
      if (XWINT (x20, 0) != 0L)
        return -1;
      x21 = XVECEXP (x19, 0, 1);
      if (XWINT (x21, 0) != 2L)
        return -1;
      return 0;

    case 0L:
      x18 = XVECEXP (x16, 0, 1);
      if (XWINT (x18, 0) != 2L)
        return -1;
      x19 = XEXP (x8, 1);
      x20 = XVECEXP (x19, 0, 0);
      if (XWINT (x20, 0) != 1L)
        return -1;
      x21 = XVECEXP (x19, 0, 1);
      if (XWINT (x21, 0) != 3L)
        return -1;
      return 1;

    default:
      return -1;
    }
}

 int
recog_6 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19, x20, x21, x22, x23, x24;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != REG
      || REGNO (x3) != 100)
    return -1;
  x4 = XEXP (x2, 1);
  x5 = XEXP (x4, 0);
  x6 = XEXP (x5, 0);
  switch (GET_CODE (x6))
    {
    case PLUS:
      if (GET_MODE (x6) != E_DImode)
        return -1;
      x7 = XVECEXP (x1, 0, 1);
      if (pattern417 (x7, 
PLUS) != 0
          || GET_MODE (x5) != E_DImode)
        return -1;
      x8 = XEXP (x6, 0);
      operands[3] = x8;
      if (!arm_carry_operation (operands[3], E_DImode))
        return -1;
      x9 = XEXP (x6, 1);
      if (GET_MODE (x9) != E_DImode)
        return -1;
      x10 = XEXP (x7, 0);
      operands[0] = x10;
      if (!s_register_operand (operands[0], E_SImode))
        return -1;
      switch (GET_CODE (x9))
        {
        case SIGN_EXTEND:
          x11 = XEXP (x4, 1);
          if (pattern477 (x11, 
PLUS) != 0
              || GET_MODE (x3) != E_CC_Vmode
              || GET_MODE (x4) != E_CC_Vmode)
            return -1;
          x12 = XEXP (x9, 0);
          operands[1] = x12;
          if (!s_register_operand (operands[1], E_SImode))
            return -1;
          x13 = XEXP (x11, 0);
          x14 = XEXP (x13, 0);
          x15 = XEXP (x14, 0);
          operands[4] = x15;
          if (!arm_carry_operation (operands[4], E_SImode))
            return -1;
          x16 = XEXP (x14, 1);
          if (!rtx_equal_p (x16, operands[1]))
            return -1;
          x17 = XEXP (x7, 1);
          x18 = XEXP (x17, 0);
          x19 = XEXP (x18, 0);
          if (!rtx_equal_p (x19, operands[4]))
            return -1;
          x20 = XEXP (x18, 1);
          if (!rtx_equal_p (x20, operands[1]))
            return -1;
          x21 = XEXP (x5, 1);
          switch (GET_CODE (x21))
            {
            case SIGN_EXTEND:
              if (GET_MODE (x21) != E_DImode)
                return -1;
              x22 = XEXP (x21, 0);
              operands[2] = x22;
              if (!s_register_operand (operands[2], E_SImode))
                return -1;
              x23 = XEXP (x13, 1);
              if (!rtx_equal_p (x23, operands[2]))
                return -1;
              x24 = XEXP (x17, 1);
              if (!rtx_equal_p (x24, operands[2])
                  || !
#line 643 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT))
                return -1;
              return 1; /* *addsi3_cin_vout_reg_insn */

            case CONST_INT:
              operands[2] = x21;
              if (!arm_adcimm_operand (operands[2], E_VOIDmode))
                return -1;
              x23 = XEXP (x13, 1);
              if (!rtx_equal_p (x23, operands[2]))
                return -1;
              x24 = XEXP (x17, 1);
              if (!rtx_equal_p (x24, operands[2])
                  || !
#line 689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT))
                return -1;
              return 2; /* *addsi3_cin_vout_imm_insn */

            default:
              return -1;
            }

        case ZERO_EXTEND:
          x11 = XEXP (x4, 1);
          if (GET_CODE (x11) != CONST_INT
              || XWINT (x11, 0) != 4294967296L
              || GET_MODE (x3) != E_CC_ADCmode
              || GET_MODE (x4) != E_CC_ADCmode)
            return -1;
          x12 = XEXP (x9, 0);
          operands[1] = x12;
          if (!s_register_operand (operands[1], E_SImode))
            return -1;
          x17 = XEXP (x7, 1);
          x18 = XEXP (x17, 0);
          x19 = XEXP (x18, 0);
          operands[4] = x19;
          if (!arm_carry_operation (operands[4], E_SImode))
            return -1;
          x20 = XEXP (x18, 1);
          if (!rtx_equal_p (x20, operands[1]))
            return -1;
          x21 = XEXP (x5, 1);
          switch (GET_CODE (x21))
            {
            case ZERO_EXTEND:
              if (GET_MODE (x21) != E_DImode)
                return -1;
              x22 = XEXP (x21, 0);
              operands[2] = x22;
              if (!s_register_operand (operands[2], E_SImode))
                return -1;
              x24 = XEXP (x17, 1);
              if (!rtx_equal_p (x24, operands[2])
                  || !
#line 821 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT))
                return -1;
              return 4; /* *addsi3_cin_cout_reg_insn */

            case CONST_INT:
              operands[5] = x21;
              if (!const_int_operand (operands[5], E_DImode))
                return -1;
              x24 = XEXP (x17, 1);
              operands[2] = x24;
              if (!arm_adcimm_operand (operands[2], E_SImode)
                  || !
#line 865 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (UINTVAL (operands[2]) & 0xffffffff) == UINTVAL (operands[5])))
                return -1;
              return 5; /* *addsi3_cin_cout_imm_insn */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case GEU:
    case LTU:
      operands[2] = x6;
      if (!arm_carry_operation (operands[2], E_DImode)
          || pattern445 (x1, 
E_DImode) != 0)
        return -1;
      x21 = XEXP (x5, 1);
      if (GET_MODE (x21) != E_DImode)
        return -1;
      x7 = XVECEXP (x1, 0, 1);
      x10 = XEXP (x7, 0);
      operands[0] = x10;
      if (!s_register_operand (operands[0], E_SImode))
        return -1;
      switch (GET_CODE (x21))
        {
        case SIGN_EXTEND:
          x11 = XEXP (x4, 1);
          if (GET_CODE (x11) != SIGN_EXTEND
              || GET_MODE (x11) != E_DImode)
            return -1;
          x13 = XEXP (x11, 0);
          if (GET_CODE (x13) != PLUS
              || GET_MODE (x13) != E_SImode
              || GET_MODE (x3) != E_CC_Vmode
              || GET_MODE (x4) != E_CC_Vmode)
            return -1;
          x22 = XEXP (x21, 0);
          operands[1] = x22;
          if (!s_register_operand (operands[1], E_SImode))
            return -1;
          x14 = XEXP (x13, 0);
          operands[3] = x14;
          if (!arm_carry_operation (operands[3], E_SImode))
            return -1;
          x23 = XEXP (x13, 1);
          if (!rtx_equal_p (x23, operands[1]))
            return -1;
          x17 = XEXP (x7, 1);
          x18 = XEXP (x17, 0);
          if (!rtx_equal_p (x18, operands[3]))
            return -1;
          x24 = XEXP (x17, 1);
          if (!rtx_equal_p (x24, operands[1])
              || !
#line 725 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT))
            return -1;
          return 3; /* *addsi3_cin_vout_0_insn */

        case ZERO_EXTEND:
          x11 = XEXP (x4, 1);
          if (GET_CODE (x11) != CONST_INT
              || XWINT (x11, 0) != 4294967296L
              || GET_MODE (x3) != E_CC_ADCmode
              || GET_MODE (x4) != E_CC_ADCmode)
            return -1;
          x22 = XEXP (x21, 0);
          operands[1] = x22;
          if (!s_register_operand (operands[1], E_SImode))
            return -1;
          x17 = XEXP (x7, 1);
          x18 = XEXP (x17, 0);
          operands[3] = x18;
          if (!arm_carry_operation (operands[3], E_SImode))
            return -1;
          x24 = XEXP (x17, 1);
          if (!rtx_equal_p (x24, operands[1])
              || !
#line 900 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT))
            return -1;
          return 6; /* *addsi3_cin_cout_0_insn */

        default:
          return -1;
        }

    case SIGN_EXTEND:
      if (GET_MODE (x6) != E_DImode
          || GET_MODE (x5) != E_DImode)
        return -1;
      x21 = XEXP (x5, 1);
      switch (GET_CODE (x21))
        {
        case SIGN_EXTEND:
          if (GET_MODE (x21) != E_DImode
              || pattern476 (x1) != 0)
            return -1;
          x22 = XEXP (x21, 0);
          operands[2] = x22;
          if (!register_operand (operands[2], E_SImode))
            return -1;
          x7 = XVECEXP (x1, 0, 1);
          x10 = XEXP (x7, 0);
          operands[0] = x10;
          if (!register_operand (operands[0], E_SImode)
              || pattern619 (x1) != 0
              || !
#line 992 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT))
            return -1;
          return 8; /* addsi3_compareV_reg */

        case CONST_INT:
          if (pattern476 (x1) != 0)
            return -1;
          x7 = XVECEXP (x1, 0, 1);
          x10 = XEXP (x7, 0);
          operands[0] = x10;
          if (!register_operand (operands[0], E_SImode))
            return -1;
          x11 = XEXP (x4, 1);
          x13 = XEXP (x11, 0);
          x14 = XEXP (x13, 0);
          if (!rtx_equal_p (x14, operands[1]))
            return -1;
          x17 = XEXP (x7, 1);
          x18 = XEXP (x17, 0);
          if (!rtx_equal_p (x18, operands[1]))
            return -1;
          if (XWINT (x21, 0) == 2147483648L)
            {
              x23 = XEXP (x13, 1);
              if (GET_CODE (x23) == CONST_INT
                  && XWINT (x23, 0) == -2147483648L)
                {
                  x24 = XEXP (x17, 1);
                  if (GET_CODE (x24) == CONST_INT
                      && XWINT (x24, 0) == -2147483648L
                      && 
#line 1025 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT))
                    return 10; /* subvsi3_intmin */
                }
            }
          operands[2] = x21;
          if (!arm_addimm_operand (operands[2], E_VOIDmode))
            return -1;
          x23 = XEXP (x13, 1);
          if (!rtx_equal_p (x23, operands[2]))
            return -1;
          x24 = XEXP (x17, 1);
          if (!rtx_equal_p (x24, operands[2])
              || !
#line 1041 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && INTVAL (operands[2]) == ARM_SIGN_EXTEND (INTVAL (operands[2]))))
            return -1;
          return 11; /* addsi3_compareV_imm */

        case GEU:
        case LTU:
          operands[3] = x21;
          if (!arm_borrow_operation (operands[3], E_DImode))
            return -1;
          x7 = XVECEXP (x1, 0, 1);
          if (GET_CODE (x7) != CLOBBER
              || GET_MODE (x3) != E_CC_SWPmode
              || GET_MODE (x4) != E_CC_SWPmode)
            return -1;
          x8 = XEXP (x6, 0);
          operands[2] = x8;
          if (!s_register_operand (operands[2], E_SImode))
            return -1;
          x11 = XEXP (x4, 1);
          operands[1] = x11;
          if (!arm_immediate_operand (operands[1], E_VOIDmode))
            return -1;
          x10 = XEXP (x7, 0);
          operands[0] = x10;
          if (!scratch_operand (operands[0], E_SImode)
              || !
#line 2128 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_ARM))
            return -1;
          return 50; /* rscsi3_CC_NVout_scratch */

        default:
          return -1;
        }

    case REG:
    case SUBREG:
      operands[1] = x6;
      if (!s_register_operand (operands[1], E_SImode)
          || pattern445 (x1, 
E_SImode) != 0)
        return -1;
      x21 = XEXP (x5, 1);
      operands[2] = x21;
      if (!arm_add_operand (operands[2], E_SImode))
        return -1;
      x7 = XVECEXP (x1, 0, 1);
      x10 = XEXP (x7, 0);
      operands[0] = x10;
      if (!s_register_operand (operands[0], E_SImode))
        return -1;
      x17 = XEXP (x7, 1);
      x18 = XEXP (x17, 0);
      if (!rtx_equal_p (x18, operands[1]))
        return -1;
      x24 = XEXP (x17, 1);
      if (!rtx_equal_p (x24, operands[2]))
        return -1;
      x11 = XEXP (x4, 1);
      switch (GET_CODE (x11))
        {
        case CONST_INT:
          if (XWINT (x11, 0) == 0L
              && GET_MODE (x3) == E_CC_NZmode
              && GET_MODE (x4) == E_CC_NZmode)
            {
              if (
#line 1127 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_ARM))
                return 13; /* addsi3_compare0 */
              if (
#line 1371 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/thumb2.md"
(TARGET_THUMB2))
                return 1059; /* thumb2_addsi3_compare0 */
            }
          break;

        case REG:
        case SUBREG:
          if (rtx_equal_p (x11, operands[1])
              && GET_MODE (x3) == E_CC_Cmode
              && GET_MODE (x4) == E_CC_Cmode
              && 
#line 1245 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT))
            return 17; /* addsi3_compare_op1 */
          break;

        default:
          break;
        }
      if (GET_MODE (x3) != E_CC_Cmode
          || GET_MODE (x4) != E_CC_Cmode
          || !rtx_equal_p (x11, operands[2])
          || !
#line 1270 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT))
        return -1;
      return 18; /* *addsi3_compare_op2 */

    case ZERO_EXTEND:
      if (GET_MODE (x6) != E_DImode)
        return -1;
      x7 = XVECEXP (x1, 0, 1);
      if (GET_CODE (x7) != CLOBBER
          || pattern446 (x2, 
E_DImode, 
E_CC_SWPmode) != 0)
        return -1;
      x21 = XEXP (x5, 1);
      operands[3] = x21;
      if (!arm_borrow_operation (operands[3], E_DImode))
        return -1;
      x11 = XEXP (x4, 1);
      operands[1] = x11;
      if (!arm_immediate_operand (operands[1], E_VOIDmode))
        return -1;
      x10 = XEXP (x7, 0);
      operands[0] = x10;
      if (!scratch_operand (operands[0], E_SImode)
          || !
#line 2128 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_ARM))
        return -1;
      return 51; /* rscsi3_CC_Bout_scratch */

    case MULT:
      if (GET_MODE (x6) != E_SImode)
        return -1;
      x11 = XEXP (x4, 1);
      if (x11 != const_int_rtx[MAX_SAVED_CONST_INT + 0]
          || pattern446 (x2, 
E_SImode, 
E_CC_NZmode) != 0)
        return -1;
      x9 = XEXP (x6, 1);
      operands[1] = x9;
      if (!s_register_operand (operands[1], E_SImode))
        return -1;
      x21 = XEXP (x5, 1);
      operands[3] = x21;
      if (!s_register_operand (operands[3], E_SImode))
        return -1;
      x7 = XVECEXP (x1, 0, 1);
      switch (pattern592 (x7, 
MULT, 
PLUS))
        {
        case 0:
          x17 = XEXP (x7, 1);
          x18 = XEXP (x17, 0);
          x20 = XEXP (x18, 1);
          if (!rtx_equal_p (x20, operands[1]))
            return -1;
          x24 = XEXP (x17, 1);
          if (!rtx_equal_p (x24, operands[3]))
            return -1;
          if (
#line 2363 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_ARM && arm_arch6))
            return 63; /* *mulsi3addsi_compare0 */
          if (!
#line 2380 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_ARM && arm_arch6 && optimize_size))
            return -1;
          return 64; /* *mulsi3addsi_compare0_v6 */

        case 1:
          if (
#line 2395 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_ARM && !arm_arch6))
            return 65; /* *mulsi3addsi_compare0_scratch */
          if (!
#line 2410 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_ARM && arm_arch6 && optimize_size))
            return -1;
          return 66; /* *mulsi3addsi_compare0_scratch_v6 */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_37 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19, x20, x21, x22, x23, x24, x25;
  rtx x26, x27, x28, x29, x30, x31, x32, x33;
  rtx x34;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  switch (GET_CODE (x2))
    {
    case CALL:
      x3 = XEXP (x2, 0);
      switch (pattern7 (x3))
        {
        case 0:
          x4 = XEXP (x2, 1);
          operands[1] = x4;
          x5 = XVECEXP (x1, 0, 1);
          switch (GET_CODE (x5))
            {
            case USE:
              x6 = XVECEXP (x1, 0, 2);
              if (pattern319 (x6, 
E_SImode, 
14) != 0)
                return -1;
              x7 = XEXP (x5, 0);
              operands[2] = x7;
              if (s_register_operand (operands[0], E_SImode))
                {
                  if (
#line 8707 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_ARM && arm_arch5t && !SIBLING_CALL_P (insn)))
                    return 290; /* *call_reg_armv5 */
                  if (
#line 8717 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_ARM && !arm_arch5t && !SIBLING_CALL_P (insn)))
                    return 291; /* *call_reg_arm */
                }
              if (
#line 8846 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && !SIBLING_CALL_P (insn)
   && (GET_CODE (operands[0]) == SYMBOL_REF)
   && !arm_is_long_call_p (SYMBOL_REF_DECL (operands[0]))))
                return 294; /* *call_symbol */
              if (register_operand (operands[0], E_SImode))
                {
                  if (
#line 1870 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/thumb1.md"
(TARGET_THUMB1 && arm_arch5t && !SIBLING_CALL_P (insn)))
                    return 991; /* *call_reg_thumb1_v5 */
                  if (
#line 1893 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/thumb1.md"
(TARGET_THUMB1 && !arm_arch5t && !SIBLING_CALL_P (insn)))
                    return 993; /* *call_reg_thumb1 */
                }
              if (
#line 1960 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/thumb1.md"
(TARGET_THUMB1
   && GET_CODE (operands[0]) == SYMBOL_REF
   && !arm_is_long_call_p (SYMBOL_REF_DECL (operands[0]))))
                return 997; /* *call_insn */
              if (!s_register_operand (operands[0], E_SImode)
                  || !
#line 534 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/thumb2.md"
(TARGET_THUMB2))
                return -1;
              return 1025; /* *call_reg_thumb2 */

            case RETURN:
              x6 = XVECEXP (x1, 0, 2);
              if (GET_CODE (x6) != USE
                  || !call_insn_operand (operands[0], E_SImode))
                return -1;
              x8 = XEXP (x6, 0);
              operands[2] = x8;
              if (!
#line 8959 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT && SIBLING_CALL_P (insn)))
                return -1;
              return 296; /* *sibcall_insn */

            default:
              return -1;
            }

        case 1:
          x5 = XVECEXP (x1, 0, 1);
          if (GET_CODE (x5) != USE)
            return -1;
          x6 = XVECEXP (x1, 0, 2);
          if (pattern319 (x6, 
E_SImode, 
14) != 0)
            return -1;
          x9 = XVECEXP (x3, 0, 0);
          x10 = XEXP (x9, 0);
          if (GET_CODE (x10) == REG
              && REGNO (x10) == 4
              && GET_MODE (x10) == E_SImode)
            {
              x4 = XEXP (x2, 1);
              operands[0] = x4;
              x7 = XEXP (x5, 0);
              operands[1] = x7;
              if (
#line 1882 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/thumb1.md"
(TARGET_THUMB1 && use_cmse && !SIBLING_CALL_P (insn)))
                return 992; /* *nonsecure_call_reg_thumb1_v5 */
            }
          operands[0] = x10;
          if (s_register_operand (operands[0], E_SImode))
            {
              x4 = XEXP (x2, 1);
              operands[1] = x4;
              x7 = XEXP (x5, 0);
              operands[2] = x7;
              if (
#line 545 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/thumb2.md"
(TARGET_THUMB2 && use_cmse && TARGET_HAVE_FPCXT_CMSE))
                return 1026; /* *nonsecure_call_reg_thumb2_fpcxt */
            }
          if (GET_CODE (x10) != REG
              || REGNO (x10) != 4
              || GET_MODE (x10) != E_SImode)
            return -1;
          x4 = XEXP (x2, 1);
          operands[0] = x4;
          x7 = XEXP (x5, 0);
          operands[1] = x7;
          if (!
#line 557 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/thumb2.md"
(TARGET_THUMB2 && use_cmse && !TARGET_HAVE_FPCXT_CMSE))
            return -1;
          return 1027; /* *nonsecure_call_reg_thumb2 */

        default:
          return -1;
        }

    case SET:
      x4 = XEXP (x2, 1);
      switch (GET_CODE (x4))
        {
        case CALL:
          switch (pattern19 (x2))
            {
            case 0:
              x11 = XEXP (x4, 1);
              operands[2] = x11;
              x5 = XVECEXP (x1, 0, 1);
              switch (GET_CODE (x5))
                {
                case USE:
                  x6 = XVECEXP (x1, 0, 2);
                  if (pattern319 (x6, 
E_SImode, 
14) != 0)
                    return -1;
                  x7 = XEXP (x5, 0);
                  operands[3] = x7;
                  if (s_register_operand (operands[1], E_SImode))
                    {
                      if (
#line 8819 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_ARM && arm_arch5t && !SIBLING_CALL_P (insn)))
                        return 292; /* *call_value_reg_armv5 */
                      if (
#line 8830 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_ARM && !arm_arch5t && !SIBLING_CALL_P (insn)))
                        return 293; /* *call_value_reg_arm */
                    }
                  if (
#line 8870 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && !SIBLING_CALL_P (insn)
   && (GET_CODE (operands[1]) == SYMBOL_REF)
   && !arm_is_long_call_p (SYMBOL_REF_DECL (operands[1]))))
                    return 295; /* *call_value_symbol */
                  if (register_operand (operands[1], E_SImode))
                    {
                      if (
#line 1914 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/thumb1.md"
(TARGET_THUMB1 && arm_arch5t))
                        return 994; /* *call_value_reg_thumb1_v5 */
                      if (
#line 1940 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/thumb1.md"
(TARGET_THUMB1 && !arm_arch5t))
                        return 996; /* *call_value_reg_thumb1 */
                    }
                  if (
#line 1974 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/thumb1.md"
(TARGET_THUMB1
   && GET_CODE (operands[1]) == SYMBOL_REF
   && !arm_is_long_call_p (SYMBOL_REF_DECL (operands[1]))))
                    return 998; /* *call_value_insn */
                  if (!register_operand (operands[1], E_SImode)
                      || !
#line 569 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/thumb2.md"
(TARGET_THUMB2))
                    return -1;
                  return 1028; /* *call_value_reg_thumb2 */

                case RETURN:
                  x6 = XVECEXP (x1, 0, 2);
                  if (GET_CODE (x6) != USE
                      || !call_insn_operand (operands[1], E_SImode))
                    return -1;
                  x8 = XEXP (x6, 0);
                  operands[3] = x8;
                  if (!
#line 8980 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT && SIBLING_CALL_P (insn)))
                    return -1;
                  return 297; /* *sibcall_value_insn */

                default:
                  return -1;
                }

            case 1:
              x5 = XVECEXP (x1, 0, 1);
              if (GET_CODE (x5) != USE)
                return -1;
              x6 = XVECEXP (x1, 0, 2);
              if (pattern319 (x6, 
E_SImode, 
14) != 0)
                return -1;
              x12 = XEXP (x4, 0);
              x13 = XVECEXP (x12, 0, 0);
              x14 = XEXP (x13, 0);
              if (GET_CODE (x14) == REG
                  && REGNO (x14) == 4
                  && GET_MODE (x14) == E_SImode)
                {
                  x11 = XEXP (x4, 1);
                  operands[1] = x11;
                  x7 = XEXP (x5, 0);
                  operands[2] = x7;
                  if (
#line 1928 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/thumb1.md"
(TARGET_THUMB1 && use_cmse))
                    return 995; /* *nonsecure_call_value_reg_thumb1_v5 */
                }
              operands[1] = x14;
              if (register_operand (operands[1], E_SImode))
                {
                  x11 = XEXP (x4, 1);
                  operands[2] = x11;
                  x7 = XEXP (x5, 0);
                  operands[3] = x7;
                  if (
#line 582 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/thumb2.md"
(TARGET_THUMB2 && use_cmse && TARGET_HAVE_FPCXT_CMSE))
                    return 1029; /* *nonsecure_call_value_reg_thumb2_fpcxt */
                }
              if (GET_CODE (x14) != REG
                  || REGNO (x14) != 4
                  || GET_MODE (x14) != E_SImode)
                return -1;
              x11 = XEXP (x4, 1);
              operands[1] = x11;
              x7 = XEXP (x5, 0);
              operands[2] = x7;
              if (!
#line 595 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/thumb2.md"
(TARGET_THUMB2 && use_cmse && !TARGET_HAVE_FPCXT_CMSE))
                return -1;
              return 1030; /* *nonsecure_call_value_reg_thumb2 */

            default:
              return -1;
            }

        case UNSPEC:
          x5 = XVECEXP (x1, 0, 1);
          if (GET_CODE (x5) != CLOBBER)
            return -1;
          x6 = XVECEXP (x1, 0, 2);
          if (GET_CODE (x6) != CLOBBER)
            return -1;
          switch (XVECLEN (x4, 0))
            {
            case 1:
              if (pattern286 (x4) != 0
                  || pattern451 (x1) != 0)
                return -1;
              return 308; /* *stack_protect_combined_set_insn */

            case 2:
              if (XINT (x4, 1) != 21)
                return -1;
              x15 = XVECEXP (x4, 0, 0);
              if (GET_CODE (x15) != REG
                  || REGNO (x15) != 0
                  || GET_MODE (x15) != E_SImode)
                return -1;
              x16 = XVECEXP (x4, 0, 1);
              if (GET_CODE (x16) != LABEL_REF)
                return -1;
              x3 = XEXP (x2, 0);
              if (GET_CODE (x3) != PC)
                return -1;
              x7 = XEXP (x5, 0);
              if (GET_CODE (x7) != REG
                  || REGNO (x7) != 12
                  || GET_MODE (x7) != E_SImode)
                return -1;
              x8 = XEXP (x6, 0);
              if (GET_CODE (x8) != REG
                  || REGNO (x8) != 14
                  || GET_MODE (x8) != E_SImode)
                return -1;
              x17 = XEXP (x16, 0);
              operands[0] = x17;
              if (!
#line 2008 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/thumb1.md"
(TARGET_THUMB1))
                return -1;
              return 999; /* thumb1_casesi_dispatch */

            default:
              return -1;
            }

        case COMPARE:
          if (GET_MODE (x4) != E_CC_Zmode)
            return -1;
          x12 = XEXP (x4, 0);
          if (GET_CODE (x12) != UNSPEC
              || XVECLEN (x12, 0) != 2
              || XINT (x12, 1) != 41
              || pattern290 (x2, 
E_CC_Zmode) != 0)
            return -1;
          x5 = XVECEXP (x1, 0, 1);
          if (GET_CODE (x5) != CLOBBER)
            return -1;
          x6 = XVECEXP (x1, 0, 2);
          if (GET_CODE (x6) != CLOBBER)
            return -1;
          x13 = XVECEXP (x12, 0, 0);
          if (!memory_operand (x13, E_SImode))
            return -1;
          operands[1] = x13;
          x18 = XVECEXP (x12, 0, 1);
          if (GET_CODE (x18) == MEM
              && GET_MODE (x18) == E_SImode)
            {
              x19 = XEXP (x18, 0);
              operands[2] = x19;
              if (register_operand (operands[2], E_SImode))
                {
                  x7 = XEXP (x5, 0);
                  operands[0] = x7;
                  if (register_operand (operands[0], E_SImode))
                    {
                      x8 = XEXP (x6, 0);
                      if (rtx_equal_p (x8, operands[2])
                          && 
#line 9452 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT))
                        return 311; /* arm_stack_protect_test_insn */
                    }
                }
            }
          operands[0] = x13;
          operands[1] = x18;
          if (!memory_operand (operands[1], E_SImode))
            return -1;
          x7 = XEXP (x5, 0);
          operands[2] = x7;
          if (!scratch_operand (operands[2], E_SImode))
            return -1;
          x8 = XEXP (x6, 0);
          operands[3] = x8;
          if (!scratch_operand (operands[3], E_SImode))
            return -1;
          return 313; /* stack_protect_test_tls */

        case IF_THEN_ELSE:
          x12 = XEXP (x4, 0);
          switch (GET_CODE (x12))
            {
            case NE:
            case EQ:
            case GE:
            case GT:
            case LE:
            case LT:
            case GEU:
            case GTU:
            case LEU:
            case LTU:
            case UNORDERED:
            case ORDERED:
            case UNGE:
            case UNGT:
            case UNLE:
            case UNLT:
              x20 = XEXP (x12, 1);
              if (GET_CODE (x20) != CONST_INT)
                return -1;
              x21 = XEXP (x4, 2);
              if (GET_CODE (x21) != PC)
                return -1;
              x3 = XEXP (x2, 0);
              if (GET_CODE (x3) != PC)
                return -1;
              x5 = XVECEXP (x1, 0, 1);
              if (GET_CODE (x5) != SET)
                return -1;
              x22 = XEXP (x5, 1);
              if (GET_CODE (x22) != PLUS
                  || GET_MODE (x22) != E_SImode)
                return -1;
              x23 = XEXP (x22, 1);
              if (GET_CODE (x23) == CONST_INT)
                {
                  res = recog_36 (x1, insn, pnum_clobbers);
                  if (res >= 0)
                    return res;
                }
              x24 = XEXP (x12, 0);
              if (GET_CODE (x24) != PLUS
                  || GET_MODE (x24) != E_SImode
                  || XWINT (x20, 0) != 0L)
                return -1;
              x11 = XEXP (x4, 1);
              if (GET_CODE (x11) != LABEL_REF)
                return -1;
              x6 = XVECEXP (x1, 0, 2);
              if (GET_CODE (x6) != CLOBBER)
                return -1;
              operands[4] = x12;
              if (!arm_comparison_operator (operands[4], E_VOIDmode))
                return -1;
              x25 = XEXP (x24, 0);
              operands[2] = x25;
              if (!s_register_operand (operands[2], E_SImode))
                return -1;
              x26 = XEXP (x24, 1);
              operands[3] = x26;
              if (!reg_or_int_operand (operands[3], E_SImode))
                return -1;
              x27 = XEXP (x11, 0);
              operands[5] = x27;
              x7 = XEXP (x5, 0);
              operands[0] = x7;
              if (!thumb_cbrch_target_operand (operands[0], E_SImode))
                return -1;
              x8 = XEXP (x6, 0);
              operands[1] = x8;
              if (!scratch_operand (operands[1], E_SImode))
                return -1;
              x28 = XEXP (x22, 0);
              if (!rtx_equal_p (x28, operands[2])
                  || !rtx_equal_p (x23, operands[3])
                  || !
#line 1582 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/thumb1.md"
(TARGET_THUMB1
   && (GET_CODE (operands[4]) == EQ
       || GET_CODE (operands[4]) == NE
       || GET_CODE (operands[4]) == GE
       || GET_CODE (operands[4]) == LT)))
                return -1;
              return 982; /* *addsi3_cbranch */

            default:
              return -1;
            }

        case UNSPEC_VOLATILE:
          if (pnum_clobbers == NULL
              || XVECLEN (x4, 0) != 1
              || XINT (x4, 1) != 17)
            return -1;
          x15 = XVECEXP (x4, 0, 0);
          if (x15 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
            return -1;
          x5 = XVECEXP (x1, 0, 1);
          if (GET_CODE (x5) != SET)
            return -1;
          x6 = XVECEXP (x1, 0, 2);
          if (GET_CODE (x6) != SET)
            return -1;
          x29 = XEXP (x6, 1);
          if (GET_CODE (x29) != UNSPEC_VOLATILE
              || XVECLEN (x29, 0) != 5
              || XINT (x29, 1) != 17)
            return -1;
          x3 = XEXP (x2, 0);
          operands[0] = x3;
          x7 = XEXP (x5, 0);
          operands[1] = x7;
          x30 = XVECEXP (x29, 0, 0);
          operands[3] = x30;
          x31 = XVECEXP (x29, 0, 1);
          operands[4] = x31;
          x32 = XVECEXP (x29, 0, 2);
          operands[5] = x32;
          if (!const_int_operand (operands[5], E_SImode))
            return -1;
          x33 = XVECEXP (x29, 0, 3);
          operands[6] = x33;
          if (!const_int_operand (operands[6], E_SImode))
            return -1;
          x34 = XVECEXP (x29, 0, 4);
          operands[7] = x34;
          if (!const_int_operand (operands[7], E_SImode))
            return -1;
          switch (pattern262 (x1))
            {
            case 0:
              if (!(
#line 250 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREXBH && TARGET_HAVE_MEMORY_BARRIER) && 
#line 57 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iterators.md"
(TARGET_32BIT)))
                return -1;
              *pnum_clobbers = 1;
              return 3078; /* atomic_compare_and_swap32qi_1 */

            case 1:
              if (!(
#line 250 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREXBH && TARGET_HAVE_MEMORY_BARRIER) && 
#line 57 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iterators.md"
(TARGET_32BIT)))
                return -1;
              *pnum_clobbers = 1;
              return 3080; /* atomic_compare_and_swap32hi_1 */

            case 2:
              if (!(
#line 250 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREXBH && TARGET_HAVE_MEMORY_BARRIER) && 
#line 57 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iterators.md"
(TARGET_THUMB1)))
                return -1;
              *pnum_clobbers = 1;
              return 3079; /* atomic_compare_and_swapt1qi_1 */

            case 3:
              if (!(
#line 250 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREXBH && TARGET_HAVE_MEMORY_BARRIER) && 
#line 57 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iterators.md"
(TARGET_THUMB1)))
                return -1;
              *pnum_clobbers = 1;
              return 3081; /* atomic_compare_and_swapt1hi_1 */

            case 4:
              if (!(
#line 281 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREX && TARGET_HAVE_MEMORY_BARRIER) && 
#line 57 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iterators.md"
(TARGET_32BIT)))
                return -1;
              *pnum_clobbers = 1;
              return 3082; /* atomic_compare_and_swap32si_1 */

            case 5:
              if (!(
#line 281 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREXD && ARM_DOUBLEWORD_ALIGN
	&& TARGET_HAVE_MEMORY_BARRIER) && 
#line 57 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iterators.md"
(TARGET_32BIT)))
                return -1;
              *pnum_clobbers = 1;
              return 3084; /* atomic_compare_and_swap32di_1 */

            case 6:
              if (!(
#line 281 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREX && TARGET_HAVE_MEMORY_BARRIER) && 
#line 57 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iterators.md"
(TARGET_THUMB1)))
                return -1;
              *pnum_clobbers = 1;
              return 3083; /* atomic_compare_and_swapt1si_1 */

            case 7:
              if (!(
#line 281 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREXD && ARM_DOUBLEWORD_ALIGN
	&& TARGET_HAVE_MEMORY_BARRIER) && 
#line 57 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iterators.md"
(TARGET_THUMB1)))
                return -1;
              *pnum_clobbers = 1;
              return 3085; /* atomic_compare_and_swapt1di_1 */

            default:
              return -1;
            }

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_63 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (pattern93 (x1) != 0)
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_V16QImode:
      if (!s_register_operand (operands[0], E_V16QImode))
        return -1;
      x2 = XEXP (x1, 1);
      if (GET_MODE (x2) != E_V16QImode
          || !s_register_operand (operands[2], E_V16QImode)
          || !
#line 3437 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
((TARGET_HAVE_MVE && VALID_MVE_SI_MODE (V16QImode))
   || (TARGET_HAVE_MVE_FLOAT && VALID_MVE_SF_MODE (V16QImode))))
        return -1;
      return 4876; /* mve_vldrq_gather_offset_v16qi */

    case E_V8HImode:
      if (!s_register_operand (operands[0], E_V8HImode))
        return -1;
      x2 = XEXP (x1, 1);
      if (GET_MODE (x2) != E_V8HImode
          || !s_register_operand (operands[2], E_V8HImode)
          || !
#line 3437 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
((TARGET_HAVE_MVE && VALID_MVE_SI_MODE (V8HImode))
   || (TARGET_HAVE_MVE_FLOAT && VALID_MVE_SF_MODE (V8HImode))))
        return -1;
      return 4877; /* mve_vldrq_gather_offset_v8hi */

    case E_V4SImode:
      if (!s_register_operand (operands[0], E_V4SImode))
        return -1;
      x2 = XEXP (x1, 1);
      if (GET_MODE (x2) != E_V4SImode
          || !s_register_operand (operands[2], E_V4SImode)
          || !
#line 3437 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
((TARGET_HAVE_MVE && VALID_MVE_SI_MODE (V4SImode))
   || (TARGET_HAVE_MVE_FLOAT && VALID_MVE_SF_MODE (V4SImode))))
        return -1;
      return 4878; /* mve_vldrq_gather_offset_v4si */

    case E_V8HFmode:
      if (!s_register_operand (operands[0], E_V8HFmode))
        return -1;
      x2 = XEXP (x1, 1);
      if (GET_MODE (x2) != E_V8HFmode
          || !s_register_operand (operands[2], E_V8HImode)
          || !
#line 3437 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
((TARGET_HAVE_MVE && VALID_MVE_SI_MODE (V8HFmode))
   || (TARGET_HAVE_MVE_FLOAT && VALID_MVE_SF_MODE (V8HFmode))))
        return -1;
      return 4879; /* mve_vldrq_gather_offset_v8hf */

    case E_V4SFmode:
      if (!s_register_operand (operands[0], E_V4SFmode))
        return -1;
      x2 = XEXP (x1, 1);
      if (GET_MODE (x2) != E_V4SFmode
          || !s_register_operand (operands[2], E_V4SImode)
          || !
#line 3437 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
((TARGET_HAVE_MVE && VALID_MVE_SI_MODE (V4SFmode))
   || (TARGET_HAVE_MVE_FLOAT && VALID_MVE_SF_MODE (V4SFmode))))
        return -1;
      return 4880; /* mve_vldrq_gather_offset_v4sf */

    case E_V2DImode:
      if (!s_register_operand (operands[0], E_V2DImode))
        return -1;
      x2 = XEXP (x1, 1);
      if (GET_MODE (x2) != E_V2DImode
          || !s_register_operand (operands[2], E_V2DImode)
          || !
#line 3437 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
((TARGET_HAVE_MVE && VALID_MVE_SI_MODE (V2DImode))
   || (TARGET_HAVE_MVE_FLOAT && VALID_MVE_SF_MODE (V2DImode))))
        return -1;
      return 4881; /* mve_vldrq_gather_offset_v2di */

    default:
      return -1;
    }
}

 int
recog_68 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  x5 = XVECEXP (x3, 0, 1);
  operands[2] = x5;
  x6 = XVECEXP (x3, 0, 2);
  operands[3] = x6;
  if (!immediate_operand (operands[3], E_SImode))
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_V4HImode:
      if (pattern42 (x3, 
E_V4HImode) != 0
          || !
#line 3880 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2173; /* neon_vmul_lanev4hi */

    case E_V2SImode:
      if (pattern42 (x3, 
E_V2SImode) != 0
          || !
#line 3880 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2174; /* neon_vmul_lanev2si */

    case E_V2SFmode:
      if (pattern42 (x3, 
E_V2SFmode) != 0
          || !
#line 3880 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2175; /* neon_vmul_lanev2sf */

    case E_V8HImode:
      if (pattern41 (x3, 
E_V4HImode, 
E_V8HImode) != 0
          || !
#line 3897 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2176; /* neon_vmul_lanev8hi */

    case E_V4SImode:
      if (pattern41 (x3, 
E_V2SImode, 
E_V4SImode) != 0
          || !
#line 3897 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2177; /* neon_vmul_lanev4si */

    case E_V4SFmode:
      if (pattern41 (x3, 
E_V2SFmode, 
E_V4SFmode) != 0
          || !
#line 3897 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2178; /* neon_vmul_lanev4sf */

    case E_V8HFmode:
      if (pattern41 (x3, 
E_V4HFmode, 
E_V8HFmode) != 0
          || !
#line 3914 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON_FP16INST))
        return -1;
      return 2179; /* neon_vmul_lanev8hf */

    case E_V4HFmode:
      if (pattern42 (x3, 
E_V4HFmode) != 0
          || !
#line 3914 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON_FP16INST))
        return -1;
      return 2180; /* neon_vmul_lanev4hf */

    default:
      return -1;
    }
}

 int
recog_75 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  if (!const_int_coproc_operand (operands[1], E_SImode))
    return -1;
  x5 = XVECEXP (x3, 0, 1);
  operands[2] = x5;
  x6 = XVECEXP (x3, 0, 2);
  operands[3] = x6;
  switch (GET_MODE (operands[0]))
    {
    case E_SImode:
      if (pattern427 (x3, 
E_SImode) != 0
          || !
#line 2214 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/vfp.md"
(TARGET_CDE && (TARGET_ARM_FP || TARGET_HAVE_MVE)))
        return -1;
      return 933; /* arm_vcx2si */

    case E_DImode:
      if (pattern427 (x3, 
E_DImode) != 0
          || !
#line 2214 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/vfp.md"
(TARGET_CDE && (TARGET_ARM_FP || TARGET_HAVE_MVE)))
        return -1;
      return 934; /* arm_vcx2di */

    case E_V16QImode:
      if (!register_operand (operands[0], E_V16QImode)
          || GET_MODE (x3) != E_V16QImode
          || !register_operand (operands[2], E_V16QImode)
          || !const_int_mve_cde2_operand (operands[3], E_SImode)
          || !
#line 4472 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_CDE && TARGET_HAVE_MVE))
        return -1;
      return 5044; /* arm_vcx2qv16qi */

    default:
      return -1;
    }
}

 int
recog_85 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (pattern34 (x1))
    {
    case 0:
      if (!
#line 2155 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 1571; /* neon_vmlsv8qi_unspec */

    case 1:
      if (!
#line 2155 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 1572; /* neon_vmlsv16qi_unspec */

    case 2:
      if (!
#line 2155 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 1573; /* neon_vmlsv4hi_unspec */

    case 3:
      if (!
#line 2155 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 1574; /* neon_vmlsv8hi_unspec */

    case 4:
      if (!
#line 2155 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 1575; /* neon_vmlsv2si_unspec */

    case 5:
      if (!
#line 2155 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 1576; /* neon_vmlsv4si_unspec */

    case 6:
      if (!
#line 2155 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 1577; /* neon_vmlsv2sf_unspec */

    case 7:
      if (!
#line 2155 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 1578; /* neon_vmlsv4sf_unspec */

    default:
      return -1;
    }
}

 int
recog_96 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (pattern71 (x1))
    {
    case 0:
      if (!
#line 1918 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
        return -1;
      return 4135; /* mve_vpselq_uv16qi */

    case 1:
      if (!
#line 1918 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
        return -1;
      return 4137; /* mve_vpselq_uv8hi */

    case 2:
      if (!
#line 1918 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
        return -1;
      return 4139; /* mve_vpselq_uv4si */

    case 3:
      if (!
#line 1918 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
        return -1;
      return 4141; /* mve_vpselq_uv2di */

    default:
      return -1;
    }
}

 int
recog_104 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  switch (GET_MODE (operands[0]))
    {
    case E_V8QImode:
      if (!neon_struct_operand (operands[0], E_V8QImode)
          || GET_MODE (x3) != E_V8QImode
          || !s_register_operand (operands[1], E_V8QImode)
          || !
#line 5228 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2643; /* neon_vst1v8qi */

    case E_V16QImode:
      if (!neon_struct_operand (operands[0], E_V16QImode)
          || GET_MODE (x3) != E_V16QImode
          || !s_register_operand (operands[1], E_V16QImode)
          || !
#line 5228 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2644; /* neon_vst1v16qi */

    case E_V4HImode:
      if (!neon_struct_operand (operands[0], E_V4HImode)
          || GET_MODE (x3) != E_V4HImode
          || !s_register_operand (operands[1], E_V4HImode)
          || !
#line 5228 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2645; /* neon_vst1v4hi */

    case E_V8HImode:
      if (!neon_struct_operand (operands[0], E_V8HImode)
          || GET_MODE (x3) != E_V8HImode
          || !s_register_operand (operands[1], E_V8HImode)
          || !
#line 5228 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2646; /* neon_vst1v8hi */

    case E_V2SImode:
      if (!neon_struct_operand (operands[0], E_V2SImode)
          || GET_MODE (x3) != E_V2SImode
          || !s_register_operand (operands[1], E_V2SImode)
          || !
#line 5228 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2647; /* neon_vst1v2si */

    case E_V4SImode:
      if (!neon_struct_operand (operands[0], E_V4SImode)
          || GET_MODE (x3) != E_V4SImode
          || !s_register_operand (operands[1], E_V4SImode)
          || !
#line 5228 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2648; /* neon_vst1v4si */

    case E_V4HFmode:
      if (!neon_struct_operand (operands[0], E_V4HFmode)
          || GET_MODE (x3) != E_V4HFmode
          || !s_register_operand (operands[1], E_V4HFmode)
          || !
#line 5228 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2649; /* neon_vst1v4hf */

    case E_V8HFmode:
      if (!neon_struct_operand (operands[0], E_V8HFmode)
          || GET_MODE (x3) != E_V8HFmode
          || !s_register_operand (operands[1], E_V8HFmode)
          || !
#line 5228 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2650; /* neon_vst1v8hf */

    case E_V4BFmode:
      if (!neon_struct_operand (operands[0], E_V4BFmode)
          || GET_MODE (x3) != E_V4BFmode
          || !s_register_operand (operands[1], E_V4BFmode)
          || !
#line 5228 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2651; /* neon_vst1v4bf */

    case E_V8BFmode:
      if (!neon_struct_operand (operands[0], E_V8BFmode)
          || GET_MODE (x3) != E_V8BFmode
          || !s_register_operand (operands[1], E_V8BFmode)
          || !
#line 5228 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2652; /* neon_vst1v8bf */

    case E_V2SFmode:
      if (!neon_struct_operand (operands[0], E_V2SFmode)
          || GET_MODE (x3) != E_V2SFmode
          || !s_register_operand (operands[1], E_V2SFmode)
          || !
#line 5228 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2653; /* neon_vst1v2sf */

    case E_V4SFmode:
      if (!neon_struct_operand (operands[0], E_V4SFmode)
          || GET_MODE (x3) != E_V4SFmode
          || !s_register_operand (operands[1], E_V4SFmode)
          || !
#line 5228 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2654; /* neon_vst1v4sf */

    case E_DImode:
      if (!neon_struct_operand (operands[0], E_DImode)
          || GET_MODE (x3) != E_DImode
          || !s_register_operand (operands[1], E_DImode)
          || !
#line 5228 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2655; /* neon_vst1di */

    case E_V2DImode:
      if (!neon_struct_operand (operands[0], E_V2DImode)
          || GET_MODE (x3) != E_V2DImode
          || !s_register_operand (operands[1], E_V2DImode)
          || !
#line 5228 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2656; /* neon_vst1v2di */

    default:
      return -1;
    }
}

 int
recog_124 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XVECEXP (x2, 0, 0);
  if (GET_CODE (x3) != TRUNCATE)
    return -1;
  x4 = XEXP (x1, 0);
  operands[0] = x4;
  x5 = XEXP (x3, 0);
  operands[1] = x5;
  switch (GET_MODE (operands[0]))
    {
    case E_V8QImode:
      if (pattern369 (x2, 
E_V8QImode, 
E_V8HImode) != 0
          || !
#line 3179 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
        return -1;
      return 4827; /* mve_vstrq_truncate_v8qi */

    case E_V4QImode:
      if (pattern369 (x2, 
E_V4QImode, 
E_V4SImode) != 0
          || !
#line 3179 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
        return -1;
      return 4828; /* mve_vstrq_truncate_v4qi */

    case E_V4HImode:
      if (pattern369 (x2, 
E_V4HImode, 
E_V4SImode) != 0
          || !
#line 3179 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
        return -1;
      return 4829; /* mve_vstrq_truncate_v4hi */

    default:
      return -1;
    }
}

 int
recog_132 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != E_SImode)
    return -1;
  x3 = XEXP (x1, 0);
  if (GET_CODE (x3) != REG
      || REGNO (x3) != 101
      || GET_MODE (x3) != E_SImode)
    return -1;
  x4 = XVECEXP (x2, 0, 0);
  operands[0] = x4;
  if (!register_operand (operands[0], E_SImode)
      || !
#line 3977 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
    return -1;
  return 4972; /* set_fpscr_nzcvqc */
}

 int
recog_138 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XVECEXP (x2, 0, 1);
  if (GET_CODE (x3) != UNSPEC
      || XVECLEN (x3, 0) != 1
      || XINT (x3, 1) != 335)
    return -1;
  x4 = XVECEXP (x3, 0, 0);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x5 = XEXP (x1, 0);
  operands[0] = x5;
  x6 = XVECEXP (x2, 0, 0);
  operands[1] = x6;
  switch (GET_MODE (operands[0]))
    {
    case E_TImode:
      if (!s_register_operand (operands[0], E_TImode)
          || GET_MODE (x2) != E_TImode)
        return -1;
      switch (GET_MODE (operands[1]))
        {
        case E_HImode:
          if (!neon_struct_operand (operands[1], E_HImode)
              || GET_MODE (x3) != E_V8QImode
              || !
#line 5498 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2793; /* neon_vld2_dupv8qi */

        case E_SImode:
          if (!neon_struct_operand (operands[1], E_SImode)
              || GET_MODE (x3) != E_V4HImode
              || !
#line 5498 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2794; /* neon_vld2_dupv4hi */

        case E_SFmode:
          if (!neon_struct_operand (operands[1], E_SFmode)
              || GET_MODE (x3) != E_V4HFmode
              || !
#line 5498 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2795; /* neon_vld2_dupv4hf */

        case E_BFmode:
          if (!neon_struct_operand (operands[1], E_BFmode)
              || GET_MODE (x3) != E_V4BFmode
              || !(
#line 5498 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON) && 
#line 98 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iterators.md"
(TARGET_BF16_SIMD)))
            return -1;
          return 2796; /* neon_vld2_dupv4bf */

        case E_V2SImode:
          if (!neon_struct_operand (operands[1], E_V2SImode)
              || GET_MODE (x3) != E_V2SImode
              || !
#line 5498 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2797; /* neon_vld2_dupv2si */

        case E_V2SFmode:
          if (!neon_struct_operand (operands[1], E_V2SFmode)
              || GET_MODE (x3) != E_V2SFmode
              || !
#line 5498 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2798; /* neon_vld2_dupv2sf */

        case E_V2DImode:
          if (!neon_struct_operand (operands[1], E_V2DImode)
              || GET_MODE (x3) != E_DImode
              || !
#line 5498 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2799; /* neon_vld2_dupdi */

        default:
          return -1;
        }

    case E_OImode:
      if (pattern458 (x2, 
E_OImode) != 0
          || !
#line 5516 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_BF16_SIMD))
        return -1;
      return 2800; /* neon_vld2_dupv8bf */

    case E_CImode:
      if (pattern458 (x2, 
E_CImode) != 0
          || !
#line 5799 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_BF16_SIMD))
        return -1;
      return 2862; /* neon_vld3_dupv8bf */

    case E_XImode:
      if (pattern458 (x2, 
E_XImode) != 0
          || !
#line 6134 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_BF16_SIMD))
        return -1;
      return 2930; /* neon_vld4_dupv8bf */

    default:
      return -1;
    }
}

 int
recog_147 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (pattern158 (x1))
    {
    case 0:
      if (!
#line 5270 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2699; /* neon_vst1x3qav8qi */

    case 1:
      if (!
#line 5270 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2700; /* neon_vst1x3qav16qi */

    case 2:
      if (!
#line 5270 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2701; /* neon_vst1x3qav4hi */

    case 3:
      if (!
#line 5270 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2702; /* neon_vst1x3qav8hi */

    case 4:
      if (!
#line 5270 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2703; /* neon_vst1x3qav2si */

    case 5:
      if (!
#line 5270 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2704; /* neon_vst1x3qav4si */

    case 6:
      if (!
#line 5270 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2705; /* neon_vst1x3qav4hf */

    case 7:
      if (!
#line 5270 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2706; /* neon_vst1x3qav8hf */

    case 8:
      if (!
#line 5270 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2707; /* neon_vst1x3qav4bf */

    case 9:
      if (!
#line 5270 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2708; /* neon_vst1x3qav8bf */

    case 10:
      if (!
#line 5270 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2709; /* neon_vst1x3qav2sf */

    case 11:
      if (!
#line 5270 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2710; /* neon_vst1x3qav4sf */

    case 12:
      if (!
#line 5270 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2711; /* neon_vst1x3qadi */

    case 13:
      if (!
#line 5270 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2712; /* neon_vst1x3qav2di */

    default:
      return -1;
    }
}

 int
recog_156 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (pattern146 (x1))
    {
    case 0:
      if (!
#line 2681 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 1826; /* neon_vminsv8qi */

    case 1:
      if (!
#line 2681 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 1830; /* neon_vminsv16qi */

    case 2:
      if (!
#line 2681 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 1834; /* neon_vminsv4hi */

    case 3:
      if (!
#line 2681 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 1838; /* neon_vminsv8hi */

    case 4:
      if (!
#line 2681 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 1842; /* neon_vminsv2si */

    case 5:
      if (!
#line 2681 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 1846; /* neon_vminsv4si */

    case 6:
      if (!
#line 2691 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 1849; /* neon_vminfv2sf */

    case 7:
      if (!
#line 2691 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 1851; /* neon_vminfv4sf */

    case 8:
      if (!
#line 2702 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON_FP16INST))
        return -1;
      return 1853; /* neon_vminfv8hf */

    case 9:
      if (!
#line 2702 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON_FP16INST))
        return -1;
      return 1855; /* neon_vminfv4hf */

    default:
      return -1;
    }
}

 int
recog_164 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (pattern152 (x1))
    {
    case 0:
      if (!
#line 4588 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2400; /* neon_vqshl_s_nv8qi */

    case 1:
      if (!
#line 4588 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2402; /* neon_vqshl_s_nv16qi */

    case 2:
      if (!
#line 4588 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2404; /* neon_vqshl_s_nv4hi */

    case 3:
      if (!
#line 4588 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2406; /* neon_vqshl_s_nv8hi */

    case 4:
      if (!
#line 4588 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2408; /* neon_vqshl_s_nv2si */

    case 5:
      if (!
#line 4588 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2410; /* neon_vqshl_s_nv4si */

    case 6:
      if (!
#line 4588 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2412; /* neon_vqshl_s_ndi */

    case 7:
      if (!
#line 4588 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2414; /* neon_vqshl_s_nv2di */

    default:
      return -1;
    }
}

 int
recog_174 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (pattern139 (x1))
    {
    case 0:
      if (!
#line 4498 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2275; /* neon_vrshluv8qi */

    case 1:
      if (!
#line 4498 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2279; /* neon_vrshluv16qi */

    case 2:
      if (!
#line 4498 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2283; /* neon_vrshluv4hi */

    case 3:
      if (!
#line 4498 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2287; /* neon_vrshluv8hi */

    case 4:
      if (!
#line 4498 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2291; /* neon_vrshluv2si */

    case 5:
      if (!
#line 4498 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2295; /* neon_vrshluv4si */

    case 6:
      if (!
#line 4498 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2299; /* neon_vrshludi */

    case 7:
      if (!
#line 4498 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2303; /* neon_vrshluv2di */

    default:
      return -1;
    }
}

 int
recog_184 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  x5 = XVECEXP (x3, 0, 1);
  operands[2] = x5;
  switch (GET_MODE (operands[0]))
    {
    case E_V8QImode:
      if (pattern42 (x3, 
E_V8QImode) != 0
          || !
#line 1621 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 1527; /* neon_vmulpv8qi */

    case E_V16QImode:
      if (pattern42 (x3, 
E_V16QImode) != 0
          || !
#line 1621 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 1528; /* neon_vmulpv16qi */

    case E_V2SFmode:
      if (pattern42 (x3, 
E_V2SFmode) != 0
          || !
#line 1621 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 1529; /* neon_vmulfv2sf */

    case E_V4SFmode:
      if (pattern42 (x3, 
E_V4SFmode) != 0
          || !
#line 1621 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 1530; /* neon_vmulfv4sf */

    default:
      return -1;
    }
}

 int
recog_193 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (pattern159 (x1))
    {
    case 0:
      if (!
#line 5327 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2741; /* neon_vst1x4qav16qi */

    case 1:
      if (!
#line 5327 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2742; /* neon_vst1x4qav8hi */

    case 2:
      if (!
#line 5327 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2743; /* neon_vst1x4qav8hf */

    case 3:
      if (!(
#line 5327 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON) && 
#line 132 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iterators.md"
(TARGET_BF16_SIMD)))
        return -1;
      return 2744; /* neon_vst1x4qav8bf */

    case 4:
      if (!
#line 5327 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2745; /* neon_vst1x4qav4si */

    case 5:
      if (!
#line 5327 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2746; /* neon_vst1x4qav4sf */

    case 6:
      if (!
#line 5327 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2747; /* neon_vst1x4qav2di */

    default:
      return -1;
    }
}

 int
recog_203 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (pattern162 (x1, 
E_OImode, 
E_XImode))
    {
    case 0:
      if (!
#line 6004 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2900; /* neon_vld4qav16qi */

    case 1:
      if (!
#line 6004 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2901; /* neon_vld4qav8hi */

    case 2:
      if (!
#line 6004 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2902; /* neon_vld4qav8hf */

    case 3:
      if (!(
#line 6004 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON) && 
#line 120 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iterators.md"
(TARGET_BF16_SIMD)))
        return -1;
      return 2903; /* neon_vld4qav8bf */

    case 4:
      if (!
#line 6004 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2904; /* neon_vld4qav4si */

    case 5:
      if (!
#line 6004 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2905; /* neon_vld4qav4sf */

    default:
      return -1;
    }
}

 int
recog_213 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (pattern138 (x1))
    {
    case 0:
      if (!
#line 2593 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 1785; /* neon_vabduv8qi */

    case 1:
      if (!
#line 2593 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 1787; /* neon_vabduv16qi */

    case 2:
      if (!
#line 2593 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 1789; /* neon_vabduv4hi */

    case 3:
      if (!
#line 2593 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 1791; /* neon_vabduv8hi */

    case 4:
      if (!
#line 2593 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 1793; /* neon_vabduv2si */

    case 5:
      if (!
#line 2593 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 1795; /* neon_vabduv4si */

    default:
      return -1;
    }
}

 int
recog_223 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (pattern127 (x1))
    {
    case 0:
      if (!
#line 376 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/vec-common.md"
(ARM_HAVE_V8QI_ARITH && !TARGET_REALLY_IWMMXT))
        return -1;
      return 518; /* mve_vshlq_sv8qi */

    case 1:
      if (!
#line 376 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/vec-common.md"
(ARM_HAVE_V16QI_ARITH && !TARGET_REALLY_IWMMXT))
        return -1;
      return 520; /* mve_vshlq_sv16qi */

    case 2:
      if (!
#line 376 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/vec-common.md"
(ARM_HAVE_V4HI_ARITH && !TARGET_REALLY_IWMMXT))
        return -1;
      return 522; /* mve_vshlq_sv4hi */

    case 3:
      if (!
#line 376 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/vec-common.md"
(ARM_HAVE_V8HI_ARITH && !TARGET_REALLY_IWMMXT))
        return -1;
      return 524; /* mve_vshlq_sv8hi */

    case 4:
      if (!
#line 376 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/vec-common.md"
(ARM_HAVE_V2SI_ARITH && !TARGET_REALLY_IWMMXT))
        return -1;
      return 526; /* mve_vshlq_sv2si */

    case 5:
      if (!
#line 376 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/vec-common.md"
(ARM_HAVE_V4SI_ARITH && !TARGET_REALLY_IWMMXT))
        return -1;
      return 528; /* mve_vshlq_sv4si */

    default:
      return -1;
    }
}

 int
recog_239 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (pattern133 (x1))
    {
    case 0:
      if (!
#line 1389 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 1441; /* neon_vpsmaxv8qi */

    case 1:
      if (!
#line 1389 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 1442; /* neon_vpsmaxv4hi */

    case 2:
      if (!
#line 1389 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 1443; /* neon_vpsmaxv2si */

    case 3:
      if (!
#line 1389 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 1444; /* neon_vpsmaxv2sf */

    default:
      return -1;
    }
}

 int
recog_250 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (pattern232 (x1) != 0)
    return -1;
  switch (GET_MODE (operands[1]))
    {
    case E_V8HImode:
      switch (pattern536 ())
        {
        case 0:
          if (!
#line 3699 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
((TARGET_HAVE_MVE && VALID_MVE_SI_MODE (V8HImode))
   || (TARGET_HAVE_MVE_FLOAT && VALID_MVE_SF_MODE (V8HImode))))
            return -1;
          return 4929; /* mve_vstrq_scatter_shifted_offset_p_v8hi */

        case 1:
          if (!
#line 3699 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
((TARGET_HAVE_MVE && VALID_MVE_SI_MODE (V8HFmode))
   || (TARGET_HAVE_MVE_FLOAT && VALID_MVE_SF_MODE (V8HFmode))))
            return -1;
          return 4931; /* mve_vstrq_scatter_shifted_offset_p_v8hf */

        default:
          return -1;
        }

    case E_V4SImode:
      if (!s_register_operand (operands[1], E_V4SImode))
        return -1;
      switch (pattern555 ())
        {
        case 0:
          if (!
#line 3699 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
((TARGET_HAVE_MVE && VALID_MVE_SI_MODE (V4SImode))
   || (TARGET_HAVE_MVE_FLOAT && VALID_MVE_SF_MODE (V4SImode))))
            return -1;
          return 4930; /* mve_vstrq_scatter_shifted_offset_p_v4si */

        case 1:
          if (!
#line 3699 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
((TARGET_HAVE_MVE && VALID_MVE_SI_MODE (V4SFmode))
   || (TARGET_HAVE_MVE_FLOAT && VALID_MVE_SF_MODE (V4SFmode))))
            return -1;
          return 4932; /* mve_vstrq_scatter_shifted_offset_p_v4sf */

        default:
          return -1;
        }

    case E_V2DImode:
      if (!s_register_operand (operands[1], E_V2DImode)
          || !s_register_operand (operands[2], E_V2DImode)
          || !vpr_register_operand (operands[3], E_V2QImode)
          || !
#line 3699 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
((TARGET_HAVE_MVE && VALID_MVE_SI_MODE (V2DImode))
   || (TARGET_HAVE_MVE_FLOAT && VALID_MVE_SF_MODE (V2DImode))))
        return -1;
      return 4933; /* mve_vstrq_scatter_shifted_offset_p_v2di */

    default:
      return -1;
    }
}

 int
recog_259 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  x5 = XVECEXP (x3, 0, 1);
  operands[2] = x5;
  x6 = XVECEXP (x3, 0, 2);
  operands[3] = x6;
  if (!s_register_operand (operands[3], E_SImode))
    return -1;
  x7 = XVECEXP (x3, 0, 3);
  operands[4] = x7;
  switch (GET_MODE (operands[0]))
    {
    case E_V8HFmode:
      if (pattern214 (x3, 
E_V8BImode, 
E_V8HFmode) != 0
          || !
#line 3070 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
        return -1;
      return 4795; /* mve_vbrsrq_m_n_fv8hf */

    case E_V4SFmode:
      if (pattern214 (x3, 
E_V4BImode, 
E_V4SFmode) != 0
          || !
#line 3070 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
        return -1;
      return 4796; /* mve_vbrsrq_m_n_fv4sf */

    default:
      return -1;
    }
}

 int
recog_266 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  switch (XINT (x2, 1))
    {
    case 30:
      if (pattern95 (x2, 
104, 
E_CCmode) != 0)
        return -1;
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      if (!s_register_operand (operands[0], E_SImode)
          || !
#line 4419 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_ARM_QBIT))
        return -1;
      return 131; /* arm_get_apsr */

    case 25:
      return recog_123 (x1, insn, pnum_clobbers);

    case 26:
      return recog_113 (x1, insn, pnum_clobbers);

    case 45:
      if (GET_MODE (x2) != E_SImode)
        return -1;
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      if (!s_register_operand (operands[0], E_SImode))
        return -1;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      if (!s_register_operand (operands[1], E_SImode)
          || !
#line 6049 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_INT_SIMD))
        return -1;
      return 190; /* arm_sxtb16 */

    case 46:
      if (GET_MODE (x2) != E_SImode)
        return -1;
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      if (!s_register_operand (operands[0], E_SImode))
        return -1;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      if (!s_register_operand (operands[1], E_SImode)
          || !
#line 6049 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_INT_SIMD))
        return -1;
      return 191; /* arm_uxtb16 */

    case 1:
      if (GET_MODE (x2) != E_SImode)
        return -1;
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      if (!s_register_operand (operands[0], E_SImode))
        return -1;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      if (
#line 6704 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT && flag_pic))
        return 259; /* pic_load_addr_32bit */
      if (!
#line 6720 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_THUMB1 && flag_pic))
        return -1;
      return 260; /* pic_load_addr_thumb1 */

    case 38:
      if (GET_MODE (x2) != E_SImode)
        return -1;
      x4 = XVECEXP (x2, 0, 0);
      if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      if (!memory_operand (operands[0], E_SImode)
          || !
#line 9255 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT))
        return -1;
      return 306; /* probe_stack */

    case 40:
      return recog_134 (x1, insn, pnum_clobbers);

    case 22:
      if (GET_MODE (x2) != E_SImode)
        return -1;
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      if (!s_register_operand (operands[0], E_SImode))
        return -1;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      if (!s_register_operand (operands[1], E_SImode)
          || !
#line 12194 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT && arm_arch_thumb2))
        return -1;
      return 400; /* arm_rbit */

    case 17:
      return recog_116 (x1, insn, pnum_clobbers);

    case 15:
      if (GET_MODE (x2) != E_DImode)
        return -1;
      x4 = XVECEXP (x2, 0, 0);
      if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      if (!register_operand (operands[0], E_DImode)
          || !
#line 560 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iwmmxt.md"
(TARGET_REALLY_IWMMXT))
        return -1;
      return 577; /* iwmmxt_clrdi */

    case 8:
      switch (pattern96 (x1, 
E_SImode))
        {
        case 0:
          if (!
#line 1579 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iwmmxt.md"
(TARGET_REALLY_IWMMXT))
            return -1;
          return 671; /* iwmmxt_tmovmskb */

        case 1:
          if (!
#line 1588 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iwmmxt.md"
(TARGET_REALLY_IWMMXT))
            return -1;
          return 672; /* iwmmxt_tmovmskh */

        case 2:
          if (!
#line 1597 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iwmmxt.md"
(TARGET_REALLY_IWMMXT))
            return -1;
          return 673; /* iwmmxt_tmovmskw */

        default:
          return -1;
        }

    case 7:
      switch (pattern96 (x1, 
E_DImode))
        {
        case 0:
          if (!
#line 1606 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iwmmxt.md"
(TARGET_REALLY_IWMMXT))
            return -1;
          return 674; /* iwmmxt_waccb */

        case 1:
          if (!
#line 1615 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iwmmxt.md"
(TARGET_REALLY_IWMMXT))
            return -1;
          return 675; /* iwmmxt_wacch */

        case 2:
          if (!
#line 1624 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iwmmxt.md"
(TARGET_REALLY_IWMMXT))
            return -1;
          return 676; /* iwmmxt_waccw */

        default:
          return -1;
        }

    case 16:
      return recog_111 (x1, insn, pnum_clobbers);

    case 109:
      return recog_115 (x1, insn, pnum_clobbers);

    case 108:
      return recog_133 (x1, insn, pnum_clobbers);

    case 363:
      switch (pattern97 (x1))
        {
        case 0:
          if (!
#line 971 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/vfp.md"
(TARGET_VFP_FP16INST))
            return -1;
          return 788; /* neon_vrndhf */

        case 1:
          if (!
#line 842 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON_FP16INST))
            return -1;
          return 1326; /* neon_vrndv8hf */

        case 2:
          if (!
#line 842 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON_FP16INST))
            return -1;
          return 1332; /* neon_vrndv4hf */

        default:
          return -1;
        }

    case 364:
      switch (pattern97 (x1))
        {
        case 0:
          if (!
#line 971 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/vfp.md"
(TARGET_VFP_FP16INST))
            return -1;
          return 789; /* neon_vrndahf */

        case 1:
          if (!
#line 842 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON_FP16INST))
            return -1;
          return 1327; /* neon_vrndav8hf */

        case 2:
          if (!
#line 842 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON_FP16INST))
            return -1;
          return 1333; /* neon_vrndav4hf */

        default:
          return -1;
        }

    case 366:
      switch (pattern97 (x1))
        {
        case 0:
          if (!
#line 971 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/vfp.md"
(TARGET_VFP_FP16INST))
            return -1;
          return 790; /* neon_vrndmhf */

        case 1:
          if (!
#line 842 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON_FP16INST))
            return -1;
          return 1328; /* neon_vrndmv8hf */

        case 2:
          if (!
#line 842 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON_FP16INST))
            return -1;
          return 1334; /* neon_vrndmv4hf */

        default:
          return -1;
        }

    case 367:
      switch (pattern97 (x1))
        {
        case 0:
          if (!
#line 971 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/vfp.md"
(TARGET_VFP_FP16INST))
            return -1;
          return 791; /* neon_vrndnhf */

        case 1:
          if (!
#line 842 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON_FP16INST))
            return -1;
          return 1329; /* neon_vrndnv8hf */

        case 2:
          if (!
#line 842 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON_FP16INST))
            return -1;
          return 1335; /* neon_vrndnv4hf */

        default:
          return -1;
        }

    case 368:
      switch (pattern97 (x1))
        {
        case 0:
          if (!
#line 971 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/vfp.md"
(TARGET_VFP_FP16INST))
            return -1;
          return 792; /* neon_vrndphf */

        case 1:
          if (!
#line 842 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON_FP16INST))
            return -1;
          return 1330; /* neon_vrndpv8hf */

        case 2:
          if (!
#line 842 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON_FP16INST))
            return -1;
          return 1336; /* neon_vrndpv4hf */

        default:
          return -1;
        }

    case 369:
      switch (pattern97 (x1))
        {
        case 0:
          if (!
#line 971 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/vfp.md"
(TARGET_VFP_FP16INST))
            return -1;
          return 793; /* neon_vrndxhf */

        case 1:
          if (!
#line 842 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON_FP16INST))
            return -1;
          return 1331; /* neon_vrndxv8hf */

        case 2:
          if (!
#line 842 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON_FP16INST))
            return -1;
          return 1337; /* neon_vrndxv4hf */

        default:
          return -1;
        }

    case 365:
      if (GET_MODE (x2) != E_HFmode)
        return -1;
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      if (!s_register_operand (operands[0], E_HFmode))
        return -1;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      if (!s_register_operand (operands[1], E_HFmode)
          || !
#line 982 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/vfp.md"
(TARGET_VFP_FP16INST))
        return -1;
      return 794; /* neon_vrndihf */

    case 181:
      switch (pattern98 (x1))
        {
        case 0:
          if (!
#line 1907 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/vfp.md"
(TARGET_VFP_FP16INST))
            return -1;
          return 874; /* neon_vcvthshf */

        case 1:
          if (!
#line 1918 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/vfp.md"
(TARGET_VFP_FP16INST))
            return -1;
          return 876; /* neon_vcvthssi */

        default:
          return -1;
        }

    case 182:
      switch (pattern98 (x1))
        {
        case 0:
          if (!
#line 1907 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/vfp.md"
(TARGET_VFP_FP16INST))
            return -1;
          return 875; /* neon_vcvthuhf */

        case 1:
          if (!
#line 1918 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/vfp.md"
(TARGET_VFP_FP16INST))
            return -1;
          return 877; /* neon_vcvthusi */

        default:
          return -1;
        }

    case 183:
      switch (pattern99 (x1))
        {
        case 0:
          if (!
#line 2014 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/vfp.md"
(TARGET_VFP_FP16INST))
            return -1;
          return 882; /* neon_vcvtahssi */

        case 1:
          if (!
#line 3832 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON_FP16INST))
            return -1;
          return 2139; /* neon_vcvtasv8hf */

        case 2:
          if (!
#line 3832 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON_FP16INST))
            return -1;
          return 2147; /* neon_vcvtasv4hf */

        default:
          return -1;
        }

    case 184:
      switch (pattern99 (x1))
        {
        case 0:
          if (!
#line 2014 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/vfp.md"
(TARGET_VFP_FP16INST))
            return -1;
          return 883; /* neon_vcvtahusi */

        case 1:
          if (!
#line 3832 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON_FP16INST))
            return -1;
          return 2140; /* neon_vcvtauv8hf */

        case 2:
          if (!
#line 3832 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON_FP16INST))
            return -1;
          return 2148; /* neon_vcvtauv4hf */

        default:
          return -1;
        }

    case 185:
      switch (pattern99 (x1))
        {
        case 0:
          if (!
#line 2014 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/vfp.md"
(TARGET_VFP_FP16INST))
            return -1;
          return 884; /* neon_vcvtmhssi */

        case 1:
          if (!
#line 3832 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON_FP16INST))
            return -1;
          return 2141; /* neon_vcvtmsv8hf */

        case 2:
          if (!
#line 3832 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON_FP16INST))
            return -1;
          return 2149; /* neon_vcvtmsv4hf */

        default:
          return -1;
        }

    case 186:
      switch (pattern99 (x1))
        {
        case 0:
          if (!
#line 2014 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/vfp.md"
(TARGET_VFP_FP16INST))
            return -1;
          return 885; /* neon_vcvtmhusi */

        case 1:
          if (!
#line 3832 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON_FP16INST))
            return -1;
          return 2142; /* neon_vcvtmuv8hf */

        case 2:
          if (!
#line 3832 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON_FP16INST))
            return -1;
          return 2150; /* neon_vcvtmuv4hf */

        default:
          return -1;
        }

    case 187:
      switch (pattern99 (x1))
        {
        case 0:
          if (!
#line 2014 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/vfp.md"
(TARGET_VFP_FP16INST))
            return -1;
          return 886; /* neon_vcvtnhssi */

        case 1:
          if (!
#line 3832 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON_FP16INST))
            return -1;
          return 2143; /* neon_vcvtnsv8hf */

        case 2:
          if (!
#line 3832 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON_FP16INST))
            return -1;
          return 2151; /* neon_vcvtnsv4hf */

        default:
          return -1;
        }

    case 188:
      switch (pattern99 (x1))
        {
        case 0:
          if (!
#line 2014 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/vfp.md"
(TARGET_VFP_FP16INST))
            return -1;
          return 887; /* neon_vcvtnhusi */

        case 1:
          if (!
#line 3832 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON_FP16INST))
            return -1;
          return 2144; /* neon_vcvtnuv8hf */

        case 2:
          if (!
#line 3832 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON_FP16INST))
            return -1;
          return 2152; /* neon_vcvtnuv4hf */

        default:
          return -1;
        }

    case 189:
      switch (pattern99 (x1))
        {
        case 0:
          if (!
#line 2014 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/vfp.md"
(TARGET_VFP_FP16INST))
            return -1;
          return 888; /* neon_vcvtphssi */

        case 1:
          if (!
#line 3832 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON_FP16INST))
            return -1;
          return 2145; /* neon_vcvtpsv8hf */

        case 2:
          if (!
#line 3832 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON_FP16INST))
            return -1;
          return 2153; /* neon_vcvtpsv4hf */

        default:
          return -1;
        }

    case 190:
      switch (pattern99 (x1))
        {
        case 0:
          if (!
#line 2014 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/vfp.md"
(TARGET_VFP_FP16INST))
            return -1;
          return 889; /* neon_vcvtphusi */

        case 1:
          if (!
#line 3832 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON_FP16INST))
            return -1;
          return 2146; /* neon_vcvtpuv8hf */

        case 2:
          if (!
#line 3832 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON_FP16INST))
            return -1;
          return 2154; /* neon_vcvtpuv4hf */

        default:
          return -1;
        }

    case 32:
      switch (pattern100 (x1))
        {
        case 0:
          if (!
#line 2040 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/vfp.md"
(TARGET_HARD_FLOAT && TARGET_VFP5 ))
            return -1;
          return 891; /* btruncsf2 */

        case 1:
          if (!(
#line 2040 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/vfp.md"
(TARGET_HARD_FLOAT && TARGET_VFP5 && TARGET_VFP_DOUBLE) && 
#line 60 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iterators.md"
(TARGET_VFP_DOUBLE)))
            return -1;
          return 897; /* btruncdf2 */

        default:
          return -1;
        }

    case 33:
      switch (pattern100 (x1))
        {
        case 0:
          if (!
#line 2040 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/vfp.md"
(TARGET_HARD_FLOAT && TARGET_VFP5 ))
            return -1;
          return 892; /* ceilsf2 */

        case 1:
          if (!(
#line 2040 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/vfp.md"
(TARGET_HARD_FLOAT && TARGET_VFP5 && TARGET_VFP_DOUBLE) && 
#line 60 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iterators.md"
(TARGET_VFP_DOUBLE)))
            return -1;
          return 898; /* ceildf2 */

        default:
          return -1;
        }

    case 34:
      switch (pattern100 (x1))
        {
        case 0:
          if (!
#line 2040 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/vfp.md"
(TARGET_HARD_FLOAT && TARGET_VFP5 ))
            return -1;
          return 893; /* floorsf2 */

        case 1:
          if (!(
#line 2040 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/vfp.md"
(TARGET_HARD_FLOAT && TARGET_VFP5 && TARGET_VFP_DOUBLE) && 
#line 60 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iterators.md"
(TARGET_VFP_DOUBLE)))
            return -1;
          return 899; /* floordf2 */

        default:
          return -1;
        }

    case 35:
      switch (pattern100 (x1))
        {
        case 0:
          if (!
#line 2040 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/vfp.md"
(TARGET_HARD_FLOAT && TARGET_VFP5 ))
            return -1;
          return 894; /* nearbyintsf2 */

        case 1:
          if (!(
#line 2040 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/vfp.md"
(TARGET_HARD_FLOAT && TARGET_VFP5 && TARGET_VFP_DOUBLE) && 
#line 60 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iterators.md"
(TARGET_VFP_DOUBLE)))
            return -1;
          return 900; /* nearbyintdf2 */

        default:
          return -1;
        }

    case 36:
      switch (pattern100 (x1))
        {
        case 0:
          if (!
#line 2040 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/vfp.md"
(TARGET_HARD_FLOAT && TARGET_VFP5 ))
            return -1;
          return 895; /* rintsf2 */

        case 1:
          if (!(
#line 2040 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/vfp.md"
(TARGET_HARD_FLOAT && TARGET_VFP5 && TARGET_VFP_DOUBLE) && 
#line 60 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iterators.md"
(TARGET_VFP_DOUBLE)))
            return -1;
          return 901; /* rintdf2 */

        default:
          return -1;
        }

    case 37:
      switch (pattern100 (x1))
        {
        case 0:
          if (!
#line 2040 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/vfp.md"
(TARGET_HARD_FLOAT && TARGET_VFP5 ))
            return -1;
          return 896; /* roundsf2 */

        case 1:
          if (!(
#line 2040 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/vfp.md"
(TARGET_HARD_FLOAT && TARGET_VFP5 && TARGET_VFP_DOUBLE) && 
#line 60 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iterators.md"
(TARGET_VFP_DOUBLE)))
            return -1;
          return 902; /* rounddf2 */

        default:
          return -1;
        }

    case 106:
      if (pattern101 (x1, 
E_SImode, 
14) != 0
          || !
#line 1818 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/thumb2.md"
(TARGET_32BIT && TARGET_HAVE_LOB))
        return -1;
      return 1073; /* dls_insn */

    case 352:
      return recog_103 (x1, insn, pnum_clobbers);

    case 356:
      switch (pattern102 (x1))
        {
        case 0:
          if (!
#line 699 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON && TARGET_VFP5))
            return -1;
          return 1216; /* neon_vrintpv2sf */

        case 1:
          if (!
#line 699 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON && TARGET_VFP5))
            return -1;
          return 1222; /* neon_vrintpv4sf */

        default:
          return -1;
        }

    case 355:
      switch (pattern102 (x1))
        {
        case 0:
          if (!
#line 699 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON && TARGET_VFP5))
            return -1;
          return 1217; /* neon_vrintzv2sf */

        case 1:
          if (!
#line 699 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON && TARGET_VFP5))
            return -1;
          return 1223; /* neon_vrintzv4sf */

        default:
          return -1;
        }

    case 357:
      switch (pattern102 (x1))
        {
        case 0:
          if (!
#line 699 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON && TARGET_VFP5))
            return -1;
          return 1218; /* neon_vrintmv2sf */

        case 1:
          if (!
#line 699 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON && TARGET_VFP5))
            return -1;
          return 1224; /* neon_vrintmv4sf */

        default:
          return -1;
        }

    case 358:
      switch (pattern102 (x1))
        {
        case 0:
          if (!
#line 699 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON && TARGET_VFP5))
            return -1;
          return 1219; /* neon_vrintxv2sf */

        case 1:
          if (!
#line 699 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON && TARGET_VFP5))
            return -1;
          return 1225; /* neon_vrintxv4sf */

        default:
          return -1;
        }

    case 359:
      switch (pattern102 (x1))
        {
        case 0:
          if (!
#line 699 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON && TARGET_VFP5))
            return -1;
          return 1220; /* neon_vrintav2sf */

        case 1:
          if (!
#line 699 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON && TARGET_VFP5))
            return -1;
          return 1226; /* neon_vrintav4sf */

        default:
          return -1;
        }

    case 360:
      switch (pattern102 (x1))
        {
        case 0:
          if (!
#line 699 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON && TARGET_VFP5))
            return -1;
          return 1221; /* neon_vrintnv2sf */

        case 1:
          if (!
#line 699 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON && TARGET_VFP5))
            return -1;
          return 1227; /* neon_vrintnv4sf */

        default:
          return -1;
        }

    case 298:
      return recog_131 (x1, insn, pnum_clobbers);

    case 145:
      if (GET_MODE (x2) != E_DImode)
        return -1;
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      if (!s_register_operand (operands[0], E_DImode))
        return -1;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      if (!nonimmediate_operand (operands[1], E_SImode)
          || !
#line 968 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 1394; /* neon_load_count */

    case 250:
      if (GET_MODE (x2) != E_V2DImode)
        return -1;
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      if (!s_register_operand (operands[0], E_V2DImode))
        return -1;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      if (!s_register_operand (operands[1], E_V2DImode)
          || !
#line 1236 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON && !BYTES_BIG_ENDIAN))
        return -1;
      return 1431; /* arm_reduc_plus_internal_v2di */

    case 251:
      return recog_130 (x1, insn, pnum_clobbers);

    case 252:
      return recog_129 (x1, insn, pnum_clobbers);

    case 261:
      return recog_128 (x1, insn, pnum_clobbers);

    case 277:
      return recog_127 (x1, insn, pnum_clobbers);

    case 170:
      return recog_126 (x1, insn, pnum_clobbers);

    case 293:
      return recog_125 (x1, insn, pnum_clobbers);

    case 173:
      return recog_122 (x1, insn, pnum_clobbers);

    case 174:
      return recog_121 (x1, insn, pnum_clobbers);

    case 172:
      return recog_120 (x1, insn, pnum_clobbers);

    case 240:
      switch (pattern108 (x1))
        {
        case 0:
          if (!
#line 3841 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2155; /* neon_vmovnv8hi */

        case 1:
          if (!
#line 3841 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2156; /* neon_vmovnv4si */

        case 2:
          if (!
#line 3841 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2157; /* neon_vmovnv2di */

        default:
          return -1;
        }

    case 274:
      switch (pattern108 (x1))
        {
        case 0:
          if (!
#line 3850 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2158; /* neon_vqmovnsv8hi */

        case 1:
          if (!
#line 3850 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2160; /* neon_vqmovnsv4si */

        case 2:
          if (!
#line 3850 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2162; /* neon_vqmovnsv2di */

        default:
          return -1;
        }

    case 275:
      switch (pattern108 (x1))
        {
        case 0:
          if (!
#line 3850 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2159; /* neon_vqmovnuv8hi */

        case 1:
          if (!
#line 3850 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2161; /* neon_vqmovnuv4si */

        case 2:
          if (!
#line 3850 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2163; /* neon_vqmovnuv2di */

        default:
          return -1;
        }

    case 276:
      switch (pattern108 (x1))
        {
        case 0:
          if (!
#line 3859 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2164; /* neon_vqmovunv8hi */

        case 1:
          if (!
#line 3859 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2165; /* neon_vqmovunv4si */

        case 2:
          if (!
#line 3859 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2166; /* neon_vqmovunv2di */

        default:
          return -1;
        }

    case 238:
      switch (pattern110 (x1))
        {
        case 0:
          if (!
#line 3868 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2167; /* neon_vmovlsv8qi */

        case 1:
          if (!
#line 3868 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2169; /* neon_vmovlsv4hi */

        case 2:
          if (!
#line 3868 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2171; /* neon_vmovlsv2si */

        default:
          return -1;
        }

    case 239:
      switch (pattern110 (x1))
        {
        case 0:
          if (!
#line 3868 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2168; /* neon_vmovluv8qi */

        case 1:
          if (!
#line 3868 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2170; /* neon_vmovluv4hi */

        case 2:
          if (!
#line 3868 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2172; /* neon_vmovluv2si */

        default:
          return -1;
        }

    case 297:
      return recog_106 (x1, insn, pnum_clobbers);

    case 296:
      return recog_112 (x1, insn, pnum_clobbers);

    case 295:
      return recog_119 (x1, insn, pnum_clobbers);

    case 198:
      return recog_105 (x1, insn, pnum_clobbers);

    case 319:
      return recog_104 (x1, insn, pnum_clobbers);

    case 392:
      return recog_107 (x1, insn, pnum_clobbers);

    case 393:
      if (GET_MODE (x2) != E_V4SFmode)
        return -1;
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      if (!register_operand (operands[0], E_V4SFmode))
        return -1;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      if (!register_operand (operands[1], E_V8BFmode)
          || !
#line 6717 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_BF16_SIMD))
        return -1;
      return 3032; /* neon_vbfcvt_highv8bf */

    case 132:
      switch (pattern111 (x1, 
130))
        {
        case 0:
          if (!
#line 27 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/crypto.md"
(TARGET_CRYPTO))
            return -1;
          return 3040; /* crypto_aesmc */

        case 1:
          if (!
#line 144 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/crypto.md"
(TARGET_CRYPTO
   && arm_fusion_enabled_p (tune_params::FUSE_AES_AESMC)))
            return -1;
          return 3049; /* *aarch32_crypto_aese_fused */

        default:
          return -1;
        }

    case 131:
      switch (pattern111 (x1, 
129))
        {
        case 0:
          if (!
#line 27 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/crypto.md"
(TARGET_CRYPTO))
            return -1;
          return 3041; /* crypto_aesimc */

        case 1:
          if (!
#line 183 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/crypto.md"
(TARGET_CRYPTO
   && arm_fusion_enabled_p (tune_params::FUSE_AES_AESMC)))
            return -1;
          return 3051; /* *aarch32_crypto_aesd_fused */

        default:
          return -1;
        }

    case 129:
      if (pattern112 (x1) != 0
          || !
#line 60 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/crypto.md"
(TARGET_CRYPTO))
        return -1;
      return 3042; /* *crypto_aesd_insn */

    case 130:
      if (pattern112 (x1) != 0
          || !
#line 60 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/crypto.md"
(TARGET_CRYPTO))
        return -1;
      return 3043; /* *crypto_aese_insn */

    case 133:
      return recog_110 (x1, insn, pnum_clobbers);

    case 137:
      return recog_118 (x1, insn, pnum_clobbers);

    case 24:
      if (GET_MODE (x2) != E_BLKmode)
        return -1;
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      if (!rtx_equal_p (x4, operands[0])
          || !
#line 49 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_MEMORY_BARRIER))
        return -1;
      return 3064; /* *memory_barrier */

    case 399:
      switch (pattern114 (x1))
        {
        case 0:
          if (!
#line 159 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
            return -1;
          return 3254; /* mve_vrndq_fv8hf */

        case 1:
          if (!
#line 159 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
            return -1;
          return 3260; /* mve_vrndq_fv4sf */

        default:
          return -1;
        }

    case 403:
      switch (pattern114 (x1))
        {
        case 0:
          if (!
#line 159 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
            return -1;
          return 3255; /* mve_vrndaq_fv8hf */

        case 1:
          if (!
#line 159 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
            return -1;
          return 3261; /* mve_vrndaq_fv4sf */

        default:
          return -1;
        }

    case 402:
      switch (pattern114 (x1))
        {
        case 0:
          if (!
#line 159 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
            return -1;
          return 3256; /* mve_vrndmq_fv8hf */

        case 1:
          if (!
#line 159 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
            return -1;
          return 3262; /* mve_vrndmq_fv4sf */

        default:
          return -1;
        }

    case 401:
      switch (pattern114 (x1))
        {
        case 0:
          if (!
#line 159 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
            return -1;
          return 3257; /* mve_vrndnq_fv8hf */

        case 1:
          if (!
#line 159 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
            return -1;
          return 3263; /* mve_vrndnq_fv4sf */

        default:
          return -1;
        }

    case 400:
      switch (pattern114 (x1))
        {
        case 0:
          if (!
#line 159 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
            return -1;
          return 3258; /* mve_vrndpq_fv8hf */

        case 1:
          if (!
#line 159 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
            return -1;
          return 3264; /* mve_vrndpq_fv4sf */

        default:
          return -1;
        }

    case 398:
      switch (pattern114 (x1))
        {
        case 0:
          if (!
#line 159 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
            return -1;
          return 3259; /* mve_vrndxq_fv8hf */

        case 1:
          if (!
#line 159 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
            return -1;
          return 3265; /* mve_vrndxq_fv4sf */

        default:
          return -1;
        }

    case 404:
      switch (pattern114 (x1))
        {
        case 0:
          if (!
#line 174 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
            return -1;
          return 3266; /* mve_vrev64q_fv8hf */

        case 1:
          if (!
#line 174 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
            return -1;
          return 3267; /* mve_vrev64q_fv4sf */

        default:
          return -1;
        }

    case 406:
      if (GET_MODE (x2) != E_V8HFmode)
        return -1;
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      if (!s_register_operand (operands[0], E_V8HFmode))
        return -1;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      if (!s_register_operand (operands[1], E_V8HFmode)
          || !
#line 204 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
        return -1;
      return 3272; /* mve_vrev32q_fv8hf */

    case 408:
      if (GET_MODE (x2) != E_V4SFmode)
        return -1;
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      if (!s_register_operand (operands[0], E_V4SFmode))
        return -1;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      if (!s_register_operand (operands[1], E_V8HFmode)
          || !
#line 220 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
        return -1;
      return 3273; /* mve_vcvtbq_f32_f16v4sf */

    case 407:
      if (GET_MODE (x2) != E_V4SFmode)
        return -1;
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      if (!s_register_operand (operands[0], E_V4SFmode))
        return -1;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      if (!s_register_operand (operands[1], E_V8HFmode)
          || !
#line 220 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
        return -1;
      return 3274; /* mve_vcvttq_f32_f16v4sf */

    case 409:
      switch (pattern115 (x1))
        {
        case 0:
          if (!
#line 235 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
            return -1;
          return 3275; /* mve_vcvtq_to_f_sv8hf */

        case 1:
          if (!
#line 235 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
            return -1;
          return 3277; /* mve_vcvtq_to_f_sv4sf */

        default:
          return -1;
        }

    case 411:
      switch (pattern115 (x1))
        {
        case 0:
          if (!
#line 235 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
            return -1;
          return 3276; /* mve_vcvtq_to_f_uv8hf */

        case 1:
          if (!
#line 235 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
            return -1;
          return 3278; /* mve_vcvtq_to_f_uv4sf */

        default:
          return -1;
        }

    case 419:
      switch (pattern117 (x1))
        {
        case 0:
          if (!
#line 250 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3279; /* mve_vrev64q_sv16qi */

        case 1:
          if (!
#line 250 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3281; /* mve_vrev64q_sv8hi */

        case 2:
          if (!
#line 250 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3283; /* mve_vrev64q_sv4si */

        default:
          return -1;
        }

    case 420:
      switch (pattern117 (x1))
        {
        case 0:
          if (!
#line 250 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3280; /* mve_vrev64q_uv16qi */

        case 1:
          if (!
#line 250 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3282; /* mve_vrev64q_uv8hi */

        case 2:
          if (!
#line 250 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3284; /* mve_vrev64q_uv4si */

        default:
          return -1;
        }

    case 433:
      switch (pattern119 (x1, 
E_V8HFmode, 
E_V4SFmode))
        {
        case 0:
          if (!
#line 265 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
            return -1;
          return 3285; /* mve_vcvtq_from_f_sv8hi */

        case 1:
          if (!
#line 265 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
            return -1;
          return 3287; /* mve_vcvtq_from_f_sv4si */

        default:
          return -1;
        }

    case 434:
      switch (pattern119 (x1, 
E_V8HFmode, 
E_V4SFmode))
        {
        case 0:
          if (!
#line 265 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
            return -1;
          return 3286; /* mve_vcvtq_from_f_uv8hi */

        case 1:
          if (!
#line 265 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
            return -1;
          return 3288; /* mve_vcvtq_from_f_uv4si */

        default:
          return -1;
        }

    case 424:
      switch (pattern117 (x1))
        {
        case 0:
          if (!
#line 339 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3301; /* mve_vclsq_sv16qi */

        case 1:
          if (!
#line 339 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3304; /* mve_vclsq_sv8hi */

        case 2:
          if (!
#line 339 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3307; /* mve_vclsq_sv4si */

        default:
          return -1;
        }

    case 421:
      switch (pattern117 (x1))
        {
        case 0:
          if (!
#line 339 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3302; /* mve_vqabsq_sv16qi */

        case 1:
          if (!
#line 339 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3305; /* mve_vqabsq_sv8hi */

        case 2:
          if (!
#line 339 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3308; /* mve_vqabsq_sv4si */

        default:
          return -1;
        }

    case 410:
      switch (pattern117 (x1))
        {
        case 0:
          if (!
#line 339 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3303; /* mve_vqnegq_sv16qi */

        case 1:
          if (!
#line 339 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3306; /* mve_vqnegq_sv8hi */

        case 2:
          if (!
#line 339 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3309; /* mve_vqnegq_sv4si */

        default:
          return -1;
        }

    case 426:
      switch (pattern120 (x1))
        {
        case 0:
          if (!
#line 354 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3310; /* mve_vaddvq_uv16qi */

        case 1:
          if (!
#line 354 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3312; /* mve_vaddvq_uv8hi */

        case 2:
          if (!
#line 354 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3314; /* mve_vaddvq_uv4si */

        default:
          return -1;
        }

    case 425:
      switch (pattern120 (x1))
        {
        case 0:
          if (!
#line 354 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3311; /* mve_vaddvq_sv16qi */

        case 1:
          if (!
#line 354 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3313; /* mve_vaddvq_sv8hi */

        case 2:
          if (!
#line 354 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3315; /* mve_vaddvq_sv4si */

        default:
          return -1;
        }

    case 427:
      switch (pattern121 (x1))
        {
        case 0:
          if (!
#line 370 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3316; /* mve_vrev32q_uv16qi */

        case 1:
          if (!
#line 370 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3318; /* mve_vrev32q_uv8hi */

        default:
          return -1;
        }

    case 428:
      switch (pattern121 (x1))
        {
        case 0:
          if (!
#line 370 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3317; /* mve_vrev32q_sv16qi */

        case 1:
          if (!
#line 370 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3319; /* mve_vrev32q_sv8hi */

        default:
          return -1;
        }

    case 431:
      switch (pattern119 (x1, 
E_V16QImode, 
E_V8HImode))
        {
        case 0:
          if (!
#line 386 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3320; /* mve_vmovlbq_sv16qi */

        case 1:
          if (!
#line 386 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3324; /* mve_vmovlbq_sv8hi */

        default:
          return -1;
        }

    case 432:
      switch (pattern119 (x1, 
E_V16QImode, 
E_V8HImode))
        {
        case 0:
          if (!
#line 386 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3321; /* mve_vmovlbq_uv16qi */

        case 1:
          if (!
#line 386 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3325; /* mve_vmovlbq_uv8hi */

        default:
          return -1;
        }

    case 429:
      switch (pattern119 (x1, 
E_V16QImode, 
E_V8HImode))
        {
        case 0:
          if (!
#line 386 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3322; /* mve_vmovltq_uv16qi */

        case 1:
          if (!
#line 386 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3326; /* mve_vmovltq_uv8hi */

        default:
          return -1;
        }

    case 430:
      switch (pattern119 (x1, 
E_V16QImode, 
E_V8HImode))
        {
        case 0:
          if (!
#line 386 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3323; /* mve_vmovltq_sv16qi */

        case 1:
          if (!
#line 386 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3327; /* mve_vmovltq_sv8hi */

        default:
          return -1;
        }

    case 417:
      switch (pattern119 (x1, 
E_V8HFmode, 
E_V4SFmode))
        {
        case 0:
          if (!
#line 404 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
            return -1;
          return 3328; /* mve_vcvtaq_sv8hi */

        case 1:
          if (!
#line 404 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
            return -1;
          return 3336; /* mve_vcvtaq_sv4si */

        default:
          return -1;
        }

    case 418:
      switch (pattern119 (x1, 
E_V8HFmode, 
E_V4SFmode))
        {
        case 0:
          if (!
#line 404 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
            return -1;
          return 3329; /* mve_vcvtaq_uv8hi */

        case 1:
          if (!
#line 404 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
            return -1;
          return 3337; /* mve_vcvtaq_uv4si */

        default:
          return -1;
        }

    case 439:
      switch (pattern119 (x1, 
E_V8HFmode, 
E_V4SFmode))
        {
        case 0:
          if (!
#line 404 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
            return -1;
          return 3330; /* mve_vcvtmq_sv8hi */

        case 1:
          if (!
#line 404 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
            return -1;
          return 3338; /* mve_vcvtmq_sv4si */

        default:
          return -1;
        }

    case 440:
      switch (pattern119 (x1, 
E_V8HFmode, 
E_V4SFmode))
        {
        case 0:
          if (!
#line 404 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
            return -1;
          return 3331; /* mve_vcvtmq_uv8hi */

        case 1:
          if (!
#line 404 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
            return -1;
          return 3339; /* mve_vcvtmq_uv4si */

        default:
          return -1;
        }

    case 437:
      switch (pattern119 (x1, 
E_V8HFmode, 
E_V4SFmode))
        {
        case 0:
          if (!
#line 404 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
            return -1;
          return 3332; /* mve_vcvtnq_sv8hi */

        case 1:
          if (!
#line 404 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
            return -1;
          return 3340; /* mve_vcvtnq_sv4si */

        default:
          return -1;
        }

    case 438:
      switch (pattern119 (x1, 
E_V8HFmode, 
E_V4SFmode))
        {
        case 0:
          if (!
#line 404 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
            return -1;
          return 3333; /* mve_vcvtnq_uv8hi */

        case 1:
          if (!
#line 404 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
            return -1;
          return 3341; /* mve_vcvtnq_uv4si */

        default:
          return -1;
        }

    case 435:
      switch (pattern119 (x1, 
E_V8HFmode, 
E_V4SFmode))
        {
        case 0:
          if (!
#line 404 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
            return -1;
          return 3334; /* mve_vcvtpq_sv8hi */

        case 1:
          if (!
#line 404 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
            return -1;
          return 3342; /* mve_vcvtpq_sv4si */

        default:
          return -1;
        }

    case 436:
      switch (pattern119 (x1, 
E_V8HFmode, 
E_V4SFmode))
        {
        case 0:
          if (!
#line 404 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
            return -1;
          return 3335; /* mve_vcvtpq_uv8hi */

        case 1:
          if (!
#line 404 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
            return -1;
          return 3343; /* mve_vcvtpq_uv4si */

        default:
          return -1;
        }

    case 416:
      switch (pattern122 (x1))
        {
        case 0:
          if (!
#line 419 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3344; /* mve_vmvnq_n_uv8hi */

        case 1:
          if (!
#line 419 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3346; /* mve_vmvnq_n_uv4si */

        default:
          return -1;
        }

    case 415:
      switch (pattern122 (x1))
        {
        case 0:
          if (!
#line 419 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3345; /* mve_vmvnq_n_sv8hi */

        case 1:
          if (!
#line 419 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3347; /* mve_vmvnq_n_sv4si */

        default:
          return -1;
        }

    case 413:
      if (GET_MODE (x2) != E_V16QImode)
        return -1;
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      if (!s_register_operand (operands[0], E_V16QImode))
        return -1;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      if (!s_register_operand (operands[1], E_V16QImode)
          || !
#line 434 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
        return -1;
      return 3348; /* mve_vrev16q_uv16qi */

    case 412:
      if (GET_MODE (x2) != E_V16QImode)
        return -1;
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      if (!s_register_operand (operands[0], E_V16QImode))
        return -1;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      if (!s_register_operand (operands[1], E_V16QImode)
          || !
#line 434 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
        return -1;
      return 3349; /* mve_vrev16q_sv16qi */

    case 441:
      if (GET_MODE (x2) != E_DImode)
        return -1;
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      if (!s_register_operand (operands[0], E_DImode))
        return -1;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      if (!s_register_operand (operands[1], E_V4SImode)
          || !
#line 449 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
        return -1;
      return 3350; /* mve_vaddlvq_uv4si */

    case 414:
      if (GET_MODE (x2) != E_DImode)
        return -1;
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      if (!s_register_operand (operands[0], E_DImode))
        return -1;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      if (!s_register_operand (operands[1], E_V4SImode)
          || !
#line 449 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
        return -1;
      return 3351; /* mve_vaddlvq_sv4si */

    case 442:
      return recog_114 (x1, insn, pnum_clobbers);

    case 448:
      if (GET_MODE (x2) != E_V16BImode)
        return -1;
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      if (!vpr_register_operand (operands[0], E_V16BImode))
        return -1;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      if (!vpr_register_operand (operands[1], E_V16BImode)
          || !
#line 480 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
        return -1;
      return 3356; /* mve_vpnotv16bi */

    case 1019:
      return recog_109 (x1, insn, pnum_clobbers);

    case 1021:
      return recog_124 (x1, insn, pnum_clobbers);

    case 1005:
      return recog_108 (x1, insn, pnum_clobbers);

    case 1007:
      return recog_117 (x1, insn, pnum_clobbers);

    case 120:
      if (pattern95 (x2, 
101, 
E_SImode) != 0)
        return -1;
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      if (!register_operand (operands[0], E_SImode)
          || !
#line 3969 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
        return -1;
      return 4971; /* get_fpscr_nzcvqc */

    case 31:
      return recog_132 (x1, insn, pnum_clobbers);

    default:
      return -1;
    }
}

 int
recog_306 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19, x20, x21, x22, x23, x24, x25;
  rtx x26, x27;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case VEC_DUPLICATE:
      x5 = XEXP (x3, 2);
      if (!immediate_operand (x5, E_SImode))
        return -1;
      x6 = XEXP (x4, 0);
      switch (GET_CODE (x6))
        {
        case TRUNCATE:
          x7 = XEXP (x6, 0);
          operands[2] = x7;
          if (!nonimmediate_operand (operands[2], E_SImode))
            return -1;
          x8 = XEXP (x3, 1);
          operands[1] = x8;
          operands[3] = x5;
          switch (GET_MODE (operands[0]))
            {
            case E_V8QImode:
              if (pattern470 (x3, 
E_V8QImode, 
E_QImode) != 0
                  || !
#line 676 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iwmmxt.md"
(TARGET_REALLY_IWMMXT))
                return -1;
              return 585; /* iwmmxt_tinsrb */

            case E_V4HImode:
              if (pattern470 (x3, 
E_V4HImode, 
E_HImode) != 0
                  || !
#line 693 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iwmmxt.md"
(TARGET_REALLY_IWMMXT))
                return -1;
              return 586; /* iwmmxt_tinsrh */

            default:
              return -1;
            }

        case REG:
        case SUBREG:
        case MEM:
          switch (GET_MODE (operands[0]))
            {
            case E_V2SImode:
              if (GET_MODE (x3) != E_V2SImode
                  || GET_MODE (x4) != E_V2SImode
                  || !nonimmediate_operand (x6, E_SImode))
                return -1;
              operands[2] = x6;
              if (register_operand (operands[0], E_V2SImode))
                {
                  x8 = XEXP (x3, 1);
                  operands[1] = x8;
                  if (register_operand (operands[1], E_V2SImode))
                    {
                      operands[3] = x5;
                      if (
#line 710 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iwmmxt.md"
(TARGET_REALLY_IWMMXT))
                        return 587; /* iwmmxt_tinsrw */
                    }
                }
              operands[1] = x6;
              if (!s_register_operand (operands[0], E_V2SImode))
                return -1;
              x8 = XEXP (x3, 1);
              operands[3] = x8;
              if (!s_register_operand (operands[3], E_V2SImode))
                return -1;
              operands[2] = x5;
              if (!
#line 324 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
                return -1;
              return 1136; /* vec_setv2si_internal */

            case E_V8QImode:
              if (pattern359 (x3, 
E_V8QImode, 
E_QImode) != 0
                  || !
#line 324 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
                return -1;
              return 1132; /* vec_setv8qi_internal */

            case E_V4HImode:
              if (pattern359 (x3, 
E_V4HImode, 
E_HImode) != 0
                  || !
#line 324 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
                return -1;
              return 1133; /* vec_setv4hi_internal */

            case E_V4HFmode:
              if (pattern359 (x3, 
E_V4HFmode, 
E_HFmode) != 0
                  || !
#line 324 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
                return -1;
              return 1134; /* vec_setv4hf_internal */

            case E_V4BFmode:
              if (pattern359 (x3, 
E_V4BFmode, 
E_BFmode) != 0
                  || !
#line 324 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
                return -1;
              return 1135; /* vec_setv4bf_internal */

            case E_V2SFmode:
              if (pattern359 (x3, 
E_V2SFmode, 
E_SFmode) != 0
                  || !
#line 324 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
                return -1;
              return 1137; /* vec_setv2sf_internal */

            case E_V16QImode:
              if (pattern359 (x3, 
E_V16QImode, 
E_QImode) != 0)
                return -1;
              if (
#line 345 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
                return 1138; /* vec_setv16qi_internal */
              if (!
#line 4246 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
((TARGET_HAVE_MVE && VALID_MVE_SI_MODE (V16QImode))
   || (TARGET_HAVE_MVE_FLOAT && VALID_MVE_SF_MODE (V16QImode))))
                return -1;
              return 5016; /* mve_vec_setv16qi_internal */

            case E_V8HImode:
              if (pattern359 (x3, 
E_V8HImode, 
E_HImode) != 0)
                return -1;
              if (
#line 345 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
                return 1139; /* vec_setv8hi_internal */
              if (!
#line 4246 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
((TARGET_HAVE_MVE && VALID_MVE_SI_MODE (V8HImode))
   || (TARGET_HAVE_MVE_FLOAT && VALID_MVE_SF_MODE (V8HImode))))
                return -1;
              return 5017; /* mve_vec_setv8hi_internal */

            case E_V8HFmode:
              if (pattern359 (x3, 
E_V8HFmode, 
E_HFmode) != 0)
                return -1;
              if (
#line 345 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
                return 1140; /* vec_setv8hf_internal */
              if (!
#line 4246 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
((TARGET_HAVE_MVE && VALID_MVE_SI_MODE (V8HFmode))
   || (TARGET_HAVE_MVE_FLOAT && VALID_MVE_SF_MODE (V8HFmode))))
                return -1;
              return 5018; /* mve_vec_setv8hf_internal */

            case E_V4SImode:
              if (pattern359 (x3, 
E_V4SImode, 
E_SImode) != 0)
                return -1;
              if (
#line 345 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
                return 1141; /* vec_setv4si_internal */
              if (!
#line 4246 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
((TARGET_HAVE_MVE && VALID_MVE_SI_MODE (V4SImode))
   || (TARGET_HAVE_MVE_FLOAT && VALID_MVE_SF_MODE (V4SImode))))
                return -1;
              return 5019; /* mve_vec_setv4si_internal */

            case E_V4SFmode:
              if (pattern359 (x3, 
E_V4SFmode, 
E_SFmode) != 0)
                return -1;
              if (
#line 345 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
                return 1142; /* vec_setv4sf_internal */
              if (!
#line 4246 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
((TARGET_HAVE_MVE && VALID_MVE_SI_MODE (V4SFmode))
   || (TARGET_HAVE_MVE_FLOAT && VALID_MVE_SF_MODE (V4SFmode))))
                return -1;
              return 5020; /* mve_vec_setv4sf_internal */

            case E_V2DImode:
              if (pattern359 (x3, 
E_V2DImode, 
E_DImode) != 0)
                return -1;
              if (
#line 374 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
                return 1143; /* vec_setv2di_internal */
              if (!
#line 4265 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
                return -1;
              return 5021; /* mve_vec_setv2di_internal */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case VEC_SELECT:
      x9 = XEXP (x4, 1);
      if (GET_CODE (x9) != PARALLEL)
        return -1;
      x8 = XEXP (x3, 1);
      if (GET_CODE (x8) != VEC_SELECT)
        return -1;
      x10 = XEXP (x8, 1);
      if (GET_CODE (x10) != PARALLEL)
        return -1;
      x5 = XEXP (x3, 2);
      if (GET_CODE (x5) != CONST_INT)
        return -1;
      x6 = XEXP (x4, 0);
      operands[1] = x6;
      x11 = XEXP (x8, 0);
      operands[2] = x11;
      switch (XVECLEN (x9, 0))
        {
        case 8:
          if (pattern471 (x9) != 0)
            return -1;
          x12 = XVECEXP (x9, 0, 4);
          if (GET_CODE (x12) != CONST_INT)
            return -1;
          x13 = XVECEXP (x9, 0, 5);
          if (GET_CODE (x13) != CONST_INT)
            return -1;
          x14 = XVECEXP (x9, 0, 6);
          if (GET_CODE (x14) != CONST_INT)
            return -1;
          x15 = XVECEXP (x9, 0, 7);
          if (GET_CODE (x15) != CONST_INT
              || pattern557 (x10, 
8) != 0)
            return -1;
          x16 = XVECEXP (x10, 0, 4);
          if (GET_CODE (x16) != CONST_INT)
            return -1;
          x17 = XVECEXP (x10, 0, 5);
          if (GET_CODE (x17) != CONST_INT)
            return -1;
          x18 = XVECEXP (x10, 0, 6);
          if (GET_CODE (x18) != CONST_INT)
            return -1;
          x19 = XVECEXP (x10, 0, 7);
          if (GET_CODE (x19) != CONST_INT
              || XWINT (x5, 0) != 85L
              || pattern586 (x3, 
E_V8QImode) != 0)
            return -1;
          x20 = XVECEXP (x9, 0, 0);
          switch (XWINT (x20, 0))
            {
            case 4L:
              x21 = XVECEXP (x9, 0, 1);
              if (XWINT (x21, 0) != 0L)
                return -1;
              x22 = XVECEXP (x9, 0, 2);
              if (XWINT (x22, 0) != 5L)
                return -1;
              x23 = XVECEXP (x9, 0, 3);
              if (XWINT (x23, 0) != 1L
                  || XWINT (x12, 0) != 6L
                  || XWINT (x13, 0) != 2L
                  || XWINT (x14, 0) != 7L
                  || XWINT (x15, 0) != 3L)
                return -1;
              x24 = XVECEXP (x10, 0, 0);
              if (XWINT (x24, 0) != 0L)
                return -1;
              x25 = XVECEXP (x10, 0, 1);
              if (XWINT (x25, 0) != 4L)
                return -1;
              x26 = XVECEXP (x10, 0, 2);
              if (XWINT (x26, 0) != 1L)
                return -1;
              x27 = XVECEXP (x10, 0, 3);
              if (XWINT (x27, 0) != 5L
                  || XWINT (x16, 0) != 2L
                  || XWINT (x17, 0) != 6L
                  || XWINT (x18, 0) != 3L
                  || XWINT (x19, 0) != 7L
                  || !
#line 1029 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iwmmxt.md"
(TARGET_REALLY_IWMMXT))
                return -1;
              return 621; /* iwmmxt_wunpckihb */

            case 0L:
              x21 = XVECEXP (x9, 0, 1);
              if (XWINT (x21, 0) != 4L)
                return -1;
              x22 = XVECEXP (x9, 0, 2);
              if (XWINT (x22, 0) != 1L)
                return -1;
              x23 = XVECEXP (x9, 0, 3);
              if (XWINT (x23, 0) != 5L
                  || XWINT (x12, 0) != 2L
                  || XWINT (x13, 0) != 6L
                  || XWINT (x14, 0) != 3L
                  || XWINT (x15, 0) != 7L)
                return -1;
              x24 = XVECEXP (x10, 0, 0);
              if (XWINT (x24, 0) != 4L)
                return -1;
              x25 = XVECEXP (x10, 0, 1);
              if (XWINT (x25, 0) != 0L)
                return -1;
              x26 = XVECEXP (x10, 0, 2);
              if (XWINT (x26, 0) != 5L)
                return -1;
              x27 = XVECEXP (x10, 0, 3);
              if (XWINT (x27, 0) != 1L
                  || XWINT (x16, 0) != 6L
                  || XWINT (x17, 0) != 2L
                  || XWINT (x18, 0) != 7L
                  || XWINT (x19, 0) != 3L
                  || !
#line 1093 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iwmmxt.md"
(TARGET_REALLY_IWMMXT))
                return -1;
              return 624; /* iwmmxt_wunpckilb */

            default:
              return -1;
            }

        case 4:
          if (pattern471 (x9) != 0
              || pattern557 (x10, 
4) != 0
              || XWINT (x5, 0) != 5L
              || pattern586 (x3, 
E_V4HImode) != 0)
            return -1;
          x20 = XVECEXP (x9, 0, 0);
          switch (XWINT (x20, 0))
            {
            case 2L:
              x21 = XVECEXP (x9, 0, 1);
              if (XWINT (x21, 0) != 0L)
                return -1;
              x22 = XVECEXP (x9, 0, 2);
              if (XWINT (x22, 0) != 3L)
                return -1;
              x23 = XVECEXP (x9, 0, 3);
              if (XWINT (x23, 0) != 1L)
                return -1;
              x24 = XVECEXP (x10, 0, 0);
              if (XWINT (x24, 0) != 0L)
                return -1;
              x25 = XVECEXP (x10, 0, 1);
              if (XWINT (x25, 0) != 2L)
                return -1;
              x26 = XVECEXP (x10, 0, 2);
              if (XWINT (x26, 0) != 1L)
                return -1;
              x27 = XVECEXP (x10, 0, 3);
              if (XWINT (x27, 0) != 3L
                  || !
#line 1049 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iwmmxt.md"
(TARGET_REALLY_IWMMXT))
                return -1;
              return 622; /* iwmmxt_wunpckihh */

            case 0L:
              x21 = XVECEXP (x9, 0, 1);
              if (XWINT (x21, 0) != 2L)
                return -1;
              x22 = XVECEXP (x9, 0, 2);
              if (XWINT (x22, 0) != 1L)
                return -1;
              x23 = XVECEXP (x9, 0, 3);
              if (XWINT (x23, 0) != 3L)
                return -1;
              x24 = XVECEXP (x10, 0, 0);
              if (XWINT (x24, 0) != 2L)
                return -1;
              x25 = XVECEXP (x10, 0, 1);
              if (XWINT (x25, 0) != 0L)
                return -1;
              x26 = XVECEXP (x10, 0, 2);
              if (XWINT (x26, 0) != 3L)
                return -1;
              x27 = XVECEXP (x10, 0, 3);
              if (XWINT (x27, 0) != 1L
                  || !
#line 1113 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iwmmxt.md"
(TARGET_REALLY_IWMMXT))
                return -1;
              return 625; /* iwmmxt_wunpckilh */

            default:
              return -1;
            }

        case 2:
          x20 = XVECEXP (x9, 0, 0);
          if (GET_CODE (x20) != CONST_INT)
            return -1;
          x21 = XVECEXP (x9, 0, 1);
          if (GET_CODE (x21) != CONST_INT
              || XVECLEN (x10, 0) != 2)
            return -1;
          x24 = XVECEXP (x10, 0, 0);
          if (GET_CODE (x24) != CONST_INT)
            return -1;
          x25 = XVECEXP (x10, 0, 1);
          if (GET_CODE (x25) != CONST_INT
              || XWINT (x5, 0) != 1L
              || pattern586 (x3, 
E_V2SImode) != 0)
            return -1;
          switch (XWINT (x20, 0))
            {
            case 1L:
              if (XWINT (x21, 0) != 0L
                  || XWINT (x24, 0) != 0L
                  || XWINT (x25, 0) != 1L
                  || !
#line 1065 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iwmmxt.md"
(TARGET_REALLY_IWMMXT))
                return -1;
              return 623; /* iwmmxt_wunpckihw */

            case 0L:
              if (XWINT (x21, 0) != 1L
                  || XWINT (x24, 0) != 1L
                  || XWINT (x25, 0) != 0L
                  || !
#line 1129 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iwmmxt.md"
(TARGET_REALLY_IWMMXT))
                return -1;
              return 626; /* iwmmxt_wunpckilw */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case SS_MINUS:
      if (pattern250 (x3, 
SS_PLUS) != 0
          || !
#line 81 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iwmmxt2.md"
(TARGET_REALLY_IWMMXT))
        return -1;
      return 693; /* iwmmxt_waddsubhx */

    case SS_PLUS:
      if (pattern250 (x3, 
SS_MINUS) != 0
          || !
#line 99 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iwmmxt2.md"
(TARGET_REALLY_IWMMXT))
        return -1;
      return 694; /* iwmmxt_wsubaddhx */

    default:
      return -1;
    }
}

 int
recog_313 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  switch (GET_CODE (x3))
    {
    case SMAX:
      res = recog_281 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case SMIN:
      res = recog_282 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case UMAX:
      switch (pattern241 (x3, pnum_clobbers))
        {
        case 0:
          if (
#line 4170 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_ARM))
            {
              *pnum_clobbers = 1;
              return 122; /* *arm_umaxsi3 */
            }
          break;

        case 1:
          if (register_operand (operands[0], E_V2SImode)
              && register_operand (operands[1], E_V2SImode)
              && register_operand (operands[2], E_V2SImode)
              && 
#line 913 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iwmmxt.md"
(TARGET_REALLY_IWMMXT))
            return 606; /* *umaxv2si3_iwmmxt */
          if (s_register_operand (operands[0], E_V2SImode)
              && s_register_operand (operands[1], E_V2SImode)
              && s_register_operand (operands[2], E_V2SImode)
              && 
#line 870 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return 1350; /* *umaxv2si3_neon */
          break;

        case 2:
          if (register_operand (operands[0], E_V4HImode)
              && register_operand (operands[1], E_V4HImode)
              && register_operand (operands[2], E_V4HImode)
              && 
#line 913 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iwmmxt.md"
(TARGET_REALLY_IWMMXT))
            return 607; /* *umaxv4hi3_iwmmxt */
          if (s_register_operand (operands[0], E_V4HImode)
              && s_register_operand (operands[1], E_V4HImode)
              && s_register_operand (operands[2], E_V4HImode)
              && 
#line 870 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return 1348; /* *umaxv4hi3_neon */
          break;

        case 3:
          if (register_operand (operands[0], E_V8QImode)
              && register_operand (operands[1], E_V8QImode)
              && register_operand (operands[2], E_V8QImode)
              && 
#line 913 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iwmmxt.md"
(TARGET_REALLY_IWMMXT))
            return 608; /* *umaxv8qi3_iwmmxt */
          if (s_register_operand (operands[0], E_V8QImode)
              && s_register_operand (operands[1], E_V8QImode)
              && s_register_operand (operands[2], E_V8QImode)
              && 
#line 870 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return 1346; /* *umaxv8qi3_neon */
          break;

        case 4:
          if (
#line 870 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return 1347; /* *umaxv16qi3_neon */
          if (
#line 916 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return 3611; /* mve_vmaxq_uv16qi */
          break;

        case 5:
          if (
#line 870 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return 1349; /* *umaxv8hi3_neon */
          if (
#line 916 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return 3615; /* mve_vmaxq_uv8hi */
          break;

        case 6:
          if (
#line 870 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return 1351; /* *umaxv4si3_neon */
          if (
#line 916 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return 3619; /* mve_vmaxq_uv4si */
          break;

        case 7:
          if (
#line 1129 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return 1417; /* quad_halves_umaxv4si */
          break;

        case 8:
          if (
#line 1157 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return 1425; /* quad_halves_umaxv8hi */
          break;

        case 9:
          if (
#line 1176 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return 1430; /* quad_halves_umaxv16qi */
          break;

        default:
          break;
        }
      break;

    case UMIN:
      switch (pattern241 (x3, pnum_clobbers))
        {
        case 0:
          if (
#line 4203 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_ARM))
            {
              *pnum_clobbers = 1;
              return 123; /* *arm_uminsi3 */
            }
          break;

        case 1:
          if (register_operand (operands[0], E_V2SImode)
              && register_operand (operands[1], E_V2SImode)
              && register_operand (operands[2], E_V2SImode)
              && 
#line 933 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iwmmxt.md"
(TARGET_REALLY_IWMMXT))
            return 612; /* *uminv2si3_iwmmxt */
          if (s_register_operand (operands[0], E_V2SImode)
              && s_register_operand (operands[1], E_V2SImode)
              && s_register_operand (operands[2], E_V2SImode)
              && 
#line 861 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return 1344; /* *uminv2si3_neon */
          break;

        case 2:
          if (register_operand (operands[0], E_V4HImode)
              && register_operand (operands[1], E_V4HImode)
              && register_operand (operands[2], E_V4HImode)
              && 
#line 933 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iwmmxt.md"
(TARGET_REALLY_IWMMXT))
            return 613; /* *uminv4hi3_iwmmxt */
          if (s_register_operand (operands[0], E_V4HImode)
              && s_register_operand (operands[1], E_V4HImode)
              && s_register_operand (operands[2], E_V4HImode)
              && 
#line 861 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return 1342; /* *uminv4hi3_neon */
          break;

        case 3:
          if (register_operand (operands[0], E_V8QImode)
              && register_operand (operands[1], E_V8QImode)
              && register_operand (operands[2], E_V8QImode)
              && 
#line 933 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iwmmxt.md"
(TARGET_REALLY_IWMMXT))
            return 614; /* *uminv8qi3_iwmmxt */
          if (s_register_operand (operands[0], E_V8QImode)
              && s_register_operand (operands[1], E_V8QImode)
              && s_register_operand (operands[2], E_V8QImode)
              && 
#line 861 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return 1340; /* *uminv8qi3_neon */
          break;

        case 4:
          if (
#line 861 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return 1341; /* *uminv16qi3_neon */
          if (
#line 916 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return 3613; /* mve_vminq_uv16qi */
          break;

        case 5:
          if (
#line 861 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return 1343; /* *uminv8hi3_neon */
          if (
#line 916 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return 3617; /* mve_vminq_uv8hi */
          break;

        case 6:
          if (
#line 861 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return 1345; /* *uminv4si3_neon */
          if (
#line 916 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return 3621; /* mve_vminq_uv4si */
          break;

        case 7:
          if (
#line 1129 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return 1416; /* quad_halves_uminv4si */
          break;

        case 8:
          if (
#line 1157 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return 1424; /* quad_halves_uminv8hi */
          break;

        case 9:
          if (
#line 1176 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return 1429; /* quad_halves_uminv16qi */
          break;

        default:
          break;
        }
      break;

    default:
      break;
    }
  if (pnum_clobbers == NULL)
    return -1;
  x4 = XEXP (x3, 0);
  operands[1] = x4;
  if (!s_register_operand (operands[1], E_SImode))
    return -1;
  x5 = XEXP (x3, 1);
  operands[2] = x5;
  if (s_register_operand (operands[2], E_SImode)
      && memory_operand (operands[0], E_SImode))
    {
      operands[3] = x3;
      if (minmax_operator (operands[3], E_SImode)
          && 
#line 4227 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT && optimize_function_for_size_p (cfun) && !arm_restrict_it))
        {
          *pnum_clobbers = 1;
          return 124; /* *store_minmaxsi */
        }
    }
  if (!arm_rhs_operand (operands[2], E_SImode)
      || !s_register_operand (operands[0], E_SImode)
      || GET_MODE (x3) != E_SImode)
    return -1;
  switch (GET_CODE (x3))
    {
    case SMAX:
      if (!
#line 34 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/thumb2.md"
(TARGET_THUMB2))
        return -1;
      *pnum_clobbers = 1;
      return 1007; /* *thumb2_smaxsi3 */

    case SMIN:
      if (!
#line 55 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/thumb2.md"
(TARGET_THUMB2))
        return -1;
      *pnum_clobbers = 1;
      return 1008; /* *thumb2_sminsi3 */

    case UMAX:
      if (!
#line 76 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/thumb2.md"
(TARGET_THUMB2))
        return -1;
      *pnum_clobbers = 1;
      return 1009; /* *thumb32_umaxsi3 */

    case UMIN:
      if (!
#line 97 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/thumb2.md"
(TARGET_THUMB2))
        return -1;
      *pnum_clobbers = 1;
      return 1010; /* *thumb2_uminsi3 */

    default:
      return -1;
    }
}

 int
recog_320 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (pattern2 (x1))
    {
    case 0:
      if (!
#line 4360 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_DSP_MULTIPLY && !ARM_Q_BIT_READ))
        return -1;
      return 127; /* arm_qadd_insn */

    case 1:
      if (register_operand (operands[0], E_V8QImode)
          && register_operand (operands[1], E_V8QImode)
          && register_operand (operands[2], E_V8QImode)
          && 
#line 351 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iwmmxt.md"
(TARGET_REALLY_IWMMXT))
        return 555; /* ssaddv8qi3 */
      if (!s_register_operand (operands[0], E_V8QImode)
          || !s_register_operand (operands[1], E_V8QImode)
          || !s_register_operand (operands[2], E_V8QImode)
          || !
#line 1429 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 1451; /* *ss_addv8qi_neon */

    case 2:
      if (register_operand (operands[0], E_V4HImode)
          && register_operand (operands[1], E_V4HImode)
          && register_operand (operands[2], E_V4HImode)
          && 
#line 361 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iwmmxt.md"
(TARGET_REALLY_IWMMXT))
        return 556; /* ssaddv4hi3 */
      if (!s_register_operand (operands[0], E_V4HImode)
          || !s_register_operand (operands[1], E_V4HImode)
          || !s_register_operand (operands[2], E_V4HImode)
          || !
#line 1429 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 1452; /* *ss_addv4hi_neon */

    case 3:
      if (register_operand (operands[0], E_V2SImode)
          && register_operand (operands[1], E_V2SImode)
          && register_operand (operands[2], E_V2SImode)
          && 
#line 371 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iwmmxt.md"
(TARGET_REALLY_IWMMXT))
        return 557; /* ssaddv2si3 */
      if (!s_register_operand (operands[0], E_V2SImode)
          || !s_register_operand (operands[1], E_V2SImode)
          || !s_register_operand (operands[2], E_V2SImode)
          || !
#line 1429 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 1453; /* *ss_addv2si_neon */

    case 4:
      if (!
#line 1429 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 1454; /* *ss_addv2sf_neon */

    case 5:
      if (!
#line 75 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm-fixed.md"
(TARGET_INT_SIMD && !0))
        return -1;
      return 3197; /* *arm_ssaddv4qq3 */

    case 6:
      if (!
#line 75 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm-fixed.md"
(TARGET_INT_SIMD && !0))
        return -1;
      return 3198; /* *arm_ssaddv2hq3 */

    case 7:
      if (!
#line 75 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm-fixed.md"
(TARGET_INT_SIMD && !0))
        return -1;
      return 3199; /* *arm_ssaddqq3 */

    case 8:
      if (!
#line 75 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm-fixed.md"
(TARGET_INT_SIMD && !0))
        return -1;
      return 3200; /* *arm_ssaddhq3 */

    case 9:
      if (!
#line 75 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm-fixed.md"
(TARGET_INT_SIMD && !0))
        return -1;
      return 3201; /* *arm_ssaddv2ha3 */

    case 10:
      if (!
#line 75 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm-fixed.md"
(TARGET_INT_SIMD && !0))
        return -1;
      return 3202; /* *arm_ssaddha3 */

    case 11:
      if (!
#line 75 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm-fixed.md"
(TARGET_INT_SIMD && !ARM_Q_BIT_READ))
        return -1;
      return 3203; /* *arm_ssaddsq3 */

    case 12:
      if (!
#line 75 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm-fixed.md"
(TARGET_INT_SIMD && !ARM_Q_BIT_READ))
        return -1;
      return 3204; /* *arm_ssaddsa3 */

    default:
      return -1;
    }
}

 int
recog_324 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  operands[1] = x4;
  switch (GET_MODE (operands[0]))
    {
    case E_SImode:
      if (!s_register_operand (operands[0], E_SImode)
          || GET_MODE (x3) != E_SImode
          || !s_register_operand (operands[1], E_SImode)
          || !
#line 12186 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT && arm_arch5t))
        return -1;
      return 399; /* clzsi2 */

    case E_V8QImode:
      if (!s_register_operand (operands[0], E_V8QImode)
          || GET_MODE (x3) != E_V8QImode
          || !s_register_operand (operands[1], E_V8QImode)
          || !
#line 3158 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2015; /* neon_vclzv8qi */

    case E_V16QImode:
      if (!s_register_operand (operands[0], E_V16QImode)
          || GET_MODE (x3) != E_V16QImode
          || !s_register_operand (operands[1], E_V16QImode))
        return -1;
      if (
#line 3158 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return 2016; /* neon_vclzv16qi */
      if (!
#line 315 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
        return -1;
      return 3298; /* mve_vclzq_sv16qi */

    case E_V4HImode:
      if (!s_register_operand (operands[0], E_V4HImode)
          || GET_MODE (x3) != E_V4HImode
          || !s_register_operand (operands[1], E_V4HImode)
          || !
#line 3158 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2017; /* neon_vclzv4hi */

    case E_V8HImode:
      if (!s_register_operand (operands[0], E_V8HImode)
          || GET_MODE (x3) != E_V8HImode
          || !s_register_operand (operands[1], E_V8HImode))
        return -1;
      if (
#line 3158 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return 2018; /* neon_vclzv8hi */
      if (!
#line 315 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
        return -1;
      return 3299; /* mve_vclzq_sv8hi */

    case E_V2SImode:
      if (!s_register_operand (operands[0], E_V2SImode)
          || GET_MODE (x3) != E_V2SImode
          || !s_register_operand (operands[1], E_V2SImode)
          || !
#line 3158 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2019; /* neon_vclzv2si */

    case E_V4SImode:
      if (!s_register_operand (operands[0], E_V4SImode)
          || GET_MODE (x3) != E_V4SImode
          || !s_register_operand (operands[1], E_V4SImode))
        return -1;
      if (
#line 3158 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return 2020; /* neon_vclzv4si */
      if (!
#line 315 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
        return -1;
      return 3300; /* mve_vclzq_sv4si */

    default:
      return -1;
    }
}

 int
recog_330 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != ZERO_EXTRACT
      || GET_MODE (x3) != E_SImode)
    return -1;
  x4 = XEXP (x3, 0);
  operands[0] = x4;
  if (!s_register_operand (operands[0], E_SImode))
    return -1;
  x5 = XEXP (x2, 1);
  if (XWINT (x5, 0) == 0L)
    {
      x6 = XEXP (x1, 0);
      operands[3] = x6;
      x7 = XEXP (x6, 0);
      operands[4] = x7;
      x8 = XEXP (x3, 1);
      operands[1] = x8;
      if (const_int_M_operand (operands[1], E_SImode))
        {
          x9 = XEXP (x3, 2);
          operands[2] = x9;
          if (const_int_M_operand (operands[2], E_SImode)
              && (
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 3500 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(arm_arch_thumb2)))
            return 6448; /* *p insv_zero */
        }
    }
  x8 = XEXP (x3, 1);
  if (x8 != const_int_rtx[MAX_SAVED_CONST_INT + 16])
    return -1;
  x9 = XEXP (x3, 2);
  if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 16])
    return -1;
  x6 = XEXP (x1, 0);
  operands[2] = x6;
  x7 = XEXP (x6, 0);
  operands[3] = x7;
  operands[1] = x5;
  if (!const_int_operand (operands[1], E_SImode)
      || !(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 12364 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_HAVE_MOVT)))
    return -1;
  return 6606; /* *p *arm_movtas_ze */
}

 int
recog_335 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 1);
  operands[1] = x4;
  x5 = XEXP (x2, 0);
  if (REGNO (x5) != 101)
    return -1;
  x6 = XEXP (x1, 0);
  operands[2] = x6;
  x7 = XEXP (x6, 0);
  operands[3] = x7;
  switch (GET_MODE (x5))
    {
    case E_CCFPmode:
      switch (pattern558 (x3, 
E_CCFPmode))
        {
        case 0:
          if (!(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 1815 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/vfp.md"
(TARGET_32BIT && TARGET_HARD_FLOAT)))
            return -1;
          return 6967; /* *p *cmpsf_vfp */

        case 1:
          if (!(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 1839 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/vfp.md"
(TARGET_32BIT && TARGET_HARD_FLOAT && TARGET_VFP_DOUBLE)))
            return -1;
          return 6969; /* *p *cmpdf_vfp */

        default:
          return -1;
        }

    case E_CCFPEmode:
      switch (pattern558 (x3, 
E_CCFPEmode))
        {
        case 0:
          if (!(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 1827 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/vfp.md"
(TARGET_32BIT && TARGET_HARD_FLOAT)))
            return -1;
          return 6968; /* *p *cmpsf_trap_vfp */

        case 1:
          if (!(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 1851 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/vfp.md"
(TARGET_32BIT && TARGET_HARD_FLOAT && TARGET_VFP_DOUBLE)))
            return -1;
          return 6970; /* *p *cmpdf_trap_vfp */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_339 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[6] = x2;
  x3 = XEXP (x2, 0);
  operands[7] = x3;
  if (!s_register_operand (operands[0], E_SImode))
    return -1;
  x4 = XEXP (x1, 1);
  x5 = XEXP (x4, 1);
  x6 = XEXP (x5, 0);
  x7 = XEXP (x6, 0);
  x8 = XEXP (x7, 0);
  operands[3] = x8;
  if (!s_register_operand (operands[3], E_SImode))
    return -1;
  x9 = XEXP (x6, 1);
  operands[5] = x9;
  if (!const_int_operand (operands[5], E_VOIDmode))
    return -1;
  x10 = XEXP (x5, 1);
  x11 = XEXP (x10, 0);
  operands[1] = x11;
  if (!s_register_operand (operands[1], E_SImode))
    return -1;
  x12 = XEXP (x10, 1);
  operands[2] = x12;
  if (!const_int_operand (operands[2], E_VOIDmode)
      || !(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 3559 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(arm_arch_thumb2
   && UINTVAL (operands[4]) < 32
   && UINTVAL (operands[2]) == ~UINTVAL (operands[5])
   && (exact_log2 (UINTVAL (operands[5])
		   + (HOST_WIDE_INT_1U << UINTVAL (operands[4])))
       >= 0))))
    return -1;
  return 6451; /* *p *bfi_alt1 */
}

 int
recog_341 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19, x20, x21, x22, x23, x24, x25;
  rtx x26, x27, x28, x29, x30, x31, x32, x33;
  rtx x34, x35, x36, x37, x38, x39, x40, x41;
  rtx x42, x43, x44, x45, x46, x47, x48, x49;
  rtx x50, x51, x52, x53, x54, x55, x56, x57;
  rtx x58, x59, x60, x61, x62, x63, x64, x65;
  rtx x66;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[3] = x2;
  x3 = XEXP (x2, 0);
  operands[4] = x3;
  x4 = XEXP (x1, 1);
  x5 = XEXP (x4, 0);
  operands[0] = x5;
  x6 = XEXP (x4, 1);
  x7 = XEXP (x6, 0);
  switch (GET_CODE (x7))
    {
    case LSHIFTRT:
      x8 = XEXP (x7, 1);
      if (GET_CODE (x8) != CONST_INT)
        return -1;
      x9 = XEXP (x7, 0);
      switch (GET_CODE (x9))
        {
        case MULT:
          x10 = XEXP (x9, 0);
          switch (GET_CODE (x10))
            {
            case SIGN_EXTEND:
              if (GET_MODE (x10) != E_V4SImode)
                return -1;
              x11 = XEXP (x9, 1);
              if (GET_CODE (x11) != SIGN_EXTEND
                  || GET_MODE (x11) != E_V4SImode
                  || XWINT (x8, 0) != 16L
                  || !register_operand (operands[0], E_V4HImode)
                  || GET_MODE (x6) != E_V4HImode
                  || GET_MODE (x7) != E_V4SImode
                  || GET_MODE (x9) != E_V4SImode)
                return -1;
              x12 = XEXP (x10, 0);
              operands[1] = x12;
              if (!register_operand (operands[1], E_V4HImode))
                return -1;
              x13 = XEXP (x11, 0);
              operands[2] = x13;
              if (!register_operand (operands[2], E_V4HImode)
                  || !(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 494 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iwmmxt.md"
(TARGET_REALLY_IWMMXT)))
                return -1;
              return 6713; /* *p smulv4hi3_highpart */

            case ZERO_EXTEND:
              x11 = XEXP (x9, 1);
              if (GET_CODE (x11) != ZERO_EXTEND)
                return -1;
              x12 = XEXP (x10, 0);
              operands[1] = x12;
              x13 = XEXP (x11, 0);
              operands[2] = x13;
              switch (XWINT (x8, 0))
                {
                case 16L:
                  if (pattern574 (x6, 
E_V4HImode, 
E_V4SImode) != 0
                      || !(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 507 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iwmmxt.md"
(TARGET_REALLY_IWMMXT)))
                    return -1;
                  return 6714; /* *p umulv4hi3_highpart */

                case 32L:
                  if (pattern574 (x6, 
E_V2SImode, 
E_V2DImode) != 0
                      || !(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 279 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iwmmxt2.md"
(TARGET_REALLY_IWMMXT)))
                    return -1;
                  return 6846; /* *p iwmmxt_wmulwum */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        case PLUS:
          x10 = XEXP (x9, 0);
          switch (GET_CODE (x10))
            {
            case PLUS:
              x12 = XEXP (x10, 0);
              if (GET_CODE (x12) != ZERO_EXTEND)
                return -1;
              x14 = XEXP (x10, 1);
              if (GET_CODE (x14) != ZERO_EXTEND)
                return -1;
              x11 = XEXP (x9, 1);
              if (GET_CODE (x11) != CONST_VECTOR
                  || XWINT (x8, 0) != 1L)
                return -1;
              x15 = XEXP (x12, 0);
              operands[1] = x15;
              x16 = XEXP (x14, 0);
              operands[2] = x16;
              switch (XVECLEN (x11, 0))
                {
                case 8:
                  if (pattern606 (x11, 
1) != 0
                      || pattern598 (x6, 
E_V8QImode, 
E_V8HImode) != 0
                      || !(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 617 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iwmmxt.md"
(TARGET_REALLY_IWMMXT)))
                    return -1;
                  return 6723; /* *p iwmmxt_uavgrndv8qi3 */

                case 4:
                  if (GET_MODE (x11) != E_V4SImode)
                    return -1;
                  x17 = XVECEXP (x11, 0, 0);
                  if (x17 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
                    return -1;
                  x18 = XVECEXP (x11, 0, 1);
                  if (x18 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
                    return -1;
                  x19 = XVECEXP (x11, 0, 2);
                  if (x19 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
                    return -1;
                  x20 = XVECEXP (x11, 0, 3);
                  if (x20 != const_int_rtx[MAX_SAVED_CONST_INT + 1]
                      || pattern598 (x6, 
E_V4HImode, 
E_V4SImode) != 0
                      || !(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 635 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iwmmxt.md"
(TARGET_REALLY_IWMMXT)))
                    return -1;
                  return 6724; /* *p iwmmxt_uavgrndv4hi3 */

                default:
                  return -1;
                }

            case ZERO_EXTEND:
              x11 = XEXP (x9, 1);
              if (GET_CODE (x11) != ZERO_EXTEND
                  || XWINT (x8, 0) != 1L)
                return -1;
              x12 = XEXP (x10, 0);
              operands[1] = x12;
              x13 = XEXP (x11, 0);
              operands[2] = x13;
              switch (GET_MODE (operands[0]))
                {
                case E_V8QImode:
                  if (pattern574 (x6, 
E_V8QImode, 
E_V8HImode) != 0
                      || !(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 648 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iwmmxt.md"
(TARGET_REALLY_IWMMXT)))
                    return -1;
                  return 6725; /* *p iwmmxt_uavgv8qi3 */

                case E_V4HImode:
                  if (pattern574 (x6, 
E_V4HImode, 
E_V4SImode) != 0
                      || !(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 661 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iwmmxt.md"
(TARGET_REALLY_IWMMXT)))
                    return -1;
                  return 6726; /* *p iwmmxt_uavgv4hi3 */

                default:
                  return -1;
                }

            case MULT:
              x12 = XEXP (x10, 0);
              if (GET_CODE (x12) != ZERO_EXTEND)
                return -1;
              x14 = XEXP (x10, 1);
              if (GET_CODE (x14) != ZERO_EXTEND)
                return -1;
              x11 = XEXP (x9, 1);
              if (GET_CODE (x11) != CONST_VECTOR)
                return -1;
              x15 = XEXP (x12, 0);
              operands[1] = x15;
              x16 = XEXP (x14, 0);
              operands[2] = x16;
              switch (XVECLEN (x11, 0))
                {
                case 4:
                  if (pattern597 (x11) != 0)
                    return -1;
                  x20 = XVECEXP (x11, 0, 3);
                  if (GET_CODE (x20) != CONST_INT
                      || XWINT (x20, 0) != 32768L
                      || XWINT (x8, 0) != 16L
                      || pattern598 (x6, 
E_V4HImode, 
E_V4SImode) != 0
                      || !(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 316 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iwmmxt2.md"
(TARGET_REALLY_IWMMXT)))
                    return -1;
                  return 6848; /* *p iwmmxt_wmulumr */

                case 2:
                  if (pattern599 (x6) != 0
                      || !(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 350 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iwmmxt2.md"
(TARGET_REALLY_IWMMXT)))
                    return -1;
                  return 6850; /* *p iwmmxt_wmulwumr */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        default:
          return -1;
        }

    case ABS:
      x9 = XEXP (x7, 0);
      if (GET_CODE (x9) != MINUS)
        return -1;
      x10 = XEXP (x9, 0);
      if (GET_CODE (x10) != ZERO_EXTEND)
        return -1;
      x11 = XEXP (x9, 1);
      if (GET_CODE (x11) != ZERO_EXTEND)
        return -1;
      x12 = XEXP (x10, 0);
      operands[1] = x12;
      x13 = XEXP (x11, 0);
      operands[2] = x13;
      switch (GET_MODE (operands[0]))
        {
        case E_V8QImode:
          if (pattern574 (x6, 
E_V8QImode, 
E_V8HImode) != 0
              || !(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 37 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iwmmxt2.md"
(TARGET_REALLY_IWMMXT)))
            return -1;
          return 6832; /* *p iwmmxt_wabsdiffb */

        case E_V4HImode:
          if (pattern574 (x6, 
E_V4HImode, 
E_V4SImode) != 0
              || !(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 50 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iwmmxt2.md"
(TARGET_REALLY_IWMMXT)))
            return -1;
          return 6833; /* *p iwmmxt_wabsdiffh */

        case E_V2SImode:
          if (pattern574 (x6, 
E_V2SImode, 
E_V2DImode) != 0
              || !(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 63 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iwmmxt2.md"
(TARGET_REALLY_IWMMXT)))
            return -1;
          return 6834; /* *p iwmmxt_wabsdiffw */

        default:
          return -1;
        }

    case VEC_SELECT:
      if (GET_MODE (x7) != E_V8HImode)
        return -1;
      x9 = XEXP (x7, 0);
      if (GET_CODE (x9) != VEC_MERGE
          || GET_MODE (x9) != E_V8HImode)
        return -1;
      x10 = XEXP (x9, 0);
      if (GET_CODE (x10) != LSHIFTRT
          || GET_MODE (x10) != E_V8HImode)
        return -1;
      x12 = XEXP (x10, 0);
      if (GET_CODE (x12) != PLUS
          || GET_MODE (x12) != E_V8HImode)
        return -1;
      x15 = XEXP (x12, 0);
      if (GET_CODE (x15) != PLUS
          || GET_MODE (x15) != E_V8HImode)
        return -1;
      x21 = XEXP (x15, 0);
      if (GET_CODE (x21) != PLUS
          || GET_MODE (x21) != E_V8HImode)
        return -1;
      x22 = XEXP (x21, 0);
      if (GET_CODE (x22) != PLUS
          || GET_MODE (x22) != E_V8HImode)
        return -1;
      x23 = XEXP (x22, 0);
      if (GET_CODE (x23) != ZERO_EXTEND
          || GET_MODE (x23) != E_V8HImode)
        return -1;
      x24 = XEXP (x22, 1);
      if (GET_CODE (x24) != ZERO_EXTEND
          || GET_MODE (x24) != E_V8HImode)
        return -1;
      x25 = XEXP (x21, 1);
      if (GET_CODE (x25) != VEC_SELECT
          || GET_MODE (x25) != E_V8HImode)
        return -1;
      x26 = XEXP (x25, 0);
      if (GET_CODE (x26) != ZERO_EXTEND
          || GET_MODE (x26) != E_V8HImode)
        return -1;
      x27 = XEXP (x25, 1);
      if (GET_CODE (x27) != PARALLEL
          || XVECLEN (x27, 0) != 8)
        return -1;
      x28 = XVECEXP (x27, 0, 0);
      if (x28 != const_int_rtx[MAX_SAVED_CONST_INT + 7])
        return -1;
      x29 = XVECEXP (x27, 0, 1);
      if (x29 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      x30 = XVECEXP (x27, 0, 2);
      if (x30 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
        return -1;
      x31 = XVECEXP (x27, 0, 3);
      if (x31 != const_int_rtx[MAX_SAVED_CONST_INT + 2])
        return -1;
      x32 = XVECEXP (x27, 0, 4);
      if (x32 != const_int_rtx[MAX_SAVED_CONST_INT + 3])
        return -1;
      x33 = XVECEXP (x27, 0, 5);
      if (x33 != const_int_rtx[MAX_SAVED_CONST_INT + 4])
        return -1;
      x34 = XVECEXP (x27, 0, 6);
      if (x34 != const_int_rtx[MAX_SAVED_CONST_INT + 5])
        return -1;
      x35 = XVECEXP (x27, 0, 7);
      if (x35 != const_int_rtx[MAX_SAVED_CONST_INT + 6])
        return -1;
      x36 = XEXP (x15, 1);
      if (GET_CODE (x36) != VEC_SELECT
          || GET_MODE (x36) != E_V8HImode)
        return -1;
      x37 = XEXP (x36, 0);
      if (GET_CODE (x37) != ZERO_EXTEND
          || GET_MODE (x37) != E_V8HImode)
        return -1;
      x38 = XEXP (x36, 1);
      if (GET_CODE (x38) != PARALLEL
          || XVECLEN (x38, 0) != 8)
        return -1;
      x39 = XVECEXP (x38, 0, 0);
      if (x39 != const_int_rtx[MAX_SAVED_CONST_INT + 7])
        return -1;
      x40 = XVECEXP (x38, 0, 1);
      if (x40 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      x41 = XVECEXP (x38, 0, 2);
      if (x41 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
        return -1;
      x42 = XVECEXP (x38, 0, 3);
      if (x42 != const_int_rtx[MAX_SAVED_CONST_INT + 2])
        return -1;
      x43 = XVECEXP (x38, 0, 4);
      if (x43 != const_int_rtx[MAX_SAVED_CONST_INT + 3])
        return -1;
      x44 = XVECEXP (x38, 0, 5);
      if (x44 != const_int_rtx[MAX_SAVED_CONST_INT + 4])
        return -1;
      x45 = XVECEXP (x38, 0, 6);
      if (x45 != const_int_rtx[MAX_SAVED_CONST_INT + 5])
        return -1;
      x46 = XVECEXP (x38, 0, 7);
      if (x46 != const_int_rtx[MAX_SAVED_CONST_INT + 6])
        return -1;
      x47 = XEXP (x12, 1);
      if (GET_CODE (x47) != CONST_VECTOR
          || XVECLEN (x47, 0) != 8
          || GET_MODE (x47) != E_V8HImode)
        return -1;
      x48 = XVECEXP (x47, 0, 0);
      if (GET_CODE (x48) != CONST_INT)
        return -1;
      x49 = XVECEXP (x47, 0, 1);
      if (GET_CODE (x49) != CONST_INT)
        return -1;
      x50 = XVECEXP (x47, 0, 2);
      if (GET_CODE (x50) != CONST_INT)
        return -1;
      x51 = XVECEXP (x47, 0, 3);
      if (GET_CODE (x51) != CONST_INT)
        return -1;
      x52 = XVECEXP (x47, 0, 4);
      if (GET_CODE (x52) != CONST_INT)
        return -1;
      x53 = XVECEXP (x47, 0, 5);
      if (GET_CODE (x53) != CONST_INT)
        return -1;
      x54 = XVECEXP (x47, 0, 6);
      if (GET_CODE (x54) != CONST_INT)
        return -1;
      x55 = XVECEXP (x47, 0, 7);
      if (GET_CODE (x55) != CONST_INT)
        return -1;
      x14 = XEXP (x10, 1);
      if (x14 != const_int_rtx[MAX_SAVED_CONST_INT + 2])
        return -1;
      x11 = XEXP (x9, 1);
      if (GET_CODE (x11) != CONST_VECTOR
          || XVECLEN (x11, 0) != 8
          || pattern606 (x11, 
0) != 0)
        return -1;
      x56 = XEXP (x9, 2);
      if (GET_CODE (x56) != CONST_INT
          || XWINT (x56, 0) != 254L)
        return -1;
      x8 = XEXP (x7, 1);
      if (pattern609 (x8, 
2, 
8) != 0)
        return -1;
      x57 = XVECEXP (x8, 0, 2);
      if (x57 != const_int_rtx[MAX_SAVED_CONST_INT + 3])
        return -1;
      x58 = XVECEXP (x8, 0, 3);
      if (x58 != const_int_rtx[MAX_SAVED_CONST_INT + 4])
        return -1;
      x59 = XVECEXP (x8, 0, 4);
      if (x59 != const_int_rtx[MAX_SAVED_CONST_INT + 5])
        return -1;
      x60 = XVECEXP (x8, 0, 5);
      if (x60 != const_int_rtx[MAX_SAVED_CONST_INT + 6])
        return -1;
      x61 = XVECEXP (x8, 0, 6);
      if (x61 != const_int_rtx[MAX_SAVED_CONST_INT + 7])
        return -1;
      x62 = XVECEXP (x8, 0, 7);
      if (x62 != const_int_rtx[MAX_SAVED_CONST_INT + 0]
          || !register_operand (operands[0], E_V8QImode)
          || GET_MODE (x6) != E_V8QImode)
        return -1;
      x63 = XEXP (x23, 0);
      operands[1] = x63;
      if (!register_operand (operands[1], E_V8QImode))
        return -1;
      x64 = XEXP (x24, 0);
      operands[2] = x64;
      if (!register_operand (operands[2], E_V8QImode))
        return -1;
      x65 = XEXP (x26, 0);
      if (!rtx_equal_p (x65, operands[1]))
        return -1;
      x66 = XEXP (x37, 0);
      if (!rtx_equal_p (x66, operands[2]))
        return -1;
      switch (XWINT (x48, 0))
        {
        case 1L:
          if (XWINT (x49, 0) != 1L
              || XWINT (x50, 0) != 1L
              || XWINT (x51, 0) != 1L
              || XWINT (x52, 0) != 1L
              || XWINT (x53, 0) != 1L
              || XWINT (x54, 0) != 1L
              || XWINT (x55, 0) != 1L
              || !(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 143 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iwmmxt2.md"
(TARGET_REALLY_IWMMXT)))
            return -1;
          return 6839; /* *p iwmmxt_avg4 */

        case 2L:
          if (XWINT (x49, 0) != 2L
              || XWINT (x50, 0) != 2L
              || XWINT (x51, 0) != 2L
              || XWINT (x52, 0) != 2L
              || XWINT (x53, 0) != 2L
              || XWINT (x54, 0) != 2L
              || XWINT (x55, 0) != 2L
              || !(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 175 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iwmmxt2.md"
(TARGET_REALLY_IWMMXT)))
            return -1;
          return 6840; /* *p iwmmxt_avg4r */

        default:
          return -1;
        }

    case ASHIFTRT:
      x8 = XEXP (x7, 1);
      if (GET_CODE (x8) != CONST_INT)
        return -1;
      x9 = XEXP (x7, 0);
      switch (GET_CODE (x9))
        {
        case MULT:
          if (GET_MODE (x9) != E_V2DImode)
            return -1;
          x10 = XEXP (x9, 0);
          if (GET_CODE (x10) != SIGN_EXTEND
              || GET_MODE (x10) != E_V2DImode)
            return -1;
          x11 = XEXP (x9, 1);
          if (GET_CODE (x11) != SIGN_EXTEND
              || GET_MODE (x11) != E_V2DImode
              || XWINT (x8, 0) != 32L
              || !register_operand (operands[0], E_V2SImode)
              || GET_MODE (x6) != E_V2SImode
              || GET_MODE (x7) != E_V2DImode)
            return -1;
          x12 = XEXP (x10, 0);
          operands[1] = x12;
          if (!register_operand (operands[1], E_V2SImode))
            return -1;
          x13 = XEXP (x11, 0);
          operands[2] = x13;
          if (!register_operand (operands[2], E_V2SImode)
              || !(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 265 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iwmmxt2.md"
(TARGET_REALLY_IWMMXT)))
            return -1;
          return 6845; /* *p iwmmxt_wmulwsm */

        case PLUS:
          x10 = XEXP (x9, 0);
          if (GET_CODE (x10) != MULT)
            return -1;
          x12 = XEXP (x10, 0);
          if (GET_CODE (x12) != SIGN_EXTEND)
            return -1;
          x14 = XEXP (x10, 1);
          if (GET_CODE (x14) != SIGN_EXTEND)
            return -1;
          x11 = XEXP (x9, 1);
          if (GET_CODE (x11) != CONST_VECTOR)
            return -1;
          x15 = XEXP (x12, 0);
          operands[1] = x15;
          x16 = XEXP (x14, 0);
          operands[2] = x16;
          switch (XVECLEN (x11, 0))
            {
            case 3:
              if (pattern597 (x11) != 0
                  || XWINT (x8, 0) != 16L
                  || pattern598 (x6, 
E_V4HImode, 
E_V4SImode) != 0
                  || !(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 297 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iwmmxt2.md"
(TARGET_REALLY_IWMMXT)))
                return -1;
              return 6847; /* *p iwmmxt_wmulsmr */

            case 2:
              if (pattern599 (x6) != 0
                  || !(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 333 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iwmmxt2.md"
(TARGET_REALLY_IWMMXT)))
                return -1;
              return 6849; /* *p iwmmxt_wmulwsmr */

            default:
              return -1;
            }

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_348 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 1);
  switch (XVECLEN (x3, 0))
    {
    case 1:
      switch (XINT (x3, 1))
        {
        case 52:
          if (GET_MODE (x3) != E_CCmode)
            return -1;
          x4 = XEXP (x2, 0);
          if (GET_CODE (x4) != REG
              || REGNO (x4) != 104
              || GET_MODE (x4) != E_CCmode)
            return -1;
          x5 = XEXP (x1, 0);
          operands[1] = x5;
          x6 = XEXP (x5, 0);
          operands[2] = x6;
          x7 = XVECEXP (x3, 0, 0);
          operands[0] = x7;
          if (!s_register_operand (operands[0], E_SImode)
              || !(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 4429 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_ARM_QBIT)))
            return -1;
          return 6469; /* *p arm_set_apsr */

        case 53:
          if (GET_MODE (x3) != E_SImode)
            return -1;
          x4 = XEXP (x2, 0);
          if (GET_CODE (x4) != MEM
              || GET_MODE (x4) != E_SImode)
            return -1;
          x5 = XEXP (x1, 0);
          operands[2] = x5;
          x6 = XEXP (x5, 0);
          operands[3] = x6;
          x8 = XEXP (x4, 0);
          if (GET_MODE (x8) != E_SImode)
            return -1;
          x7 = XVECEXP (x3, 0, 0);
          operands[1] = x7;
          if (!const_int_operand (operands[1], E_SImode))
            return -1;
          switch (GET_CODE (x8))
            {
            case POST_DEC:
              x9 = XEXP (x8, 0);
              operands[0] = x9;
              if (!s_register_operand (operands[0], E_SImode)
                  || !(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 1647 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/vfp.md"
(TARGET_HAVE_FPCXT_CMSE && use_cmse)))
                return -1;
              return 6963; /* *p push_fpsysreg_insn */

            case POST_INC:
              x9 = XEXP (x8, 0);
              operands[0] = x9;
              if (!s_register_operand (operands[0], E_SImode)
                  || !(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 1666 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/vfp.md"
(TARGET_HAVE_FPCXT_CMSE && use_cmse)))
                return -1;
              return 6964; /* *p pop_fpsysreg_insn */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case 2:
      x5 = XEXP (x1, 0);
      operands[3] = x5;
      x6 = XEXP (x5, 0);
      operands[4] = x6;
      x4 = XEXP (x2, 0);
      operands[0] = x4;
      x7 = XVECEXP (x3, 0, 0);
      operands[1] = x7;
      x10 = XVECEXP (x3, 0, 1);
      operands[2] = x10;
      switch (XINT (x3, 1))
        {
        case 13:
          switch (GET_MODE (operands[0]))
            {
            case E_V8QImode:
              if (pattern545 (x3, 
E_V8QImode) != 0
                  || !(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 802 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iwmmxt.md"
(TARGET_REALLY_IWMMXT)))
                return -1;
              return 6736; /* *p eqv8qi3 */

            case E_V4HImode:
              if (pattern545 (x3, 
E_V4HImode) != 0
                  || !(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 813 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iwmmxt.md"
(TARGET_REALLY_IWMMXT)))
                return -1;
              return 6737; /* *p eqv4hi3 */

            case E_V2SImode:
              if (pattern545 (x3, 
E_V2SImode) != 0
                  || !(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 825 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iwmmxt.md"
(TARGET_REALLY_IWMMXT)))
                return -1;
              return 6738; /* *p eqv2si3 */

            default:
              return -1;
            }

        case 14:
          switch (GET_MODE (operands[0]))
            {
            case E_V8QImode:
              if (pattern545 (x3, 
E_V8QImode) != 0
                  || !(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 836 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iwmmxt.md"
(TARGET_REALLY_IWMMXT)))
                return -1;
              return 6739; /* *p gtuv8qi3 */

            case E_V4HImode:
              if (pattern545 (x3, 
E_V4HImode) != 0
                  || !(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 847 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iwmmxt.md"
(TARGET_REALLY_IWMMXT)))
                return -1;
              return 6740; /* *p gtuv4hi3 */

            case E_V2SImode:
              if (pattern545 (x3, 
E_V2SImode) != 0
                  || !(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 858 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iwmmxt.md"
(TARGET_REALLY_IWMMXT)))
                return -1;
              return 6741; /* *p gtuv2si3 */

            default:
              return -1;
            }

        case 15:
          switch (GET_MODE (operands[0]))
            {
            case E_V8QImode:
              if (pattern545 (x3, 
E_V8QImode) != 0
                  || !(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 869 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iwmmxt.md"
(TARGET_REALLY_IWMMXT)))
                return -1;
              return 6742; /* *p gtv8qi3 */

            case E_V4HImode:
              if (pattern545 (x3, 
E_V4HImode) != 0
                  || !(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 880 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iwmmxt.md"
(TARGET_REALLY_IWMMXT)))
                return -1;
              return 6743; /* *p gtv4hi3 */

            case E_V2SImode:
              if (pattern545 (x3, 
E_V2SImode) != 0
                  || !(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 891 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iwmmxt.md"
(TARGET_REALLY_IWMMXT)))
                return -1;
              return 6744; /* *p gtv2si3 */

            default:
              return -1;
            }

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_353 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 1);
  if (GET_CODE (x4) != PARALLEL)
    return -1;
  x5 = XEXP (x2, 0);
  operands[0] = x5;
  x6 = XEXP (x3, 0);
  switch (GET_CODE (x6))
    {
    case REG:
    case SUBREG:
      operands[1] = x6;
      if (!register_operand (operands[1], E_V2SImode)
          || XVECLEN (x4, 0) != 1)
        return -1;
      x7 = XEXP (x1, 0);
      operands[3] = x7;
      x8 = XEXP (x7, 0);
      operands[4] = x8;
      if (!register_operand (operands[0], E_SImode)
          || GET_MODE (x3) != E_SImode)
        return -1;
      x9 = XVECEXP (x4, 0, 0);
      operands[2] = x9;
      if (!immediate_operand (operands[2], E_SImode)
          || !(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 770 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iwmmxt.md"
(TARGET_REALLY_IWMMXT)))
        return -1;
      return 6734; /* *p iwmmxt_textrmw */

    case ZERO_EXTEND:
      switch (pattern412 (x1))
        {
        case 0:
          if (!(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 1141 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iwmmxt.md"
(TARGET_REALLY_IWMMXT)))
            return -1;
          return 6769; /* *p iwmmxt_wunpckehub */

        case 1:
          if (!(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 1209 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iwmmxt.md"
(TARGET_REALLY_IWMMXT)))
            return -1;
          return 6775; /* *p iwmmxt_wunpckelub */

        case 2:
          if (!(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 1152 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iwmmxt.md"
(TARGET_REALLY_IWMMXT)))
            return -1;
          return 6770; /* *p iwmmxt_wunpckehuh */

        case 3:
          if (!(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 1220 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iwmmxt.md"
(TARGET_REALLY_IWMMXT)))
            return -1;
          return 6776; /* *p iwmmxt_wunpckeluh */

        case 4:
          if (!(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 1163 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iwmmxt.md"
(TARGET_REALLY_IWMMXT)))
            return -1;
          return 6771; /* *p iwmmxt_wunpckehuw */

        case 5:
          if (!(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 1231 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iwmmxt.md"
(TARGET_REALLY_IWMMXT)))
            return -1;
          return 6777; /* *p iwmmxt_wunpckeluw */

        default:
          return -1;
        }

    case SIGN_EXTEND:
      switch (pattern412 (x1))
        {
        case 0:
          if (!(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 1175 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iwmmxt.md"
(TARGET_REALLY_IWMMXT)))
            return -1;
          return 6772; /* *p iwmmxt_wunpckehsb */

        case 1:
          if (!(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 1243 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iwmmxt.md"
(TARGET_REALLY_IWMMXT)))
            return -1;
          return 6778; /* *p iwmmxt_wunpckelsb */

        case 2:
          if (!(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 1186 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iwmmxt.md"
(TARGET_REALLY_IWMMXT)))
            return -1;
          return 6773; /* *p iwmmxt_wunpckehsh */

        case 3:
          if (!(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 1254 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iwmmxt.md"
(TARGET_REALLY_IWMMXT)))
            return -1;
          return 6779; /* *p iwmmxt_wunpckelsh */

        case 4:
          if (!(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 1197 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iwmmxt.md"
(TARGET_REALLY_IWMMXT)))
            return -1;
          return 6774; /* *p iwmmxt_wunpckehsw */

        case 5:
          if (!(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 1265 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iwmmxt.md"
(TARGET_REALLY_IWMMXT)))
            return -1;
          return 6780; /* *p iwmmxt_wunpckelsw */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_364 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19, x20, x21, x22, x23, x24, x25;
  rtx x26, x27, x28;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XVECEXP (x2, 0, 0);
  x4 = XEXP (x3, 1);
  x5 = XEXP (x4, 0);
  if (GET_CODE (x5) != MULT
      || GET_MODE (x5) != E_SImode)
    return -1;
  x6 = XVECEXP (x2, 0, 1);
  if (GET_CODE (x6) != SET)
    return -1;
  x7 = XEXP (x4, 1);
  if (!s_register_operand (x7, E_SImode))
    return -1;
  x8 = XEXP (x5, 0);
  switch (GET_CODE (x8))
    {
    case REG:
    case SUBREG:
      operands[4] = x8;
      if (!s_register_operand (operands[4], E_SImode))
        return -1;
      x9 = XEXP (x6, 1);
      if (pattern567 (x9, 
LSHIFTRT, 
E_SImode, 
TRUNCATE, 
PLUS) != 0)
        return -1;
      x10 = XEXP (x9, 0);
      x11 = XEXP (x10, 0);
      x12 = XEXP (x11, 0);
      if (GET_CODE (x12) != PLUS
          || GET_MODE (x12) != E_DImode)
        return -1;
      x13 = XEXP (x12, 0);
      if (GET_CODE (x13) != MULT
          || GET_MODE (x13) != E_DImode)
        return -1;
      x14 = XEXP (x12, 1);
      if (GET_CODE (x14) != ZERO_EXTEND
          || GET_MODE (x14) != E_DImode)
        return -1;
      x15 = XEXP (x11, 1);
      if (x15 != const_int_rtx[MAX_SAVED_CONST_INT + 32])
        return -1;
      x16 = XEXP (x1, 0);
      operands[6] = x16;
      x17 = XEXP (x16, 0);
      operands[7] = x17;
      x18 = XEXP (x5, 1);
      operands[5] = x18;
      if (!s_register_operand (operands[5], E_SImode))
        return -1;
      operands[1] = x7;
      x19 = XEXP (x6, 0);
      operands[2] = x19;
      if (!s_register_operand (operands[2], E_SImode))
        return -1;
      x20 = XEXP (x13, 0);
      if (GET_MODE (x20) != E_DImode)
        return -1;
      x21 = XEXP (x13, 1);
      if (GET_MODE (x21) != E_DImode)
        return -1;
      x22 = XEXP (x9, 1);
      operands[3] = x22;
      if (!s_register_operand (operands[3], E_SImode))
        return -1;
      x23 = XEXP (x14, 0);
      if (!rtx_equal_p (x23, operands[1]))
        return -1;
      switch (GET_CODE (x20))
        {
        case SIGN_EXTEND:
          if (GET_CODE (x21) != SIGN_EXTEND)
            return -1;
          x24 = XEXP (x20, 0);
          if (!rtx_equal_p (x24, operands[4]))
            return -1;
          x25 = XEXP (x21, 0);
          if (!rtx_equal_p (x25, operands[5])
              || !(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 2485 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT)))
            return -1;
          return 6425; /* *p smlal */

        case ZERO_EXTEND:
          if (GET_CODE (x21) != ZERO_EXTEND)
            return -1;
          x24 = XEXP (x20, 0);
          if (!rtx_equal_p (x24, operands[4]))
            return -1;
          x25 = XEXP (x21, 0);
          if (!rtx_equal_p (x25, operands[5])
              || !(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 2485 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT)))
            return -1;
          return 6426; /* *p umlal */

        default:
          return -1;
        }

    case SIGN_EXTEND:
      if (GET_MODE (x8) != E_SImode)
        return -1;
      x18 = XEXP (x5, 1);
      if (GET_CODE (x18) != SIGN_EXTEND
          || GET_MODE (x18) != E_SImode
          || pattern601 (x1, 
E_HImode) != 0)
        return -1;
      x26 = XEXP (x18, 0);
      operands[2] = x26;
      if (!s_register_operand (operands[2], E_HImode))
        return -1;
      operands[3] = x7;
      if (!(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 2618 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_DSP_MULTIPLY)))
        return -1;
      return 6434; /* *p arm_smlabb_setq */

    case ASHIFTRT:
      if (GET_MODE (x8) != E_SImode)
        return -1;
      x27 = XEXP (x8, 1);
      if (x27 != const_int_rtx[MAX_SAVED_CONST_INT + 16]
          || pattern601 (x1, 
E_SImode) != 0)
        return -1;
      x18 = XEXP (x5, 1);
      if (GET_MODE (x18) != E_SImode)
        return -1;
      operands[3] = x7;
      switch (GET_CODE (x18))
        {
        case SIGN_EXTEND:
          x26 = XEXP (x18, 0);
          operands[2] = x26;
          if (!s_register_operand (operands[2], E_HImode)
              || !(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 2666 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_DSP_MULTIPLY)))
            return -1;
          return 6436; /* *p arm_smlatb_setq */

        case ASHIFTRT:
          x28 = XEXP (x18, 1);
          if (x28 != const_int_rtx[MAX_SAVED_CONST_INT + 16])
            return -1;
          x26 = XEXP (x18, 0);
          operands[2] = x26;
          if (!s_register_operand (operands[2], E_SImode)
              || !(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 2716 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_DSP_MULTIPLY)))
            return -1;
          return 6438; /* *p arm_smlatt_setq */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_380 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  switch (XVECLEN (x1, 0))
    {
    case 1:
      switch (XINT (x1, 1))
        {
        case 0:
          x2 = XVECEXP (x1, 0, 0);
          if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
            return -1;
          return 305; /* blockage */

        case 3:
          x2 = XVECEXP (x1, 0, 0);
          if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
            return -1;
          return 391; /* align_4 */

        case 12:
          x2 = XVECEXP (x1, 0, 0);
          if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
            return -1;
          return 392; /* align_8 */

        case 4:
          x2 = XVECEXP (x1, 0, 0);
          if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
            return -1;
          return 393; /* consttable_end */

        case 5:
          x2 = XVECEXP (x1, 0, 0);
          operands[0] = x2;
          return 394; /* consttable_1 */

        case 6:
          x2 = XVECEXP (x1, 0, 0);
          operands[0] = x2;
          return 395; /* consttable_2 */

        case 7:
          x2 = XVECEXP (x1, 0, 0);
          operands[0] = x2;
          return 396; /* consttable_4 */

        case 8:
          x2 = XVECEXP (x1, 0, 0);
          operands[0] = x2;
          return 397; /* consttable_8 */

        case 9:
          x2 = XVECEXP (x1, 0, 0);
          operands[0] = x2;
          return 398; /* consttable_16 */

        case 16:
          if (pnum_clobbers == NULL)
            return -1;
          x2 = XVECEXP (x1, 0, 0);
          operands[0] = x2;
          if (!s_register_operand (operands[0], E_SImode))
            return -1;
          if (
#line 12268 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_ARM))
            {
              *pnum_clobbers = 1;
              return 404; /* arm_eh_return */
            }
          if (
#line 2096 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/thumb1.md"
(TARGET_THUMB1))
            {
              *pnum_clobbers = 1;
              return 1005; /* thumb_eh_return */
            }
          if (!
#line 1239 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/thumb2.md"
(TARGET_THUMB2))
            return -1;
          *pnum_clobbers = 1;
          return 1051; /* thumb2_eh_return */

        case 51:
          x2 = XVECEXP (x1, 0, 0);
          if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + 0]
              || !
#line 13083 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(arm_arch7 || arm_arch8))
            return -1;
          return 513; /* *speculation_barrier_insn */

        case 60:
          x2 = XVECEXP (x1, 0, 0);
          if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + 0]
              || !
#line 13114 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(arm_arch8m_main))
            return -1;
          return 517; /* bti_nop */

        case 56:
          x2 = XVECEXP (x1, 0, 0);
          if (GET_CODE (x2) != MEM
              || GET_MODE (x2) != E_BLKmode)
            return -1;
          x3 = XEXP (x2, 0);
          operands[0] = x3;
          if (!s_register_operand (operands[0], E_SImode)
              || !
#line 1725 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/vfp.md"
(use_cmse && reload_completed))
            return -1;
          return 859; /* lazy_store_multiple_insn */

        case 57:
          x2 = XVECEXP (x1, 0, 0);
          if (GET_CODE (x2) != MEM
              || GET_MODE (x2) != E_BLKmode)
            return -1;
          x3 = XEXP (x2, 0);
          operands[0] = x3;
          if (!s_register_operand (operands[0], E_SImode)
              || !
#line 1735 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/vfp.md"
(use_cmse && reload_completed))
            return -1;
          return 860; /* lazy_load_multiple_insn */

        case 30:
          x2 = XVECEXP (x1, 0, 0);
          operands[0] = x2;
          if (!register_operand (operands[0], E_SImode)
              || !
#line 2116 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/vfp.md"
(TARGET_VFP_BASE))
            return -1;
          return 925; /* set_fpscr */

        case 2:
          x2 = XVECEXP (x1, 0, 0);
          if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + 0]
              || !
#line 2028 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/thumb1.md"
(TARGET_THUMB1))
            return -1;
          return 1001; /* prologue_thumb1_interwork */

        case 1:
          x2 = XVECEXP (x1, 0, 0);
          if (GET_CODE (x2) != RETURN
              || !
#line 2036 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/thumb1.md"
(TARGET_THUMB1))
            return -1;
          return 1002; /* *epilogue_insns */

        case 54:
          if (pnum_clobbers == NULL
              || GET_MODE (x1) != E_SImode)
            return -1;
          x2 = XVECEXP (x1, 0, 0);
          if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + 0]
              || !
#line 1709 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/thumb2.md"
(TARGET_THUMB2 && TARGET_HAVE_FPCXT_CMSE && use_cmse))
            return -1;
          *pnum_clobbers = 1;
          return 1070; /* *clear_apsr */

        default:
          return -1;
        }

    case 6:
      x2 = XVECEXP (x1, 0, 0);
      operands[0] = x2;
      if (!immediate_operand (operands[0], E_SImode))
        return -1;
      x4 = XVECEXP (x1, 0, 1);
      operands[1] = x4;
      if (!immediate_operand (operands[1], E_SImode))
        return -1;
      x5 = XVECEXP (x1, 0, 2);
      operands[2] = x5;
      if (!immediate_operand (operands[2], E_SImode))
        return -1;
      x6 = XVECEXP (x1, 0, 3);
      operands[3] = x6;
      if (!immediate_operand (operands[3], E_SImode))
        return -1;
      x7 = XVECEXP (x1, 0, 4);
      operands[4] = x7;
      if (!immediate_operand (operands[4], E_SImode))
        return -1;
      x8 = XVECEXP (x1, 0, 5);
      operands[5] = x8;
      if (!immediate_operand (operands[5], E_SImode))
        return -1;
      switch (XINT (x1, 1))
        {
        case 33:
          if (!
#line 12941 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(arm_coproc_builtin_available (VUNSPEC_CDP)))
            return -1;
          return 495; /* arm_cdp */

        case 34:
          if (!
#line 12941 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(arm_coproc_builtin_available (VUNSPEC_CDP2)))
            return -1;
          return 496; /* arm_cdp2 */

        default:
          return -1;
        }

    case 3:
      switch (XINT (x1, 1))
        {
        case 35:
          x2 = XVECEXP (x1, 0, 0);
          operands[0] = x2;
          if (!immediate_operand (operands[0], E_SImode))
            return -1;
          x4 = XVECEXP (x1, 0, 1);
          operands[1] = x4;
          if (!immediate_operand (operands[1], E_SImode))
            return -1;
          x5 = XVECEXP (x1, 0, 2);
          operands[2] = x5;
          if (!memory_operand (operands[2], E_SImode)
              || !
#line 12958 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(arm_coproc_builtin_available (VUNSPEC_LDC)))
            return -1;
          return 497; /* *ldc */

        case 36:
          x2 = XVECEXP (x1, 0, 0);
          operands[0] = x2;
          if (!immediate_operand (operands[0], E_SImode))
            return -1;
          x4 = XVECEXP (x1, 0, 1);
          operands[1] = x4;
          if (!immediate_operand (operands[1], E_SImode))
            return -1;
          x5 = XVECEXP (x1, 0, 2);
          operands[2] = x5;
          if (!memory_operand (operands[2], E_SImode)
              || !
#line 12958 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(arm_coproc_builtin_available (VUNSPEC_LDC2)))
            return -1;
          return 498; /* *ldc */

        case 37:
          x2 = XVECEXP (x1, 0, 0);
          operands[0] = x2;
          if (!immediate_operand (operands[0], E_SImode))
            return -1;
          x4 = XVECEXP (x1, 0, 1);
          operands[1] = x4;
          if (!immediate_operand (operands[1], E_SImode))
            return -1;
          x5 = XVECEXP (x1, 0, 2);
          operands[2] = x5;
          if (!memory_operand (operands[2], E_SImode)
              || !
#line 12958 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(arm_coproc_builtin_available (VUNSPEC_LDCL)))
            return -1;
          return 499; /* *ldc */

        case 38:
          x2 = XVECEXP (x1, 0, 0);
          operands[0] = x2;
          if (!immediate_operand (operands[0], E_SImode))
            return -1;
          x4 = XVECEXP (x1, 0, 1);
          operands[1] = x4;
          if (!immediate_operand (operands[1], E_SImode))
            return -1;
          x5 = XVECEXP (x1, 0, 2);
          operands[2] = x5;
          if (!memory_operand (operands[2], E_SImode)
              || !
#line 12958 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(arm_coproc_builtin_available (VUNSPEC_LDC2L)))
            return -1;
          return 500; /* *ldc */

        case 39:
          x2 = XVECEXP (x1, 0, 0);
          operands[0] = x2;
          if (!immediate_operand (operands[0], E_SImode))
            return -1;
          x4 = XVECEXP (x1, 0, 1);
          operands[1] = x4;
          if (!immediate_operand (operands[1], E_SImode))
            return -1;
          x5 = XVECEXP (x1, 0, 2);
          operands[2] = x5;
          if (!memory_operand (operands[2], E_SImode)
              || !
#line 12971 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(arm_coproc_builtin_available (VUNSPEC_STC)))
            return -1;
          return 501; /* *stc */

        case 40:
          x2 = XVECEXP (x1, 0, 0);
          operands[0] = x2;
          if (!immediate_operand (operands[0], E_SImode))
            return -1;
          x4 = XVECEXP (x1, 0, 1);
          operands[1] = x4;
          if (!immediate_operand (operands[1], E_SImode))
            return -1;
          x5 = XVECEXP (x1, 0, 2);
          operands[2] = x5;
          if (!memory_operand (operands[2], E_SImode)
              || !
#line 12971 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(arm_coproc_builtin_available (VUNSPEC_STC2)))
            return -1;
          return 502; /* *stc */

        case 41:
          x2 = XVECEXP (x1, 0, 0);
          operands[0] = x2;
          if (!immediate_operand (operands[0], E_SImode))
            return -1;
          x4 = XVECEXP (x1, 0, 1);
          operands[1] = x4;
          if (!immediate_operand (operands[1], E_SImode))
            return -1;
          x5 = XVECEXP (x1, 0, 2);
          operands[2] = x5;
          if (!memory_operand (operands[2], E_SImode)
              || !
#line 12971 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(arm_coproc_builtin_available (VUNSPEC_STCL)))
            return -1;
          return 503; /* *stc */

        case 42:
          x2 = XVECEXP (x1, 0, 0);
          operands[0] = x2;
          if (!immediate_operand (operands[0], E_SImode))
            return -1;
          x4 = XVECEXP (x1, 0, 1);
          operands[1] = x4;
          if (!immediate_operand (operands[1], E_SImode))
            return -1;
          x5 = XVECEXP (x1, 0, 2);
          operands[2] = x5;
          if (!memory_operand (operands[2], E_SImode)
              || !
#line 12971 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(arm_coproc_builtin_available (VUNSPEC_STC2L)))
            return -1;
          return 504; /* *stc */

        case 59:
          if (GET_MODE (x1) != E_SImode)
            return -1;
          x2 = XVECEXP (x1, 0, 0);
          if (GET_CODE (x2) != REG
              || REGNO (x2) != 12
              || GET_MODE (x2) != E_SImode)
            return -1;
          x4 = XVECEXP (x1, 0, 1);
          if (GET_CODE (x4) != REG
              || REGNO (x4) != 13
              || GET_MODE (x4) != E_SImode)
            return -1;
          x5 = XVECEXP (x1, 0, 2);
          if (GET_CODE (x5) != REG
              || REGNO (x5) != 14
              || GET_MODE (x5) != E_SImode
              || !
#line 13108 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(arm_arch8m_main))
            return -1;
          return 516; /* aut_nop */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 rtx_insn *
split_4 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  if (GET_MODE (x3) != E_SImode)
    return NULL;
  x4 = XEXP (x3, 1);
  if (!minmax_operator (x4, E_SImode))
    return NULL;
  operands[4] = x4;
  x5 = XVECEXP (x1, 0, 1);
  x6 = XEXP (x5, 0);
  if (GET_CODE (x6) != REG
      || REGNO (x6) != 100
      || GET_MODE (x6) != E_CCmode)
    return NULL;
  x7 = XEXP (x3, 0);
  operands[1] = x7;
  if (!s_register_operand (operands[1], E_SImode))
    return NULL;
  x8 = XEXP (x4, 0);
  operands[2] = x8;
  if (!s_register_operand (operands[2], E_SImode))
    return NULL;
  x9 = XEXP (x4, 1);
  operands[3] = x9;
  if (!arm_rhs_operand (operands[3], E_SImode)
      || !
#line 4304 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT && !arm_eliminable_register (operands[1]) && reload_completed))
    return NULL;
  return gen_split_26 (insn, operands);
}

 rtx_insn *
split_5 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  if (GET_MODE (x3) != E_SImode)
    return NULL;
  x4 = XEXP (x3, 0);
  if (GET_CODE (x4) != ASHIFT
      || GET_MODE (x4) != E_SImode)
    return NULL;
  x5 = XEXP (x3, 1);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + -1])
    return NULL;
  x6 = XEXP (x4, 0);
  operands[1] = x6;
  if (!const_int_operand (operands[1], E_SImode))
    return NULL;
  x7 = XEXP (x4, 1);
  operands[2] = x7;
  if (!s_register_operand (operands[2], E_SImode))
    return NULL;
  x8 = XVECEXP (x1, 0, 1);
  x9 = XEXP (x8, 0);
  operands[3] = x9;
  if (!s_register_operand (operands[3], E_SImode)
      || !
#line 1895 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT))
    return NULL;
  return gen_split_2 (insn, operands);
}

 rtx_insn *
split_7 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  if (GET_MODE (x3) == E_SImode)
    {
      res = split_6 (x1, insn);
      if (res != NULL_RTX)
        return res;
    }
  operands[1] = x3;
  if (!logical_binary_operator (operands[1], E_SImode))
    return NULL;
  x4 = XVECEXP (x1, 0, 1);
  x5 = XEXP (x4, 0);
  operands[8] = x5;
  if (!s_register_operand (operands[8], E_SImode))
    return NULL;
  x6 = XEXP (x3, 0);
  switch (GET_CODE (x6))
    {
    case ZERO_EXTRACT:
      if (pattern550 (x3, 
LSHIFTRT) != 0
          || !
#line 3949 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && GET_CODE (operands[1]) == GET_CODE (operands[9])
   && INTVAL (operands[3]) == 32 - INTVAL (operands[6])))
        return NULL;
      return gen_split_18 (insn, operands);

    case AND:
    case IOR:
    case XOR:
      operands[9] = x6;
      if (!logical_binary_operator (operands[9], E_SImode))
        return NULL;
      x7 = XEXP (x6, 0);
      if (GET_MODE (x7) != E_SImode)
        return NULL;
      x8 = XEXP (x6, 1);
      operands[7] = x8;
      if (!s_register_operand (operands[7], E_SImode))
        return NULL;
      x9 = XEXP (x3, 1);
      if (GET_MODE (x9) != E_SImode)
        return NULL;
      switch (GET_CODE (x7))
        {
        case LSHIFTRT:
          if (pattern612 (x3, 
ZERO_EXTRACT) != 0
              || !
#line 3975 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && GET_CODE (operands[1]) == GET_CODE (operands[9])
   && INTVAL (operands[3]) == 32 - INTVAL (operands[6])))
            return NULL;
          return gen_split_19 (insn, operands);

        case ASHIFTRT:
          if (pattern612 (x3, 
SIGN_EXTRACT) != 0
              || !
#line 4027 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && GET_CODE (operands[1]) == GET_CODE (operands[9])
   && INTVAL (operands[3]) == 32 - INTVAL (operands[6])))
            return NULL;
          return gen_split_21 (insn, operands);

        default:
          return NULL;
        }

    case SIGN_EXTRACT:
      if (pattern550 (x3, 
ASHIFTRT) != 0
          || !
#line 4001 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && GET_CODE (operands[1]) == GET_CODE (operands[9])
   && INTVAL (operands[3]) == 32 - INTVAL (operands[6])))
        return NULL;
      return gen_split_20 (insn, operands);

    default:
      return NULL;
    }
}

 rtx_insn *
split_10 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  switch (GET_CODE (x3))
    {
    case NE:
      x4 = XEXP (x3, 0);
      switch (GET_CODE (x4))
        {
        case ZERO_EXTRACT:
          if (GET_MODE (x4) != E_SImode)
            return NULL;
          x5 = XEXP (x4, 2);
          if (GET_CODE (x5) != CONST_INT)
            return NULL;
          operands[3] = x5;
          if (const_int_operand (operands[3], E_SImode))
            {
              x6 = XEXP (x3, 1);
              if (x6 == const_int_rtx[MAX_SAVED_CONST_INT + 0])
                {
                  x7 = XEXP (x4, 0);
                  operands[1] = x7;
                  if (s_register_operand (operands[1], E_SImode))
                    {
                      x8 = XEXP (x4, 1);
                      operands[2] = x8;
                      if (const_int_operand (operands[2], E_SImode)
                          && 
#line 3122 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (INTVAL (operands[3]) >= 0 && INTVAL (operands[3]) < 32
       && INTVAL (operands[2]) > 0 
       && INTVAL (operands[2]) + (INTVAL (operands[3]) & 1) <= 8
       && INTVAL (operands[2]) + INTVAL (operands[3]) <= 32)))
                        return gen_split_7 (insn, operands);
                    }
                }
            }
          if (XWINT (x5, 0) != 0L)
            return NULL;
          x6 = XEXP (x3, 1);
          if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
            return NULL;
          x7 = XEXP (x4, 0);
          operands[1] = x7;
          if (!s_register_operand (operands[1], E_SImode))
            return NULL;
          x8 = XEXP (x4, 1);
          operands[2] = x8;
          if (!const_int_operand (operands[2], E_SImode)
              || !
#line 3156 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_ARM))
            return NULL;
          return gen_split_8 (insn, operands);

        case REG:
        case SUBREG:
          operands[1] = x4;
          if (!s_register_operand (operands[1], E_SImode))
            return NULL;
          x6 = XEXP (x3, 1);
          operands[2] = x6;
          if (const_int_operand (operands[2], E_SImode)
              && 
#line 9914 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT && reload_completed))
            return gen_split_84 (insn, operands);
          if (!arm_add_operand (operands[2], E_SImode)
              || !
#line 9930 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT && reload_completed))
            return NULL;
          return gen_split_85 (insn, operands);

        default:
          return NULL;
        }

    case LT:
      x6 = XEXP (x3, 1);
      if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return NULL;
      x4 = XEXP (x3, 0);
      operands[1] = x4;
      if (!s_register_operand (operands[1], E_SImode)
          || !
#line 9873 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT && reload_completed))
        return NULL;
      return gen_split_80 (insn, operands);

    case GE:
      x6 = XEXP (x3, 1);
      if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return NULL;
      x4 = XEXP (x3, 0);
      operands[1] = x4;
      if (!s_register_operand (operands[1], E_SImode)
          || !
#line 9881 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT && reload_completed))
        return NULL;
      return gen_split_81 (insn, operands);

    case EQ:
      x6 = XEXP (x3, 1);
      if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return NULL;
      x4 = XEXP (x3, 0);
      operands[1] = x4;
      if (!s_register_operand (operands[1], E_SImode))
        return NULL;
      if (
#line 9890 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(arm_arch5t && TARGET_32BIT))
        return gen_split_82 (insn, operands);
      if (!
#line 9900 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT && reload_completed))
        return NULL;
      return gen_split_83 (insn, operands);

    default:
      return NULL;
    }
}

 rtx_insn *
peephole2_7 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pmatch_len_ ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = PATTERN (peep2_next_insn (1));
  x3 = XEXP (x2, 0);
  operands[1] = x3;
  if (!arm_general_register_operand (operands[1], E_SImode))
    return NULL;
  x4 = XEXP (x2, 1);
  operands[3] = x4;
  if (!memory_operand (operands[3], E_SImode))
    return NULL;
  x5 = PATTERN (peep2_next_insn (2));
  switch (GET_CODE (x5))
    {
    case SET:
      x6 = XEXP (x5, 1);
      if (!commutative_binary_operator (x6, E_SImode))
        return NULL;
      operands[5] = x6;
      x7 = XEXP (x5, 0);
      operands[4] = x7;
      if (!arm_general_register_operand (operands[4], E_SImode))
        return NULL;
      x8 = XEXP (x6, 0);
      operands[6] = x8;
      if (!arm_general_register_operand (operands[6], E_VOIDmode))
        return NULL;
      x9 = XEXP (x6, 1);
      operands[7] = x9;
      if (!arm_general_register_operand (operands[7], E_VOIDmode)
          || !
#line 109 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/ldrdstrd.md"
(TARGET_LDRD && TARGET_ARM
   && (  ((rtx_equal_p(operands[0], operands[6])) && (rtx_equal_p(operands[1], operands[7])))
	||((rtx_equal_p(operands[0], operands[7])) && (rtx_equal_p(operands[1], operands[6]))))
   && (peep2_reg_dead_p (3, operands[0]) || rtx_equal_p (operands[0], operands[4]))
   && (peep2_reg_dead_p (3, operands[1]) || rtx_equal_p (operands[1], operands[4]))))
        return NULL;
      *pmatch_len_ = 2;
      return gen_peephole2_17 (insn, operands);

    case PARALLEL:
      if (pattern570 (x5) != 0
          || !arm_general_register_operand (operands[4], E_SImode))
        return NULL;
      x10 = XVECEXP (x5, 0, 0);
      x11 = XEXP (x10, 1);
      x12 = XEXP (x11, 0);
      operands[6] = x12;
      if (!arm_general_register_operand (operands[6], E_VOIDmode))
        return NULL;
      x13 = XEXP (x11, 1);
      operands[7] = x13;
      if (!arm_general_register_operand (operands[7], E_VOIDmode)
          || !
#line 134 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/ldrdstrd.md"
(TARGET_LDRD && TARGET_ARM
   && (  ((rtx_equal_p(operands[0], operands[6])) && (rtx_equal_p(operands[1], operands[7])))
       ||((rtx_equal_p(operands[0], operands[7])) && (rtx_equal_p(operands[1], operands[6]))))
   && (peep2_reg_dead_p (3, operands[0]) || rtx_equal_p (operands[0], operands[4]))
   && (peep2_reg_dead_p (3, operands[1]) || rtx_equal_p (operands[1], operands[4]))))
        return NULL;
      *pmatch_len_ = 2;
      return gen_peephole2_18 (insn, operands);

    default:
      return NULL;
    }
}

 rtx_insn *
peephole2_14 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pmatch_len_ ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx_insn *res ATTRIBUTE_UNUSED;
  if (peep2_current_count < 4)
    return NULL;
  x2 = PATTERN (peep2_next_insn (1));
  if (GET_CODE (x2) != SET)
    return NULL;
  x3 = PATTERN (peep2_next_insn (2));
  if (GET_CODE (x3) != SET)
    return NULL;
  x4 = PATTERN (peep2_next_insn (3));
  if (GET_CODE (x4) != SET)
    return NULL;
  if (arm_general_register_operand (operands[0], E_SImode))
    {
      res = peephole2_11 (x1, insn, pmatch_len_);
      if (res != NULL_RTX)
        return res;
    }
  if (!s_register_operand (operands[0], E_SImode))
    return NULL;
  if (peep2_current_count >= 5)
    {
      res = peephole2_13 (x1, insn, pmatch_len_);
      if (res != NULL_RTX)
        return res;
    }
  x5 = XEXP (x1, 1);
  operands[4] = x5;
  switch (pattern494 (x2))
    {
    case 0:
      if (!s_register_operand (operands[1], E_SImode))
        return NULL;
      x6 = XEXP (x3, 1);
      operands[5] = x6;
      if (!const_int_operand (operands[5], E_SImode))
        return NULL;
      x7 = XEXP (x4, 1);
      if (!rtx_equal_p (x7, operands[1]))
        return NULL;
      *pmatch_len_ = 3;
      return gen_peephole2_30 (insn, operands);

    case 1:
      x8 = XEXP (x2, 0);
      operands[1] = x8;
      if (!s_register_operand (operands[1], E_SImode))
        return NULL;
      x9 = XEXP (x3, 0);
      operands[2] = x9;
      if (!memory_operand (operands[2], E_SImode))
        return NULL;
      x6 = XEXP (x3, 1);
      if (!rtx_equal_p (x6, operands[0]))
        return NULL;
      x7 = XEXP (x4, 1);
      if (!rtx_equal_p (x7, operands[1]))
        return NULL;
      *pmatch_len_ = 3;
      return gen_peephole2_31 (insn, operands);

    default:
      return NULL;
    }
}
