/* Generated automatically by the program `genrecog' from the target
   machine description file.  */

#define IN_TARGET_CODE 1

#include "config.h"
#include "system.h"
#include "coretypes.h"
#include "backend.h"
#include "predict.h"
#include "rtl.h"
#include "memmodel.h"
#include "tm_p.h"
#include "emit-rtl.h"
#include "insn-config.h"
#include "recog.h"
#include "output.h"
#include "flags.h"
#include "df.h"
#include "resource.h"
#include "diagnostic-core.h"
#include "reload.h"
#include "regs.h"
#include "tm-constrs.h"
#include "insn-recog.h"


/* `recog' contains a decision tree that recognizes whether the rtx
   X0 is a valid instruction.

   recog returns -1 if the rtx is not valid.  If the rtx is valid, recog
   returns a nonnegative number which is the insn code number for the
   pattern that matched.  This is the same as the order in the machine
   description of the entry that matched.  This number can be used as an
   index into `insn_data' and other tables.
   The third parameter to recog is an optional pointer to an int.  If
   present, recog will accept a pattern if it matches except for missing
   CLOBBER expressions at the end.  In that case, the value pointed to by
   the optional pointer will be set to the number of CLOBBERs that need
   to be added (it should be initialized to zero by the caller).  If it   is set nonzero, the caller should allocate a PARALLEL of the
   appropriate size, copy the initial entries, and call add_clobbers
   (found in insn-emit.cc) to fill in the CLOBBERs.

   The function split_insns returns 0 if the rtl could not
   be split or the split rtl as an INSN list if it can be.

   The function peephole2_insns returns 0 if the rtl could not
   be matched. If there was a match, the new rtl is returned in an INSN list,
   and LAST_INSN will point to the last recognized insn in the old sequence.
*/




int
pattern4 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  operands[1] = x4;
  x5 = XEXP (x3, 1);
  operands[2] = x5;
  switch (GET_MODE (operands[0]))
    {
    case E_V8QImode:
      if (GET_MODE (x3) != E_V8QImode)
        return -1;
      return 0;

    case E_V4HImode:
      if (GET_MODE (x3) != E_V4HImode)
        return -1;
      return 1;

    case E_V2SImode:
      if (GET_MODE (x3) != E_V2SImode)
        return -1;
      return 2;

    case E_V2SFmode:
      if (pattern1 (x3, 
E_V2SFmode) != 0)
        return -1;
      return 3;

    case E_V4UQQmode:
      if (pattern1 (x3, 
E_V4UQQmode) != 0)
        return -1;
      return 4;

    case E_V2UHQmode:
      if (pattern1 (x3, 
E_V2UHQmode) != 0)
        return -1;
      return 5;

    case E_UQQmode:
      if (pattern1 (x3, 
E_UQQmode) != 0)
        return -1;
      return 6;

    case E_UHQmode:
      if (pattern1 (x3, 
E_UHQmode) != 0)
        return -1;
      return 7;

    case E_V2UHAmode:
      if (pattern1 (x3, 
E_V2UHAmode) != 0)
        return -1;
      return 8;

    case E_UHAmode:
      if (pattern1 (x3, 
E_UHAmode) != 0)
        return -1;
      return 9;

    default:
      return -1;
    }
}

int
pattern21 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  x3 = XEXP (x2, 1);
  x4 = XVECEXP (x3, 0, 0);
  if (!rtx_equal_p (x4, operands[1]))
    return -1;
  x5 = XVECEXP (x3, 0, 1);
  if (!rtx_equal_p (x5, operands[2]))
    return -1;
  x6 = XEXP (x2, 0);
  if (!rtx_equal_p (x6, operands[1]))
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_QImode:
      return pattern20 (x1, 
E_QImode); /* [-1, 0] */

    case E_HImode:
      if (pattern20 (x1, 
E_HImode) != 0)
        return -1;
      return 1;

    case E_SImode:
      if (pattern20 (x1, 
E_SImode) != 0)
        return -1;
      return 2;

    case E_DImode:
      if (!s_register_operand (operands[0], E_DImode))
        return -1;
      x7 = XVECEXP (x1, 0, 0);
      x8 = XEXP (x7, 1);
      if (GET_MODE (x8) != E_DImode
          || !mem_noofs_operand (operands[1], E_DImode)
          || !s_register_operand (operands[2], E_DImode)
          || GET_MODE (x3) != E_DImode)
        return -1;
      return 3;

    default:
      return -1;
    }
}

int
pattern37 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  x5 = XVECEXP (x3, 0, 1);
  operands[2] = x5;
  x6 = XVECEXP (x3, 0, 2);
  operands[3] = x6;
  switch (GET_MODE (operands[0]))
    {
    case E_V4HImode:
      return pattern33 (x3, 
E_V4HImode); /* [-1, 0] */

    case E_V2SImode:
      if (pattern33 (x3, 
E_V2SImode) != 0)
        return -1;
      return 1;

    case E_V8HImode:
      if (pattern33 (x3, 
E_V8HImode) != 0)
        return -1;
      return 2;

    case E_V4SImode:
      if (pattern33 (x3, 
E_V4SImode) != 0)
        return -1;
      return 3;

    default:
      return -1;
    }
}

int
pattern49 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != E_V4SImode)
    return -1;
  x3 = XVECEXP (x2, 0, 1);
  if (GET_CODE (x3) != VEC_SELECT
      || GET_MODE (x3) != E_SImode)
    return -1;
  x4 = XEXP (x3, 1);
  if (GET_CODE (x4) != PARALLEL
      || XVECLEN (x4, 0) != 1)
    return -1;
  x5 = XEXP (x1, 0);
  operands[0] = x5;
  if (!register_operand (operands[0], E_V4SImode))
    return -1;
  x6 = XVECEXP (x2, 0, 0);
  operands[1] = x6;
  if (!register_operand (operands[1], E_V4SImode))
    return -1;
  x7 = XEXP (x3, 0);
  operands[2] = x7;
  if (!register_operand (operands[2], E_V4SImode))
    return -1;
  x8 = XVECEXP (x4, 0, 0);
  operands[4] = x8;
  if (!immediate_operand (operands[4], E_SImode))
    return -1;
  x9 = XVECEXP (x2, 0, 2);
  operands[3] = x9;
  if (!register_operand (operands[3], E_V4SImode))
    return -1;
  return 0;
}

int
pattern60 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!s_register_operand (operands[0], i2)
      || GET_MODE (x1) != i2
      || !s_register_operand (operands[1], i2)
      || !s_register_operand (operands[2], i2)
      || !vpr_register_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern68 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != E_SImode)
    return -1;
  x3 = XEXP (x1, 0);
  operands[0] = x3;
  if (!s_register_operand (operands[0], E_SImode))
    return -1;
  x4 = XVECEXP (x2, 0, 0);
  operands[1] = x4;
  x5 = XVECEXP (x2, 0, 1);
  operands[2] = x5;
  x6 = XVECEXP (x2, 0, 2);
  operands[3] = x6;
  switch (GET_MODE (operands[1]))
    {
    case E_V16QImode:
      if (!s_register_operand (operands[1], E_V16QImode)
          || !s_register_operand (operands[2], E_V16QImode)
          || !vpr_register_operand (operands[3], E_V16BImode))
        return -1;
      return 0;

    case E_V8HImode:
      if (!s_register_operand (operands[1], E_V8HImode)
          || !s_register_operand (operands[2], E_V8HImode)
          || !vpr_register_operand (operands[3], E_V8BImode))
        return -1;
      return 1;

    case E_V4SImode:
      if (!s_register_operand (operands[1], E_V4SImode)
          || !s_register_operand (operands[2], E_V4SImode)
          || !vpr_register_operand (operands[3], E_V4BImode))
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern83 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != E_DImode)
    return -1;
  x3 = XEXP (x1, 0);
  operands[0] = x3;
  if (!s_register_operand (operands[0], E_DImode))
    return -1;
  x4 = XVECEXP (x2, 0, 0);
  operands[1] = x4;
  if (!s_register_operand (operands[1], E_DImode))
    return -1;
  x5 = XVECEXP (x2, 0, 1);
  operands[2] = x5;
  x6 = XVECEXP (x2, 0, 2);
  operands[3] = x6;
  switch (GET_MODE (operands[2]))
    {
    case E_V8HImode:
      if (!s_register_operand (operands[2], E_V8HImode)
          || !s_register_operand (operands[3], E_V8HImode))
        return -1;
      return 0;

    case E_V4SImode:
      if (!s_register_operand (operands[2], E_V4SImode)
          || !s_register_operand (operands[3], E_V4SImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern97 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  switch (GET_MODE (operands[0]))
    {
    case E_HFmode:
      if (!s_register_operand (operands[0], E_HFmode)
          || GET_MODE (x3) != E_HFmode
          || !s_register_operand (operands[1], E_HFmode))
        return -1;
      return 0;

    case E_V8HFmode:
      if (!s_register_operand (operands[0], E_V8HFmode)
          || GET_MODE (x3) != E_V8HFmode
          || !s_register_operand (operands[1], E_V8HFmode))
        return -1;
      return 1;

    case E_V4HFmode:
      if (!s_register_operand (operands[0], E_V4HFmode)
          || GET_MODE (x3) != E_V4HFmode
          || !s_register_operand (operands[1], E_V4HFmode))
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern110 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  return pattern109 (x3); /* [-1, 2] */
}

int
pattern114 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  return pattern113 (x3); /* [-1, 1] */
}

int
pattern115 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  switch (GET_MODE (operands[0]))
    {
    case E_V8HFmode:
      if (!s_register_operand (operands[0], E_V8HFmode)
          || GET_MODE (x3) != E_V8HFmode
          || !s_register_operand (operands[1], E_V8HImode))
        return -1;
      return 0;

    case E_V4SFmode:
      if (!s_register_operand (operands[0], E_V4SFmode)
          || GET_MODE (x3) != E_V4SFmode
          || !s_register_operand (operands[1], E_V4SImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern125 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != E_SImode)
    return -1;
  x3 = XVECEXP (x2, 0, 0);
  if (GET_CODE (x3) != REG
      || REGNO (x3) != 13
      || GET_MODE (x3) != E_SImode)
    return -1;
  x4 = XVECEXP (x2, 0, 1);
  if (GET_CODE (x4) != REG
      || REGNO (x4) != 14
      || GET_MODE (x4) != E_SImode)
    return -1;
  x5 = XEXP (x1, 0);
  if (GET_CODE (x5) != REG
      || REGNO (x5) != 12
      || GET_MODE (x5) != E_SImode)
    return -1;
  return 0;
}

int
pattern136 (rtx x1, machine_mode i1, machine_mode i2, machine_mode i3)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  x5 = XVECEXP (x3, 0, 1);
  operands[2] = x5;
  switch (GET_MODE (operands[0]))
    {
    case E_V8HImode:
      return pattern39 (x3, 
i1, 
E_V8HImode); /* [-1, 0] */

    case E_V4SImode:
      if (pattern39 (x3, 
i2, 
E_V4SImode) != 0)
        return -1;
      return 1;

    case E_V2DImode:
      if (pattern39 (x3, 
i3, 
E_V2DImode) != 0)
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern144 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  x5 = XVECEXP (x3, 0, 1);
  operands[2] = x5;
  switch (GET_MODE (operands[0]))
    {
    case E_V2SImode:
      return pattern143 (x3, 
E_V2SFmode, 
E_V2SImode); /* [-1, 0] */

    case E_V4SImode:
      if (pattern143 (x3, 
E_V4SFmode, 
E_V4SImode) != 0)
        return -1;
      return 1;

    case E_V8HImode:
      if (pattern143 (x3, 
E_V8HFmode, 
E_V8HImode) != 0)
        return -1;
      return 2;

    case E_V4HImode:
      if (pattern143 (x3, 
E_V4HFmode, 
E_V4HImode) != 0)
        return -1;
      return 3;

    default:
      return -1;
    }
}

int
pattern154 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  x5 = XVECEXP (x3, 0, 1);
  operands[2] = x5;
  if (!immediate_operand (operands[2], E_SImode))
    return -1;
  return pattern109 (x3); /* [-1, 2] */
}

int
pattern159 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != E_OImode)
    return -1;
  x3 = XVECEXP (x2, 0, 1);
  if (GET_CODE (x3) != UNSPEC
      || XVECLEN (x3, 0) != 1
      || XINT (x3, 1) != 335)
    return -1;
  x4 = XVECEXP (x3, 0, 0);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x5 = XEXP (x1, 0);
  operands[0] = x5;
  if (!neon_struct_operand (operands[0], E_OImode))
    return -1;
  x6 = XVECEXP (x2, 0, 0);
  operands[1] = x6;
  if (!s_register_operand (operands[1], E_XImode))
    return -1;
  switch (GET_MODE (x3))
    {
    case E_V16QImode:
      return 0;

    case E_V8HImode:
      return 1;

    case E_V8HFmode:
      return 2;

    case E_V8BFmode:
      return 3;

    case E_V4SImode:
      return 4;

    case E_V4SFmode:
      return 5;

    case E_V2DImode:
      return 6;

    default:
      return -1;
    }
}

int
pattern168 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!s_register_operand (operands[0], i2)
      || GET_MODE (x1) != i2
      || !s_register_operand (operands[1], i1)
      || !mve_imm_32 (operands[2], E_SImode))
    return -1;
  return 0;
}

int
pattern173 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != E_DImode)
    return -1;
  x3 = XEXP (x1, 0);
  operands[0] = x3;
  if (!s_register_operand (operands[0], E_DImode))
    return -1;
  x4 = XVECEXP (x2, 0, 0);
  operands[1] = x4;
  if (!s_register_operand (operands[1], E_V4SImode))
    return -1;
  x5 = XVECEXP (x2, 0, 1);
  operands[2] = x5;
  if (!vpr_register_operand (operands[2], E_V4BImode))
    return -1;
  return 0;
}

int
pattern181 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  x5 = XVECEXP (x3, 0, 1);
  operands[2] = x5;
  if (!immediate_operand (operands[2], E_SImode))
    return -1;
  return pattern116 (x3); /* [-1, 2] */
}

int
pattern186 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  x5 = XVECEXP (x3, 0, 1);
  operands[2] = x5;
  switch (GET_MODE (operands[0]))
    {
    case E_V16QImode:
      return pattern41 (x3, 
E_V8HImode, 
E_V16QImode); /* [-1, 0] */

    case E_V8HImode:
      if (pattern41 (x3, 
E_V4SImode, 
E_V8HImode) != 0)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern195 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != E_DImode)
    return -1;
  x3 = XEXP (x1, 0);
  operands[0] = x3;
  if (!arm_low_register_operand (operands[0], E_DImode))
    return -1;
  x4 = XVECEXP (x2, 0, 0);
  operands[1] = x4;
  if (!arm_low_register_operand (operands[1], E_DImode))
    return -1;
  x5 = XVECEXP (x2, 0, 1);
  operands[2] = x5;
  if (!immediate_operand (operands[2], E_SImode))
    return -1;
  return 0;
}

int
pattern204 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != E_SImode)
    return -1;
  x3 = XEXP (x1, 0);
  operands[0] = x3;
  if (!s_register_operand (operands[0], E_SImode))
    return -1;
  x4 = XVECEXP (x2, 0, 0);
  operands[1] = x4;
  if (!s_register_operand (operands[1], E_SImode))
    return -1;
  x5 = XVECEXP (x2, 0, 1);
  operands[2] = x5;
  x6 = XVECEXP (x2, 0, 2);
  operands[3] = x6;
  x7 = XVECEXP (x2, 0, 3);
  operands[4] = x7;
  switch (GET_MODE (operands[2]))
    {
    case E_V16QImode:
      if (!s_register_operand (operands[2], E_V16QImode)
          || !s_register_operand (operands[3], E_V16QImode)
          || !vpr_register_operand (operands[4], E_V16BImode))
        return -1;
      return 0;

    case E_V8HImode:
      if (!s_register_operand (operands[2], E_V8HImode)
          || !s_register_operand (operands[3], E_V8HImode)
          || !vpr_register_operand (operands[4], E_V8BImode))
        return -1;
      return 1;

    case E_V4SImode:
      if (!s_register_operand (operands[2], E_V4SImode)
          || !s_register_operand (operands[3], E_V4SImode)
          || !vpr_register_operand (operands[4], E_V4BImode))
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern221 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != E_DImode)
    return -1;
  x3 = XEXP (x1, 0);
  operands[0] = x3;
  if (!s_register_operand (operands[0], E_DImode))
    return -1;
  x4 = XVECEXP (x2, 0, 0);
  operands[1] = x4;
  if (!s_register_operand (operands[1], E_DImode))
    return -1;
  x5 = XVECEXP (x2, 0, 1);
  operands[2] = x5;
  x6 = XVECEXP (x2, 0, 2);
  operands[3] = x6;
  x7 = XVECEXP (x2, 0, 3);
  operands[4] = x7;
  switch (GET_MODE (operands[2]))
    {
    case E_V8HImode:
      if (!s_register_operand (operands[2], E_V8HImode)
          || !s_register_operand (operands[3], E_V8HImode)
          || !vpr_register_operand (operands[4], E_V8BImode))
        return -1;
      return 0;

    case E_V4SImode:
      if (!s_register_operand (operands[2], E_V4SImode)
          || !s_register_operand (operands[3], E_V4SImode)
          || !vpr_register_operand (operands[4], E_V4BImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern238 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!s_register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !s_register_operand (operands[1], i2))
    return -1;
  x3 = XEXP (x1, 1);
  if (GET_MODE (x3) != i1)
    return -1;
  return 0;
}

int
pattern246 (rtx x1, machine_mode i1, machine_mode i2, machine_mode i3)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i3)
      || GET_MODE (x1) != i3)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2
      || !register_operand (operands[1], i2)
      || !const_neon_scalar_shift_amount_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern248 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (GET_MODE (x1) != E_SImode)
    return -1;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  if (!s_register_operand (operands[0], E_SImode))
    return -1;
  x3 = XEXP (x1, 1);
  operands[1] = x3;
  if (!const_int_M_operand (operands[1], E_SImode))
    return -1;
  x4 = XEXP (x1, 2);
  operands[2] = x4;
  if (!const_int_M_operand (operands[2], E_SImode))
    return -1;
  return 0;
}

int
pattern255 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  if (GET_MODE (x3) != E_SImode)
    return -1;
  x4 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x4) != CLOBBER)
    return -1;
  x5 = XEXP (x4, 0);
  if (GET_CODE (x5) != REG
      || REGNO (x5) != 100
      || GET_MODE (x5) != E_CCmode)
    return -1;
  x6 = XEXP (x2, 0);
  operands[0] = x6;
  if (!s_register_operand (operands[0], E_SImode))
    return -1;
  x7 = XEXP (x3, 0);
  operands[1] = x7;
  if (!s_register_operand (operands[1], E_SImode))
    return -1;
  x8 = XEXP (x3, 1);
  operands[2] = x8;
  if (!arm_rhs_operand (operands[2], E_SImode))
    return -1;
  return 0;
}

int
pattern262 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  x3 = XEXP (x2, 1);
  switch (GET_CODE (x3))
    {
    case ZERO_EXTEND:
      if (GET_MODE (x3) != E_SImode
          || !s_register_operand (operands[1], E_SImode))
        return -1;
      x4 = XEXP (x3, 0);
      operands[2] = x4;
      if (!arm_add_operand (operands[3], E_SImode))
        return -1;
      x5 = XVECEXP (x1, 0, 2);
      x6 = XEXP (x5, 0);
      if (!rtx_equal_p (x6, operands[2]))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_CC_Zmode:
          return pattern260 (x1, 
E_CC_Zmode); /* [-1, 1] */

        case E_SImode:
          res = pattern260 (x1, 
E_SImode);
          if (res >= 0)
            return res + 2; /* [2, 3] */
          return -1;

        default:
          return -1;
        }

    case MEM:
      operands[2] = x3;
      x5 = XVECEXP (x1, 0, 2);
      x6 = XEXP (x5, 0);
      if (!rtx_equal_p (x6, operands[2]))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_CC_Zmode:
          res = pattern261 (x1, 
E_CC_Zmode);
          if (res >= 0)
            return res + 4; /* [4, 5] */
          return -1;

        case E_SImode:
          res = pattern261 (x1, 
E_SImode);
          if (res >= 0)
            return res + 6; /* [6, 7] */
          return -1;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern276 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != E_SImode
      || !s_register_operand (operands[0], E_SImode)
      || GET_MODE (x1) != E_SImode)
    return -1;
  x3 = XEXP (x2, 0);
  operands[2] = x3;
  if (!s_register_operand (operands[2], E_SImode))
    return -1;
  x4 = XEXP (x2, 1);
  operands[3] = x4;
  if (!power_of_two_operand (operands[3], E_SImode))
    return -1;
  x5 = XEXP (x1, 1);
  operands[1] = x5;
  if (!s_register_operand (operands[1], E_SImode))
    return -1;
  return 0;
}

int
pattern281 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  switch (GET_CODE (x3))
    {
    case REG:
    case SUBREG:
      return pattern279 (x1); /* [-1, 9] */

    case ABS:
      x4 = XEXP (x2, 1);
      if (GET_CODE (x4) != ABS)
        return -1;
      x5 = XEXP (x3, 0);
      operands[1] = x5;
      x6 = XEXP (x4, 0);
      operands[2] = x6;
      switch (GET_MODE (operands[0]))
        {
        case E_V2SImode:
          if (pattern280 (x1, 
E_V2SFmode, 
E_V2SImode) != 0)
            return -1;
          return 10;

        case E_V4SImode:
          if (pattern280 (x1, 
E_V4SFmode, 
E_V4SImode) != 0)
            return -1;
          return 11;

        case E_V8HImode:
          if (pattern280 (x1, 
E_V8HFmode, 
E_V8HImode) != 0)
            return -1;
          return 12;

        case E_V4HImode:
          if (pattern280 (x1, 
E_V4HFmode, 
E_V4HImode) != 0)
            return -1;
          return 13;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern295 (rtx x1, int *pnum_clobbers)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case NE:
    case EQ:
    case GE:
    case GT:
    case LE:
    case LT:
    case GEU:
    case GTU:
    case LEU:
    case LTU:
    case UNORDERED:
    case ORDERED:
    case UNGE:
    case UNGT:
    case UNLE:
    case UNLT:
      operands[3] = x4;
      if (!arm_comparison_operator (operands[3], E_SImode))
        return -1;
      x5 = XEXP (x3, 1);
      if (!arm_comparison_operator (x5, E_SImode))
        return -1;
      operands[6] = x5;
      x6 = XVECEXP (x1, 0, 1);
      if (GET_CODE (x6) != CLOBBER)
        return -1;
      x7 = XEXP (x6, 0);
      if (GET_CODE (x7) != REG
          || REGNO (x7) != 100
          || GET_MODE (x7) != E_CCmode
          || !s_register_operand (operands[0], E_SImode)
          || GET_MODE (x3) != E_SImode
          || pattern291 (x3) != 0)
        return -1;
      return 0;

    case MEM:
      res = pattern294 (x1, pnum_clobbers);
      if (res >= 0)
        return res + 1; /* [1, 4] */
      return -1;

    default:
      return -1;
    }
}

int
pattern308 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2
      || !register_operand (operands[1], i1))
    return -1;
  x3 = XEXP (x1, 1);
  if (GET_MODE (x3) != i2
      || !register_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern314 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[3] = x2;
  x3 = XEXP (x2, 0);
  operands[4] = x3;
  x4 = XEXP (x1, 1);
  x5 = XEXP (x4, 0);
  operands[0] = x5;
  x6 = XEXP (x4, 1);
  x7 = XEXP (x6, 0);
  operands[1] = x7;
  x8 = XEXP (x6, 1);
  operands[2] = x8;
  switch (GET_MODE (operands[0]))
    {
    case E_V8QImode:
      return pattern312 (x6, 
E_V8QImode); /* [-1, 0] */

    case E_V4HImode:
      if (pattern312 (x6, 
E_V4HImode) != 0)
        return -1;
      return 1;

    case E_V2SImode:
      if (pattern312 (x6, 
E_V2SImode) != 0)
        return -1;
      return 2;

    case E_V4UQQmode:
      if (pattern311 (x6, 
E_V4UQQmode) != 0)
        return -1;
      return 3;

    case E_V2UHQmode:
      if (pattern311 (x6, 
E_V2UHQmode) != 0)
        return -1;
      return 4;

    case E_UQQmode:
      if (pattern311 (x6, 
E_UQQmode) != 0)
        return -1;
      return 5;

    case E_UHQmode:
      if (pattern311 (x6, 
E_UHQmode) != 0)
        return -1;
      return 6;

    case E_V2UHAmode:
      if (pattern311 (x6, 
E_V2UHAmode) != 0)
        return -1;
      return 7;

    case E_UHAmode:
      if (pattern311 (x6, 
E_UHAmode) != 0)
        return -1;
      return 8;

    default:
      return -1;
    }
}

int
pattern332 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  if (!s_register_operand (operands[0], E_V4SImode))
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  if (!s_register_operand (operands[1], E_V4SImode))
    return -1;
  x5 = XVECEXP (x3, 0, 1);
  operands[2] = x5;
  if (!s_register_operand (operands[2], E_V4SImode))
    return -1;
  x6 = XVECEXP (x1, 0, 1);
  x7 = XEXP (x6, 1);
  x8 = XVECEXP (x7, 0, 0);
  if (!rtx_equal_p (x8, operands[1]))
    return -1;
  x9 = XVECEXP (x7, 0, 1);
  if (!rtx_equal_p (x9, operands[2]))
    return -1;
  return 0;
}

int
pattern341 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  operands[4] = x4;
  if (!arm_comparison_operator (operands[4], E_VOIDmode))
    return -1;
  x5 = XEXP (x3, 1);
  if (!arm_comparison_operator (x5, E_SImode))
    return -1;
  operands[5] = x5;
  return pattern340 (x1); /* [-1, 0] */
}

int
pattern346 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 0);
  operands[1] = x3;
  switch (GET_MODE (operands[0]))
    {
    case E_V8HImode:
      if (!s_register_operand (operands[0], E_V8HImode)
          || GET_MODE (x1) != E_V8HImode
          || GET_MODE (x2) != E_V8HImode
          || !mve_memory_operand (operands[1], E_V8QImode)
          || !vpr_register_operand (operands[2], E_V8BImode))
        return -1;
      return 0;

    case E_V4SImode:
      if (!s_register_operand (operands[0], E_V4SImode)
          || GET_MODE (x1) != E_V4SImode
          || GET_MODE (x2) != E_V4SImode
          || !vpr_register_operand (operands[2], E_V4BImode))
        return -1;
      switch (GET_MODE (operands[1]))
        {
        case E_V4QImode:
          if (!mve_memory_operand (operands[1], E_V4QImode))
            return -1;
          return 1;

        case E_V4HImode:
          if (!mve_memory_operand (operands[1], E_V4HImode))
            return -1;
          return 2;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern361 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (GET_MODE (x1) != i1)
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_SFmode:
      if (!s_register_operand (operands[0], E_SFmode)
          || !vfp_compare_operand (operands[1], E_SFmode))
        return -1;
      return 0;

    case E_DFmode:
      if (!s_register_operand (operands[0], E_DFmode)
          || !vfp_compare_operand (operands[1], E_DFmode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern372 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!s_register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !s_register_operand (operands[1], i1)
      || !neon_logic_op2 (operands[2], i1))
    return -1;
  return 0;
}

int
pattern377 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  operands[2] = x2;
  switch (GET_MODE (operands[0]))
    {
    case E_SImode:
      return pattern376 (x1); /* [-1, 0] */

    case E_DImode:
      if (pattern312 (x1, 
E_DImode) != 0)
        return -1;
      return 1;

    case E_V2SImode:
      if (pattern312 (x1, 
E_V2SImode) != 0)
        return -1;
      return 2;

    case E_V4HImode:
      if (pattern312 (x1, 
E_V4HImode) != 0)
        return -1;
      return 3;

    case E_V8QImode:
      if (pattern312 (x1, 
E_V8QImode) != 0)
        return -1;
      return 4;

    default:
      return -1;
    }
}

int
pattern388 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x2) != CLOBBER)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != REG
      || REGNO (x3) != 100
      || GET_MODE (x3) != E_CCmode)
    return -1;
  x4 = XVECEXP (x1, 0, 0);
  x5 = XEXP (x4, 1);
  x6 = XEXP (x5, 0);
  operands[1] = x6;
  if (!s_register_operand (operands[1], E_SImode)
      || !arm_rhs_operand (operands[2], E_SImode))
    return -1;
  return 0;
}

int
pattern394 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + 0]
      || !s_register_operand (operands[0], E_SImode)
      || GET_MODE (x1) != E_SImode)
    return -1;
  x3 = XEXP (x1, 0);
  x4 = XEXP (x3, 0);
  operands[1] = x4;
  if (!s_register_operand (operands[1], E_SImode))
    return -1;
  x5 = XEXP (x3, 1);
  operands[2] = x5;
  if (!const_int_operand (operands[2], E_SImode))
    return -1;
  return 0;
}

int
pattern403 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !register_operand (operands[1], i1)
      || !register_operand (operands[2], i1)
      || !register_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern410 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  if (!const_int_operand (operands[2], E_SImode))
    return -1;
  x2 = XEXP (x1, 0);
  operands[4] = x2;
  x3 = XEXP (x2, 0);
  operands[5] = x3;
  x4 = XEXP (x1, 1);
  x5 = XEXP (x4, 0);
  operands[0] = x5;
  if (!s_register_operand (operands[0], E_SImode))
    return -1;
  x6 = XEXP (x4, 1);
  x7 = XEXP (x6, 0);
  operands[1] = x7;
  if (!s_register_operand (operands[1], E_SImode))
    return -1;
  x8 = XEXP (x6, 2);
  operands[3] = x8;
  if (!const_int_operand (operands[3], E_SImode))
    return -1;
  return 0;
}

int
pattern418 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  operands[1] = x4;
  if (!s_register_operand (operands[1], E_SImode))
    return -1;
  x5 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x5) != CLOBBER)
    return -1;
  x6 = XEXP (x5, 0);
  if (GET_CODE (x6) != REG
      || REGNO (x6) != 100
      || GET_MODE (x6) != E_CCmode
      || !arm_rhs_operand (operands[2], E_SImode))
    return -1;
  return 0;
}

int
pattern429 (rtx x1, machine_mode i1, machine_mode i2, machine_mode i3)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!mve_memory_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i1
      || !s_register_operand (operands[1], i3)
      || !vpr_register_operand (operands[2], i2))
    return -1;
  return 0;
}

int
pattern437 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (GET_MODE (x1) != E_DImode)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_CODE (x2) != MULT
      || GET_MODE (x2) != E_DImode)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != SIGN_EXTEND
      || GET_MODE (x3) != E_DImode)
    return -1;
  return 0;
}

int
pattern445 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x2) != SET)
    return -1;
  x3 = XEXP (x2, 1);
  if (GET_CODE (x3) != PLUS
      || GET_MODE (x3) != E_SImode)
    return -1;
  x4 = XVECEXP (x1, 0, 0);
  x5 = XEXP (x4, 1);
  x6 = XEXP (x5, 0);
  if (GET_MODE (x6) != i1)
    return -1;
  return 0;
}

int
pattern449 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != REG
      || REGNO (x3) != 100
      || GET_MODE (x3) != E_CCmode)
    return -1;
  x4 = XVECEXP (x1, 0, 0);
  x5 = XEXP (x4, 0);
  operands[0] = x5;
  if (!s_register_operand (operands[0], E_SImode))
    return -1;
  x6 = XEXP (x4, 1);
  if (GET_MODE (x6) != E_SImode)
    return -1;
  x7 = XEXP (x6, 0);
  x8 = XEXP (x7, 1);
  if (!arm_add_operand (x8, E_SImode))
    return -1;
  return 0;
}

int
pattern461 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 1);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x5 = XEXP (x2, 2);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x6 = XEXP (x1, 0);
  operands[0] = x6;
  if (!s_register_operand (operands[0], E_SImode)
      || GET_MODE (x2) != E_SImode)
    return -1;
  x7 = XEXP (x3, 0);
  x8 = XEXP (x7, 0);
  operands[1] = x8;
  if (!s_register_operand (operands[1], E_SImode))
    return -1;
  x9 = XEXP (x7, 1);
  operands[2] = x9;
  if (!const_int_operand (operands[2], E_SImode))
    return -1;
  return 0;
}

int
pattern476 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 1);
  if (GET_CODE (x4) != SIGN_EXTEND
      || GET_MODE (x4) != E_DImode)
    return -1;
  x5 = XEXP (x4, 0);
  if (GET_CODE (x5) != PLUS
      || GET_MODE (x5) != E_SImode)
    return -1;
  x6 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x6) != SET)
    return -1;
  x7 = XEXP (x6, 1);
  if (GET_CODE (x7) != PLUS
      || GET_MODE (x7) != E_SImode)
    return -1;
  x8 = XEXP (x2, 0);
  if (GET_MODE (x8) != E_CC_Vmode
      || GET_MODE (x3) != E_CC_Vmode)
    return -1;
  x9 = XEXP (x3, 0);
  x10 = XEXP (x9, 0);
  x11 = XEXP (x10, 0);
  operands[1] = x11;
  if (!register_operand (operands[1], E_SImode))
    return -1;
  return 0;
}

int
pattern491 (rtx x1, machine_mode i1, machine_mode i2, machine_mode i3)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i3)
      || GET_MODE (x1) != i3)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2
      || !register_operand (operands[1], i1))
    return -1;
  x3 = XEXP (x1, 1);
  if (GET_MODE (x3) != i2
      || !register_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern498 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  x5 = XEXP (x4, 1);
  if (XWINT (x5, 0) != 0L)
    return -1;
  x6 = XEXP (x3, 2);
  if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x7 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x7) != CLOBBER
      || pattern450 (x1) != 0)
    return -1;
  return 0;
}

int
pattern503 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!neon_struct_operand (operands[0], i2)
      || GET_MODE (x1) != i2
      || !s_register_operand (operands[1], i1))
    return -1;
  x2 = XVECEXP (x1, 0, 2);
  if (GET_MODE (x2) != E_V8QImode)
    return -1;
  return 0;
}

int
pattern507 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (GET_MODE (operands[1]))
    {
    case E_OImode:
      if (!s_register_operand (operands[1], E_OImode)
          || GET_MODE (x1) != i1)
        return -1;
      return 0;

    case E_XImode:
      if (!s_register_operand (operands[1], E_XImode)
          || GET_MODE (x1) != i2)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern516 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !register_operand (operands[2], i2)
      || !register_operand (operands[1], i1))
    return -1;
  switch (GET_MODE (operands[3]))
    {
    case E_V8QImode:
      if (!register_operand (operands[3], E_V8QImode))
        return -1;
      return 0;

    case E_V16QImode:
      if (!register_operand (operands[3], E_V16QImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern531 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (GET_CODE (x1) != SET)
    return -1;
  x2 = XEXP (x1, 1);
  if (GET_CODE (x2) != PLUS
      || GET_MODE (x2) != E_SImode)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != REG
      || REGNO (x3) != 14
      || GET_MODE (x3) != E_SImode)
    return -1;
  return 0;
}

int
pattern540 (rtx x1, machine_mode i1, machine_mode i2, machine_mode i3)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  if (!s_register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i3)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_MODE (x4) != i3
      || !s_register_operand (operands[2], i2))
    return -1;
  x5 = XEXP (x1, 1);
  return pattern518 (x5, 
i1, 
i2, 
i3); /* [-1, 0] */
}

int
pattern548 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  x3 = XEXP (x2, 1);
  if (GET_MODE (x3) != E_SImode)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_CODE (x4) != PLUS
      || GET_MODE (x4) != E_SImode)
    return -1;
  x5 = XEXP (x4, 1);
  if (GET_CODE (x5) != CONST_INT
      || pattern547 (x1) != 0)
    return -1;
  return 0;
}

int
pattern558 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (GET_MODE (x1) != i1)
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_SFmode:
      if (!s_register_operand (operands[0], E_SFmode)
          || !vfp_compare_operand (operands[1], E_SFmode))
        return -1;
      return 0;

    case E_DFmode:
      if (!s_register_operand (operands[0], E_DFmode)
          || !vfp_compare_operand (operands[1], E_DFmode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern566 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !register_operand (operands[1], i1)
      || !register_operand (operands[2], i1))
    return -1;
  x3 = XEXP (x1, 2);
  if (GET_MODE (x3) != i1
      || !register_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern576 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != MEM
      || GET_MODE (x3) != E_SImode)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_CODE (x4) != PLUS
      || GET_MODE (x4) != E_SImode)
    return -1;
  x5 = XEXP (x4, 1);
  if (GET_CODE (x5) != CONST_INT
      || pattern575 (x1) != 0)
    return -1;
  return 0;
}

int
pattern588 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i2
      || !register_operand (operands[1], i1))
    return -1;
  return 0;
}

int
pattern594 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 2);
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != MEM
      || GET_MODE (x3) != E_SImode)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_CODE (x4) != PLUS
      || GET_MODE (x4) != E_SImode)
    return -1;
  x5 = XEXP (x4, 1);
  if (GET_CODE (x5) != CONST_INT)
    return -1;
  x6 = XVECEXP (x1, 0, 3);
  x7 = XEXP (x6, 0);
  if (GET_CODE (x7) != MEM
      || GET_MODE (x7) != E_SImode)
    return -1;
  x8 = XEXP (x7, 0);
  if (GET_CODE (x8) != PLUS
      || GET_MODE (x8) != E_SImode)
    return -1;
  x9 = XEXP (x8, 1);
  if (GET_CODE (x9) != CONST_INT)
    return -1;
  x10 = XVECEXP (x1, 0, 4);
  x11 = XEXP (x10, 0);
  if (GET_CODE (x11) != MEM
      || GET_MODE (x11) != E_SImode)
    return -1;
  return 0;
}

int
pattern606 (rtx x1, int i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  if (GET_MODE (x1) != E_V8HImode)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + i1])
    return -1;
  x3 = XVECEXP (x1, 0, 1);
  if (x3 != const_int_rtx[MAX_SAVED_CONST_INT + i1])
    return -1;
  x4 = XVECEXP (x1, 0, 2);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + i1])
    return -1;
  x5 = XVECEXP (x1, 0, 3);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + i1])
    return -1;
  x6 = XVECEXP (x1, 0, 4);
  if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + i1])
    return -1;
  x7 = XVECEXP (x1, 0, 5);
  if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + i1])
    return -1;
  x8 = XVECEXP (x1, 0, 6);
  if (x8 != const_int_rtx[MAX_SAVED_CONST_INT + i1])
    return -1;
  x9 = XVECEXP (x1, 0, 7);
  if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + i1])
    return -1;
  return 0;
}

int
pattern623 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !register_operand (operands[1], i1))
    return -1;
  x3 = XEXP (x1, 1);
  if (GET_MODE (x3) != i1
      || !register_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern632 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  operands[2] = x4;
  if (!register_operand (operands[2], E_V2SImode))
    return -1;
  x5 = XEXP (x1, 1);
  x6 = XEXP (x5, 0);
  x7 = XEXP (x6, 0);
  operands[3] = x7;
  if (!register_operand (operands[3], E_V2SImode))
    return -1;
  x8 = XEXP (x3, 1);
  x9 = XVECEXP (x8, 0, 0);
  switch (XWINT (x9, 0))
    {
    case 0L:
      x10 = XEXP (x6, 1);
      x11 = XVECEXP (x10, 0, 0);
      switch (XWINT (x11, 0))
        {
        case 0L:
          return 0;

        case 1L:
          return 1;

        default:
          return -1;
        }

    case 1L:
      x10 = XEXP (x6, 1);
      x11 = XVECEXP (x10, 0, 0);
      switch (XWINT (x11, 0))
        {
        case 0L:
          return 2;

        case 1L:
          return 3;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern643 (rtx x1, int i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (GET_CODE (x1) != PLUS
      || GET_MODE (x1) != E_SImode)
    return -1;
  x2 = XEXP (x1, 1);
  if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + i1])
    return -1;
  x3 = XEXP (x1, 0);
  if (!rtx_equal_p (x3, operands[4]))
    return -1;
  return 0;
}

int
pattern649 (rtx x1, int i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (GET_CODE (x1) != PLUS
      || GET_MODE (x1) != E_SImode)
    return -1;
  x2 = XEXP (x1, 1);
  if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + i1])
    return -1;
  x3 = XEXP (x1, 0);
  if (!rtx_equal_p (x3, operands[5]))
    return -1;
  return 0;
}

int
pattern654 (rtx x1, rtx_code i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19, x20, x21;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  if (GET_CODE (x4) != i1)
    return -1;
  x5 = XEXP (x1, 1);
  x6 = XEXP (x5, 0);
  x7 = XEXP (x6, 0);
  if (GET_CODE (x7) != i1)
    return -1;
  x8 = XEXP (x5, 1);
  x9 = XEXP (x8, 0);
  if (GET_CODE (x9) != i1)
    return -1;
  x10 = XEXP (x2, 0);
  x11 = XEXP (x10, 0);
  x12 = XEXP (x11, 0);
  operands[1] = x12;
  if (!register_operand (operands[1], E_V4HImode))
    return -1;
  x13 = XEXP (x4, 0);
  operands[2] = x13;
  if (!register_operand (operands[2], E_V4HImode))
    return -1;
  x14 = XEXP (x7, 0);
  if (!rtx_equal_p (x14, operands[1]))
    return -1;
  x15 = XEXP (x9, 0);
  if (!rtx_equal_p (x15, operands[2]))
    return -1;
  x16 = XEXP (x3, 1);
  x17 = XVECEXP (x16, 0, 0);
  switch (XWINT (x17, 0))
    {
    case 1L:
      x18 = XVECEXP (x16, 0, 1);
      if (XWINT (x18, 0) != 3L)
        return -1;
      x19 = XEXP (x8, 1);
      x20 = XVECEXP (x19, 0, 0);
      if (XWINT (x20, 0) != 0L)
        return -1;
      x21 = XVECEXP (x19, 0, 1);
      if (XWINT (x21, 0) != 2L)
        return -1;
      return 0;

    case 0L:
      x18 = XVECEXP (x16, 0, 1);
      if (XWINT (x18, 0) != 2L)
        return -1;
      x19 = XEXP (x8, 1);
      x20 = XVECEXP (x19, 0, 0);
      if (XWINT (x20, 0) != 1L)
        return -1;
      x21 = XVECEXP (x19, 0, 1);
      if (XWINT (x21, 0) != 3L)
        return -1;
      return 1;

    default:
      return -1;
    }
}

 int
recog_8 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  if (GET_MODE (x4) != E_SImode)
    return -1;
  x5 = XEXP (x3, 1);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x6 = XEXP (x4, 0);
  switch (GET_CODE (x6))
    {
    case REG:
    case SUBREG:
      if (!s_register_operand (x6, E_SImode)
          || pattern289 (x2) != 0)
        return -1;
      x7 = XEXP (x4, 1);
      if (!arm_not_operand (x7, E_SImode))
        return -1;
      x8 = XVECEXP (x1, 0, 1);
      switch (GET_CODE (x8))
        {
        case SET:
          x9 = XEXP (x8, 1);
          if (GET_CODE (x9) != AND
              || GET_MODE (x9) != E_SImode)
            return -1;
          operands[1] = x6;
          operands[2] = x7;
          x10 = XEXP (x8, 0);
          operands[0] = x10;
          if (!s_register_operand (operands[0], E_SImode))
            return -1;
          x11 = XEXP (x9, 0);
          if (!rtx_equal_p (x11, operands[1]))
            return -1;
          x12 = XEXP (x9, 1);
          if (!rtx_equal_p (x12, operands[2])
              || !
#line 3060 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT))
            return -1;
          return 91; /* *andsi3_compare0 */

        case CLOBBER:
          operands[0] = x6;
          operands[1] = x7;
          x10 = XEXP (x8, 0);
          operands[2] = x10;
          if (!scratch_operand (operands[2], E_SImode)
              || !
#line 3076 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT))
            return -1;
          return 92; /* *andsi3_compare0_scratch */

        default:
          return -1;
        }

    case NOT:
      if (GET_MODE (x6) != E_SImode
          || pattern289 (x2) != 0)
        return -1;
      x7 = XEXP (x4, 1);
      if (!s_register_operand (x7, E_SImode))
        return -1;
      x13 = XEXP (x6, 0);
      switch (GET_CODE (x13))
        {
        case MULT:
        case ASHIFT:
        case ROTATE:
        case ASHIFTRT:
        case LSHIFTRT:
        case ROTATERT:
          operands[0] = x13;
          if (!shift_operator (operands[0], E_SImode))
            return -1;
          x14 = XEXP (x13, 0);
          operands[1] = x14;
          if (!s_register_operand (operands[1], E_SImode))
            return -1;
          x15 = XEXP (x13, 1);
          operands[2] = x15;
          if (!shift_amount_operand (operands[2], E_SImode))
            return -1;
          operands[3] = x7;
          x8 = XVECEXP (x1, 0, 1);
          switch (GET_CODE (x8))
            {
            case CLOBBER:
              x10 = XEXP (x8, 0);
              operands[4] = x10;
              if (!scratch_operand (operands[4], E_SImode)
                  || !
#line 3637 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT))
                return -1;
              return 106; /* andsi_not_shiftsi_si_scc_no_reuse */

            case SET:
              x9 = XEXP (x8, 1);
              if (pattern17 (x9, 
NOT, 
AND, 
E_SImode) != 0)
                return -1;
              x11 = XEXP (x9, 0);
              x16 = XEXP (x11, 0);
              switch (GET_CODE (x16))
                {
                case MULT:
                case ASHIFT:
                case ROTATE:
                case ASHIFTRT:
                case LSHIFTRT:
                case ROTATERT:
                  if (!rtx_equal_p (x16, operands[0]))
                    return -1;
                  x10 = XEXP (x8, 0);
                  operands[4] = x10;
                  if (!s_register_operand (operands[4], E_SImode))
                    return -1;
                  x12 = XEXP (x9, 1);
                  if (!rtx_equal_p (x12, operands[3])
                      || !
#line 3661 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT))
                    return -1;
                  return 107; /* andsi_not_shiftsi_si_scc */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        case REG:
        case SUBREG:
          operands[2] = x13;
          if (!s_register_operand (operands[2], E_SImode))
            return -1;
          operands[1] = x7;
          x8 = XVECEXP (x1, 0, 1);
          switch (pattern592 (x8, 
NOT, 
AND))
            {
            case 0:
              x9 = XEXP (x8, 1);
              x12 = XEXP (x9, 1);
              if (!rtx_equal_p (x12, operands[1])
                  || !
#line 3678 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT))
                return -1;
              return 108; /* *andsi_notsi_si_compare0 */

            case 1:
              if (!
#line 3691 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT))
                return -1;
              return 109; /* *andsi_notsi_si_compare0_scratch */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case NE:
    case EQ:
    case GE:
    case GT:
    case LE:
    case LT:
    case GEU:
    case GTU:
    case LEU:
    case LTU:
    case UNORDERED:
    case ORDERED:
    case UNGE:
    case UNGT:
    case UNLE:
    case UNLT:
      if (pattern384 (x1, 
AND) != 0
          || !
#line 10587 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT))
        return -1;
      return 347; /* *and_scc_scc_cmp */

    default:
      return -1;
    }
}

 int
recog_23 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  if (GET_MODE (x3) == E_SImode)
    {
      res = recog_22 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
    }
  if (pnum_clobbers == NULL)
    return -1;
  operands[1] = x3;
  x4 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x4) != SET)
    return -1;
  x5 = XEXP (x4, 1);
  if (GET_CODE (x5) != UNSPEC_VOLATILE
      || XVECLEN (x5, 0) != 2)
    return -1;
  x6 = XEXP (x2, 0);
  operands[0] = x6;
  x7 = XVECEXP (x5, 0, 1);
  operands[3] = x7;
  if (!const_int_operand (operands[3], E_SImode))
    return -1;
  x8 = XEXP (x4, 0);
  if (!rtx_equal_p (x8, operands[1]))
    return -1;
  switch (XINT (x5, 1))
    {
    case 18:
      x9 = XVECEXP (x5, 0, 0);
      operands[2] = x9;
      switch (GET_MODE (operands[0]))
        {
        case E_QImode:
          if (pattern580 (x5, 
E_QImode) != 0
              || !
#line 301 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREXBH && TARGET_HAVE_MEMORY_BARRIER))
            return -1;
          *pnum_clobbers = 2;
          return 3086; /* atomic_exchangeqi */

        case E_HImode:
          if (pattern580 (x5, 
E_HImode) != 0
              || !
#line 301 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREXBH && TARGET_HAVE_MEMORY_BARRIER))
            return -1;
          *pnum_clobbers = 2;
          return 3087; /* atomic_exchangehi */

        case E_DImode:
          if (pattern580 (x5, 
E_DImode) != 0
              || !
#line 301 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREXD && ARM_DOUBLEWORD_ALIGN
	&& TARGET_HAVE_MEMORY_BARRIER))
            return -1;
          *pnum_clobbers = 2;
          return 3089; /* atomic_exchangedi */

        default:
          return -1;
        }

    case 19:
      x9 = XVECEXP (x5, 0, 0);
      switch (GET_CODE (x9))
        {
        case PLUS:
          switch (pattern572 (x5))
            {
            case 0:
              if (!
#line 406 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREXBH && TARGET_HAVE_MEMORY_BARRIER))
                return -1;
              *pnum_clobbers = 3;
              return 3114; /* atomic_fetch_addqi */

            case 1:
              if (!
#line 406 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREXBH && TARGET_HAVE_MEMORY_BARRIER))
                return -1;
              *pnum_clobbers = 3;
              return 3119; /* atomic_fetch_addhi */

            case 2:
              if (!
#line 406 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREXD && ARM_DOUBLEWORD_ALIGN
	&& TARGET_HAVE_MEMORY_BARRIER))
                return -1;
              *pnum_clobbers = 3;
              return 3129; /* atomic_fetch_adddi */

            default:
              return -1;
            }

        case MINUS:
          switch (pattern572 (x5))
            {
            case 0:
              if (!
#line 406 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREXBH && TARGET_HAVE_MEMORY_BARRIER))
                return -1;
              *pnum_clobbers = 3;
              return 3115; /* atomic_fetch_subqi */

            case 1:
              if (!
#line 406 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREXBH && TARGET_HAVE_MEMORY_BARRIER))
                return -1;
              *pnum_clobbers = 3;
              return 3120; /* atomic_fetch_subhi */

            case 2:
              if (!
#line 406 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREXD && ARM_DOUBLEWORD_ALIGN
	&& TARGET_HAVE_MEMORY_BARRIER))
                return -1;
              *pnum_clobbers = 3;
              return 3130; /* atomic_fetch_subdi */

            default:
              return -1;
            }

        case IOR:
          switch (pattern572 (x5))
            {
            case 0:
              if (!
#line 406 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREXBH && TARGET_HAVE_MEMORY_BARRIER))
                return -1;
              *pnum_clobbers = 3;
              return 3116; /* atomic_fetch_orqi */

            case 1:
              if (!
#line 406 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREXBH && TARGET_HAVE_MEMORY_BARRIER))
                return -1;
              *pnum_clobbers = 3;
              return 3121; /* atomic_fetch_orhi */

            case 2:
              if (!
#line 406 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREXD && ARM_DOUBLEWORD_ALIGN
	&& TARGET_HAVE_MEMORY_BARRIER))
                return -1;
              *pnum_clobbers = 3;
              return 3131; /* atomic_fetch_ordi */

            default:
              return -1;
            }

        case XOR:
          switch (pattern572 (x5))
            {
            case 0:
              if (!
#line 406 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREXBH && TARGET_HAVE_MEMORY_BARRIER))
                return -1;
              *pnum_clobbers = 3;
              return 3117; /* atomic_fetch_xorqi */

            case 1:
              if (!
#line 406 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREXBH && TARGET_HAVE_MEMORY_BARRIER))
                return -1;
              *pnum_clobbers = 3;
              return 3122; /* atomic_fetch_xorhi */

            case 2:
              if (!
#line 406 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREXD && ARM_DOUBLEWORD_ALIGN
	&& TARGET_HAVE_MEMORY_BARRIER))
                return -1;
              *pnum_clobbers = 3;
              return 3132; /* atomic_fetch_xordi */

            default:
              return -1;
            }

        case AND:
          switch (pattern572 (x5))
            {
            case 0:
              if (!
#line 406 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREXBH && TARGET_HAVE_MEMORY_BARRIER))
                return -1;
              *pnum_clobbers = 3;
              return 3118; /* atomic_fetch_andqi */

            case 1:
              if (!
#line 406 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREXBH && TARGET_HAVE_MEMORY_BARRIER))
                return -1;
              *pnum_clobbers = 3;
              return 3123; /* atomic_fetch_andhi */

            case 2:
              if (!
#line 406 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREXD && ARM_DOUBLEWORD_ALIGN
	&& TARGET_HAVE_MEMORY_BARRIER))
                return -1;
              *pnum_clobbers = 3;
              return 3133; /* atomic_fetch_anddi */

            default:
              return -1;
            }

        case NOT:
          x10 = XEXP (x9, 0);
          if (GET_CODE (x10) != AND)
            return -1;
          x11 = XEXP (x10, 1);
          operands[2] = x11;
          x12 = XEXP (x10, 0);
          if (!rtx_equal_p (x12, operands[1]))
            return -1;
          switch (GET_MODE (operands[0]))
            {
            case E_QImode:
              if (pattern603 (x5, 
E_QImode) != 0
                  || !
#line 432 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREXBH && TARGET_HAVE_MEMORY_BARRIER))
                return -1;
              *pnum_clobbers = 3;
              return 3134; /* atomic_fetch_nandqi */

            case E_HImode:
              if (pattern603 (x5, 
E_HImode) != 0
                  || !
#line 432 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREXBH && TARGET_HAVE_MEMORY_BARRIER))
                return -1;
              *pnum_clobbers = 3;
              return 3135; /* atomic_fetch_nandhi */

            case E_DImode:
              if (!s_register_operand (operands[0], E_DImode)
                  || !mem_noofs_operand (operands[1], E_DImode)
                  || GET_MODE (x5) != E_DImode
                  || GET_MODE (x9) != E_DImode
                  || GET_MODE (x10) != E_DImode
                  || !s_register_operand (operands[2], E_DImode)
                  || !
#line 432 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREXD && ARM_DOUBLEWORD_ALIGN
	&& TARGET_HAVE_MEMORY_BARRIER))
                return -1;
              *pnum_clobbers = 3;
              return 3137; /* atomic_fetch_nanddi */

            default:
              return -1;
            }

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_35 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  x5 = XEXP (x4, 1);
  if (XWINT (x5, 0) != 0L)
    return -1;
  x6 = XEXP (x3, 1);
  if (GET_CODE (x6) != LABEL_REF)
    return -1;
  x7 = XVECEXP (x1, 0, 1);
  x8 = XEXP (x7, 1);
  x9 = XEXP (x8, 1);
  if (XWINT (x9, 0) != -1L)
    return -1;
  x10 = XVECEXP (x1, 0, 2);
  if (GET_CODE (x10) != CLOBBER)
    return -1;
  x11 = XEXP (x4, 0);
  operands[2] = x11;
  if (!s_register_operand (operands[2], E_SImode))
    return -1;
  x12 = XEXP (x6, 0);
  operands[4] = x12;
  x13 = XEXP (x7, 0);
  operands[0] = x13;
  if (!thumb_cbrch_target_operand (operands[0], E_SImode))
    return -1;
  x14 = XEXP (x10, 0);
  operands[1] = x14;
  if (!scratch_operand (operands[1], E_SImode))
    return -1;
  x15 = XEXP (x8, 0);
  if (!rtx_equal_p (x15, operands[2])
      || !
#line 1474 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/thumb1.md"
(TARGET_THUMB1))
    return -1;
  return 981; /* *cbranchne_decr1 */
}

 int
recog_38 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19, x20, x21, x22, x23, x24, x25;
  rtx x26, x27, x28, x29;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_CODE (x2) != SET)
    return -1;
  x3 = XEXP (x2, 1);
  switch (GET_CODE (x3))
    {
    case IF_THEN_ELSE:
      x4 = XEXP (x2, 0);
      if (GET_CODE (x4) != PC)
        return -1;
      x5 = XEXP (x3, 0);
      switch (GET_CODE (x5))
        {
        case EQ:
          x6 = XEXP (x5, 1);
          if (pattern298 (x6) != 0)
            return -1;
          x7 = XEXP (x3, 1);
          if (GET_CODE (x7) != LABEL_REF)
            return -1;
          x8 = XEXP (x3, 2);
          if (GET_CODE (x8) != PC)
            return -1;
          x9 = XVECEXP (x1, 0, 1);
          if (GET_CODE (x9) != CLOBBER)
            return -1;
          x10 = XVECEXP (x1, 0, 2);
          if (GET_CODE (x10) != CLOBBER)
            return -1;
          x11 = XVECEXP (x1, 0, 3);
          if (GET_CODE (x11) != CLOBBER
              || pattern581 (x1) != 0)
            return -1;
          return 310; /* *stack_protect_combined_test_insn */

        case LEU:
          x7 = XEXP (x3, 1);
          if (pattern267 (x7) != 0)
            return -1;
          x8 = XEXP (x3, 2);
          if (GET_CODE (x8) != LABEL_REF
              || GET_MODE (x8) != E_SImode
              || pattern554 (x1) != 0)
            return -1;
          x11 = XVECEXP (x1, 0, 3);
          if (GET_CODE (x11) != USE)
            return -1;
          x12 = XEXP (x11, 0);
          if (GET_CODE (x12) != LABEL_REF
              || GET_MODE (x12) != E_SImode)
            return -1;
          x13 = XEXP (x5, 0);
          operands[0] = x13;
          if (!s_register_operand (operands[0], E_SImode))
            return -1;
          x6 = XEXP (x5, 1);
          operands[1] = x6;
          if (!arm_rhs_operand (operands[1], E_SImode))
            return -1;
          x14 = XEXP (x8, 0);
          operands[3] = x14;
          x10 = XVECEXP (x1, 0, 2);
          x15 = XEXP (x10, 0);
          operands[4] = x15;
          if (!scratch_operand (operands[4], E_SImode))
            return -1;
          x16 = XEXP (x7, 0);
          x17 = XEXP (x16, 0);
          x18 = XEXP (x17, 0);
          if (!rtx_equal_p (x18, operands[0]))
            return -1;
          x19 = XEXP (x16, 1);
          switch (GET_CODE (x19))
            {
            case REG:
            case SUBREG:
              operands[5] = x19;
              if (!s_register_operand (operands[5], E_SImode))
                return -1;
              x20 = XEXP (x12, 0);
              operands[2] = x20;
              if (!
#line 9592 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_ARM))
                return -1;
              return 314; /* *arm_casesi_internal */

            case LABEL_REF:
              if (GET_MODE (x19) != E_SImode)
                return -1;
              x21 = XEXP (x19, 0);
              operands[2] = x21;
              x20 = XEXP (x12, 0);
              if (!rtx_equal_p (x20, operands[2])
                  || !
#line 1161 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/thumb2.md"
(TARGET_THUMB2 && !flag_pic))
                return -1;
              return 1047; /* *thumb2_casesi_internal */

            default:
              return -1;
            }

        case GTU:
          x13 = XEXP (x5, 0);
          if (pattern299 (x13) != 0)
            return -1;
          x6 = XEXP (x5, 1);
          if (GET_CODE (x6) != CONST_INT)
            return -1;
          x8 = XEXP (x3, 2);
          if (GET_CODE (x8) != PC)
            return -1;
          x9 = XVECEXP (x1, 0, 1);
          if (pattern531 (x9) != 0)
            return -1;
          x22 = XEXP (x9, 1);
          x23 = XEXP (x22, 1);
          if (GET_CODE (x23) != CONST_INT
              || pattern608 (x1) != 0)
            return -1;
          x11 = XVECEXP (x1, 0, 3);
          if (pattern593 (x11, 
E_CCmode, 
100) != 0)
            return -1;
          switch (pattern633 (x1))
            {
            case 0:
              if (!
#line 4689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
                return -1;
              return 5064; /* predicated_doloop_end_internal16 */

            case 1:
              if (!
#line 4689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
                return -1;
              return 5065; /* predicated_doloop_end_internal8 */

            case 2:
              if (!
#line 4689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
                return -1;
              return 5066; /* predicated_doloop_end_internal4 */

            case 3:
              if (!
#line 4689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
                return -1;
              return 5067; /* predicated_doloop_end_internal2 */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case UNSPEC:
      if (XINT (x3, 1) != 17)
        return -1;
      x4 = XEXP (x2, 0);
      if (GET_CODE (x4) != REG
          || REGNO (x4) != 0
          || GET_MODE (x4) != E_SImode)
        return -1;
      x9 = XVECEXP (x1, 0, 1);
      if (GET_CODE (x9) != CLOBBER)
        return -1;
      x24 = XEXP (x9, 0);
      if (GET_CODE (x24) != REG
          || GET_MODE (x24) != E_SImode)
        return -1;
      x10 = XVECEXP (x1, 0, 2);
      if (GET_CODE (x10) != CLOBBER)
        return -1;
      x15 = XEXP (x10, 0);
      if (GET_CODE (x15) != REG
          || GET_MODE (x15) != E_SImode)
        return -1;
      x11 = XVECEXP (x1, 0, 3);
      if (GET_CODE (x11) != CLOBBER)
        return -1;
      x12 = XEXP (x11, 0);
      if (GET_CODE (x12) != REG
          || REGNO (x12) != 100
          || GET_MODE (x3) != E_SImode)
        return -1;
      switch (XVECLEN (x3, 0))
        {
        case 1:
          x25 = XVECEXP (x3, 0, 0);
          if (x25 != const_int_rtx[MAX_SAVED_CONST_INT + 0]
              || REGNO (x24) != 14
              || REGNO (x15) != 12
              || GET_MODE (x12) != E_CCmode
              || !
#line 12319 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_SOFT_TP && !TARGET_FDPIC))
            return -1;
          return 408; /* load_tp_soft */

        case 3:
          x25 = XVECEXP (x3, 0, 0);
          if (GET_CODE (x25) != REG
              || REGNO (x25) != 0
              || GET_MODE (x25) != E_SImode
              || REGNO (x24) != 1
              || REGNO (x15) != 14)
            return -1;
          x26 = XVECEXP (x3, 0, 1);
          operands[0] = x26;
          x27 = XVECEXP (x3, 0, 2);
          operands[1] = x27;
          if (GET_MODE (x12) != E_SImode
              || !
#line 12334 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_GNU2_TLS))
            return -1;
          return 409; /* tlscall */

        default:
          return -1;
        }

    case MEM:
      if (pnum_clobbers != NULL
          && pattern26 (x1) == 0
          && pattern629 (x1) == 0
          && pattern640 (x1) == 0
          && 
#line 1063 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/thumb1.md"
(TARGET_THUMB1))
        {
          *pnum_clobbers = 2;
          return 973; /* cpymem8b */
        }
      operands[1] = x3;
      if (pattern259 (x1, 
18, 
2) != 0)
        return -1;
      x4 = XEXP (x2, 0);
      operands[0] = x4;
      x9 = XVECEXP (x1, 0, 1);
      x22 = XEXP (x9, 1);
      x28 = XVECEXP (x22, 0, 0);
      operands[2] = x28;
      x29 = XVECEXP (x22, 0, 1);
      operands[3] = x29;
      if (!const_int_operand (operands[3], E_SImode))
        return -1;
      x11 = XVECEXP (x1, 0, 3);
      x12 = XEXP (x11, 0);
      operands[4] = x12;
      if (!scratch_operand (operands[4], E_SImode))
        return -1;
      x24 = XEXP (x9, 0);
      if (!rtx_equal_p (x24, operands[1]))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_QImode:
          if (pattern580 (x22, 
E_QImode) != 0
              || !
#line 301 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREXBH && TARGET_HAVE_MEMORY_BARRIER))
            return -1;
          return 3086; /* atomic_exchangeqi */

        case E_HImode:
          if (pattern580 (x22, 
E_HImode) != 0
              || !
#line 301 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREXBH && TARGET_HAVE_MEMORY_BARRIER))
            return -1;
          return 3087; /* atomic_exchangehi */

        case E_DImode:
          if (pattern580 (x22, 
E_DImode) != 0
              || !
#line 301 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREXD && ARM_DOUBLEWORD_ALIGN
	&& TARGET_HAVE_MEMORY_BARRIER))
            return -1;
          return 3089; /* atomic_exchangedi */

        default:
          return -1;
        }

    case UNSPEC_VOLATILE:
      x11 = XVECEXP (x1, 0, 3);
      if (GET_CODE (x11) != CLOBBER)
        return -1;
      switch (pattern266 (x1))
        {
        case 0:
          if (!(
#line 250 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREXBH && TARGET_HAVE_MEMORY_BARRIER) && 
#line 57 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iterators.md"
(TARGET_32BIT)))
            return -1;
          return 3078; /* atomic_compare_and_swap32qi_1 */

        case 1:
          if (!(
#line 250 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREXBH && TARGET_HAVE_MEMORY_BARRIER) && 
#line 57 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iterators.md"
(TARGET_32BIT)))
            return -1;
          return 3080; /* atomic_compare_and_swap32hi_1 */

        case 2:
          if (!(
#line 250 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREXBH && TARGET_HAVE_MEMORY_BARRIER) && 
#line 57 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iterators.md"
(TARGET_THUMB1)))
            return -1;
          return 3079; /* atomic_compare_and_swapt1qi_1 */

        case 3:
          if (!(
#line 250 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREXBH && TARGET_HAVE_MEMORY_BARRIER) && 
#line 57 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iterators.md"
(TARGET_THUMB1)))
            return -1;
          return 3081; /* atomic_compare_and_swapt1hi_1 */

        case 4:
          if (!(
#line 281 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREX && TARGET_HAVE_MEMORY_BARRIER) && 
#line 57 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iterators.md"
(TARGET_32BIT)))
            return -1;
          return 3082; /* atomic_compare_and_swap32si_1 */

        case 5:
          if (!(
#line 281 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREXD && ARM_DOUBLEWORD_ALIGN
	&& TARGET_HAVE_MEMORY_BARRIER) && 
#line 57 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iterators.md"
(TARGET_32BIT)))
            return -1;
          return 3084; /* atomic_compare_and_swap32di_1 */

        case 6:
          if (!(
#line 281 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREX && TARGET_HAVE_MEMORY_BARRIER) && 
#line 57 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iterators.md"
(TARGET_THUMB1)))
            return -1;
          return 3083; /* atomic_compare_and_swapt1si_1 */

        case 7:
          if (!(
#line 281 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREXD && ARM_DOUBLEWORD_ALIGN
	&& TARGET_HAVE_MEMORY_BARRIER) && 
#line 57 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iterators.md"
(TARGET_THUMB1)))
            return -1;
          return 3085; /* atomic_compare_and_swapt1di_1 */

        case 8:
          if (!
#line 342 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREXBH && TARGET_HAVE_MEMORY_BARRIER))
            return -1;
          return 3090; /* atomic_addqi */

        case 9:
          if (!
#line 342 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREXBH && TARGET_HAVE_MEMORY_BARRIER))
            return -1;
          return 3095; /* atomic_addhi */

        case 10:
          if (!
#line 342 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREX && TARGET_HAVE_MEMORY_BARRIER))
            return -1;
          return 3100; /* atomic_addsi */

        case 11:
          if (!
#line 342 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREXD && ARM_DOUBLEWORD_ALIGN
	&& TARGET_HAVE_MEMORY_BARRIER))
            return -1;
          return 3105; /* atomic_adddi */

        case 12:
          if (!
#line 342 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREXBH && TARGET_HAVE_MEMORY_BARRIER))
            return -1;
          return 3091; /* atomic_subqi */

        case 13:
          if (!
#line 342 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREXBH && TARGET_HAVE_MEMORY_BARRIER))
            return -1;
          return 3096; /* atomic_subhi */

        case 14:
          if (!
#line 342 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREX && TARGET_HAVE_MEMORY_BARRIER))
            return -1;
          return 3101; /* atomic_subsi */

        case 15:
          if (!
#line 342 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREXD && ARM_DOUBLEWORD_ALIGN
	&& TARGET_HAVE_MEMORY_BARRIER))
            return -1;
          return 3106; /* atomic_subdi */

        case 16:
          if (!
#line 342 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREXBH && TARGET_HAVE_MEMORY_BARRIER))
            return -1;
          return 3092; /* atomic_orqi */

        case 17:
          if (!
#line 342 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREXBH && TARGET_HAVE_MEMORY_BARRIER))
            return -1;
          return 3097; /* atomic_orhi */

        case 18:
          if (!
#line 342 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREX && TARGET_HAVE_MEMORY_BARRIER))
            return -1;
          return 3102; /* atomic_orsi */

        case 19:
          if (!
#line 342 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREXD && ARM_DOUBLEWORD_ALIGN
	&& TARGET_HAVE_MEMORY_BARRIER))
            return -1;
          return 3107; /* atomic_ordi */

        case 20:
          if (!
#line 342 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREXBH && TARGET_HAVE_MEMORY_BARRIER))
            return -1;
          return 3093; /* atomic_xorqi */

        case 21:
          if (!
#line 342 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREXBH && TARGET_HAVE_MEMORY_BARRIER))
            return -1;
          return 3098; /* atomic_xorhi */

        case 22:
          if (!
#line 342 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREX && TARGET_HAVE_MEMORY_BARRIER))
            return -1;
          return 3103; /* atomic_xorsi */

        case 23:
          if (!
#line 342 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREXD && ARM_DOUBLEWORD_ALIGN
	&& TARGET_HAVE_MEMORY_BARRIER))
            return -1;
          return 3108; /* atomic_xordi */

        case 24:
          if (!
#line 342 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREXBH && TARGET_HAVE_MEMORY_BARRIER))
            return -1;
          return 3094; /* atomic_andqi */

        case 25:
          if (!
#line 342 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREXBH && TARGET_HAVE_MEMORY_BARRIER))
            return -1;
          return 3099; /* atomic_andhi */

        case 26:
          if (!
#line 342 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREX && TARGET_HAVE_MEMORY_BARRIER))
            return -1;
          return 3104; /* atomic_andsi */

        case 27:
          if (!
#line 342 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREXD && ARM_DOUBLEWORD_ALIGN
	&& TARGET_HAVE_MEMORY_BARRIER))
            return -1;
          return 3109; /* atomic_anddi */

        case 28:
          if (!
#line 366 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREXBH && TARGET_HAVE_MEMORY_BARRIER))
            return -1;
          return 3110; /* atomic_nandqi */

        case 29:
          if (!
#line 366 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREXBH && TARGET_HAVE_MEMORY_BARRIER))
            return -1;
          return 3111; /* atomic_nandhi */

        case 30:
          if (!
#line 366 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREX && TARGET_HAVE_MEMORY_BARRIER))
            return -1;
          return 3112; /* atomic_nandsi */

        case 31:
          if (!
#line 366 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREXD && ARM_DOUBLEWORD_ALIGN
	&& TARGET_HAVE_MEMORY_BARRIER))
            return -1;
          return 3113; /* atomic_nanddi */

        default:
          return -1;
        }

    case PLUS:
      switch (pattern23 (x1))
        {
        case 0:
          if (!
#line 457 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREXBH && TARGET_HAVE_MEMORY_BARRIER))
            return -1;
          return 3138; /* atomic_add_fetchqi */

        case 1:
          if (!
#line 457 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREXBH && TARGET_HAVE_MEMORY_BARRIER))
            return -1;
          return 3143; /* atomic_add_fetchhi */

        case 2:
          if (!
#line 457 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREX && TARGET_HAVE_MEMORY_BARRIER))
            return -1;
          return 3148; /* atomic_add_fetchsi */

        case 3:
          if (!
#line 457 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREXD && ARM_DOUBLEWORD_ALIGN
	&& TARGET_HAVE_MEMORY_BARRIER))
            return -1;
          return 3153; /* atomic_add_fetchdi */

        default:
          return -1;
        }

    case MINUS:
      switch (pattern23 (x1))
        {
        case 0:
          if (!
#line 457 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREXBH && TARGET_HAVE_MEMORY_BARRIER))
            return -1;
          return 3139; /* atomic_sub_fetchqi */

        case 1:
          if (!
#line 457 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREXBH && TARGET_HAVE_MEMORY_BARRIER))
            return -1;
          return 3144; /* atomic_sub_fetchhi */

        case 2:
          if (!
#line 457 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREX && TARGET_HAVE_MEMORY_BARRIER))
            return -1;
          return 3149; /* atomic_sub_fetchsi */

        case 3:
          if (!
#line 457 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREXD && ARM_DOUBLEWORD_ALIGN
	&& TARGET_HAVE_MEMORY_BARRIER))
            return -1;
          return 3154; /* atomic_sub_fetchdi */

        default:
          return -1;
        }

    case IOR:
      switch (pattern23 (x1))
        {
        case 0:
          if (!
#line 457 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREXBH && TARGET_HAVE_MEMORY_BARRIER))
            return -1;
          return 3140; /* atomic_or_fetchqi */

        case 1:
          if (!
#line 457 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREXBH && TARGET_HAVE_MEMORY_BARRIER))
            return -1;
          return 3145; /* atomic_or_fetchhi */

        case 2:
          if (!
#line 457 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREX && TARGET_HAVE_MEMORY_BARRIER))
            return -1;
          return 3150; /* atomic_or_fetchsi */

        case 3:
          if (!
#line 457 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREXD && ARM_DOUBLEWORD_ALIGN
	&& TARGET_HAVE_MEMORY_BARRIER))
            return -1;
          return 3155; /* atomic_or_fetchdi */

        default:
          return -1;
        }

    case XOR:
      switch (pattern23 (x1))
        {
        case 0:
          if (!
#line 457 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREXBH && TARGET_HAVE_MEMORY_BARRIER))
            return -1;
          return 3141; /* atomic_xor_fetchqi */

        case 1:
          if (!
#line 457 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREXBH && TARGET_HAVE_MEMORY_BARRIER))
            return -1;
          return 3146; /* atomic_xor_fetchhi */

        case 2:
          if (!
#line 457 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREX && TARGET_HAVE_MEMORY_BARRIER))
            return -1;
          return 3151; /* atomic_xor_fetchsi */

        case 3:
          if (!
#line 457 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREXD && ARM_DOUBLEWORD_ALIGN
	&& TARGET_HAVE_MEMORY_BARRIER))
            return -1;
          return 3156; /* atomic_xor_fetchdi */

        default:
          return -1;
        }

    case AND:
      switch (pattern23 (x1))
        {
        case 0:
          if (!
#line 457 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREXBH && TARGET_HAVE_MEMORY_BARRIER))
            return -1;
          return 3142; /* atomic_and_fetchqi */

        case 1:
          if (!
#line 457 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREXBH && TARGET_HAVE_MEMORY_BARRIER))
            return -1;
          return 3147; /* atomic_and_fetchhi */

        case 2:
          if (!
#line 457 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREX && TARGET_HAVE_MEMORY_BARRIER))
            return -1;
          return 3152; /* atomic_and_fetchsi */

        case 3:
          if (!
#line 457 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREXD && ARM_DOUBLEWORD_ALIGN
	&& TARGET_HAVE_MEMORY_BARRIER))
            return -1;
          return 3157; /* atomic_and_fetchdi */

        default:
          return -1;
        }

    case NOT:
      x5 = XEXP (x3, 0);
      if (GET_CODE (x5) != AND
          || pattern259 (x1, 
19, 
3) != 0)
        return -1;
      switch (pattern534 (x1))
        {
        case 0:
          if (!
#line 483 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREXBH && TARGET_HAVE_MEMORY_BARRIER))
            return -1;
          return 3158; /* atomic_nand_fetchqi */

        case 1:
          if (!
#line 483 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREXBH && TARGET_HAVE_MEMORY_BARRIER))
            return -1;
          return 3159; /* atomic_nand_fetchhi */

        case 2:
          if (!
#line 483 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREX && TARGET_HAVE_MEMORY_BARRIER))
            return -1;
          return 3160; /* atomic_nand_fetchsi */

        case 3:
          if (!
#line 483 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/sync.md"
(TARGET_HAVE_LDREXD && ARM_DOUBLEWORD_ALIGN
	&& TARGET_HAVE_MEMORY_BARRIER))
            return -1;
          return 3161; /* atomic_nand_fetchdi */

        default:
          return -1;
        }

    case SS_MULT:
      if (pattern24 (x1, 
E_SAmode) != 0
          || !
#line 264 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm-fixed.md"
(TARGET_32BIT && arm_arch6 && !ARM_Q_BIT_READ))
        return -1;
      return 3232; /* *arm_ssmulsa3 */

    case US_MULT:
      if (pattern24 (x1, 
E_USAmode) != 0
          || !
#line 336 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm-fixed.md"
(TARGET_32BIT && arm_arch6 && !ARM_Q_BIT_READ))
        return -1;
      return 3233; /* *arm_usmulusa3 */

    default:
      return -1;
    }
}

 int
recog_73 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  x5 = XVECEXP (x3, 0, 1);
  operands[2] = x5;
  if (!immediate_operand (operands[2], E_SImode))
    return -1;
  x6 = XVECEXP (x3, 0, 2);
  operands[3] = x6;
  switch (GET_MODE (operands[0]))
    {
    case E_V4SImode:
      if (pattern73 (x3, 
E_V4BImode, 
E_V4SImode) != 0
          || !
#line 3558 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
((TARGET_HAVE_MVE && VALID_MVE_SI_MODE (V4SImode))
   || (TARGET_HAVE_MVE_FLOAT && VALID_MVE_SF_MODE (V4SImode))))
        return -1;
      return 4906; /* mve_vldrq_gather_base_z_v4si */

    case E_V4SFmode:
      if (!s_register_operand (operands[0], E_V4SFmode)
          || GET_MODE (x3) != E_V4SFmode
          || !s_register_operand (operands[1], E_V4SImode)
          || !vpr_register_operand (operands[3], E_V4BImode)
          || !
#line 3558 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
((TARGET_HAVE_MVE && VALID_MVE_SI_MODE (V4SFmode))
   || (TARGET_HAVE_MVE_FLOAT && VALID_MVE_SF_MODE (V4SFmode))))
        return -1;
      return 4907; /* mve_vldrq_gather_base_z_v4sf */

    case E_V2DImode:
      if (pattern73 (x3, 
E_V2QImode, 
E_V2DImode) != 0
          || !
#line 3558 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
((TARGET_HAVE_MVE && VALID_MVE_SI_MODE (V2DImode))
   || (TARGET_HAVE_MVE_FLOAT && VALID_MVE_SF_MODE (V2DImode))))
        return -1;
      return 4908; /* mve_vldrq_gather_base_z_v2di */

    default:
      return -1;
    }
}

 int
recog_81 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (pattern44 (x1))
    {
    case 0:
      if (!
#line 4630 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2433; /* neon_vrsrau_nv8qi */

    case 1:
      if (!
#line 4630 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2437; /* neon_vrsrau_nv16qi */

    case 2:
      if (!
#line 4630 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2441; /* neon_vrsrau_nv4hi */

    case 3:
      if (!
#line 4630 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2445; /* neon_vrsrau_nv8hi */

    case 4:
      if (!
#line 4630 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2449; /* neon_vrsrau_nv2si */

    case 5:
      if (!
#line 4630 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2453; /* neon_vrsrau_nv4si */

    case 6:
      if (!
#line 4630 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2457; /* neon_vrsrau_ndi */

    case 7:
      if (!
#line 4630 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2461; /* neon_vrsrau_nv2di */

    default:
      return -1;
    }
}

 int
recog_90 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != E_SImode)
    return -1;
  x3 = XVECEXP (x2, 0, 2);
  if (GET_CODE (x3) != REG
      || REGNO (x3) != 105
      || GET_MODE (x3) != E_CCmode)
    return -1;
  x4 = XEXP (x1, 0);
  operands[0] = x4;
  if (!s_register_operand (operands[0], E_SImode))
    return -1;
  x5 = XVECEXP (x2, 0, 0);
  operands[1] = x5;
  if (!s_register_operand (operands[1], E_SImode))
    return -1;
  x6 = XVECEXP (x2, 0, 1);
  operands[2] = x6;
  if (!s_register_operand (operands[2], E_SImode)
      || !
#line 6187 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_INT_SIMD))
    return -1;
  return 254; /* arm_sel */
}

 int
recog_92 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (pattern47 (x1, 
E_CImode, 
E_EImode))
    {
    case 0:
      if (!
#line 5696 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2838; /* neon_vld3qbv16qi */

    case 1:
      if (!
#line 5696 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2839; /* neon_vld3qbv8hi */

    case 2:
      if (!
#line 5696 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2840; /* neon_vld3qbv8hf */

    case 3:
      if (!(
#line 5696 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON) && 
#line 120 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iterators.md"
(TARGET_BF16_SIMD)))
        return -1;
      return 2841; /* neon_vld3qbv8bf */

    case 4:
      if (!
#line 5696 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2842; /* neon_vld3qbv4si */

    case 5:
      if (!
#line 5696 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2843; /* neon_vld3qbv4sf */

    default:
      return -1;
    }
}

 int
recog_106 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  switch (GET_MODE (operands[0]))
    {
    case E_V8QImode:
      if (!s_register_operand (operands[0], E_V8QImode)
          || GET_MODE (x3) != E_V8QImode
          || !s_register_operand (operands[1], E_V8QImode)
          || !
#line 4435 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2241; /* neon_vrev64v8qi */

    case E_V16QImode:
      if (!s_register_operand (operands[0], E_V16QImode)
          || GET_MODE (x3) != E_V16QImode
          || !s_register_operand (operands[1], E_V16QImode)
          || !
#line 4435 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2242; /* neon_vrev64v16qi */

    case E_V4HImode:
      if (!s_register_operand (operands[0], E_V4HImode)
          || GET_MODE (x3) != E_V4HImode
          || !s_register_operand (operands[1], E_V4HImode)
          || !
#line 4435 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2243; /* neon_vrev64v4hi */

    case E_V8HImode:
      if (!s_register_operand (operands[0], E_V8HImode)
          || GET_MODE (x3) != E_V8HImode
          || !s_register_operand (operands[1], E_V8HImode)
          || !
#line 4435 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2244; /* neon_vrev64v8hi */

    case E_V2SImode:
      if (!s_register_operand (operands[0], E_V2SImode)
          || GET_MODE (x3) != E_V2SImode
          || !s_register_operand (operands[1], E_V2SImode)
          || !
#line 4435 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2245; /* neon_vrev64v2si */

    case E_V4SImode:
      if (!s_register_operand (operands[0], E_V4SImode)
          || GET_MODE (x3) != E_V4SImode
          || !s_register_operand (operands[1], E_V4SImode)
          || !
#line 4435 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2246; /* neon_vrev64v4si */

    case E_V4HFmode:
      if (!s_register_operand (operands[0], E_V4HFmode)
          || GET_MODE (x3) != E_V4HFmode
          || !s_register_operand (operands[1], E_V4HFmode)
          || !
#line 4435 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2247; /* neon_vrev64v4hf */

    case E_V8HFmode:
      if (!s_register_operand (operands[0], E_V8HFmode)
          || GET_MODE (x3) != E_V8HFmode
          || !s_register_operand (operands[1], E_V8HFmode)
          || !
#line 4435 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2248; /* neon_vrev64v8hf */

    case E_V2SFmode:
      if (!s_register_operand (operands[0], E_V2SFmode)
          || GET_MODE (x3) != E_V2SFmode
          || !s_register_operand (operands[1], E_V2SFmode)
          || !
#line 4435 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2249; /* neon_vrev64v2sf */

    case E_V4SFmode:
      if (!s_register_operand (operands[0], E_V4SFmode)
          || GET_MODE (x3) != E_V4SFmode
          || !s_register_operand (operands[1], E_V4SFmode)
          || !
#line 4435 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2250; /* neon_vrev64v4sf */

    case E_V2DImode:
      if (!s_register_operand (operands[0], E_V2DImode)
          || GET_MODE (x3) != E_V2DImode
          || !s_register_operand (operands[1], E_V2DImode)
          || !
#line 4435 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2251; /* neon_vrev64v2di */

    default:
      return -1;
    }
}

 int
recog_119 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  switch (GET_MODE (operands[0]))
    {
    case E_V8QImode:
      if (!s_register_operand (operands[0], E_V8QImode)
          || GET_MODE (x3) != E_V8QImode
          || !s_register_operand (operands[1], E_V8QImode)
          || !
#line 4453 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2256; /* neon_vrev16v8qi */

    case E_V16QImode:
      if (!s_register_operand (operands[0], E_V16QImode)
          || GET_MODE (x3) != E_V16QImode
          || !s_register_operand (operands[1], E_V16QImode)
          || !
#line 4453 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2257; /* neon_vrev16v16qi */

    default:
      return -1;
    }
}

 int
recog_127 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (pattern105 (x1))
    {
    case 0:
      if (!
#line 3141 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2003; /* neon_vqnegv8qi */

    case 1:
      if (!
#line 3141 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2004; /* neon_vqnegv16qi */

    case 2:
      if (!
#line 3141 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2005; /* neon_vqnegv4hi */

    case 3:
      if (!
#line 3141 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2006; /* neon_vqnegv8hi */

    case 4:
      if (!
#line 3141 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2007; /* neon_vqnegv2si */

    case 5:
      if (!
#line 3141 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2008; /* neon_vqnegv4si */

    default:
      return -1;
    }
}

 int
recog_136 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  switch (pattern156 (x1))
    {
    case 0:
      x2 = XEXP (x1, 1);
      switch (pattern457 (x2, 
E_TImode))
        {
        case 0:
          if (!
#line 5237 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2657; /* neon_vst1_x2v8qi */

        case 1:
          if (!
#line 5237 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2659; /* neon_vst1_x2v16qi */

        case 2:
          if (!
#line 5237 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2661; /* neon_vst1_x2v4hi */

        case 3:
          if (!
#line 5237 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2663; /* neon_vst1_x2v8hi */

        case 4:
          if (!
#line 5237 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2665; /* neon_vst1_x2v2si */

        case 5:
          if (!
#line 5237 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2667; /* neon_vst1_x2v4si */

        case 6:
          if (!
#line 5237 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2669; /* neon_vst1_x2v4hf */

        case 7:
          if (!
#line 5237 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2671; /* neon_vst1_x2v8hf */

        case 8:
          if (!
#line 5237 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2673; /* neon_vst1_x2v4bf */

        case 9:
          if (!
#line 5237 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2675; /* neon_vst1_x2v8bf */

        case 10:
          if (!
#line 5237 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2677; /* neon_vst1_x2v2sf */

        case 11:
          if (!
#line 5237 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2679; /* neon_vst1_x2v4sf */

        case 12:
          if (!
#line 5237 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2681; /* neon_vst1_x2di */

        case 13:
          if (!
#line 5237 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2683; /* neon_vst1_x2v2di */

        default:
          return -1;
        }

    case 1:
      x2 = XEXP (x1, 1);
      switch (pattern457 (x2, 
E_OImode))
        {
        case 0:
          if (!
#line 5237 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2658; /* neon_vst1q_x2v8qi */

        case 1:
          if (!
#line 5237 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2660; /* neon_vst1q_x2v16qi */

        case 2:
          if (!
#line 5237 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2662; /* neon_vst1q_x2v4hi */

        case 3:
          if (!
#line 5237 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2664; /* neon_vst1q_x2v8hi */

        case 4:
          if (!
#line 5237 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2666; /* neon_vst1q_x2v2si */

        case 5:
          if (!
#line 5237 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2668; /* neon_vst1q_x2v4si */

        case 6:
          if (!
#line 5237 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2670; /* neon_vst1q_x2v4hf */

        case 7:
          if (!
#line 5237 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2672; /* neon_vst1q_x2v8hf */

        case 8:
          if (!
#line 5237 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2674; /* neon_vst1q_x2v4bf */

        case 9:
          if (!
#line 5237 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2676; /* neon_vst1q_x2v8bf */

        case 10:
          if (!
#line 5237 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2678; /* neon_vst1q_x2v2sf */

        case 11:
          if (!
#line 5237 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2680; /* neon_vst1q_x2v4sf */

        case 12:
          if (!
#line 5237 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2682; /* neon_vst1q_x2di */

        case 13:
          if (!
#line 5237 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2684; /* neon_vst1q_x2v2di */

        default:
          return -1;
        }

    case 2:
      x2 = XEXP (x1, 1);
      switch (pattern457 (x2, 
E_EImode))
        {
        case 0:
          if (!
#line 5247 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2685; /* neon_vst1_x3v8qi */

        case 1:
          if (!
#line 5247 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2686; /* neon_vst1_x3v16qi */

        case 2:
          if (!
#line 5247 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2687; /* neon_vst1_x3v4hi */

        case 3:
          if (!
#line 5247 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2688; /* neon_vst1_x3v8hi */

        case 4:
          if (!
#line 5247 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2689; /* neon_vst1_x3v2si */

        case 5:
          if (!
#line 5247 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2690; /* neon_vst1_x3v4si */

        case 6:
          if (!
#line 5247 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2691; /* neon_vst1_x3v4hf */

        case 7:
          if (!
#line 5247 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2692; /* neon_vst1_x3v8hf */

        case 8:
          if (!
#line 5247 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2693; /* neon_vst1_x3v4bf */

        case 9:
          if (!
#line 5247 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2694; /* neon_vst1_x3v8bf */

        case 10:
          if (!
#line 5247 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2695; /* neon_vst1_x3v2sf */

        case 11:
          if (!
#line 5247 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2696; /* neon_vst1_x3v4sf */

        case 12:
          if (!
#line 5247 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2697; /* neon_vst1_x3di */

        case 13:
          if (!
#line 5247 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2698; /* neon_vst1_x3v2di */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_163 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (pattern152 (x1))
    {
    case 0:
      if (!
#line 4588 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2401; /* neon_vqshl_u_nv8qi */

    case 1:
      if (!
#line 4588 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2403; /* neon_vqshl_u_nv16qi */

    case 2:
      if (!
#line 4588 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2405; /* neon_vqshl_u_nv4hi */

    case 3:
      if (!
#line 4588 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2407; /* neon_vqshl_u_nv8hi */

    case 4:
      if (!
#line 4588 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2409; /* neon_vqshl_u_nv2si */

    case 5:
      if (!
#line 4588 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2411; /* neon_vqshl_u_nv4si */

    case 6:
      if (!
#line 4588 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2413; /* neon_vqshl_u_ndi */

    case 7:
      if (!
#line 4588 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2415; /* neon_vqshl_u_nv2di */

    default:
      return -1;
    }
}

 int
recog_173 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (pattern139 (x1))
    {
    case 0:
      if (!
#line 4509 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2304; /* neon_vqshlsv8qi */

    case 1:
      if (!
#line 4509 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2308; /* neon_vqshlsv16qi */

    case 2:
      if (!
#line 4509 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2312; /* neon_vqshlsv4hi */

    case 3:
      if (!
#line 4509 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2316; /* neon_vqshlsv8hi */

    case 4:
      if (!
#line 4509 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2320; /* neon_vqshlsv2si */

    case 5:
      if (!
#line 4509 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2324; /* neon_vqshlsv4si */

    case 6:
      if (!
#line 4509 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2328; /* neon_vqshlsdi */

    case 7:
      if (!
#line 4509 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2332; /* neon_vqshlsv2di */

    default:
      return -1;
    }
}

 int
recog_183 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (pattern139 (x1))
    {
    case 0:
      if (!
#line 2293 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 1630; /* neon_vqsubsv8qi */

    case 1:
      if (!
#line 2293 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 1632; /* neon_vqsubsv16qi */

    case 2:
      if (!
#line 2293 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 1634; /* neon_vqsubsv4hi */

    case 3:
      if (!
#line 2293 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 1636; /* neon_vqsubsv8hi */

    case 4:
      if (!
#line 2293 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 1638; /* neon_vqsubsv2si */

    case 5:
      if (!
#line 2293 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 1640; /* neon_vqsubsv4si */

    case 6:
      if (!
#line 2293 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 1642; /* neon_vqsubsdi */

    case 7:
      if (!
#line 2293 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 1644; /* neon_vqsubsv2di */

    default:
      return -1;
    }
}

 int
recog_194 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (pattern157 (x1, 
E_OImode, 
E_XImode))
    {
    case 0:
      if (!
#line 5093 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2603; /* neon_vld1x4qav16qi */

    case 1:
      if (!
#line 5093 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2604; /* neon_vld1x4qav8hi */

    case 2:
      if (!
#line 5093 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2605; /* neon_vld1x4qav8hf */

    case 3:
      if (!(
#line 5093 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON) && 
#line 132 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iterators.md"
(TARGET_BF16_SIMD)))
        return -1;
      return 2606; /* neon_vld1x4qav8bf */

    case 4:
      if (!
#line 5093 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2607; /* neon_vld1x4qav4si */

    case 5:
      if (!
#line 5093 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2608; /* neon_vld1x4qav4sf */

    case 6:
      if (!
#line 5093 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2609; /* neon_vld1x4qav2di */

    default:
      return -1;
    }
}

 int
recog_204 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (pattern165 (x1, 
E_CImode, 
E_EImode))
    {
    case 0:
      if (!
#line 5887 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2876; /* neon_vst3qbv16qi */

    case 1:
      if (!
#line 5887 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2877; /* neon_vst3qbv8hi */

    case 2:
      if (!
#line 5887 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2878; /* neon_vst3qbv8hf */

    case 3:
      if (!(
#line 5887 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON) && 
#line 120 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iterators.md"
(TARGET_BF16_SIMD)))
        return -1;
      return 2879; /* neon_vst3qbv8bf */

    case 4:
      if (!
#line 5887 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2880; /* neon_vst3qbv4si */

    case 5:
      if (!
#line 5887 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2881; /* neon_vst3qbv4sf */

    default:
      return -1;
    }
}

 int
recog_214 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (pattern138 (x1))
    {
    case 0:
      if (!
#line 2593 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 1784; /* neon_vabdsv8qi */

    case 1:
      if (!
#line 2593 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 1786; /* neon_vabdsv16qi */

    case 2:
      if (!
#line 2593 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 1788; /* neon_vabdsv4hi */

    case 3:
      if (!
#line 2593 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 1790; /* neon_vabdsv8hi */

    case 4:
      if (!
#line 2593 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 1792; /* neon_vabdsv2si */

    case 5:
      if (!
#line 2593 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 1794; /* neon_vabdsv4si */

    default:
      return -1;
    }
}

 int
recog_224 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != E_BLKmode)
    return -1;
  x3 = XEXP (x1, 0);
  if (GET_CODE (x3) != MEM
      || GET_MODE (x3) != E_BLKmode)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_CODE (x4) != SCRATCH)
    return -1;
  x5 = XVECEXP (x2, 0, 0);
  operands[0] = x5;
  if (!s_register_operand (operands[0], E_SImode))
    return -1;
  x6 = XVECEXP (x2, 0, 1);
  operands[1] = x6;
  if (!s_register_operand (operands[1], E_SImode))
    return -1;
  return 385; /* stack_tie */
}

 int
recog_232 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (pattern144 (x1))
    {
    case 0:
      if (!
#line 2391 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 1708; /* neon_vclev2sf_insn_unspec */

    case 1:
      if (!
#line 2391 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 1713; /* neon_vclev4sf_insn_unspec */

    case 2:
      if (!
#line 2458 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON_FP16INST))
        return -1;
      return 1728; /* neon_vclev8hf_fp16insn_unspec */

    case 3:
      if (!
#line 2458 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON_FP16INST))
        return -1;
      return 1733; /* neon_vclev4hf_fp16insn_unspec */

    default:
      return -1;
    }
}

 int
recog_242 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != E_SImode)
    return -1;
  x3 = XEXP (x1, 0);
  operands[0] = x3;
  if (!s_register_operand (operands[0], E_SImode))
    return -1;
  x4 = XVECEXP (x2, 0, 0);
  operands[1] = x4;
  if (!s_register_operand (operands[1], E_SImode))
    return -1;
  x5 = XVECEXP (x2, 0, 1);
  operands[2] = x5;
  if (!usat16_imm (operands[2], E_SImode)
      || !
#line 6159 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_INT_SIMD && !ARM_Q_BIT_READ))
    return -1;
  return 252; /* arm_usat16_insn */
}

 int
recog_252 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (pattern92 (x1) != 0)
    return -1;
  x2 = XEXP (x1, 1);
  x3 = XVECEXP (x2, 0, 2);
  operands[2] = x3;
  x4 = XVECEXP (x2, 0, 3);
  operands[3] = x4;
  switch (GET_MODE (operands[0]))
    {
    case E_V4SImode:
      if (!s_register_operand (operands[0], E_V4SImode))
        return -1;
      switch (pattern555 ())
        {
        case 0:
          if (!
#line 3521 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
((TARGET_HAVE_MVE && VALID_MVE_SI_MODE (V4SImode))
   || (TARGET_HAVE_MVE_FLOAT && VALID_MVE_SF_MODE (V4SImode))))
            return -1;
          return 4900; /* mve_vstrq_scatter_base_p_v4si */

        case 1:
          if (!
#line 3521 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
((TARGET_HAVE_MVE && VALID_MVE_SI_MODE (V4SFmode))
   || (TARGET_HAVE_MVE_FLOAT && VALID_MVE_SF_MODE (V4SFmode))))
            return -1;
          return 4901; /* mve_vstrq_scatter_base_p_v4sf */

        default:
          return -1;
        }

    case E_V2DImode:
      if (!s_register_operand (operands[0], E_V2DImode)
          || !s_register_operand (operands[2], E_V2DImode)
          || !vpr_register_operand (operands[3], E_V2QImode)
          || !
#line 3521 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
((TARGET_HAVE_MVE && VALID_MVE_SI_MODE (V2DImode))
   || (TARGET_HAVE_MVE_FLOAT && VALID_MVE_SF_MODE (V2DImode))))
        return -1;
      return 4902; /* mve_vstrq_scatter_base_p_v2di */

    default:
      return -1;
    }
}

 int
recog_256 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (pattern199 (x1))
    {
    case 0:
      if (!
#line 4082 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2215; /* neon_vmls_lanev4hi */

    case 1:
      if (!
#line 4082 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2216; /* neon_vmls_lanev2si */

    case 2:
      if (!
#line 4082 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2217; /* neon_vmls_lanev2sf */

    case 3:
      if (!
#line 4100 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2218; /* neon_vmls_lanev8hi */

    case 4:
      if (!
#line 4100 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2219; /* neon_vmls_lanev4si */

    case 5:
      if (!
#line 4100 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2220; /* neon_vmls_lanev4sf */

    default:
      return -1;
    }
}

 int
recog_263 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  switch (XINT (x2, 1))
    {
    case 102:
      return recog_244 (x1, insn, pnum_clobbers);

    case 47:
      if (pattern123 (x1) != 0
          || !
#line 6059 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_INT_SIMD))
        return -1;
      return 192; /* arm_qadd8 */

    case 48:
      if (pattern123 (x1) != 0
          || !
#line 6059 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_INT_SIMD))
        return -1;
      return 193; /* arm_qsub8 */

    case 49:
      if (pattern123 (x1) != 0
          || !
#line 6059 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_INT_SIMD))
        return -1;
      return 194; /* arm_shadd8 */

    case 50:
      if (pattern123 (x1) != 0
          || !
#line 6059 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_INT_SIMD))
        return -1;
      return 195; /* arm_shsub8 */

    case 51:
      if (pattern123 (x1) != 0
          || !
#line 6059 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_INT_SIMD))
        return -1;
      return 196; /* arm_uhadd8 */

    case 52:
      if (pattern123 (x1) != 0
          || !
#line 6059 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_INT_SIMD))
        return -1;
      return 197; /* arm_uhsub8 */

    case 53:
      if (pattern123 (x1) != 0
          || !
#line 6059 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_INT_SIMD))
        return -1;
      return 198; /* arm_uqadd8 */

    case 54:
      if (pattern123 (x1) != 0
          || !
#line 6059 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_INT_SIMD))
        return -1;
      return 199; /* arm_uqsub8 */

    case 55:
      if (pattern123 (x1) != 0
          || !
#line 6059 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_INT_SIMD))
        return -1;
      return 200; /* arm_qadd16 */

    case 56:
      if (pattern123 (x1) != 0
          || !
#line 6059 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_INT_SIMD))
        return -1;
      return 201; /* arm_qasx */

    case 57:
      if (pattern123 (x1) != 0
          || !
#line 6059 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_INT_SIMD))
        return -1;
      return 202; /* arm_qsax */

    case 58:
      if (pattern123 (x1) != 0
          || !
#line 6059 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_INT_SIMD))
        return -1;
      return 203; /* arm_qsub16 */

    case 59:
      if (pattern123 (x1) != 0
          || !
#line 6059 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_INT_SIMD))
        return -1;
      return 204; /* arm_shadd16 */

    case 60:
      if (pattern123 (x1) != 0
          || !
#line 6059 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_INT_SIMD))
        return -1;
      return 205; /* arm_shasx */

    case 61:
      if (pattern123 (x1) != 0
          || !
#line 6059 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_INT_SIMD))
        return -1;
      return 206; /* arm_shsax */

    case 62:
      if (pattern123 (x1) != 0
          || !
#line 6059 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_INT_SIMD))
        return -1;
      return 207; /* arm_shsub16 */

    case 63:
      if (pattern123 (x1) != 0
          || !
#line 6059 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_INT_SIMD))
        return -1;
      return 208; /* arm_uhadd16 */

    case 64:
      if (pattern123 (x1) != 0
          || !
#line 6059 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_INT_SIMD))
        return -1;
      return 209; /* arm_uhasx */

    case 65:
      if (pattern123 (x1) != 0
          || !
#line 6059 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_INT_SIMD))
        return -1;
      return 210; /* arm_uhsax */

    case 66:
      if (pattern123 (x1) != 0
          || !
#line 6059 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_INT_SIMD))
        return -1;
      return 211; /* arm_uhsub16 */

    case 67:
      if (pattern123 (x1) != 0
          || !
#line 6059 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_INT_SIMD))
        return -1;
      return 212; /* arm_uqadd16 */

    case 68:
      if (pattern123 (x1) != 0
          || !
#line 6059 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_INT_SIMD))
        return -1;
      return 213; /* arm_uqasx */

    case 69:
      if (pattern123 (x1) != 0
          || !
#line 6059 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_INT_SIMD))
        return -1;
      return 214; /* arm_uqsax */

    case 70:
      if (pattern123 (x1) != 0
          || !
#line 6059 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_INT_SIMD))
        return -1;
      return 215; /* arm_uqsub16 */

    case 71:
      if (pattern123 (x1) != 0
          || !
#line 6059 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_INT_SIMD))
        return -1;
      return 216; /* arm_smusd */

    case 72:
      if (pattern123 (x1) != 0
          || !
#line 6059 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_INT_SIMD))
        return -1;
      return 217; /* arm_smusdx */

    case 43:
      if (pattern123 (x1) != 0
          || !
#line 6059 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_INT_SIMD))
        return -1;
      return 218; /* arm_sxtab16 */

    case 44:
      if (pattern123 (x1) != 0
          || !
#line 6059 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_INT_SIMD))
        return -1;
      return 219; /* arm_uxtab16 */

    case 73:
      if (pattern123 (x1) != 0
          || !
#line 6059 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_INT_SIMD))
        return -1;
      return 220; /* arm_usad8 */

    case 98:
      if (pattern123 (x1) != 0
          || !
#line 6132 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_INT_SIMD && !ARM_Q_BIT_READ))
        return -1;
      return 246; /* arm_smuad_insn */

    case 99:
      if (pattern123 (x1) != 0
          || !
#line 6132 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_INT_SIMD && !ARM_Q_BIT_READ))
        return -1;
      return 248; /* arm_smuadx_insn */

    case 100:
      return recog_243 (x1, insn, pnum_clobbers);

    case 101:
      return recog_242 (x1, insn, pnum_clobbers);

    case 27:
      if (GET_MODE (x2) != E_SImode)
        return -1;
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      if (!s_register_operand (operands[0], E_SImode))
        return -1;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      x5 = XVECEXP (x2, 0, 1);
      operands[2] = x5;
      if (!
#line 6683 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(flag_pic))
        return -1;
      return 258; /* pic_load_addr_unified */

    case 42:
      if (GET_MODE (x2) != E_SImode)
        return -1;
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      if (!s_register_operand (operands[0], E_SImode))
        return -1;
      x5 = XVECEXP (x2, 0, 1);
      operands[1] = x5;
      if (!nonimmediate_operand (operands[1], E_SImode))
        return -1;
      x4 = XVECEXP (x2, 0, 0);
      if (!rtx_equal_p (x4, operands[0]))
        return -1;
      return 289; /* restore_pic_register_after_call */

    case 3:
      return recog_224 (x1, insn, pnum_clobbers);

    case 123:
      if (pattern124 (x1, 
E_QImode, 
E_SImode) != 0
          || !
#line 12799 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_CRC32))
        return -1;
      return 429; /* arm_crc32b */

    case 124:
      if (pattern124 (x1, 
E_HImode, 
E_SImode) != 0
          || !
#line 12799 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_CRC32))
        return -1;
      return 430; /* arm_crc32h */

    case 125:
      if (pattern123 (x1) != 0
          || !
#line 12799 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_CRC32))
        return -1;
      return 431; /* arm_crc32w */

    case 126:
      if (pattern124 (x1, 
E_QImode, 
E_SImode) != 0
          || !
#line 12799 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_CRC32))
        return -1;
      return 432; /* arm_crc32cb */

    case 127:
      if (pattern124 (x1, 
E_HImode, 
E_SImode) != 0
          || !
#line 12799 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_CRC32))
        return -1;
      return 433; /* arm_crc32ch */

    case 128:
      if (pattern123 (x1) != 0
          || !
#line 12799 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_CRC32))
        return -1;
      return 434; /* arm_crc32cw */

    case 107:
      if (pattern125 (x1) != 0
          || !
#line 13093 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(arm_arch8m_main))
        return -1;
      return 514; /* pac_nop */

    case 462:
      return recog_223 (x1, insn, pnum_clobbers);

    case 463:
      return recog_222 (x1, insn, pnum_clobbers);

    case 13:
      if (pattern128 (x1, 
E_V4HImode, 
E_DImode) != 0
          || !
#line 528 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iwmmxt.md"
(TARGET_REALLY_IWMMXT))
        return -1;
      return 574; /* iwmmxt_wmacsz */

    case 14:
      if (pattern128 (x1, 
E_V4HImode, 
E_DImode) != 0
          || !
#line 549 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iwmmxt.md"
(TARGET_REALLY_IWMMXT))
        return -1;
      return 576; /* iwmmxt_wmacuz */

    case 6:
      return recog_241 (x1, insn, pnum_clobbers);

    case 10:
      return recog_187 (x1, insn, pnum_clobbers);

    case 113:
      if (pattern129 (x1, 
E_V4HImode) != 0
          || !
#line 371 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iwmmxt2.md"
(TARGET_REALLY_IWMMXT))
        return -1;
      return 710; /* iwmmxt_wqmulm */

    case 112:
      if (pattern129 (x1, 
E_V2SImode) != 0
          || !
#line 381 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iwmmxt2.md"
(TARGET_REALLY_IWMMXT))
        return -1;
      return 711; /* iwmmxt_wqmulwm */

    case 111:
      if (pattern129 (x1, 
E_V4HImode) != 0
          || !
#line 391 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iwmmxt2.md"
(TARGET_REALLY_IWMMXT))
        return -1;
      return 712; /* iwmmxt_wqmulmr */

    case 110:
      if (pattern129 (x1, 
E_V2SImode) != 0
          || !
#line 401 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iwmmxt2.md"
(TARGET_REALLY_IWMMXT))
        return -1;
      return 713; /* iwmmxt_wqmulwmr */

    case 299:
      return recog_159 (x1, insn, pnum_clobbers);

    case 179:
      if (pattern130 (x1) != 0
          || !
#line 1982 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/vfp.md"
(TARGET_VFP_FP16INST))
        return -1;
      return 880; /* neon_vcvths_nsi_unspec */

    case 180:
      if (pattern130 (x1) != 0
          || !
#line 1982 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/vfp.md"
(TARGET_VFP_FP16INST))
        return -1;
      return 881; /* neon_vcvthu_nsi_unspec */

    case 219:
      return recog_198 (x1, insn, pnum_clobbers);

    case 222:
      return recog_199 (x1, insn, pnum_clobbers);

    case 104:
      return recog_149 (x1, insn, pnum_clobbers);

    case 21:
      return recog_221 (x1, insn, pnum_clobbers);

    case 121:
      return recog_197 (x1, insn, pnum_clobbers);

    case 122:
      return recog_196 (x1, insn, pnum_clobbers);

    case 250:
      return recog_158 (x1, insn, pnum_clobbers);

    case 258:
      return recog_240 (x1, insn, pnum_clobbers);

    case 257:
      return recog_239 (x1, insn, pnum_clobbers);

    case 260:
      switch (pattern134 (x1))
        {
        case 0:
          if (!
#line 1402 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 1445; /* neon_vpuminv8qi */

        case 1:
          if (!
#line 1402 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 1446; /* neon_vpuminv4hi */

        case 2:
          if (!
#line 1402 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 1447; /* neon_vpuminv2si */

        default:
          return -1;
        }

    case 259:
      switch (pattern134 (x1))
        {
        case 0:
          if (!
#line 1412 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 1448; /* neon_vpumaxv8qi */

        case 1:
          if (!
#line 1412 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 1449; /* neon_vpumaxv4hi */

        case 2:
          if (!
#line 1412 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 1450; /* neon_vpumaxv2si */

        default:
          return -1;
        }

    case 153:
      switch (pattern135 (x1))
        {
        case 0:
          if (!
#line 1555 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 1467; /* neon_vaddv2sf_unspec */

        case 1:
          if (!
#line 1555 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 1468; /* neon_vaddv4sf_unspec */

        default:
          return -1;
        }

    case 156:
      switch (pattern136 (x1, 
E_V8QImode, 
E_V4HImode, 
E_V2SImode))
        {
        case 0:
          if (!
#line 1568 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 1469; /* neon_vaddlsv8qi */

        case 1:
          if (!
#line 1568 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 1471; /* neon_vaddlsv4hi */

        case 2:
          if (!
#line 1568 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 1473; /* neon_vaddlsv2si */

        default:
          return -1;
        }

    case 157:
      switch (pattern136 (x1, 
E_V8QImode, 
E_V4HImode, 
E_V2SImode))
        {
        case 0:
          if (!
#line 1568 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 1470; /* neon_vaddluv8qi */

        case 1:
          if (!
#line 1568 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 1472; /* neon_vaddluv4hi */

        case 2:
          if (!
#line 1568 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 1474; /* neon_vaddluv2si */

        default:
          return -1;
        }

    case 158:
      switch (pattern137 (x1))
        {
        case 0:
          if (!
#line 1578 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 1475; /* neon_vaddwsv8qi */

        case 1:
          if (!
#line 1578 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 1477; /* neon_vaddwsv4hi */

        case 2:
          if (!
#line 1578 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 1479; /* neon_vaddwsv2si */

        default:
          return -1;
        }

    case 159:
      switch (pattern137 (x1))
        {
        case 0:
          if (!
#line 1578 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 1476; /* neon_vaddwuv8qi */

        case 1:
          if (!
#line 1578 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 1478; /* neon_vaddwuv4hi */

        case 2:
          if (!
#line 1578 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 1480; /* neon_vaddwuv2si */

        default:
          return -1;
        }

    case 194:
      return recog_220 (x1, insn, pnum_clobbers);

    case 195:
      return recog_219 (x1, insn, pnum_clobbers);

    case 192:
      return recog_218 (x1, insn, pnum_clobbers);

    case 193:
      return recog_217 (x1, insn, pnum_clobbers);

    case 262:
      return recog_186 (x1, insn, pnum_clobbers);

    case 263:
      return recog_185 (x1, insn, pnum_clobbers);

    case 154:
      switch (pattern140 (x1))
        {
        case 0:
          if (!
#line 1610 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 1521; /* neon_vaddhnv8hi */

        case 1:
          if (!
#line 1610 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 1523; /* neon_vaddhnv4si */

        case 2:
          if (!
#line 1610 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 1525; /* neon_vaddhnv2di */

        default:
          return -1;
        }

    case 155:
      switch (pattern140 (x1))
        {
        case 0:
          if (!
#line 1610 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 1522; /* neon_vraddhnv8hi */

        case 1:
          if (!
#line 1610 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 1524; /* neon_vraddhnv4si */

        case 2:
          if (!
#line 1610 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 1526; /* neon_vraddhnv2di */

        default:
          return -1;
        }

    case 241:
      return recog_184 (x1, insn, pnum_clobbers);

    case 268:
      return recog_238 (x1, insn, pnum_clobbers);

    case 270:
      return recog_237 (x1, insn, pnum_clobbers);

    case 243:
      switch (pattern136 (x1, 
E_V8QImode, 
E_V4HImode, 
E_V2SImode))
        {
        case 0:
          if (!
#line 2224 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 1605; /* neon_vmullsv8qi */

        case 1:
          if (!
#line 2224 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 1608; /* neon_vmullsv4hi */

        case 2:
          if (!
#line 2224 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 1611; /* neon_vmullsv2si */

        default:
          return -1;
        }

    case 244:
      switch (pattern136 (x1, 
E_V8QImode, 
E_V4HImode, 
E_V2SImode))
        {
        case 0:
          if (!
#line 2224 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 1606; /* neon_vmulluv8qi */

        case 1:
          if (!
#line 2224 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 1609; /* neon_vmulluv4hi */

        case 2:
          if (!
#line 2224 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 1612; /* neon_vmulluv2si */

        default:
          return -1;
        }

    case 242:
      switch (pattern136 (x1, 
E_V8QImode, 
E_V4HImode, 
E_V2SImode))
        {
        case 0:
          if (!
#line 2224 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 1607; /* neon_vmullpv8qi */

        case 1:
          if (!
#line 2224 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 1610; /* neon_vmullpv4hi */

        case 2:
          if (!
#line 2224 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 1613; /* neon_vmullpv2si */

        default:
          return -1;
        }

    case 272:
      switch (pattern142 (x1, 
E_V4HImode, 
E_V2SImode))
        {
        case 0:
          if (!
#line 2234 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 1614; /* neon_vqdmullv4hi */

        case 1:
          if (!
#line 2234 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 1615; /* neon_vqdmullv2si */

        default:
          return -1;
        }

    case 336:
      switch (pattern135 (x1))
        {
        case 0:
          if (!
#line 2260 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 1616; /* neon_vsubv2sf_unspec */

        case 1:
          if (!
#line 2260 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 1617; /* neon_vsubv4sf_unspec */

        default:
          return -1;
        }

    case 339:
      switch (pattern136 (x1, 
E_V8QImode, 
E_V4HImode, 
E_V2SImode))
        {
        case 0:
          if (!
#line 2273 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 1618; /* neon_vsublsv8qi */

        case 1:
          if (!
#line 2273 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 1620; /* neon_vsublsv4hi */

        case 2:
          if (!
#line 2273 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 1622; /* neon_vsublsv2si */

        default:
          return -1;
        }

    case 340:
      switch (pattern136 (x1, 
E_V8QImode, 
E_V4HImode, 
E_V2SImode))
        {
        case 0:
          if (!
#line 2273 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 1619; /* neon_vsubluv8qi */

        case 1:
          if (!
#line 2273 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 1621; /* neon_vsubluv4hi */

        case 2:
          if (!
#line 2273 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 1623; /* neon_vsubluv2si */

        default:
          return -1;
        }

    case 341:
      switch (pattern137 (x1))
        {
        case 0:
          if (!
#line 2283 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 1624; /* neon_vsubwsv8qi */

        case 1:
          if (!
#line 2283 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 1626; /* neon_vsubwsv4hi */

        case 2:
          if (!
#line 2283 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 1628; /* neon_vsubwsv2si */

        default:
          return -1;
        }

    case 342:
      switch (pattern137 (x1))
        {
        case 0:
          if (!
#line 2283 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 1625; /* neon_vsubwuv8qi */

        case 1:
          if (!
#line 2283 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 1627; /* neon_vsubwuv4hi */

        case 2:
          if (!
#line 2283 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 1629; /* neon_vsubwuv2si */

        default:
          return -1;
        }

    case 291:
      return recog_183 (x1, insn, pnum_clobbers);

    case 292:
      return recog_182 (x1, insn, pnum_clobbers);

    case 196:
      return recog_216 (x1, insn, pnum_clobbers);

    case 197:
      return recog_215 (x1, insn, pnum_clobbers);

    case 337:
      switch (pattern140 (x1))
        {
        case 0:
          if (!
#line 2313 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 1658; /* neon_vsubhnv8hi */

        case 1:
          if (!
#line 2313 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 1660; /* neon_vsubhnv4si */

        case 2:
          if (!
#line 2313 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 1662; /* neon_vsubhnv2di */

        default:
          return -1;
        }

    case 338:
      switch (pattern140 (x1))
        {
        case 0:
          if (!
#line 2313 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 1659; /* neon_vrsubhnv8hi */

        case 1:
          if (!
#line 2313 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 1661; /* neon_vrsubhnv4si */

        case 2:
          if (!
#line 2313 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 1663; /* neon_vrsubhnv2di */

        default:
          return -1;
        }

    case 165:
      return recog_236 (x1, insn, pnum_clobbers);

    case 168:
      return recog_234 (x1, insn, pnum_clobbers);

    case 166:
      return recog_235 (x1, insn, pnum_clobbers);

    case 354:
      return recog_233 (x1, insn, pnum_clobbers);

    case 353:
      return recog_232 (x1, insn, pnum_clobbers);

    case 161:
      return recog_231 (x1, insn, pnum_clobbers);

    case 162:
      return recog_230 (x1, insn, pnum_clobbers);

    case 163:
      return recog_229 (x1, insn, pnum_clobbers);

    case 164:
      return recog_228 (x1, insn, pnum_clobbers);

    case 149:
      return recog_214 (x1, insn, pnum_clobbers);

    case 150:
      return recog_213 (x1, insn, pnum_clobbers);

    case 148:
      return recog_181 (x1, insn, pnum_clobbers);

    case 151:
      switch (pattern136 (x1, 
E_V8QImode, 
E_V4HImode, 
E_V2SImode))
        {
        case 0:
          if (!
#line 2623 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 1800; /* neon_vabdlsv8qi */

        case 1:
          if (!
#line 2623 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 1802; /* neon_vabdlsv4hi */

        case 2:
          if (!
#line 2623 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 1804; /* neon_vabdlsv2si */

        default:
          return -1;
        }

    case 152:
      switch (pattern136 (x1, 
E_V8QImode, 
E_V4HImode, 
E_V2SImode))
        {
        case 0:
          if (!
#line 2623 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 1801; /* neon_vabdluv8qi */

        case 1:
          if (!
#line 2623 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 1803; /* neon_vabdluv4hi */

        case 2:
          if (!
#line 2623 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 1805; /* neon_vabdluv2si */

        default:
          return -1;
        }

    case 217:
      return recog_157 (x1, insn, pnum_clobbers);

    case 218:
      return recog_212 (x1, insn, pnum_clobbers);

    case 220:
      return recog_156 (x1, insn, pnum_clobbers);

    case 221:
      return recog_210 (x1, insn, pnum_clobbers);

    case 253:
      return recog_211 (x1, insn, pnum_clobbers);

    case 255:
      return recog_209 (x1, insn, pnum_clobbers);

    case 248:
      return recog_208 (x1, insn, pnum_clobbers);

    case 249:
      return recog_207 (x1, insn, pnum_clobbers);

    case 254:
      switch (pattern134 (x1))
        {
        case 0:
          if (!
#line 2776 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 1891; /* neon_vpmaxuv8qi */

        case 1:
          if (!
#line 2776 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 1895; /* neon_vpmaxuv4hi */

        case 2:
          if (!
#line 2776 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 1899; /* neon_vpmaxuv2si */

        default:
          return -1;
        }

    case 256:
      switch (pattern134 (x1))
        {
        case 0:
          if (!
#line 2776 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 1893; /* neon_vpminuv8qi */

        case 1:
          if (!
#line 2776 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 1897; /* neon_vpminuv4hi */

        case 2:
          if (!
#line 2776 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 1901; /* neon_vpminuv2si */

        default:
          return -1;
        }

    case 294:
      return recog_180 (x1, insn, pnum_clobbers);

    case 376:
      return recog_143 (x1, insn, pnum_clobbers);

    case 377:
      return recog_142 (x1, insn, pnum_clobbers);

    case 175:
      return recog_179 (x1, insn, pnum_clobbers);

    case 176:
      return recog_178 (x1, insn, pnum_clobbers);

    case 300:
      return recog_177 (x1, insn, pnum_clobbers);

    case 301:
      return recog_176 (x1, insn, pnum_clobbers);

    case 302:
      return recog_175 (x1, insn, pnum_clobbers);

    case 303:
      return recog_174 (x1, insn, pnum_clobbers);

    case 278:
      return recog_173 (x1, insn, pnum_clobbers);

    case 279:
      return recog_172 (x1, insn, pnum_clobbers);

    case 280:
      return recog_171 (x1, insn, pnum_clobbers);

    case 281:
      return recog_170 (x1, insn, pnum_clobbers);

    case 307:
      return recog_169 (x1, insn, pnum_clobbers);

    case 308:
      return recog_168 (x1, insn, pnum_clobbers);

    case 309:
      return recog_167 (x1, insn, pnum_clobbers);

    case 310:
      return recog_166 (x1, insn, pnum_clobbers);

    case 311:
      switch (pattern153 (x1))
        {
        case 0:
          if (!
#line 4534 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2368; /* neon_vshrn_nv8hi */

        case 1:
          if (!
#line 4534 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2370; /* neon_vshrn_nv4si */

        case 2:
          if (!
#line 4534 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2372; /* neon_vshrn_nv2di */

        default:
          return -1;
        }

    case 312:
      switch (pattern153 (x1))
        {
        case 0:
          if (!
#line 4534 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2369; /* neon_vrshrn_nv8hi */

        case 1:
          if (!
#line 4534 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2371; /* neon_vrshrn_nv4si */

        case 2:
          if (!
#line 4534 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2373; /* neon_vrshrn_nv2di */

        default:
          return -1;
        }

    case 285:
      switch (pattern153 (x1))
        {
        case 0:
          if (!
#line 4548 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2374; /* neon_vqshrns_nv8hi */

        case 1:
          if (!
#line 4548 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2378; /* neon_vqshrns_nv4si */

        case 2:
          if (!
#line 4548 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2382; /* neon_vqshrns_nv2di */

        default:
          return -1;
        }

    case 286:
      switch (pattern153 (x1))
        {
        case 0:
          if (!
#line 4548 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2375; /* neon_vqshrnu_nv8hi */

        case 1:
          if (!
#line 4548 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2379; /* neon_vqshrnu_nv4si */

        case 2:
          if (!
#line 4548 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2383; /* neon_vqshrnu_nv2di */

        default:
          return -1;
        }

    case 287:
      switch (pattern153 (x1))
        {
        case 0:
          if (!
#line 4548 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2376; /* neon_vqrshrns_nv8hi */

        case 1:
          if (!
#line 4548 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2380; /* neon_vqrshrns_nv4si */

        case 2:
          if (!
#line 4548 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2384; /* neon_vqrshrns_nv2di */

        default:
          return -1;
        }

    case 288:
      switch (pattern153 (x1))
        {
        case 0:
          if (!
#line 4548 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2377; /* neon_vqrshrnu_nv8hi */

        case 1:
          if (!
#line 4548 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2381; /* neon_vqrshrnu_nv4si */

        case 2:
          if (!
#line 4548 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2385; /* neon_vqrshrnu_nv2di */

        default:
          return -1;
        }

    case 289:
      switch (pattern153 (x1))
        {
        case 0:
          if (!
#line 4562 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2386; /* neon_vqshrun_nv8hi */

        case 1:
          if (!
#line 4562 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2388; /* neon_vqshrun_nv4si */

        case 2:
          if (!
#line 4562 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2390; /* neon_vqshrun_nv2di */

        default:
          return -1;
        }

    case 290:
      switch (pattern153 (x1))
        {
        case 0:
          if (!
#line 4562 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2387; /* neon_vqrshrun_nv8hi */

        case 1:
          if (!
#line 4562 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2389; /* neon_vqrshrun_nv4si */

        case 2:
          if (!
#line 4562 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2391; /* neon_vqrshrun_nv2di */

        default:
          return -1;
        }

    case 306:
      return recog_165 (x1, insn, pnum_clobbers);

    case 282:
      return recog_164 (x1, insn, pnum_clobbers);

    case 283:
      return recog_163 (x1, insn, pnum_clobbers);

    case 284:
      return recog_162 (x1, insn, pnum_clobbers);

    case 304:
      switch (pattern154 (x1))
        {
        case 0:
          if (!
#line 4614 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2424; /* neon_vshlls_nv8qi */

        case 1:
          if (!
#line 4614 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2426; /* neon_vshlls_nv4hi */

        case 2:
          if (!
#line 4614 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2428; /* neon_vshlls_nv2si */

        default:
          return -1;
        }

    case 305:
      switch (pattern154 (x1))
        {
        case 0:
          if (!
#line 4614 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2425; /* neon_vshllu_nv8qi */

        case 1:
          if (!
#line 4614 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2427; /* neon_vshllu_nv4hi */

        case 2:
          if (!
#line 4614 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
            return -1;
          return 2429; /* neon_vshllu_nv2si */

        default:
          return -1;
        }

    case 343:
      return recog_145 (x1, insn, pnum_clobbers);

    case 171:
      if (pattern155 (x1, 
E_V16QImode, 
E_OImode) != 0
          || !
#line 4814 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/neon.md"
(TARGET_NEON))
        return -1;
      return 2484; /* neon_vcombinev16qi */

    case 198:
      return recog_137 (x1, insn, pnum_clobbers);

    case 199:
      return recog_195 (x1, insn, pnum_clobbers);

    case 201:
      return recog_194 (x1, insn, pnum_clobbers);

    case 319:
      return recog_136 (x1, insn, pnum_clobbers);

    case 320:
      return recog_147 (x1, insn, pnum_clobbers);

    case 321:
      return recog_146 (x1, insn, pnum_clobbers);

    case 322:
      return recog_193 (x1, insn, pnum_clobbers);

    case 323:
      return recog_192 (x1, insn, pnum_clobbers);

    case 324:
      return recog_135 (x1, insn, pnum_clobbers);

    case 204:
      return recog_141 (x1, insn, pnum_clobbers);

    case 205:
      return recog_138 (x1, insn, pnum_clobbers);

    case 325:
      return recog_140 (x1, insn, pnum_clobbers);

    case 207:
      return recog_191 (x1, insn, pnum_clobbers);

    case 208:
      return recog_206 (x1, insn, pnum_clobbers);

    case 210:
      return recog_150 (x1, insn, pnum_clobbers);

    case 327:
      return recog_190 (x1, insn, pnum_clobbers);

    case 328:
      return recog_205 (x1, insn, pnum_clobbers);

    case 329:
      return recog_204 (x1, insn, pnum_clobbers);

    case 212:
      return recog_189 (x1, insn, pnum_clobbers);

    case 213:
      return recog_203 (x1, insn, pnum_clobbers);

    case 215:
      return recog_139 (x1, insn, pnum_clobbers);

    case 331:
      return recog_188 (x1, insn, pnum_clobbers);

    case 332:
      return recog_202 (x1, insn, pnum_clobbers);

    case 333:
      return recog_201 (x1, insn, pnum_clobbers);

    case 393:
      return recog_227 (x1, insn, pnum_clobbers);

    case 139:
      if (pattern129 (x1, 
E_V4SImode) != 0
          || !
#line 213 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/crypto.md"
(TARGET_CRYPTO))
        return -1;
      return 3053; /* crypto_sha1su1 */

    case 142:
      if (pattern129 (x1, 
E_V4SImode) != 0
          || !
#line 213 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/crypto.md"
(TARGET_CRYPTO))
        return -1;
      return 3054; /* crypto_sha256su0 */

    case 144:
      if (pattern128 (x1, 
E_DImode, 
E_TImode) != 0
          || !
#line 262 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/crypto.md"
(TARGET_CRYPTO))
        return -1;
      return 3060; /* crypto_vmullp64 */

    case 397:
      return recog_155 (x1, insn, pnum_clobbers);

    case 452:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      x5 = XVECEXP (x2, 0, 1);
      operands[2] = x5;
      if (!s_register_operand (operands[2], E_SImode))
        return -1;
      switch (pattern113 (x2))
        {
        case 0:
          if (!
#line 496 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
            return -1;
          return 3357; /* mve_vbrsrq_n_fv8hf */

        case 1:
          if (!
#line 496 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
            return -1;
          return 3358; /* mve_vbrsrq_n_fv4sf */

        default:
          return -1;
        }

    case 450:
      switch (pattern169 (x1))
        {
        case 0:
          if (!
#line 512 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
            return -1;
          return 3359; /* mve_vcvtq_n_to_f_sv8hf */

        case 1:
          if (!
#line 512 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
            return -1;
          return 3361; /* mve_vcvtq_n_to_f_sv4sf */

        default:
          return -1;
        }

    case 451:
      switch (pattern169 (x1))
        {
        case 0:
          if (!
#line 512 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
            return -1;
          return 3360; /* mve_vcvtq_n_to_f_uv8hf */

        case 1:
          if (!
#line 512 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
            return -1;
          return 3362; /* mve_vcvtq_n_to_f_uv4sf */

        default:
          return -1;
        }

    case 449:
      return recog_161 (x1, insn, pnum_clobbers);

    case 454:
      return recog_226 (x1, insn, pnum_clobbers);

    case 455:
      return recog_225 (x1, insn, pnum_clobbers);

    case 496:
      switch (pattern171 (x1))
        {
        case 0:
          if (!
#line 559 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3373; /* mve_vrshrq_n_sv16qi */

        case 1:
          if (!
#line 559 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3377; /* mve_vrshrq_n_sv8hi */

        case 2:
          if (!
#line 559 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3381; /* mve_vrshrq_n_sv4si */

        default:
          return -1;
        }

    case 533:
      switch (pattern171 (x1))
        {
        case 0:
          if (!
#line 559 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3374; /* mve_vrshrq_n_uv16qi */

        case 1:
          if (!
#line 559 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3378; /* mve_vrshrq_n_uv8hi */

        case 2:
          if (!
#line 559 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3382; /* mve_vrshrq_n_uv4si */

        default:
          return -1;
        }

    case 456:
      switch (pattern171 (x1))
        {
        case 0:
          if (!
#line 559 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3375; /* mve_vshrq_n_sv16qi */

        case 1:
          if (!
#line 559 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3379; /* mve_vshrq_n_sv8hi */

        case 2:
          if (!
#line 559 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3383; /* mve_vshrq_n_sv4si */

        default:
          return -1;
        }

    case 457:
      switch (pattern171 (x1))
        {
        case 0:
          if (!
#line 559 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3376; /* mve_vshrq_n_uv16qi */

        case 1:
          if (!
#line 559 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3380; /* mve_vshrq_n_uv8hi */

        case 2:
          if (!
#line 559 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3384; /* mve_vshrq_n_uv4si */

        default:
          return -1;
        }

    case 458:
      switch (pattern172 (x1))
        {
        case 0:
          if (!
#line 610 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
            return -1;
          return 3391; /* mve_vcvtq_n_from_f_sv8hi */

        case 1:
          if (!
#line 610 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
            return -1;
          return 3393; /* mve_vcvtq_n_from_f_sv4si */

        default:
          return -1;
        }

    case 459:
      switch (pattern172 (x1))
        {
        case 0:
          if (!
#line 610 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
            return -1;
          return 3392; /* mve_vcvtq_n_from_f_uv8hi */

        case 1:
          if (!
#line 610 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
            return -1;
          return 3394; /* mve_vcvtq_n_from_f_uv4si */

        default:
          return -1;
        }

    case 460:
      if (pattern173 (x1) != 0
          || !
#line 626 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
        return -1;
      return 3395; /* mve_vaddlvq_p_sv4si */

    case 461:
      if (pattern173 (x1) != 0
          || !
#line 626 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
        return -1;
      return 3396; /* mve_vaddlvq_p_uv4si */

    case 464:
      switch (pattern174 (x1))
        {
        case 0:
          if (!
#line 689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3445; /* mve_vabdq_sv16qi */

        case 1:
          if (!
#line 689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3469; /* mve_vabdq_sv8hi */

        case 2:
          if (!
#line 689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3493; /* mve_vabdq_sv4si */

        default:
          return -1;
        }

    case 501:
      switch (pattern174 (x1))
        {
        case 0:
          if (!
#line 689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3446; /* mve_vabdq_uv16qi */

        case 1:
          if (!
#line 689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3470; /* mve_vabdq_uv8hi */

        case 2:
          if (!
#line 689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3494; /* mve_vabdq_uv4si */

        default:
          return -1;
        }

    case 469:
      switch (pattern174 (x1))
        {
        case 0:
          if (!
#line 689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3447; /* mve_vhaddq_sv16qi */

        case 1:
          if (!
#line 689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3471; /* mve_vhaddq_sv8hi */

        case 2:
          if (!
#line 689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3495; /* mve_vhaddq_sv4si */

        default:
          return -1;
        }

    case 506:
      switch (pattern174 (x1))
        {
        case 0:
          if (!
#line 689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3448; /* mve_vhaddq_uv16qi */

        case 1:
          if (!
#line 689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3472; /* mve_vhaddq_uv8hi */

        case 2:
          if (!
#line 689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3496; /* mve_vhaddq_uv4si */

        default:
          return -1;
        }

    case 471:
      switch (pattern174 (x1))
        {
        case 0:
          if (!
#line 689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3449; /* mve_vhsubq_sv16qi */

        case 1:
          if (!
#line 689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3473; /* mve_vhsubq_sv8hi */

        case 2:
          if (!
#line 689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3497; /* mve_vhsubq_sv4si */

        default:
          return -1;
        }

    case 508:
      switch (pattern174 (x1))
        {
        case 0:
          if (!
#line 689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3450; /* mve_vhsubq_uv16qi */

        case 1:
          if (!
#line 689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3474; /* mve_vhsubq_uv8hi */

        case 2:
          if (!
#line 689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3498; /* mve_vhsubq_uv4si */

        default:
          return -1;
        }

    case 478:
      switch (pattern174 (x1))
        {
        case 0:
          if (!
#line 689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3451; /* mve_vmulhq_sv16qi */

        case 1:
          if (!
#line 689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3475; /* mve_vmulhq_sv8hi */

        case 2:
          if (!
#line 689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3499; /* mve_vmulhq_sv4si */

        default:
          return -1;
        }

    case 515:
      switch (pattern174 (x1))
        {
        case 0:
          if (!
#line 689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3452; /* mve_vmulhq_uv16qi */

        case 1:
          if (!
#line 689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3476; /* mve_vmulhq_uv8hi */

        case 2:
          if (!
#line 689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3500; /* mve_vmulhq_uv4si */

        default:
          return -1;
        }

    case 483:
      switch (pattern174 (x1))
        {
        case 0:
          if (!
#line 689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3453; /* mve_vqaddq_sv16qi */

        case 1:
          if (!
#line 689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3477; /* mve_vqaddq_sv8hi */

        case 2:
          if (!
#line 689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3501; /* mve_vqaddq_sv4si */

        default:
          return -1;
        }

    case 520:
      switch (pattern174 (x1))
        {
        case 0:
          if (!
#line 689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3454; /* mve_vqaddq_uv16qi */

        case 1:
          if (!
#line 689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3478; /* mve_vqaddq_uv8hi */

        case 2:
          if (!
#line 689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3502; /* mve_vqaddq_uv4si */

        default:
          return -1;
        }

    case 548:
      switch (pattern174 (x1))
        {
        case 0:
          if (!
#line 689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3455; /* mve_vqdmulhq_sv16qi */

        case 1:
          if (!
#line 689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3479; /* mve_vqdmulhq_sv8hi */

        case 2:
          if (!
#line 689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3503; /* mve_vqdmulhq_sv4si */

        default:
          return -1;
        }

    case 550:
      switch (pattern174 (x1))
        {
        case 0:
          if (!
#line 689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3456; /* mve_vqrdmulhq_sv16qi */

        case 1:
          if (!
#line 689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3480; /* mve_vqrdmulhq_sv8hi */

        case 2:
          if (!
#line 689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3504; /* mve_vqrdmulhq_sv4si */

        default:
          return -1;
        }

    case 485:
      switch (pattern174 (x1))
        {
        case 0:
          if (!
#line 689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3457; /* mve_vqrshlq_sv16qi */

        case 1:
          if (!
#line 689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3481; /* mve_vqrshlq_sv8hi */

        case 2:
          if (!
#line 689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3505; /* mve_vqrshlq_sv4si */

        default:
          return -1;
        }

    case 522:
      switch (pattern174 (x1))
        {
        case 0:
          if (!
#line 689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3458; /* mve_vqrshlq_uv16qi */

        case 1:
          if (!
#line 689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3482; /* mve_vqrshlq_uv8hi */

        case 2:
          if (!
#line 689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3506; /* mve_vqrshlq_uv4si */

        default:
          return -1;
        }

    case 487:
      switch (pattern174 (x1))
        {
        case 0:
          if (!
#line 689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3459; /* mve_vqshlq_sv16qi */

        case 1:
          if (!
#line 689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3483; /* mve_vqshlq_sv8hi */

        case 2:
          if (!
#line 689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3507; /* mve_vqshlq_sv4si */

        default:
          return -1;
        }

    case 524:
      switch (pattern174 (x1))
        {
        case 0:
          if (!
#line 689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3460; /* mve_vqshlq_uv16qi */

        case 1:
          if (!
#line 689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3484; /* mve_vqshlq_uv8hi */

        case 2:
          if (!
#line 689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3508; /* mve_vqshlq_uv4si */

        default:
          return -1;
        }

    case 490:
      switch (pattern174 (x1))
        {
        case 0:
          if (!
#line 689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3461; /* mve_vqsubq_sv16qi */

        case 1:
          if (!
#line 689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3485; /* mve_vqsubq_sv8hi */

        case 2:
          if (!
#line 689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3509; /* mve_vqsubq_sv4si */

        default:
          return -1;
        }

    case 527:
      switch (pattern174 (x1))
        {
        case 0:
          if (!
#line 689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3462; /* mve_vqsubq_uv16qi */

        case 1:
          if (!
#line 689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3486; /* mve_vqsubq_uv8hi */

        case 2:
          if (!
#line 689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3510; /* mve_vqsubq_uv4si */

        default:
          return -1;
        }

    case 492:
      switch (pattern174 (x1))
        {
        case 0:
          if (!
#line 689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3463; /* mve_vrhaddq_sv16qi */

        case 1:
          if (!
#line 689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3487; /* mve_vrhaddq_sv8hi */

        case 2:
          if (!
#line 689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3511; /* mve_vrhaddq_sv4si */

        default:
          return -1;
        }

    case 529:
      switch (pattern174 (x1))
        {
        case 0:
          if (!
#line 689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3464; /* mve_vrhaddq_uv16qi */

        case 1:
          if (!
#line 689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3488; /* mve_vrhaddq_uv8hi */

        case 2:
          if (!
#line 689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3512; /* mve_vrhaddq_uv4si */

        default:
          return -1;
        }

    case 493:
      switch (pattern174 (x1))
        {
        case 0:
          if (!
#line 689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3465; /* mve_vrmulhq_sv16qi */

        case 1:
          if (!
#line 689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3489; /* mve_vrmulhq_sv8hi */

        case 2:
          if (!
#line 689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3513; /* mve_vrmulhq_sv4si */

        default:
          return -1;
        }

    case 530:
      switch (pattern174 (x1))
        {
        case 0:
          if (!
#line 689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3466; /* mve_vrmulhq_uv16qi */

        case 1:
          if (!
#line 689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3490; /* mve_vrmulhq_uv8hi */

        case 2:
          if (!
#line 689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3514; /* mve_vrmulhq_uv4si */

        default:
          return -1;
        }

    case 494:
      switch (pattern174 (x1))
        {
        case 0:
          if (!
#line 689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3467; /* mve_vrshlq_sv16qi */

        case 1:
          if (!
#line 689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3491; /* mve_vrshlq_sv8hi */

        case 2:
          if (!
#line 689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3515; /* mve_vrshlq_sv4si */

        default:
          return -1;
        }

    case 531:
      switch (pattern174 (x1))
        {
        case 0:
          if (!
#line 689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3468; /* mve_vrshlq_uv16qi */

        case 1:
          if (!
#line 689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3492; /* mve_vrshlq_uv8hi */

        case 2:
          if (!
#line 689 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3516; /* mve_vrshlq_uv4si */

        default:
          return -1;
        }

    case 465:
      switch (pattern175 (x1))
        {
        case 0:
          if (!
#line 707 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3517; /* mve_vaddq_n_sv16qi */

        case 1:
          if (!
#line 707 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3523; /* mve_vaddq_n_sv8hi */

        case 2:
          if (!
#line 707 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3529; /* mve_vaddq_n_sv4si */

        default:
          return -1;
        }

    case 502:
      switch (pattern175 (x1))
        {
        case 0:
          if (!
#line 707 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3518; /* mve_vaddq_n_uv16qi */

        case 1:
          if (!
#line 707 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3524; /* mve_vaddq_n_uv8hi */

        case 2:
          if (!
#line 707 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3530; /* mve_vaddq_n_uv4si */

        default:
          return -1;
        }

    case 482:
      switch (pattern175 (x1))
        {
        case 0:
          if (!
#line 707 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3519; /* mve_vmulq_n_sv16qi */

        case 1:
          if (!
#line 707 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3525; /* mve_vmulq_n_sv8hi */

        case 2:
          if (!
#line 707 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3531; /* mve_vmulq_n_sv4si */

        default:
          return -1;
        }

    case 519:
      switch (pattern175 (x1))
        {
        case 0:
          if (!
#line 707 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3520; /* mve_vmulq_n_uv16qi */

        case 1:
          if (!
#line 707 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3526; /* mve_vmulq_n_uv8hi */

        case 2:
          if (!
#line 707 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3532; /* mve_vmulq_n_uv4si */

        default:
          return -1;
        }

    case 500:
      switch (pattern175 (x1))
        {
        case 0:
          if (!
#line 707 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3521; /* mve_vsubq_n_sv16qi */

        case 1:
          if (!
#line 707 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3527; /* mve_vsubq_n_sv8hi */

        case 2:
          if (!
#line 707 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3533; /* mve_vsubq_n_sv4si */

        default:
          return -1;
        }

    case 537:
      switch (pattern175 (x1))
        {
        case 0:
          if (!
#line 707 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3522; /* mve_vsubq_n_uv16qi */

        case 1:
          if (!
#line 707 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3528; /* mve_vsubq_n_uv8hi */

        case 2:
          if (!
#line 707 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3534; /* mve_vsubq_n_uv4si */

        default:
          return -1;
        }

    case 466:
      switch (pattern176 (x1))
        {
        case 0:
          if (!
#line 723 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3535; /* mve_vaddvaq_sv16qi */

        case 1:
          if (!
#line 723 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3537; /* mve_vaddvaq_sv8hi */

        case 2:
          if (!
#line 723 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3539; /* mve_vaddvaq_sv4si */

        default:
          return -1;
        }

    case 503:
      switch (pattern176 (x1))
        {
        case 0:
          if (!
#line 723 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3536; /* mve_vaddvaq_uv16qi */

        case 1:
          if (!
#line 723 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3538; /* mve_vaddvaq_uv8hi */

        case 2:
          if (!
#line 723 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3540; /* mve_vaddvaq_uv4si */

        default:
          return -1;
        }

    case 504:
      switch (pattern177 (x1))
        {
        case 0:
          if (!
#line 740 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3541; /* mve_vaddvq_p_uv16qi */

        case 1:
          if (!
#line 740 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3543; /* mve_vaddvq_p_uv8hi */

        case 2:
          if (!
#line 740 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3545; /* mve_vaddvq_p_uv4si */

        default:
          return -1;
        }

    case 467:
      switch (pattern177 (x1))
        {
        case 0:
          if (!
#line 740 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3542; /* mve_vaddvq_p_sv16qi */

        case 1:
          if (!
#line 740 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3544; /* mve_vaddvq_p_sv8hi */

        case 2:
          if (!
#line 740 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3546; /* mve_vaddvq_p_sv4si */

        default:
          return -1;
        }

    case 505:
      switch (pattern178 (x1))
        {
        case 0:
          if (!
#line 811 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3553; /* mve_vbrsrq_n_uv16qi */

        case 1:
          if (!
#line 811 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3555; /* mve_vbrsrq_n_uv8hi */

        case 2:
          if (!
#line 811 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3557; /* mve_vbrsrq_n_uv4si */

        default:
          return -1;
        }

    case 468:
      switch (pattern178 (x1))
        {
        case 0:
          if (!
#line 811 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3554; /* mve_vbrsrq_n_sv16qi */

        case 1:
          if (!
#line 811 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3556; /* mve_vbrsrq_n_sv8hi */

        case 2:
          if (!
#line 811 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3558; /* mve_vbrsrq_n_sv4si */

        default:
          return -1;
        }

    case 539:
      switch (pattern174 (x1))
        {
        case 0:
          if (!
#line 830 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3561; /* mve_vhcaddq_rot90_sv16qi */

        case 1:
          if (!
#line 830 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3565; /* mve_vhcaddq_rot90_sv8hi */

        case 2:
          if (!
#line 830 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3569; /* mve_vhcaddq_rot90_sv4si */

        default:
          return -1;
        }

    case 538:
      switch (pattern174 (x1))
        {
        case 0:
          if (!
#line 830 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3562; /* mve_vhcaddq_rot270_sv16qi */

        case 1:
          if (!
#line 830 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3566; /* mve_vhcaddq_rot270_sv8hi */

        case 2:
          if (!
#line 830 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3570; /* mve_vhcaddq_rot270_sv4si */

        default:
          return -1;
        }

    case 470:
      switch (pattern175 (x1))
        {
        case 0:
          if (!
#line 883 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3574; /* mve_vhaddq_n_sv16qi */

        case 1:
          if (!
#line 883 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3584; /* mve_vhaddq_n_sv8hi */

        case 2:
          if (!
#line 883 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3594; /* mve_vhaddq_n_sv4si */

        default:
          return -1;
        }

    case 507:
      switch (pattern175 (x1))
        {
        case 0:
          if (!
#line 883 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3575; /* mve_vhaddq_n_uv16qi */

        case 1:
          if (!
#line 883 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3585; /* mve_vhaddq_n_uv8hi */

        case 2:
          if (!
#line 883 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3595; /* mve_vhaddq_n_uv4si */

        default:
          return -1;
        }

    case 472:
      switch (pattern175 (x1))
        {
        case 0:
          if (!
#line 883 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3576; /* mve_vhsubq_n_sv16qi */

        case 1:
          if (!
#line 883 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3586; /* mve_vhsubq_n_sv8hi */

        case 2:
          if (!
#line 883 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3596; /* mve_vhsubq_n_sv4si */

        default:
          return -1;
        }

    case 509:
      switch (pattern175 (x1))
        {
        case 0:
          if (!
#line 883 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3577; /* mve_vhsubq_n_uv16qi */

        case 1:
          if (!
#line 883 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3587; /* mve_vhsubq_n_uv8hi */

        case 2:
          if (!
#line 883 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3597; /* mve_vhsubq_n_uv4si */

        default:
          return -1;
        }

    case 484:
      switch (pattern175 (x1))
        {
        case 0:
          if (!
#line 883 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3578; /* mve_vqaddq_n_sv16qi */

        case 1:
          if (!
#line 883 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3588; /* mve_vqaddq_n_sv8hi */

        case 2:
          if (!
#line 883 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3598; /* mve_vqaddq_n_sv4si */

        default:
          return -1;
        }

    case 521:
      switch (pattern175 (x1))
        {
        case 0:
          if (!
#line 883 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3579; /* mve_vqaddq_n_uv16qi */

        case 1:
          if (!
#line 883 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3589; /* mve_vqaddq_n_uv8hi */

        case 2:
          if (!
#line 883 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3599; /* mve_vqaddq_n_uv4si */

        default:
          return -1;
        }

    case 547:
      switch (pattern175 (x1))
        {
        case 0:
          if (!
#line 883 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3580; /* mve_vqdmulhq_n_sv16qi */

        case 1:
          if (!
#line 883 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3590; /* mve_vqdmulhq_n_sv8hi */

        case 2:
          if (!
#line 883 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3600; /* mve_vqdmulhq_n_sv4si */

        default:
          return -1;
        }

    case 549:
      switch (pattern175 (x1))
        {
        case 0:
          if (!
#line 883 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3581; /* mve_vqrdmulhq_n_sv16qi */

        case 1:
          if (!
#line 883 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3591; /* mve_vqrdmulhq_n_sv8hi */

        case 2:
          if (!
#line 883 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3601; /* mve_vqrdmulhq_n_sv4si */

        default:
          return -1;
        }

    case 491:
      switch (pattern175 (x1))
        {
        case 0:
          if (!
#line 883 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3582; /* mve_vqsubq_n_sv16qi */

        case 1:
          if (!
#line 883 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3592; /* mve_vqsubq_n_sv8hi */

        case 2:
          if (!
#line 883 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3602; /* mve_vqsubq_n_sv4si */

        default:
          return -1;
        }

    case 528:
      switch (pattern175 (x1))
        {
        case 0:
          if (!
#line 883 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3583; /* mve_vqsubq_n_uv16qi */

        case 1:
          if (!
#line 883 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3593; /* mve_vqsubq_n_uv8hi */

        case 2:
          if (!
#line 883 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3603; /* mve_vqsubq_n_uv4si */

        default:
          return -1;
        }

    case 540:
      switch (pattern174 (x1))
        {
        case 0:
          if (!
#line 900 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3604; /* mve_vmaxaq_sv16qi */

        case 1:
          if (!
#line 900 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3606; /* mve_vmaxaq_sv8hi */

        case 2:
          if (!
#line 900 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3608; /* mve_vmaxaq_sv4si */

        default:
          return -1;
        }

    case 542:
      switch (pattern174 (x1))
        {
        case 0:
          if (!
#line 900 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3605; /* mve_vminaq_sv16qi */

        case 1:
          if (!
#line 900 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3607; /* mve_vminaq_sv8hi */

        case 2:
          if (!
#line 900 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3609; /* mve_vminaq_sv4si */

        default:
          return -1;
        }

    case 541:
      switch (pattern179 (x1))
        {
        case 0:
          if (!
#line 936 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3622; /* mve_vmaxavq_sv16qi */

        case 1:
          if (!
#line 936 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3628; /* mve_vmaxavq_sv8hi */

        case 2:
          if (!
#line 936 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3634; /* mve_vmaxavq_sv4si */

        default:
          return -1;
        }

    case 474:
      switch (pattern179 (x1))
        {
        case 0:
          if (!
#line 936 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3623; /* mve_vmaxvq_sv16qi */

        case 1:
          if (!
#line 936 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3629; /* mve_vmaxvq_sv8hi */

        case 2:
          if (!
#line 936 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3635; /* mve_vmaxvq_sv4si */

        default:
          return -1;
        }

    case 511:
      switch (pattern179 (x1))
        {
        case 0:
          if (!
#line 936 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3624; /* mve_vmaxvq_uv16qi */

        case 1:
          if (!
#line 936 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3630; /* mve_vmaxvq_uv8hi */

        case 2:
          if (!
#line 936 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3636; /* mve_vmaxvq_uv4si */

        default:
          return -1;
        }

    case 543:
      switch (pattern179 (x1))
        {
        case 0:
          if (!
#line 936 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3625; /* mve_vminavq_sv16qi */

        case 1:
          if (!
#line 936 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3631; /* mve_vminavq_sv8hi */

        case 2:
          if (!
#line 936 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3637; /* mve_vminavq_sv4si */

        default:
          return -1;
        }

    case 476:
      switch (pattern179 (x1))
        {
        case 0:
          if (!
#line 936 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3626; /* mve_vminvq_sv16qi */

        case 1:
          if (!
#line 936 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3632; /* mve_vminvq_sv8hi */

        case 2:
          if (!
#line 936 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3638; /* mve_vminvq_sv4si */

        default:
          return -1;
        }

    case 513:
      switch (pattern179 (x1))
        {
        case 0:
          if (!
#line 936 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3627; /* mve_vminvq_uv16qi */

        case 1:
          if (!
#line 936 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3633; /* mve_vminvq_uv8hi */

        case 2:
          if (!
#line 936 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3639; /* mve_vminvq_uv4si */

        default:
          return -1;
        }

    case 477:
      switch (pattern180 (x1))
        {
        case 0:
          if (!
#line 956 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3640; /* mve_vmladavq_sv16qi */

        case 1:
          if (!
#line 956 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3645; /* mve_vmladavq_sv8hi */

        case 2:
          if (!
#line 956 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3650; /* mve_vmladavq_sv4si */

        default:
          return -1;
        }

    case 514:
      switch (pattern180 (x1))
        {
        case 0:
          if (!
#line 956 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3641; /* mve_vmladavq_uv16qi */

        case 1:
          if (!
#line 956 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3646; /* mve_vmladavq_uv8hi */

        case 2:
          if (!
#line 956 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3651; /* mve_vmladavq_uv4si */

        default:
          return -1;
        }

    case 544:
      switch (pattern180 (x1))
        {
        case 0:
          if (!
#line 956 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3642; /* mve_vmladavxq_sv16qi */

        case 1:
          if (!
#line 956 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3647; /* mve_vmladavxq_sv8hi */

        case 2:
          if (!
#line 956 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3652; /* mve_vmladavxq_sv4si */

        default:
          return -1;
        }

    case 545:
      switch (pattern180 (x1))
        {
        case 0:
          if (!
#line 956 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3643; /* mve_vmlsdavq_sv16qi */

        case 1:
          if (!
#line 956 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3648; /* mve_vmlsdavq_sv8hi */

        case 2:
          if (!
#line 956 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3653; /* mve_vmlsdavq_sv4si */

        default:
          return -1;
        }

    case 546:
      switch (pattern180 (x1))
        {
        case 0:
          if (!
#line 956 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3644; /* mve_vmlsdavxq_sv16qi */

        case 1:
          if (!
#line 956 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3649; /* mve_vmlsdavxq_sv8hi */

        case 2:
          if (!
#line 956 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3654; /* mve_vmlsdavxq_sv4si */

        default:
          return -1;
        }

    case 516:
      switch (pattern136 (x1, 
E_V16QImode, 
E_V8HImode, 
E_V4SImode))
        {
        case 0:
          if (!
#line 974 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3655; /* mve_vmullbq_int_uv16qi */

        case 1:
          if (!
#line 974 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3659; /* mve_vmullbq_int_uv8hi */

        case 2:
          if (!
#line 974 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3663; /* mve_vmullbq_int_uv4si */

        default:
          return -1;
        }

    case 479:
      switch (pattern136 (x1, 
E_V16QImode, 
E_V8HImode, 
E_V4SImode))
        {
        case 0:
          if (!
#line 974 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3656; /* mve_vmullbq_int_sv16qi */

        case 1:
          if (!
#line 974 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3660; /* mve_vmullbq_int_sv8hi */

        case 2:
          if (!
#line 974 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3664; /* mve_vmullbq_int_sv4si */

        default:
          return -1;
        }

    case 517:
      switch (pattern136 (x1, 
E_V16QImode, 
E_V8HImode, 
E_V4SImode))
        {
        case 0:
          if (!
#line 974 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3657; /* mve_vmulltq_int_uv16qi */

        case 1:
          if (!
#line 974 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3661; /* mve_vmulltq_int_uv8hi */

        case 2:
          if (!
#line 974 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3665; /* mve_vmulltq_int_uv4si */

        default:
          return -1;
        }

    case 480:
      switch (pattern136 (x1, 
E_V16QImode, 
E_V8HImode, 
E_V4SImode))
        {
        case 0:
          if (!
#line 974 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3658; /* mve_vmulltq_int_sv16qi */

        case 1:
          if (!
#line 974 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3662; /* mve_vmulltq_int_sv8hi */

        case 2:
          if (!
#line 974 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3666; /* mve_vmulltq_int_sv4si */

        default:
          return -1;
        }

    case 486:
      switch (pattern178 (x1))
        {
        case 0:
          if (!
#line 1061 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3682; /* mve_vqrshlq_n_sv16qi */

        case 1:
          if (!
#line 1061 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3686; /* mve_vqrshlq_n_sv8hi */

        case 2:
          if (!
#line 1061 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3690; /* mve_vqrshlq_n_sv4si */

        default:
          return -1;
        }

    case 523:
      switch (pattern178 (x1))
        {
        case 0:
          if (!
#line 1061 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3683; /* mve_vqrshlq_n_uv16qi */

        case 1:
          if (!
#line 1061 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3687; /* mve_vqrshlq_n_uv8hi */

        case 2:
          if (!
#line 1061 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3691; /* mve_vqrshlq_n_uv4si */

        default:
          return -1;
        }

    case 495:
      switch (pattern178 (x1))
        {
        case 0:
          if (!
#line 1061 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3684; /* mve_vrshlq_n_sv16qi */

        case 1:
          if (!
#line 1061 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3688; /* mve_vrshlq_n_sv8hi */

        case 2:
          if (!
#line 1061 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3692; /* mve_vrshlq_n_sv4si */

        default:
          return -1;
        }

    case 532:
      switch (pattern178 (x1))
        {
        case 0:
          if (!
#line 1061 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3685; /* mve_vrshlq_n_uv16qi */

        case 1:
          if (!
#line 1061 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3689; /* mve_vrshlq_n_uv8hi */

        case 2:
          if (!
#line 1061 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3693; /* mve_vrshlq_n_uv4si */

        default:
          return -1;
        }

    case 488:
      switch (pattern181 (x1))
        {
        case 0:
          if (!
#line 1078 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3694; /* mve_vqshlq_n_sv16qi */

        case 1:
          if (!
#line 1078 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3698; /* mve_vqshlq_n_sv8hi */

        case 2:
          if (!
#line 1078 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3702; /* mve_vqshlq_n_sv4si */

        default:
          return -1;
        }

    case 525:
      switch (pattern181 (x1))
        {
        case 0:
          if (!
#line 1078 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3695; /* mve_vqshlq_n_uv16qi */

        case 1:
          if (!
#line 1078 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3699; /* mve_vqshlq_n_uv8hi */

        case 2:
          if (!
#line 1078 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3703; /* mve_vqshlq_n_uv4si */

        default:
          return -1;
        }

    case 497:
      switch (pattern181 (x1))
        {
        case 0:
          if (!
#line 1078 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3696; /* mve_vshlq_n_sv16qi */

        case 1:
          if (!
#line 1078 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3700; /* mve_vshlq_n_sv8hi */

        case 2:
          if (!
#line 1078 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3704; /* mve_vshlq_n_sv4si */

        default:
          return -1;
        }

    case 534:
      switch (pattern181 (x1))
        {
        case 0:
          if (!
#line 1078 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3697; /* mve_vshlq_n_uv16qi */

        case 1:
          if (!
#line 1078 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3701; /* mve_vshlq_n_uv8hi */

        case 2:
          if (!
#line 1078 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3705; /* mve_vshlq_n_uv4si */

        default:
          return -1;
        }

    case 489:
      switch (pattern178 (x1))
        {
        case 0:
          if (!
#line 1095 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3706; /* mve_vqshlq_r_sv16qi */

        case 1:
          if (!
#line 1095 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3710; /* mve_vqshlq_r_sv8hi */

        case 2:
          if (!
#line 1095 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3714; /* mve_vqshlq_r_sv4si */

        default:
          return -1;
        }

    case 526:
      switch (pattern178 (x1))
        {
        case 0:
          if (!
#line 1095 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3707; /* mve_vqshlq_r_uv16qi */

        case 1:
          if (!
#line 1095 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3711; /* mve_vqshlq_r_uv8hi */

        case 2:
          if (!
#line 1095 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3715; /* mve_vqshlq_r_uv4si */

        default:
          return -1;
        }

    case 498:
      switch (pattern178 (x1))
        {
        case 0:
          if (!
#line 1095 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3708; /* mve_vshlq_r_sv16qi */

        case 1:
          if (!
#line 1095 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3712; /* mve_vshlq_r_sv8hi */

        case 2:
          if (!
#line 1095 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3716; /* mve_vshlq_r_sv4si */

        default:
          return -1;
        }

    case 535:
      switch (pattern178 (x1))
        {
        case 0:
          if (!
#line 1095 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3709; /* mve_vshlq_r_uv16qi */

        case 1:
          if (!
#line 1095 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3713; /* mve_vshlq_r_uv8hi */

        case 2:
          if (!
#line 1095 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3717; /* mve_vshlq_r_uv4si */

        default:
          return -1;
        }

    case 551:
      return recog_200 (x1, insn, pnum_clobbers);

    case 554:
      switch (pattern182 (x1))
        {
        case 0:
          if (!
#line 1127 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
            return -1;
          return 3721; /* mve_vabdq_fv8hf */

        case 1:
          if (!
#line 1127 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
            return -1;
          return 3722; /* mve_vabdq_fv4sf */

        default:
          return -1;
        }

    case 568:
      if (pattern124 (x1, 
E_V4SImode, 
E_DImode) != 0
          || !
#line 1143 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
        return -1;
      return 3723; /* mve_vaddlvaq_sv4si */

    case 567:
      if (pattern124 (x1, 
E_V4SImode, 
E_DImode) != 0
          || !
#line 1143 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
        return -1;
      return 3724; /* mve_vaddlvaq_uv4si */

    case 555:
      switch (pattern183 (x1))
        {
        case 0:
          if (!
#line 1162 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
            return -1;
          return 3725; /* mve_vaddq_n_fv8hf */

        case 1:
          if (!
#line 1162 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
            return -1;
          return 3728; /* mve_vaddq_n_fv4sf */

        default:
          return -1;
        }

    case 565:
      switch (pattern183 (x1))
        {
        case 0:
          if (!
#line 1162 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
            return -1;
          return 3726; /* mve_vmulq_n_fv8hf */

        case 1:
          if (!
#line 1162 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
            return -1;
          return 3729; /* mve_vmulq_n_fv4sf */

        default:
          return -1;
        }

    case 453:
      switch (pattern183 (x1))
        {
        case 0:
          if (!
#line 1162 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
            return -1;
          return 3727; /* mve_vsubq_n_fv8hf */

        case 1:
          if (!
#line 1162 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
            return -1;
          return 3730; /* mve_vsubq_n_fv4sf */

        default:
          return -1;
        }

    case 384:
      switch (pattern182 (x1))
        {
        case 0:
          if (!
#line 1209 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
            return -1;
          return 3737; /* mve_vcmulq_fv8hf */

        case 1:
          if (!
#line 1209 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
            return -1;
          return 3743; /* mve_vcmulq_fv4sf */

        default:
          return -1;
        }

    case 385:
      switch (pattern182 (x1))
        {
        case 0:
          if (!
#line 1209 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
            return -1;
          return 3738; /* mve_vcmulq_rot90_fv8hf */

        case 1:
          if (!
#line 1209 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
            return -1;
          return 3744; /* mve_vcmulq_rot90_fv4sf */

        default:
          return -1;
        }

    case 386:
      switch (pattern182 (x1))
        {
        case 0:
          if (!
#line 1209 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
            return -1;
          return 3739; /* mve_vcmulq_rot180_fv8hf */

        case 1:
          if (!
#line 1209 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
            return -1;
          return 3745; /* mve_vcmulq_rot180_fv4sf */

        default:
          return -1;
        }

    case 387:
      switch (pattern182 (x1))
        {
        case 0:
          if (!
#line 1209 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
            return -1;
          return 3740; /* mve_vcmulq_rot270_fv8hf */

        case 1:
          if (!
#line 1209 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
            return -1;
          return 3746; /* mve_vcmulq_rot270_fv4sf */

        default:
          return -1;
        }

    case 443:
      return recog_144 (x1, insn, pnum_clobbers);

    case 571:
      if (pattern124 (x1, 
E_V4SFmode, 
E_V8HFmode) != 0
          || !
#line 1274 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
        return -1;
      return 3775; /* mve_vcvtbq_f16_f32v8hf */

    case 572:
      if (pattern124 (x1, 
E_V4SFmode, 
E_V8HFmode) != 0
          || !
#line 1274 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
        return -1;
      return 3776; /* mve_vcvttq_f16_f32v8hf */

    case 556:
      switch (pattern182 (x1))
        {
        case 0:
          if (!
#line 1306 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
            return -1;
          return 3779; /* mve_vmaxnmaq_fv8hf */

        case 1:
          if (!
#line 1306 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
            return -1;
          return 3781; /* mve_vmaxnmaq_fv4sf */

        default:
          return -1;
        }

    case 560:
      switch (pattern182 (x1))
        {
        case 0:
          if (!
#line 1306 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
            return -1;
          return 3780; /* mve_vminnmaq_fv8hf */

        case 1:
          if (!
#line 1306 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
            return -1;
          return 3782; /* mve_vminnmaq_fv4sf */

        default:
          return -1;
        }

    case 557:
      switch (pattern184 (x1))
        {
        case 0:
          if (!
#line 1325 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
            return -1;
          return 3783; /* mve_vmaxnmavq_fv8hf */

        case 1:
          if (!
#line 1325 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
            return -1;
          return 3787; /* mve_vmaxnmavq_fv4sf */

        default:
          return -1;
        }

    case 559:
      switch (pattern184 (x1))
        {
        case 0:
          if (!
#line 1325 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
            return -1;
          return 3784; /* mve_vmaxnmvq_fv8hf */

        case 1:
          if (!
#line 1325 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
            return -1;
          return 3788; /* mve_vmaxnmvq_fv4sf */

        default:
          return -1;
        }

    case 561:
      switch (pattern184 (x1))
        {
        case 0:
          if (!
#line 1325 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
            return -1;
          return 3785; /* mve_vminnmavq_fv8hf */

        case 1:
          if (!
#line 1325 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
            return -1;
          return 3789; /* mve_vminnmavq_fv4sf */

        default:
          return -1;
        }

    case 563:
      switch (pattern184 (x1))
        {
        case 0:
          if (!
#line 1325 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
            return -1;
          return 3786; /* mve_vminnmvq_fv8hf */

        case 1:
          if (!
#line 1325 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE && TARGET_HAVE_MVE_FLOAT))
            return -1;
          return 3790; /* mve_vminnmvq_fv4sf */

        default:
          return -1;
        }

    case 575:
      switch (pattern185 (x1))
        {
        case 0:
          if (!
#line 1360 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3795; /* mve_vmlaldavq_sv8hi */

        case 1:
          if (!
#line 1360 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3800; /* mve_vmlaldavq_sv4si */

        default:
          return -1;
        }

    case 573:
      switch (pattern185 (x1))
        {
        case 0:
          if (!
#line 1360 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3796; /* mve_vmlaldavq_uv8hi */

        case 1:
          if (!
#line 1360 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3801; /* mve_vmlaldavq_uv4si */

        default:
          return -1;
        }

    case 574:
      switch (pattern185 (x1))
        {
        case 0:
          if (!
#line 1360 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3797; /* mve_vmlaldavxq_sv8hi */

        case 1:
          if (!
#line 1360 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3802; /* mve_vmlaldavxq_sv4si */

        default:
          return -1;
        }

    case 576:
      switch (pattern185 (x1))
        {
        case 0:
          if (!
#line 1360 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3798; /* mve_vmlsldavq_sv8hi */

        case 1:
          if (!
#line 1360 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3803; /* mve_vmlsldavq_sv4si */

        default:
          return -1;
        }

    case 577:
      switch (pattern185 (x1))
        {
        case 0:
          if (!
#line 1360 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3799; /* mve_vmlsldavxq_sv8hi */

        case 1:
          if (!
#line 1360 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3804; /* mve_vmlsldavxq_sv4si */

        default:
          return -1;
        }

    case 579:
      switch (pattern186 (x1))
        {
        case 0:
          if (!
#line 1382 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3805; /* mve_vmovnbq_sv8hi */

        case 1:
          if (!
#line 1382 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3815; /* mve_vmovnbq_sv4si */

        default:
          return -1;
        }

    case 578:
      switch (pattern186 (x1))
        {
        case 0:
          if (!
#line 1382 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3806; /* mve_vmovnbq_uv8hi */

        case 1:
          if (!
#line 1382 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3816; /* mve_vmovnbq_uv4si */

        default:
          return -1;
        }

    case 581:
      switch (pattern186 (x1))
        {
        case 0:
          if (!
#line 1382 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3807; /* mve_vmovntq_sv8hi */

        case 1:
          if (!
#line 1382 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3817; /* mve_vmovntq_sv4si */

        default:
          return -1;
        }

    case 580:
      switch (pattern186 (x1))
        {
        case 0:
          if (!
#line 1382 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3808; /* mve_vmovntq_uv8hi */

        case 1:
          if (!
#line 1382 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3818; /* mve_vmovntq_uv4si */

        default:
          return -1;
        }

    case 589:
      switch (pattern186 (x1))
        {
        case 0:
          if (!
#line 1382 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3809; /* mve_vqmovnbq_sv8hi */

        case 1:
          if (!
#line 1382 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3819; /* mve_vqmovnbq_sv4si */

        default:
          return -1;
        }

    case 588:
      switch (pattern186 (x1))
        {
        case 0:
          if (!
#line 1382 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3810; /* mve_vqmovnbq_uv8hi */

        case 1:
          if (!
#line 1382 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3820; /* mve_vqmovnbq_uv4si */

        default:
          return -1;
        }

    case 600:
      switch (pattern186 (x1))
        {
        case 0:
          if (!
#line 1382 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3811; /* mve_vqmovntq_sv8hi */

        case 1:
          if (!
#line 1382 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3821; /* mve_vqmovntq_sv4si */

        default:
          return -1;
        }

    case 599:
      switch (pattern186 (x1))
        {
        case 0:
          if (!
#line 1382 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3812; /* mve_vqmovntq_uv8hi */

        case 1:
          if (!
#line 1382 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3822; /* mve_vqmovntq_uv4si */

        default:
          return -1;
        }

    case 590:
      switch (pattern186 (x1))
        {
        case 0:
          if (!
#line 1382 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3813; /* mve_vqmovunbq_sv8hi */

        case 1:
          if (!
#line 1382 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3823; /* mve_vqmovunbq_sv4si */

        default:
          return -1;
        }

    case 591:
      switch (pattern186 (x1))
        {
        case 0:
          if (!
#line 1382 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3814; /* mve_vqmovuntq_sv8hi */

        case 1:
          if (!
#line 1382 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3824; /* mve_vqmovuntq_sv4si */

        default:
          return -1;
        }

    case 570:
      switch (pattern187 (x1))
        {
        case 0:
          if (!
#line 1446 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3835; /* mve_vbicq_n_sv8hi */

        case 1:
          if (!
#line 1446 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3839; /* mve_vbicq_n_sv4si */

        default:
          return -1;
        }

    case 569:
      switch (pattern187 (x1))
        {
        case 0:
          if (!
#line 1446 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3836; /* mve_vbicq_n_uv8hi */

        case 1:
          if (!
#line 1446 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3840; /* mve_vbicq_n_uv4si */

        default:
          return -1;
        }

    case 582:
      switch (pattern187 (x1))
        {
        case 0:
          if (!
#line 1446 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3837; /* mve_vorrq_n_sv8hi */

        case 1:
          if (!
#line 1446 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3841; /* mve_vorrq_n_sv4si */

        default:
          return -1;
        }

    case 583:
      switch (pattern187 (x1))
        {
        case 0:
          if (!
#line 1446 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3838; /* mve_vorrq_n_uv8hi */

        case 1:
          if (!
#line 1446 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3842; /* mve_vorrq_n_uv4si */

        default:
          return -1;
        }

    case 584:
      switch (pattern189 (x1))
        {
        case 0:
          if (!
#line 1463 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3843; /* mve_vqdmullbq_n_sv8hi */

        case 1:
          if (!
#line 1463 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3845; /* mve_vqdmullbq_n_sv4si */

        default:
          return -1;
        }

    case 586:
      switch (pattern189 (x1))
        {
        case 0:
          if (!
#line 1463 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3844; /* mve_vqdmulltq_n_sv8hi */

        case 1:
          if (!
#line 1463 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3846; /* mve_vqdmulltq_n_sv4si */

        default:
          return -1;
        }

    case 585:
      switch (pattern142 (x1, 
E_V8HImode, 
E_V4SImode))
        {
        case 0:
          if (!
#line 1480 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3847; /* mve_vqdmullbq_sv8hi */

        case 1:
          if (!
#line 1480 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3849; /* mve_vqdmullbq_sv4si */

        default:
          return -1;
        }

    case 587:
      switch (pattern142 (x1, 
E_V8HImode, 
E_V4SImode))
        {
        case 0:
          if (!
#line 1480 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3848; /* mve_vqdmulltq_sv8hi */

        case 1:
          if (!
#line 1480 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3850; /* mve_vqdmulltq_sv4si */

        default:
          return -1;
        }

    case 606:
      if (pattern155 (x1, 
E_V4SImode, 
E_DImode) != 0
          || !
#line 1499 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
        return -1;
      return 3851; /* mve_vrmlaldavhq_sv4si */

    case 605:
      if (pattern155 (x1, 
E_V4SImode, 
E_DImode) != 0
          || !
#line 1499 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
        return -1;
      return 3852; /* mve_vrmlaldavhq_uv4si */

    case 592:
      if (pattern155 (x1, 
E_V4SImode, 
E_DImode) != 0
          || !
#line 1499 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
        return -1;
      return 3853; /* mve_vrmlaldavhxq_sv4si */

    case 593:
      if (pattern155 (x1, 
E_V4SImode, 
E_DImode) != 0
          || !
#line 1499 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
        return -1;
      return 3854; /* mve_vrmlsldavhq_sv4si */

    case 594:
      if (pattern155 (x1, 
E_V4SImode, 
E_DImode) != 0
          || !
#line 1499 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
        return -1;
      return 3855; /* mve_vrmlsldavhxq_sv4si */

    case 601:
      switch (pattern190 (x1))
        {
        case 0:
          if (!
#line 1517 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3856; /* mve_vshllbq_n_sv16qi */

        case 1:
          if (!
#line 1517 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3860; /* mve_vshllbq_n_sv8hi */

        default:
          return -1;
        }

    case 602:
      switch (pattern190 (x1))
        {
        case 0:
          if (!
#line 1517 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3857; /* mve_vshllbq_n_uv16qi */

        case 1:
          if (!
#line 1517 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3861; /* mve_vshllbq_n_uv8hi */

        default:
          return -1;
        }

    case 604:
      switch (pattern190 (x1))
        {
        case 0:
          if (!
#line 1517 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3858; /* mve_vshlltq_n_sv16qi */

        case 1:
          if (!
#line 1517 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3862; /* mve_vshlltq_n_sv8hi */

        default:
          return -1;
        }

    case 603:
      switch (pattern190 (x1))
        {
        case 0:
          if (!
#line 1517 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3859; /* mve_vshlltq_n_uv16qi */

        case 1:
          if (!
#line 1517 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3863; /* mve_vshlltq_n_uv8hi */

        default:
          return -1;
        }

    case 608:
      switch (pattern191 (x1))
        {
        case 0:
          if (!
#line 1534 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3864; /* mve_vmullbq_poly_pv16qi */

        case 1:
          if (!
#line 1534 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3866; /* mve_vmullbq_poly_pv8hi */

        default:
          return -1;
        }

    case 607:
      switch (pattern191 (x1))
        {
        case 0:
          if (!
#line 1534 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3865; /* mve_vmulltq_poly_pv16qi */

        case 1:
          if (!
#line 1534 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
            return -1;
          return 3867; /* mve_vmulltq_poly_pv8hi */

        default:
          return -1;
        }

    case 1006:
      return recog_154 (x1, insn, pnum_clobbers);

    case 1008:
      return recog_160 (x1, insn, pnum_clobbers);

    case 1013:
      return recog_148 (x1, insn, pnum_clobbers);

    case 1075:
      return recog_153 (x1, insn, pnum_clobbers);

    case 1073:
      return recog_151 (x1, insn, pnum_clobbers);

    case 1074:
      return recog_152 (x1, insn, pnum_clobbers);

    case 1085:
      if (pattern193 (x1) != 0
          || !
#line 4286 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
        return -1;
      return 5022; /* mve_uqrshll_sat64_di */

    case 1086:
      if (pattern193 (x1) != 0
          || !
#line 4286 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
        return -1;
      return 5023; /* mve_uqrshll_sat48_di */

    case 1087:
      if (pattern193 (x1) != 0
          || !
#line 4298 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
        return -1;
      return 5024; /* mve_sqrshrl_sat64_di */

    case 1088:
      if (pattern193 (x1) != 0
          || !
#line 4298 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
        return -1;
      return 5025; /* mve_sqrshrl_sat48_di */

    case 1084:
      if (pattern194 (x1) != 0
          || !
#line 4310 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
        return -1;
      return 5026; /* mve_uqrshl_si */

    case 1083:
      if (pattern194 (x1) != 0
          || !
#line 4322 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
        return -1;
      return 5027; /* mve_sqrshr_si */

    case 1082:
      if (pattern195 (x1) != 0
          || !
#line 4345 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
        return -1;
      return 5029; /* mve_urshrl_di */

    case 1081:
      if (pattern196 (x1, 
E_SImode) != 0
          || !
#line 4368 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
        return -1;
      return 5031; /* mve_urshr_si */

    case 1080:
      if (pattern196 (x1, 
E_DImode) != 0
          || !
#line 4391 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
        return -1;
      return 5033; /* mve_srshr_si */

    case 1079:
      if (pattern195 (x1) != 0
          || !
#line 4403 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/mve.md"
(TARGET_HAVE_MVE))
        return -1;
      return 5034; /* mve_srshrl_di */

    default:
      return -1;
    }
}

 int
recog_357 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  operands[0] = x3;
  x4 = XEXP (x2, 1);
  x5 = XEXP (x4, 0);
  switch (GET_CODE (x5))
    {
    case REG:
    case SUBREG:
      operands[1] = x5;
      x6 = XEXP (x4, 1);
      switch (GET_CODE (x6))
        {
        case CONST_INT:
          if (XWINT (x6, 0) != 0L)
            return -1;
          x7 = XEXP (x1, 0);
          operands[2] = x7;
          x8 = XEXP (x7, 0);
          operands[3] = x8;
          if (!s_register_operand (operands[0], E_SImode)
              || GET_MODE (x4) != E_SImode
              || !s_register_operand (operands[1], E_SImode)
              || !(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 4127 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT)))
            return -1;
          return 6463; /* *p *smin_0 */

        case REG:
        case SUBREG:
          switch (pattern441 (x1))
            {
            case 0:
              if (!(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 923 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iwmmxt.md"
(TARGET_REALLY_IWMMXT)))
                return -1;
              return 6751; /* *p *sminv2si3_iwmmxt */

            case 1:
              if (!(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 923 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iwmmxt.md"
(TARGET_REALLY_IWMMXT)))
                return -1;
              return 6752; /* *p *sminv4hi3_iwmmxt */

            case 2:
              if (!(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 923 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/iwmmxt.md"
(TARGET_REALLY_IWMMXT)))
                return -1;
              return 6753; /* *p *sminv8qi3_iwmmxt */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case SMAX:
      switch (pattern379 (x1))
        {
        case 0:
          if ((
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 4477 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT && arm_arch6 && !ARM_Q_BIT_READ
   && arm_sat_operator_match (operands[1], operands[2], NULL, NULL))))
            return 6470; /* *p satsi_smin */
          if (!(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 4477 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT && arm_arch6 && ARM_Q_BIT_READ
   && arm_sat_operator_match (operands[1], operands[2], NULL, NULL))))
            return -1;
          return 6471; /* *p satsi_smin_setq */

        case 1:
          if (!(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 4503 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT && arm_arch6 && !ARM_Q_BIT_READ
   && arm_sat_operator_match (operands[1], operands[2], NULL, NULL))))
            return -1;
          return 6474; /* *p *satsi_smin_shift */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_366 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XVECEXP (x2, 0, 1);
  x4 = XEXP (x3, 1);
  x5 = XEXP (x4, 0);
  if (GET_CODE (x5) != PLUS
      || GET_MODE (x5) != E_SImode)
    return -1;
  x6 = XEXP (x1, 0);
  operands[5] = x6;
  x7 = XEXP (x6, 0);
  operands[6] = x7;
  x8 = XVECEXP (x2, 0, 0);
  x9 = XEXP (x8, 1);
  x10 = XEXP (x9, 0);
  x11 = XEXP (x10, 0);
  operands[1] = x11;
  if (!s_register_operand (operands[1], E_SImode))
    return -1;
  x12 = XEXP (x3, 0);
  operands[3] = x12;
  x13 = XEXP (x5, 1);
  operands[4] = x13;
  if (!const_int_operand (operands[4], E_SImode))
    return -1;
  x14 = XEXP (x5, 0);
  if (!rtx_equal_p (x14, operands[1])
      || !(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 12716 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_LDRD && TARGET_THUMB2 && reload_completed
     && ((INTVAL (operands[2]) + 4) == INTVAL (operands[4]))
     && (operands_ok_ldrd_strd (operands[0], operands[3],
                                  operands[1], INTVAL (operands[2]),
                                  false, true)))))
    return -1;
  return 6618; /* *p *thumb2_ldrd */
}

 int
recog_372 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19, x20, x21, x22, x23, x24, x25;
  rtx x26;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XVECEXP (x2, 0, 0);
  switch (GET_CODE (x3))
    {
    case SET:
      x4 = XEXP (x3, 1);
      switch (GET_CODE (x4))
        {
        case MULT:
        case ASHIFT:
        case ROTATE:
        case ASHIFTRT:
        case LSHIFTRT:
        case ROTATERT:
          x5 = XEXP (x1, 0);
          operands[4] = x5;
          res = recog_363 (x1, insn, pnum_clobbers);
          if (res >= 0)
            return res;
          if (GET_CODE (x4) != MULT
              || GET_MODE (x4) != E_SImode
              || pattern442 (x1) != 0)
            return -1;
          x6 = XEXP (x3, 0);
          operands[0] = x6;
          if (!low_register_operand (operands[0], E_SImode))
            return -1;
          x7 = XEXP (x4, 0);
          operands[1] = x7;
          if (!low_register_operand (operands[1], E_SImode))
            return -1;
          x8 = XEXP (x4, 1);
          operands[2] = x8;
          if (!low_register_operand (operands[2], E_SImode)
              || !(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 1429 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/thumb2.md"
(TARGET_THUMB2 && optimize_size && reload_completed)))
            return -1;
          return 6997; /* *p *thumb2_mulsi_short */

        case PLUS:
        case MINUS:
        case AND:
        case IOR:
        case XOR:
          x6 = XEXP (x3, 0);
          operands[0] = x6;
          if (s_register_operand (operands[0], E_SImode))
            {
              res = recog_365 (x1, insn, pnum_clobbers);
              if (res >= 0)
                return res;
            }
          if (!low_register_operand (operands[0], E_SImode)
              || pattern442 (x1) != 0
              || GET_MODE (x4) != E_SImode)
            return -1;
          x7 = XEXP (x4, 0);
          operands[1] = x7;
          if (!low_register_operand (operands[1], E_SImode))
            return -1;
          x8 = XEXP (x4, 1);
          operands[2] = x8;
          switch (GET_CODE (x4))
            {
            case PLUS:
              if (!low_reg_or_int_operand (operands[2], E_SImode)
                  || !(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 1301 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/thumb2.md"
(TARGET_THUMB2 && reload_completed)))
                return -1;
              return 6995; /* *p *thumb2_addsi_short */

            case MINUS:
              if (!low_register_operand (operands[2], E_SImode)
                  || !(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 1330 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/thumb2.md"
(TARGET_THUMB2 && reload_completed)))
                return -1;
              return 6996; /* *p *thumb2_subsi_short */

            default:
              return -1;
            }

        case TRUNCATE:
          if (pattern381 (x4, 
E_DImode, 
MULT, 
LSHIFTRT, 
E_SImode) != 0)
            return -1;
          x7 = XEXP (x4, 0);
          x9 = XEXP (x7, 1);
          if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 32])
            return -1;
          x10 = XVECEXP (x2, 0, 1);
          if (GET_CODE (x10) != CLOBBER)
            return -1;
          x5 = XEXP (x1, 0);
          operands[4] = x5;
          x11 = XEXP (x5, 0);
          operands[5] = x11;
          x6 = XEXP (x3, 0);
          operands[0] = x6;
          if (!s_register_operand (operands[0], E_SImode))
            return -1;
          x12 = XEXP (x7, 0);
          x13 = XEXP (x12, 0);
          if (GET_MODE (x13) != E_DImode)
            return -1;
          x14 = XEXP (x12, 1);
          if (GET_MODE (x14) != E_DImode)
            return -1;
          x15 = XEXP (x10, 0);
          operands[3] = x15;
          if (!scratch_operand (operands[3], E_SImode))
            return -1;
          switch (GET_CODE (x13))
            {
            case SIGN_EXTEND:
              if (GET_CODE (x14) != SIGN_EXTEND)
                return -1;
              x16 = XEXP (x13, 0);
              operands[1] = x16;
              if (!s_register_operand (operands[1], E_SImode))
                return -1;
              x17 = XEXP (x14, 0);
              operands[2] = x17;
              if (!s_register_operand (operands[2], E_SImode)
                  || !(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 2515 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT)))
                return -1;
              return 6427; /* *p *smull_high */

            case ZERO_EXTEND:
              if (GET_CODE (x14) != ZERO_EXTEND)
                return -1;
              x16 = XEXP (x13, 0);
              operands[1] = x16;
              if (!s_register_operand (operands[1], E_SImode))
                return -1;
              x17 = XEXP (x14, 0);
              operands[2] = x17;
              if (!s_register_operand (operands[2], E_SImode)
                  || !(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 2515 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT)))
                return -1;
              return 6428; /* *p *umull_high */

            default:
              return -1;
            }

        case COMPARE:
          if (pattern381 (x4, 
E_SImode, 
NOT, 
AND, 
E_CC_NZmode) != 0)
            return -1;
          x7 = XEXP (x4, 0);
          x12 = XEXP (x7, 0);
          x13 = XEXP (x12, 0);
          if (!shift_operator (x13, E_SImode))
            return -1;
          operands[0] = x13;
          x8 = XEXP (x4, 1);
          if (x8 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
            return -1;
          x6 = XEXP (x3, 0);
          if (GET_CODE (x6) != REG
              || REGNO (x6) != 100
              || GET_MODE (x6) != E_CC_NZmode)
            return -1;
          x5 = XEXP (x1, 0);
          operands[5] = x5;
          x11 = XEXP (x5, 0);
          operands[6] = x11;
          x16 = XEXP (x13, 0);
          operands[1] = x16;
          if (!s_register_operand (operands[1], E_SImode))
            return -1;
          x18 = XEXP (x13, 1);
          operands[2] = x18;
          if (!shift_amount_operand (operands[2], E_SImode))
            return -1;
          x9 = XEXP (x7, 1);
          operands[3] = x9;
          if (!s_register_operand (operands[3], E_SImode))
            return -1;
          x10 = XVECEXP (x2, 0, 1);
          switch (GET_CODE (x10))
            {
            case CLOBBER:
              x15 = XEXP (x10, 0);
              operands[4] = x15;
              if (!scratch_operand (operands[4], E_SImode)
                  || !(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 3637 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT)))
                return -1;
              return 6456; /* *p andsi_not_shiftsi_si_scc_no_reuse */

            case SET:
              x19 = XEXP (x10, 1);
              if (pattern382 (x19, 
NOT, 
AND, 
E_SImode) != 0)
                return -1;
              x20 = XEXP (x19, 0);
              x21 = XEXP (x20, 0);
              switch (GET_CODE (x21))
                {
                case MULT:
                case ASHIFT:
                case ROTATE:
                case ASHIFTRT:
                case LSHIFTRT:
                case ROTATERT:
                  if (!rtx_equal_p (x21, operands[0]))
                    return -1;
                  x15 = XEXP (x10, 0);
                  operands[4] = x15;
                  if (!s_register_operand (operands[4], E_SImode))
                    return -1;
                  x22 = XEXP (x19, 1);
                  if (!rtx_equal_p (x22, operands[3])
                      || !(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 3661 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT)))
                    return -1;
                  return 6457; /* *p andsi_not_shiftsi_si_scc */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        case ABS:
          if (GET_MODE (x4) != E_SImode
              || pattern362 (x1) != 0)
            return -1;
          x6 = XEXP (x3, 0);
          operands[0] = x6;
          if (!s_register_operand (operands[0], E_SImode))
            return -1;
          x7 = XEXP (x4, 0);
          operands[1] = x7;
          if (!s_register_operand (operands[1], E_SImode))
            return -1;
          if ((
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 5248 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_ARM)))
            return 6488; /* *p *arm_abssi2 */
          if (!(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 117 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/thumb2.md"
(TARGET_THUMB2)))
            return -1;
          return 6982; /* *p *thumb2_abssi2 */

        case NEG:
          if (GET_MODE (x4) != E_SImode
              || pattern413 (x1) != 0)
            return -1;
          x7 = XEXP (x4, 0);
          switch (GET_CODE (x7))
            {
            case ABS:
              if (GET_MODE (x7) != E_SImode
                  || !s_register_operand (operands[0], E_SImode))
                return -1;
              x12 = XEXP (x7, 0);
              operands[1] = x12;
              if (!s_register_operand (operands[1], E_SImode))
                return -1;
              if ((
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 5312 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_ARM)))
                return 6489; /* *p *arm_neg_abssi2 */
              if (!(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 170 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/thumb2.md"
(TARGET_THUMB2)))
                return -1;
              return 6983; /* *p *thumb2_neg_abssi2 */

            case REG:
              operands[1] = x7;
              if (!low_register_operand (operands[1], E_SImode)
                  || !low_register_operand (operands[0], E_SImode)
                  || !(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 1533 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/thumb2.md"
(TARGET_THUMB2 && reload_completed)))
                return -1;
              return 6999; /* *p *thumb2_negsi2_short */

            default:
              return -1;
            }

        case UNSPEC:
          if (XVECLEN (x4, 0) != 2)
            return -1;
          x10 = XVECEXP (x2, 0, 1);
          if (GET_CODE (x10) != SET)
            return -1;
          x19 = XEXP (x10, 1);
          if (GET_CODE (x19) != UNSPEC
              || XVECLEN (x19, 0) != 1
              || XINT (x19, 1) != 29
              || GET_MODE (x19) != E_CCmode)
            return -1;
          x23 = XVECEXP (x19, 0, 0);
          if (GET_CODE (x23) != REG
              || REGNO (x23) != 105
              || GET_MODE (x23) != E_CCmode)
            return -1;
          x15 = XEXP (x10, 0);
          if (GET_CODE (x15) != REG
              || REGNO (x15) != 105
              || GET_MODE (x15) != E_CCmode)
            return -1;
          x5 = XEXP (x1, 0);
          operands[3] = x5;
          x11 = XEXP (x5, 0);
          operands[4] = x11;
          x6 = XEXP (x3, 0);
          operands[0] = x6;
          if (!s_register_operand (operands[0], E_SImode)
              || GET_MODE (x4) != E_SImode)
            return -1;
          x24 = XVECEXP (x4, 0, 0);
          operands[1] = x24;
          if (!s_register_operand (operands[1], E_SImode))
            return -1;
          x25 = XVECEXP (x4, 0, 1);
          operands[2] = x25;
          if (!s_register_operand (operands[2], E_SImode))
            return -1;
          switch (XINT (x4, 1))
            {
            case 82:
              if (!(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 6093 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_INT_SIMD)))
                return -1;
              return 6540; /* *p arm_sadd8 */

            case 83:
              if (!(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 6093 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_INT_SIMD)))
                return -1;
              return 6541; /* *p arm_ssub8 */

            case 84:
              if (!(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 6093 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_INT_SIMD)))
                return -1;
              return 6542; /* *p arm_uadd8 */

            case 85:
              if (!(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 6093 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_INT_SIMD)))
                return -1;
              return 6543; /* *p arm_usub8 */

            case 86:
              if (!(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 6093 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_INT_SIMD)))
                return -1;
              return 6544; /* *p arm_sadd16 */

            case 87:
              if (!(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 6093 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_INT_SIMD)))
                return -1;
              return 6545; /* *p arm_sasx */

            case 88:
              if (!(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 6093 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_INT_SIMD)))
                return -1;
              return 6546; /* *p arm_ssax */

            case 89:
              if (!(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 6093 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_INT_SIMD)))
                return -1;
              return 6547; /* *p arm_ssub16 */

            case 90:
              if (!(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 6093 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_INT_SIMD)))
                return -1;
              return 6548; /* *p arm_uadd16 */

            case 91:
              if (!(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 6093 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_INT_SIMD)))
                return -1;
              return 6549; /* *p arm_uasx */

            case 92:
              if (!(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 6093 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_INT_SIMD)))
                return -1;
              return 6550; /* *p arm_usax */

            case 93:
              if (!(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 6093 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_INT_SIMD)))
                return -1;
              return 6551; /* *p arm_usub16 */

            default:
              return -1;
            }

        case REG:
        case SUBREG:
        case MEM:
          switch (GET_CODE (x4))
            {
            case MEM:
              res = recog_367 (x1, insn, pnum_clobbers);
              if (res >= 0)
                return res;
              break;

            case REG:
            case SUBREG:
              res = recog_370 (x1, insn, pnum_clobbers);
              if (res >= 0)
                return res;
              break;

            default:
              break;
            }
          operands[2] = x4;
          if (memory_operand (operands[2], E_SImode))
            {
              res = recog_371 (x1, insn, pnum_clobbers);
              if (res >= 0)
                return res;
            }
          operands[0] = x4;
          if (!s_register_operand (operands[0], E_SImode))
            return -1;
          x10 = XVECEXP (x2, 0, 1);
          if (GET_CODE (x10) != SET)
            return -1;
          x5 = XEXP (x1, 0);
          operands[4] = x5;
          x11 = XEXP (x5, 0);
          operands[5] = x11;
          x6 = XEXP (x3, 0);
          operands[2] = x6;
          if (!memory_operand (operands[2], E_SImode))
            return -1;
          x15 = XEXP (x10, 0);
          operands[3] = x15;
          if (!memory_operand (operands[3], E_SImode))
            return -1;
          x19 = XEXP (x10, 1);
          operands[1] = x19;
          if (!s_register_operand (operands[1], E_SImode)
              || !(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 184 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/ldrdstrd.md"
(TARGET_LDRD && TARGET_ARM && reload_completed
  && valid_operands_ldrd_strd (operands, false))))
            return -1;
          return 6625; /* *p *arm_strd */

        case CONST_INT:
          operands[1] = x4;
          if (pattern413 (x1) != 0)
            return -1;
          switch (GET_MODE (operands[0]))
            {
            case E_QImode:
              if (!low_register_operand (operands[0], E_QImode)
                  || !const_int_operand (operands[1], E_QImode)
                  || !(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 1289 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/thumb2.md"
(TARGET_THUMB2 && reload_completed)))
                return -1;
              return 6992; /* *p *thumb2_movqi_shortim */

            case E_HImode:
              if (!low_register_operand (operands[0], E_HImode)
                  || !const_int_operand (operands[1], E_HImode)
                  || !(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 1289 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/thumb2.md"
(TARGET_THUMB2 && reload_completed)))
                return -1;
              return 6993; /* *p *thumb2_movhi_shortim */

            case E_SImode:
              if (!low_register_operand (operands[0], E_SImode)
                  || !const_int_operand (operands[1], E_SImode)
                  || !(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 1289 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/thumb2.md"
(TARGET_THUMB2 && reload_completed)))
                return -1;
              return 6994; /* *p *thumb2_movsi_shortim */

            default:
              return -1;
            }

        case NOT:
          if (GET_MODE (x4) != E_SImode
              || pattern362 (x1) != 0)
            return -1;
          x6 = XEXP (x3, 0);
          operands[0] = x6;
          if (!low_register_operand (operands[0], E_SImode))
            return -1;
          x7 = XEXP (x4, 0);
          operands[1] = x7;
          if (!low_register_operand (operands[1], E_SImode)
              || !(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 1522 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/thumb2.md"
(TARGET_THUMB2 && reload_completed)))
            return -1;
          return 6998; /* *p *thumb2_one_cmplsi2_short */

        default:
          return -1;
        }

    case RETURN:
      x10 = XVECEXP (x2, 0, 1);
      if (GET_CODE (x10) != SET)
        return -1;
      x19 = XEXP (x10, 1);
      if (pattern382 (x19, 
POST_INC, 
MEM, 
E_SImode) != 0)
        return -1;
      x15 = XEXP (x10, 0);
      if (GET_CODE (x15) != REG
          || REGNO (x15) != 15
          || GET_MODE (x15) != E_SImode)
        return -1;
      x5 = XEXP (x1, 0);
      operands[1] = x5;
      x11 = XEXP (x5, 0);
      operands[2] = x11;
      x20 = XEXP (x19, 0);
      x21 = XEXP (x20, 0);
      operands[0] = x21;
      if (!s_register_operand (operands[0], E_SImode)
          || !(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 12009 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT && (reload_in_progress || reload_completed))))
        return -1;
      return 6602; /* *p *ldr_with_return */

    case UNSPEC_VOLATILE:
      if (XVECLEN (x3, 0) != 1
          || XINT (x3, 1) != 54
          || GET_MODE (x3) != E_SImode)
        return -1;
      x26 = XVECEXP (x3, 0, 0);
      if (x26 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      x10 = XVECEXP (x2, 0, 1);
      if (pattern474 (x10) != 0)
        return -1;
      x5 = XEXP (x1, 0);
      operands[0] = x5;
      x11 = XEXP (x5, 0);
      operands[1] = x11;
      if (!(
#line 12233 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/arm.md"
(TARGET_32BIT
   && (!TARGET_NO_VOLATILE_CE || !volatile_refs_p (PATTERN (insn)))) && 
#line 1709 "/build/armv7l-linux-gnueabihf-gcc/src/gcc/gcc/config/arm/thumb2.md"
(TARGET_THUMB2 && TARGET_HAVE_FPCXT_CMSE && use_cmse)))
        return -1;
      return 7002; /* *p *clear_apsr */

    default:
      return -1;
    }
}

 rtx_insn *
peephole2_5 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pmatch_len_ ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  operands[4] = x2;
  x3 = PATTERN (peep2_next_insn (1));
  x4 = XVECEXP (x3, 0, 0);
  if (GET_CODE (x4) != SET)
    return NULL;
  x5 = XVECEXP (x3, 0, 1);
  if (GET_CODE (x5) != SET)
    return NULL;
  x6 = XVECEXP (x3, 0, 2);
  if (GET_CODE (x6) != SET)
    return NULL;
  x7 = XEXP (x4, 0);
  operands[1] = x7;
  if (!s_register_operand (operands[1], E_SImode))
    return NULL;
  x8 = XEXP (x4, 1);
  operands[5] = x8;
  if (!memory_operand (operands[5], E_SImode))
    return NULL;
  x9 = XEXP (x5, 0);
  operands[2] = x9;
  if (!s_register_operand (operands[2], E_SImode))
    return NULL;
  x10 = XEXP (x5, 1);
  operands[6] = x10;
  if (!memory_operand (operands[6], E_SImode))
    return NULL;
  x11 = XEXP (x6, 0);
  operands[3] = x11;
  if (!s_register_operand (operands[3], E_SImode))
    return NULL;
  x12 = XEXP (x6, 1);
  operands[7] = x12;
  if (!memory_operand (operands[7], E_SImode))
    return NULL;
  *pmatch_len_ = 1;
  return gen_peephole2_20 (insn, operands);
}

 rtx_insn *
peephole2_8 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pmatch_len_ ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  if (!memory_operand (x2, E_SImode))
    return NULL;
  operands[2] = x2;
  if (arm_general_register_operand (operands[0], E_SImode))
    {
      res = peephole2_7 (x1, insn, pmatch_len_);
      if (res != NULL_RTX)
        return res;
    }
  if (peep2_current_count < 4)
    return NULL;
  operands[4] = x2;
  if (!s_register_operand (operands[0], E_SImode))
    return NULL;
  x3 = PATTERN (peep2_next_insn (1));
  x4 = XEXP (x3, 0);
  operands[1] = x4;
  if (!s_register_operand (operands[1], E_SImode))
    return NULL;
  x5 = XEXP (x3, 1);
  operands[5] = x5;
  if (!memory_operand (operands[5], E_SImode))
    return NULL;
  x6 = PATTERN (peep2_next_insn (2));
  if (GET_CODE (x6) != SET)
    return NULL;
  x7 = XEXP (x6, 0);
  operands[2] = x7;
  if (!s_register_operand (operands[2], E_SImode))
    return NULL;
  x8 = XEXP (x6, 1);
  operands[6] = x8;
  if (!memory_operand (operands[6], E_SImode))
    return NULL;
  x9 = PATTERN (peep2_next_insn (3));
  if (GET_CODE (x9) != SET)
    return NULL;
  x10 = XEXP (x9, 0);
  operands[3] = x10;
  if (!s_register_operand (operands[3], E_SImode))
    return NULL;
  x11 = XEXP (x9, 1);
  operands[7] = x11;
  if (!memory_operand (operands[7], E_SImode))
    return NULL;
  *pmatch_len_ = 3;
  return gen_peephole2_19 (insn, operands);
}

 rtx_insn *
peephole2_12 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pmatch_len_ ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19, x20, x21, x22, x23;
  rtx_insn *res ATTRIBUTE_UNUSED;
  if (peep2_current_count < 8)
    return NULL;
  x2 = XEXP (x1, 1);
  operands[8] = x2;
  x3 = PATTERN (peep2_next_insn (2));
  x4 = XEXP (x3, 0);
  if (!s_register_operand (x4, E_SImode))
    return NULL;
  x5 = XEXP (x3, 1);
  if (!const_int_operand (x5, E_SImode))
    return NULL;
  x6 = PATTERN (peep2_next_insn (4));
  if (GET_CODE (x6) != SET)
    return NULL;
  x7 = PATTERN (peep2_next_insn (5));
  if (GET_CODE (x7) != SET)
    return NULL;
  x8 = XEXP (x7, 0);
  if (!memory_operand (x8, E_SImode))
    return NULL;
  x9 = PATTERN (peep2_next_insn (6));
  if (GET_CODE (x9) != SET)
    return NULL;
  x10 = PATTERN (peep2_next_insn (7));
  if (GET_CODE (x10) != SET)
    return NULL;
  x11 = XEXP (x10, 0);
  operands[7] = x11;
  if (!memory_operand (operands[7], E_SImode))
    return NULL;
  x12 = PATTERN (peep2_next_insn (1));
  x13 = XEXP (x12, 1);
  switch (GET_CODE (x13))
    {
    case REG:
    case SUBREG:
      if (!rtx_equal_p (x13, operands[0]))
        return NULL;
      x14 = XEXP (x12, 0);
      operands[4] = x14;
      if (!memory_operand (operands[4], E_SImode))
        return NULL;
      operands[1] = x4;
      operands[9] = x5;
      x15 = PATTERN (peep2_next_insn (3));
      x16 = XEXP (x15, 0);
      operands[5] = x16;
      if (!memory_operand (operands[5], E_SImode))
        return NULL;
      x17 = XEXP (x15, 1);
      if (!rtx_equal_p (x17, operands[1]))
        return NULL;
      x18 = XEXP (x6, 0);
      operands[2] = x18;
      if (!s_register_operand (operands[2], E_SImode))
        return NULL;
      x19 = XEXP (x6, 1);
      operands[10] = x19;
      if (!const_int_operand (operands[10], E_SImode))
        return NULL;
      operands[6] = x8;
      x20 = XEXP (x7, 1);
      if (!rtx_equal_p (x20, operands[2]))
        return NULL;
      x21 = XEXP (x9, 0);
      operands[3] = x21;
      if (!s_register_operand (operands[3], E_SImode))
        return NULL;
      x22 = XEXP (x9, 1);
      operands[11] = x22;
      if (!const_int_operand (operands[11], E_SImode))
        return NULL;
      x23 = XEXP (x10, 1);
      if (!rtx_equal_p (x23, operands[3]))
        return NULL;
      *pmatch_len_ = 7;
      return gen_peephole2_21 (insn, operands);

    case CONST_INT:
      operands[9] = x13;
      if (!const_int_operand (operands[9], E_SImode))
        return NULL;
      x14 = XEXP (x12, 0);
      operands[1] = x14;
      if (!s_register_operand (operands[1], E_SImode))
        return NULL;
      operands[2] = x4;
      operands[10] = x5;
      x15 = PATTERN (peep2_next_insn (3));
      x16 = XEXP (x15, 0);
      operands[3] = x16;
      if (!s_register_operand (operands[3], E_SImode))
        return NULL;
      x17 = XEXP (x15, 1);
      operands[11] = x17;
      if (!const_int_operand (operands[11], E_SImode))
        return NULL;
      x18 = XEXP (x6, 0);
      operands[4] = x18;
      if (!memory_operand (operands[4], E_SImode))
        return NULL;
      x19 = XEXP (x6, 1);
      if (!rtx_equal_p (x19, operands[0]))
        return NULL;
      operands[5] = x8;
      x20 = XEXP (x7, 1);
      if (!rtx_equal_p (x20, operands[1]))
        return NULL;
      x21 = XEXP (x9, 0);
      operands[6] = x21;
      if (!memory_operand (operands[6], E_SImode))
        return NULL;
      x22 = XEXP (x9, 1);
      if (!rtx_equal_p (x22, operands[2]))
        return NULL;
      x23 = XEXP (x10, 1);
      if (!rtx_equal_p (x23, operands[3]))
        return NULL;
      *pmatch_len_ = 7;
      return gen_peephole2_22 (insn, operands);

    default:
      return NULL;
    }
}
