;;; fontawesome7.el --- AUCTeX style for `fontawesome7.sty' (v7.0.0-1)  -*- lexical-binding: t; -*-

;; Copyright (C) 2025 Free Software Foundation, Inc.

;; Author: Arash Esbati <arash@gnu.org>
;; Maintainer: auctex-devel@gnu.org
;; Created: 2025-08-08
;; Keywords: tex

;; This file is part of AUCTeX.

;; AUCTeX is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published by the
;; Free Software Foundation; either version 3, or (at your option) any
;; later version.

;; AUCTeX is distributed in the hope that it will be useful, but WITHOUT
;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;; for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program.  If not, see <https://www.gnu.org/licenses/>.

;;; Commentary:

;; This file adds support for `fontawesome7.sty' (v7.0.0-1) from
;; 2025-07-30.  `fontawesome7.sty' is part of TeXLive.

;;; Code:

(require 'tex)
(require 'latex)

;; Silence the compiler:
(declare-function font-latex-add-keywords "font-latex" (keywords class))

(defvar LaTeX-fontawesome7-icons
  '("42-group"
    "500px"
    "a"
    "accessible-icon"
    "accusoft"
    "address-book"
    "address-card"
    "adn"
    "adversal"
    "affiliatetheme"
    "airbnb"
    "alarm-clock"
    "algolia"
    "align-center"
    "align-justify"
    "align-left"
    "align-right"
    "alipay"
    "amazon"
    "amazon-pay"
    "amilia"
    "anchor"
    "anchor-circle-check"
    "anchor-circle-exclamation"
    "anchor-circle-xmark"
    "anchor-lock"
    "android"
    "angellist"
    "angle-down"
    "angle-left"
    "angle-right"
    "angle-up"
    "angles-down"
    "angles-left"
    "angles-right"
    "angles-up"
    "angrycreative"
    "angular"
    "ankh"
    "app-store"
    "app-store-ios"
    "apper"
    "apple"
    "apple-pay"
    "apple-whole"
    "archway"
    "arrow-down"
    "arrow-down-1-9"
    "arrow-down-9-1"
    "arrow-down-a-z"
    "arrow-down-long"
    "arrow-down-short-wide"
    "arrow-down-up-across-line"
    "arrow-down-up-lock"
    "arrow-down-wide-short"
    "arrow-down-z-a"
    "arrow-left"
    "arrow-left-long"
    "arrow-pointer"
    "arrow-right"
    "arrow-right-arrow-left"
    "arrow-right-from-bracket"
    "arrow-right-long"
    "arrow-right-to-bracket"
    "arrow-right-to-city"
    "arrow-rotate-left"
    "arrow-rotate-right"
    "arrow-trend-down"
    "arrow-trend-up"
    "arrow-turn-down"
    "arrow-turn-up"
    "arrow-up"
    "arrow-up-1-9"
    "arrow-up-9-1"
    "arrow-up-a-z"
    "arrow-up-from-bracket"
    "arrow-up-from-ground-water"
    "arrow-up-from-water-pump"
    "arrow-up-long"
    "arrow-up-right-dots"
    "arrow-up-right-from-square"
    "arrow-up-short-wide"
    "arrow-up-wide-short"
    "arrow-up-z-a"
    "arrows-down-to-line"
    "arrows-down-to-people"
    "arrows-left-right"
    "arrows-left-right-to-line"
    "arrows-rotate"
    "arrows-spin"
    "arrows-split-up-and-left"
    "arrows-to-circle"
    "arrows-to-dot"
    "arrows-to-eye"
    "arrows-turn-right"
    "arrows-turn-to-dots"
    "arrows-up-down"
    "arrows-up-down-left-right"
    "arrows-up-to-line"
    "artstation"
    "asterisk"
    "asymmetrik"
    "at"
    "atlassian"
    "atom"
    "audible"
    "audio-description"
    "austral-sign"
    "autoprefixer"
    "avianex"
    "aviato"
    "award"
    "aws"
    "b"
    "baby"
    "baby-carriage"
    "backward"
    "backward-fast"
    "backward-step"
    "bacon"
    "bacteria"
    "bacterium"
    "bag-shopping"
    "bahai"
    "baht-sign"
    "ban"
    "ban-smoking"
    "bandage"
    "bandcamp"
    "bangladeshi-taka-sign"
    "barcode"
    "bars"
    "bars-progress"
    "bars-staggered"
    "baseball"
    "baseball-bat-ball"
    "basket-shopping"
    "basketball"
    "bath"
    "battery-empty"
    "battery-full"
    "battery-half"
    "battery-quarter"
    "battery-three-quarters"
    "battle-net"
    "bed"
    "bed-pulse"
    "beer-mug-empty"
    "behance"
    "bell"
    "bell-concierge"
    "bell-slash"
    "bezier-curve"
    "bicycle"
    "bilibili"
    "bimobject"
    "binoculars"
    "biohazard"
    "bitbucket"
    "bitcoin"
    "bitcoin-sign"
    "bity"
    "black-tie"
    "blackberry"
    "blender"
    "blender-phone"
    "blog"
    "blogger"
    "blogger-b"
    "bluesky"
    "bluetooth"
    "bluetooth-b"
    "bold"
    "bolt"
    "bolt-lightning"
    "bomb"
    "bone"
    "bong"
    "book"
    "book-atlas"
    "book-bible"
    "book-bookmark"
    "book-journal-whills"
    "book-medical"
    "book-open"
    "book-open-reader"
    "book-quran"
    "book-skull"
    "book-tanakh"
    "bookmark"
    "bootstrap"
    "border-all"
    "border-none"
    "border-top-left"
    "bore-hole"
    "bots"
    "bottle-droplet"
    "bottle-water"
    "bowl-food"
    "bowl-rice"
    "bowling-ball"
    "box"
    "box-archive"
    "box-open"
    "box-tissue"
    "boxes-packing"
    "boxes-stacked"
    "braille"
    "brain"
    "brave"
    "brave-reverse"
    "brazilian-real-sign"
    "bread-slice"
    "bridge"
    "bridge-circle-check"
    "bridge-circle-exclamation"
    "bridge-circle-xmark"
    "bridge-lock"
    "bridge-water"
    "briefcase"
    "briefcase-medical"
    "broom"
    "broom-ball"
    "brush"
    "btc"
    "bucket"
    "buffer"
    "bug"
    "bug-slash"
    "bugs"
    "building"
    "building-circle-arrow-right"
    "building-circle-check"
    "building-circle-exclamation"
    "building-circle-xmark"
    "building-columns"
    "building-flag"
    "building-lock"
    "building-ngo"
    "building-shield"
    "building-un"
    "building-user"
    "building-wheat"
    "bullhorn"
    "bullseye"
    "burger"
    "buromobelexperte"
    "burst"
    "bus"
    "bus-side"
    "bus-simple"
    "business-time"
    "buy-n-large"
    "buysellads"
    "c"
    "cable-car"
    "cake-candles"
    "calculator"
    "calendar"
    "calendar-check"
    "calendar-day"
    "calendar-days"
    "calendar-minus"
    "calendar-plus"
    "calendar-week"
    "calendar-xmark"
    "camera"
    "camera-retro"
    "camera-rotate"
    "campground"
    "canadian-maple-leaf"
    "candy-cane"
    "cannabis"
    "capsules"
    "car"
    "car-battery"
    "car-burst"
    "car-on"
    "car-rear"
    "car-side"
    "car-tunnel"
    "caravan"
    "caret-down"
    "caret-left"
    "caret-right"
    "caret-up"
    "carrot"
    "cart-arrow-down"
    "cart-flatbed"
    "cart-flatbed-suitcase"
    "cart-plus"
    "cart-shopping"
    "cash-app"
    "cash-register"
    "cat"
    "cc-amazon-pay"
    "cc-amex"
    "cc-apple-pay"
    "cc-diners-club"
    "cc-discover"
    "cc-jcb"
    "cc-mastercard"
    "cc-paypal"
    "cc-stripe"
    "cc-visa"
    "cedi-sign"
    "cent-sign"
    "centercode"
    "centos"
    "certificate"
    "chair"
    "chalkboard"
    "chalkboard-user"
    "champagne-glasses"
    "charging-station"
    "chart-area"
    "chart-bar"
    "chart-column"
    "chart-diagram"
    "chart-gantt"
    "chart-line"
    "chart-pie"
    "chart-simple"
    "check"
    "check-double"
    "check-to-slot"
    "cheese"
    "chess"
    "chess-bishop"
    "chess-board"
    "chess-king"
    "chess-knight"
    "chess-pawn"
    "chess-queen"
    "chess-rook"
    "chevron-down"
    "chevron-left"
    "chevron-right"
    "chevron-up"
    "child"
    "child-combatant"
    "child-dress"
    "child-reaching"
    "children"
    "chrome"
    "chromecast"
    "church"
    "circle"
    "circle-arrow-down"
    "circle-arrow-left"
    "circle-arrow-right"
    "circle-arrow-up"
    "circle-check"
    "circle-chevron-down"
    "circle-chevron-left"
    "circle-chevron-right"
    "circle-chevron-up"
    "circle-dollar-to-slot"
    "circle-dot"
    "circle-down"
    "circle-exclamation"
    "circle-h"
    "circle-half-stroke"
    "circle-info"
    "circle-left"
    "circle-minus"
    "circle-nodes"
    "circle-notch"
    "circle-pause"
    "circle-play"
    "circle-plus"
    "circle-question"
    "circle-radiation"
    "circle-right"
    "circle-stop"
    "circle-up"
    "circle-user"
    "circle-xmark"
    "city"
    "clapperboard"
    "clipboard"
    "clipboard-check"
    "clipboard-list"
    "clipboard-question"
    "clipboard-user"
    "clock"
    "clock-rotate-left"
    "clone"
    "closed-captioning"
    "cloud"
    "cloud-arrow-down"
    "cloud-arrow-up"
    "cloud-bolt"
    "cloud-meatball"
    "cloud-moon"
    "cloud-moon-rain"
    "cloud-rain"
    "cloud-showers-heavy"
    "cloud-showers-water"
    "cloud-sun"
    "cloud-sun-rain"
    "cloudflare"
    "cloudscale"
    "cloudsmith"
    "cloudversify"
    "clover"
    "cmplid"
    "code"
    "code-branch"
    "code-commit"
    "code-compare"
    "code-fork"
    "code-merge"
    "code-pull-request"
    "codepen"
    "codiepie"
    "coins"
    "colon-sign"
    "comment"
    "comment-dollar"
    "comment-dots"
    "comment-medical"
    "comment-nodes"
    "comment-slash"
    "comment-sms"
    "comments"
    "comments-dollar"
    "compact-disc"
    "compass"
    "compass-drafting"
    "compress"
    "computer"
    "computer-mouse"
    "confluence"
    "connectdevelop"
    "contao"
    "cookie"
    "cookie-bite"
    "copy"
    "copyright"
    "cotton-bureau"
    "couch"
    "cow"
    "cpanel"
    "creative-commons"
    "creative-commons-by"
    "creative-commons-nc"
    "creative-commons-nc-eu"
    "creative-commons-nc-jp"
    "creative-commons-nd"
    "creative-commons-pd"
    "creative-commons-pd-alt"
    "creative-commons-remix"
    "creative-commons-sa"
    "creative-commons-sampling"
    "creative-commons-sampling-plus"
    "creative-commons-share"
    "creative-commons-zero"
    "credit-card"
    "critical-role"
    "crop"
    "crop-simple"
    "cross"
    "crosshairs"
    "crow"
    "crown"
    "crutch"
    "cruzeiro-sign"
    "css"
    "css3"
    "css3-alt"
    "cube"
    "cubes"
    "cubes-stacked"
    "cuttlefish"
    "d"
    "d-and-d"
    "d-and-d-beyond"
    "dailymotion"
    "dart-lang"
    "dashcube"
    "database"
    "debian"
    "deezer"
    "delete-left"
    "delicious"
    "democrat"
    "deploydog"
    "deskpro"
    "desktop"
    "dev"
    "deviantart"
    "dharmachakra"
    "dhl"
    "diagram-next"
    "diagram-predecessor"
    "diagram-project"
    "diagram-successor"
    "diamond"
    "diamond-turn-right"
    "diaspora"
    "dice"
    "dice-d20"
    "dice-d6"
    "dice-five"
    "dice-four"
    "dice-one"
    "dice-six"
    "dice-three"
    "dice-two"
    "digg"
    "digital-ocean"
    "discord"
    "discourse"
    "disease"
    "display"
    "disqus"
    "divide"
    "dna"
    "dochub"
    "docker"
    "dog"
    "dollar-sign"
    "dolly"
    "dong-sign"
    "door-closed"
    "door-open"
    "dove"
    "down-left-and-up-right-to-center"
    "down-long"
    "download"
    "draft2digital"
    "dragon"
    "draw-polygon"
    "dribbble"
    "dropbox"
    "droplet"
    "droplet-slash"
    "drum"
    "drum-steelpan"
    "drumstick-bite"
    "drupal"
    "dumbbell"
    "dumpster"
    "dumpster-fire"
    "dungeon"
    "duolingo"
    "dyalog"
    "e"
    "ear-deaf"
    "ear-listen"
    "earlybirds"
    "earth-africa"
    "earth-americas"
    "earth-asia"
    "earth-europe"
    "earth-oceania"
    "ebay"
    "edge"
    "edge-legacy"
    "egg"
    "eject"
    "elementor"
    "elevator"
    "eleventy"
    "ellipsis"
    "ellipsis-vertical"
    "ello"
    "ember"
    "empire"
    "envelope"
    "envelope-circle-check"
    "envelope-open"
    "envelope-open-text"
    "envelopes-bulk"
    "envira"
    "equals"
    "eraser"
    "erlang"
    "ethereum"
    "ethernet"
    "etsy"
    "euro-sign"
    "evernote"
    "exclamation"
    "expand"
    "expeditedssl"
    "explosion"
    "eye"
    "eye-dropper"
    "eye-low-vision"
    "eye-slash"
    "f"
    "face-angry"
    "face-dizzy"
    "face-flushed"
    "face-frown"
    "face-frown-open"
    "face-grimace"
    "face-grin"
    "face-grin-beam"
    "face-grin-beam-sweat"
    "face-grin-hearts"
    "face-grin-squint"
    "face-grin-squint-tears"
    "face-grin-stars"
    "face-grin-tears"
    "face-grin-tongue"
    "face-grin-tongue-squint"
    "face-grin-tongue-wink"
    "face-grin-wide"
    "face-grin-wink"
    "face-kiss"
    "face-kiss-beam"
    "face-kiss-wink-heart"
    "face-laugh"
    "face-laugh-beam"
    "face-laugh-squint"
    "face-laugh-wink"
    "face-meh"
    "face-meh-blank"
    "face-rolling-eyes"
    "face-sad-cry"
    "face-sad-tear"
    "face-smile"
    "face-smile-beam"
    "face-smile-wink"
    "face-surprise"
    "face-tired"
    "facebook"
    "facebook-f"
    "facebook-messenger"
    "fan"
    "fantasy-flight-games"
    "faucet"
    "faucet-drip"
    "fax"
    "feather"
    "feather-pointed"
    "fedex"
    "fedora"
    "ferry"
    "figma"
    "file"
    "file-arrow-down"
    "file-arrow-up"
    "file-audio"
    "file-circle-check"
    "file-circle-exclamation"
    "file-circle-minus"
    "file-circle-plus"
    "file-circle-question"
    "file-circle-xmark"
    "file-code"
    "file-contract"
    "file-csv"
    "file-excel"
    "file-export"
    "file-fragment"
    "file-half-dashed"
    "file-image"
    "file-import"
    "file-invoice"
    "file-invoice-dollar"
    "file-lines"
    "file-medical"
    "file-pdf"
    "file-pen"
    "file-powerpoint"
    "file-prescription"
    "file-shield"
    "file-signature"
    "file-video"
    "file-waveform"
    "file-word"
    "file-zipper"
    "files-pinwheel"
    "fill"
    "fill-drip"
    "film"
    "filter"
    "filter-circle-dollar"
    "filter-circle-xmark"
    "fingerprint"
    "fire"
    "fire-burner"
    "fire-extinguisher"
    "fire-flame-curved"
    "fire-flame-simple"
    "firefox"
    "firefox-browser"
    "first-order"
    "first-order-alt"
    "firstdraft"
    "fish"
    "fish-fins"
    "flag"
    "flag-checkered"
    "flag-usa"
    "flask"
    "flask-vial"
    "flickr"
    "flipboard"
    "floppy-disk"
    "florin-sign"
    "flutter"
    "fly"
    "folder"
    "folder-closed"
    "folder-minus"
    "folder-open"
    "folder-plus"
    "folder-tree"
    "font"
    "font-awesome"
    "fonticons"
    "fonticons-fi"
    "football"
    "fort-awesome"
    "fort-awesome-alt"
    "forumbee"
    "forward"
    "forward-fast"
    "forward-step"
    "foursquare"
    "franc-sign"
    "free-code-camp"
    "freebsd"
    "frog"
    "fulcrum"
    "futbol"
    "g"
    "galactic-republic"
    "galactic-senate"
    "gamepad"
    "gas-pump"
    "gauge"
    "gauge-high"
    "gauge-simple"
    "gauge-simple-high"
    "gavel"
    "gear"
    "gears"
    "gem"
    "genderless"
    "get-pocket"
    "gg"
    "gg-circle"
    "ghost"
    "gift"
    "gifts"
    "git"
    "git-alt"
    "github"
    "github-alt"
    "gitkraken"
    "gitlab"
    "gitter"
    "glass-water"
    "glass-water-droplet"
    "glasses"
    "glide"
    "glide-g"
    "globe"
    "gofore"
    "golang"
    "golf-ball-tee"
    "goodreads"
    "goodreads-g"
    "google"
    "google-drive"
    "google-pay"
    "google-play"
    "google-plus"
    "google-plus-g"
    "google-scholar"
    "google-wallet"
    "gopuram"
    "graduation-cap"
    "gratipay"
    "grav"
    "greater-than"
    "greater-than-equal"
    "grip"
    "grip-lines"
    "grip-lines-vertical"
    "grip-vertical"
    "gripfire"
    "group-arrows-rotate"
    "grunt"
    "guarani-sign"
    "guilded"
    "guitar"
    "gulp"
    "gun"
    "h"
    "hacker-news"
    "hackerrank"
    "hammer"
    "hamsa"
    "hand"
    "hand-back-fist"
    "hand-dots"
    "hand-fist"
    "hand-holding"
    "hand-holding-dollar"
    "hand-holding-droplet"
    "hand-holding-hand"
    "hand-holding-heart"
    "hand-holding-medical"
    "hand-lizard"
    "hand-middle-finger"
    "hand-peace"
    "hand-point-down"
    "hand-point-left"
    "hand-point-right"
    "hand-point-up"
    "hand-pointer"
    "hand-scissors"
    "hand-sparkles"
    "hand-spock"
    "handcuffs"
    "hands"
    "hands-asl-interpreting"
    "hands-bound"
    "hands-bubbles"
    "hands-clapping"
    "hands-holding"
    "hands-holding-child"
    "hands-holding-circle"
    "hands-praying"
    "handshake"
    "handshake-angle"
    "handshake-slash"
    "hanukiah"
    "hard-drive"
    "hashnode"
    "hashtag"
    "hat-cowboy"
    "hat-cowboy-side"
    "hat-wizard"
    "head-side-cough"
    "head-side-cough-slash"
    "head-side-mask"
    "head-side-virus"
    "heading"
    "headphones"
    "headset"
    "heart"
    "heart-circle-bolt"
    "heart-circle-check"
    "heart-circle-exclamation"
    "heart-circle-minus"
    "heart-circle-plus"
    "heart-circle-xmark"
    "heart-crack"
    "heart-pulse"
    "helicopter"
    "helicopter-symbol"
    "helmet-safety"
    "helmet-un"
    "hexagon"
    "hexagon-nodes"
    "hexagon-nodes-bolt"
    "highlighter"
    "hill-avalanche"
    "hill-rockslide"
    "hippo"
    "hips"
    "hire-a-helper"
    "hive"
    "hockey-puck"
    "holly-berry"
    "hooli"
    "hornbill"
    "horse"
    "horse-head"
    "hospital"
    "hospital-user"
    "hot-tub-person"
    "hotdog"
    "hotel"
    "hotjar"
    "hourglass"
    "hourglass-end"
    "hourglass-half"
    "hourglass-start"
    "house"
    "house-chimney"
    "house-chimney-crack"
    "house-chimney-medical"
    "house-chimney-user"
    "house-chimney-window"
    "house-circle-check"
    "house-circle-exclamation"
    "house-circle-xmark"
    "house-crack"
    "house-fire"
    "house-flag"
    "house-flood-water"
    "house-flood-water-circle-arrow-right"
    "house-laptop"
    "house-lock"
    "house-medical"
    "house-medical-circle-check"
    "house-medical-circle-exclamation"
    "house-medical-circle-xmark"
    "house-medical-flag"
    "house-signal"
    "house-tsunami"
    "house-user"
    "houzz"
    "hryvnia-sign"
    "html5"
    "hubspot"
    "hurricane"
    "i"
    "i-cursor"
    "ice-cream"
    "icicles"
    "icons"
    "id-badge"
    "id-card"
    "id-card-clip"
    "ideal"
    "igloo"
    "image"
    "image-portrait"
    "images"
    "imdb"
    "inbox"
    "indent"
    "indian-rupee-sign"
    "industry"
    "infinity"
    "info"
    "instagram"
    "instalod"
    "intercom"
    "internet-explorer"
    "invision"
    "ioxhost"
    "italic"
    "itch-io"
    "itunes"
    "itunes-note"
    "j"
    "jar"
    "jar-wheat"
    "java"
    "jedi"
    "jedi-order"
    "jenkins"
    "jet-fighter"
    "jet-fighter-up"
    "jira"
    "joget"
    "joint"
    "joomla"
    "js"
    "jsfiddle"
    "jug-detergent"
    "jxl"
    "k"
    "kaaba"
    "kaggle"
    "kakao-talk"
    "key"
    "keybase"
    "keyboard"
    "keycdn"
    "khanda"
    "kickstarter"
    "kickstarter-k"
    "kip-sign"
    "kit-medical"
    "kitchen-set"
    "kiwi-bird"
    "korvue"
    "l"
    "land-mine-on"
    "landmark"
    "landmark-dome"
    "landmark-flag"
    "language"
    "laptop"
    "laptop-code"
    "laptop-file"
    "laptop-medical"
    "laravel"
    "lari-sign"
    "lastfm"
    "layer-group"
    "leaf"
    "leanpub"
    "left-long"
    "left-right"
    "lemon"
    "less"
    "less-than"
    "less-than-equal"
    "letterboxd"
    "life-ring"
    "lightbulb"
    "line"
    "lines-leaning"
    "link"
    "link-slash"
    "linkedin"
    "linkedin-in"
    "linktree"
    "linode"
    "linux"
    "lira-sign"
    "list"
    "list-check"
    "list-ol"
    "list-ul"
    "litecoin-sign"
    "location-arrow"
    "location-crosshairs"
    "location-dot"
    "location-pin"
    "location-pin-lock"
    "lock"
    "lock-open"
    "locust"
    "lumon"
    "lumon-drop"
    "lungs"
    "lungs-virus"
    "lyft"
    "m"
    "magento"
    "magnet"
    "magnifying-glass"
    "magnifying-glass-arrow-right"
    "magnifying-glass-chart"
    "magnifying-glass-dollar"
    "magnifying-glass-location"
    "magnifying-glass-minus"
    "magnifying-glass-plus"
    "mailchimp"
    "manat-sign"
    "mandalorian"
    "map"
    "map-location"
    "map-location-dot"
    "map-pin"
    "markdown"
    "marker"
    "mars"
    "mars-and-venus"
    "mars-and-venus-burst"
    "mars-double"
    "mars-stroke"
    "mars-stroke-right"
    "mars-stroke-up"
    "martini-glass"
    "martini-glass-citrus"
    "martini-glass-empty"
    "mask"
    "mask-face"
    "mask-ventilator"
    "masks-theater"
    "mastodon"
    "mattress-pillow"
    "maxcdn"
    "maximize"
    "mdb"
    "medal"
    "medapps"
    "medium"
    "medrt"
    "meetup"
    "megaport"
    "memory"
    "mendeley"
    "menorah"
    "mercury"
    "message"
    "meta"
    "meteor"
    "microblog"
    "microchip"
    "microphone"
    "microphone-lines"
    "microphone-lines-slash"
    "microphone-slash"
    "microscope"
    "microsoft"
    "mill-sign"
    "minimize"
    "mintbit"
    "minus"
    "mitten"
    "mix"
    "mixcloud"
    "mixer"
    "mizuni"
    "mobile"
    "mobile-button"
    "mobile-retro"
    "mobile-screen"
    "mobile-screen-button"
    "mobile-vibrate"
    "modx"
    "monero"
    "money-bill"
    "money-bill-1"
    "money-bill-1-wave"
    "money-bill-transfer"
    "money-bill-trend-up"
    "money-bill-wave"
    "money-bill-wheat"
    "money-bills"
    "money-check"
    "money-check-dollar"
    "monument"
    "moon"
    "mortar-pestle"
    "mosque"
    "mosquito"
    "mosquito-net"
    "motorcycle"
    "mound"
    "mountain"
    "mountain-city"
    "mountain-sun"
    "mug-hot"
    "mug-saucer"
    "music"
    "n"
    "naira-sign"
    "napster"
    "neos"
    "network-wired"
    "neuter"
    "newspaper"
    "nfc-directional"
    "nfc-symbol"
    "nimblr"
    "node"
    "node-js"
    "non-binary"
    "not-equal"
    "notdef"
    "note-sticky"
    "notes-medical"
    "notion"
    "npm"
    "ns8"
    "nutritionix"
    "o"
    "object-group"
    "object-ungroup"
    "octagon"
    "octopus-deploy"
    "odnoklassniki"
    "odysee"
    "oil-can"
    "oil-well"
    "old-republic"
    "om"
    "openai"
    "opencart"
    "openid"
    "opensuse"
    "opera"
    "optin-monster"
    "orcid"
    "osi"
    "otter"
    "outdent"
    "p"
    "padlet"
    "page4"
    "pagelines"
    "pager"
    "paint-roller"
    "paintbrush"
    "palette"
    "palfed"
    "pallet"
    "pandora"
    "panorama"
    "paper-plane"
    "paperclip"
    "parachute-box"
    "paragraph"
    "passport"
    "paste"
    "patreon"
    "pause"
    "paw"
    "paypal"
    "peace"
    "pen"
    "pen-clip"
    "pen-fancy"
    "pen-nib"
    "pen-ruler"
    "pen-to-square"
    "pencil"
    "pentagon"
    "people-arrows"
    "people-carry-box"
    "people-group"
    "people-line"
    "people-pulling"
    "people-robbery"
    "people-roof"
    "pepper-hot"
    "perbyte"
    "percent"
    "periscope"
    "person"
    "person-arrow-down-to-line"
    "person-arrow-up-from-line"
    "person-biking"
    "person-booth"
    "person-breastfeeding"
    "person-burst"
    "person-cane"
    "person-chalkboard"
    "person-circle-check"
    "person-circle-exclamation"
    "person-circle-minus"
    "person-circle-plus"
    "person-circle-question"
    "person-circle-xmark"
    "person-digging"
    "person-dots-from-line"
    "person-dress"
    "person-dress-burst"
    "person-drowning"
    "person-falling"
    "person-falling-burst"
    "person-half-dress"
    "person-harassing"
    "person-hiking"
    "person-military-pointing"
    "person-military-rifle"
    "person-military-to-person"
    "person-praying"
    "person-pregnant"
    "person-rays"
    "person-rifle"
    "person-running"
    "person-shelter"
    "person-skating"
    "person-skiing"
    "person-skiing-nordic"
    "person-snowboarding"
    "person-swimming"
    "person-through-window"
    "person-walking"
    "person-walking-arrow-loop-left"
    "person-walking-arrow-right"
    "person-walking-dashed-line-arrow-right"
    "person-walking-luggage"
    "person-walking-with-cane"
    "peseta-sign"
    "peso-sign"
    "phabricator"
    "phoenix-framework"
    "phoenix-squadron"
    "phone"
    "phone-flip"
    "phone-slash"
    "phone-volume"
    "photo-film"
    "php"
    "pied-piper"
    "pied-piper-alt"
    "pied-piper-hat"
    "pied-piper-pp"
    "piggy-bank"
    "pills"
    "pinterest"
    "pinterest-p"
    "pix"
    "pixelfed"
    "pixiv"
    "pizza-slice"
    "place-of-worship"
    "plane"
    "plane-arrival"
    "plane-circle-check"
    "plane-circle-exclamation"
    "plane-circle-xmark"
    "plane-departure"
    "plane-lock"
    "plane-slash"
    "plane-up"
    "plant-wilt"
    "plate-wheat"
    "play"
    "playstation"
    "plug"
    "plug-circle-bolt"
    "plug-circle-check"
    "plug-circle-exclamation"
    "plug-circle-minus"
    "plug-circle-plus"
    "plug-circle-xmark"
    "plus"
    "plus-minus"
    "podcast"
    "poo"
    "poo-storm"
    "poop"
    "power-off"
    "prescription"
    "prescription-bottle"
    "prescription-bottle-medical"
    "print"
    "product-hunt"
    "pump-medical"
    "pump-soap"
    "pushed"
    "puzzle-piece"
    "python"
    "q"
    "qq"
    "qrcode"
    "question"
    "quinscape"
    "quora"
    "quote-left"
    "quote-right"
    "r"
    "r-project"
    "radiation"
    "radio"
    "rainbow"
    "ranking-star"
    "raspberry-pi"
    "ravelry"
    "react"
    "reacteurope"
    "readme"
    "rebel"
    "receipt"
    "record-vinyl"
    "rectangle-ad"
    "rectangle-list"
    "rectangle-xmark"
    "recycle"
    "red-river"
    "reddit"
    "reddit-alien"
    "redhat"
    "registered"
    "renren"
    "repeat"
    "reply"
    "reply-all"
    "replyd"
    "republican"
    "researchgate"
    "resolving"
    "restroom"
    "retweet"
    "rev"
    "ribbon"
    "right-from-bracket"
    "right-left"
    "right-long"
    "right-to-bracket"
    "ring"
    "road"
    "road-barrier"
    "road-bridge"
    "road-circle-check"
    "road-circle-exclamation"
    "road-circle-xmark"
    "road-lock"
    "road-spikes"
    "robot"
    "rocket"
    "rocketchat"
    "rockrms"
    "rotate"
    "rotate-left"
    "rotate-right"
    "route"
    "rss"
    "ruble-sign"
    "rug"
    "ruler"
    "ruler-combined"
    "ruler-horizontal"
    "ruler-vertical"
    "rupee-sign"
    "rupiah-sign"
    "rust"
    "s"
    "sack-dollar"
    "sack-xmark"
    "safari"
    "sailboat"
    "salesforce"
    "sass"
    "satellite"
    "satellite-dish"
    "scale-balanced"
    "scale-unbalanced"
    "scale-unbalanced-flip"
    "schlix"
    "school"
    "school-circle-check"
    "school-circle-exclamation"
    "school-circle-xmark"
    "school-flag"
    "school-lock"
    "scissors"
    "screenpal"
    "screwdriver"
    "screwdriver-wrench"
    "scribd"
    "scroll"
    "scroll-torah"
    "sd-card"
    "searchengin"
    "section"
    "seedling"
    "sellcast"
    "sellsy"
    "septagon"
    "server"
    "servicestack"
    "shapes"
    "share"
    "share-from-square"
    "share-nodes"
    "sheet-plastic"
    "shekel-sign"
    "shield"
    "shield-cat"
    "shield-dog"
    "shield-halved"
    "shield-heart"
    "shield-virus"
    "ship"
    "shirt"
    "shirtsinbulk"
    "shoe-prints"
    "shoelace"
    "shop"
    "shop-lock"
    "shop-slash"
    "shopify"
    "shopware"
    "shower"
    "shrimp"
    "shuffle"
    "shuttle-space"
    "sign-hanging"
    "signal"
    "signal-messenger"
    "signature"
    "signs-post"
    "sim-card"
    "simplybuilt"
    "single-quote-left"
    "single-quote-right"
    "sink"
    "sistrix"
    "sitemap"
    "sith"
    "sitrox"
    "sketch"
    "skull"
    "skull-crossbones"
    "skyatlas"
    "skype"
    "slack"
    "slash"
    "sleigh"
    "sliders"
    "slideshare"
    "smog"
    "smoking"
    "snapchat"
    "snowflake"
    "snowman"
    "snowplow"
    "soap"
    "socks"
    "solar-panel"
    "sort"
    "sort-down"
    "sort-up"
    "soundcloud"
    "sourcetree"
    "spa"
    "space-awesome"
    "spaghetti-monster-flying"
    "speakap"
    "speaker-deck"
    "spell-check"
    "spider"
    "spinner"
    "spiral"
    "splotch"
    "spoon"
    "spotify"
    "spray-can"
    "spray-can-sparkles"
    "square"
    "square-arrow-up-right"
    "square-behance"
    "square-binary"
    "square-bluesky"
    "square-caret-down"
    "square-caret-left"
    "square-caret-right"
    "square-caret-up"
    "square-check"
    "square-dribbble"
    "square-envelope"
    "square-facebook"
    "square-figma"
    "square-font-awesome"
    "square-font-awesome-stroke"
    "square-full"
    "square-git"
    "square-github"
    "square-gitlab"
    "square-google-plus"
    "square-h"
    "square-hacker-news"
    "square-instagram"
    "square-js"
    "square-lastfm"
    "square-letterboxd"
    "square-linkedin"
    "square-minus"
    "square-nfi"
    "square-odnoklassniki"
    "square-parking"
    "square-pen"
    "square-person-confined"
    "square-phone"
    "square-phone-flip"
    "square-pied-piper"
    "square-pinterest"
    "square-plus"
    "square-poll-horizontal"
    "square-poll-vertical"
    "square-reddit"
    "square-root-variable"
    "square-rss"
    "square-share-nodes"
    "square-snapchat"
    "square-steam"
    "square-threads"
    "square-tumblr"
    "square-twitter"
    "square-up-right"
    "square-upwork"
    "square-viadeo"
    "square-vimeo"
    "square-virus"
    "square-web-awesome"
    "square-web-awesome-stroke"
    "square-whatsapp"
    "square-x-twitter"
    "square-xing"
    "square-xmark"
    "square-youtube"
    "squarespace"
    "stack-exchange"
    "stack-overflow"
    "stackpath"
    "staff-snake"
    "stairs"
    "stamp"
    "stapler"
    "star"
    "star-and-crescent"
    "star-half"
    "star-half-stroke"
    "star-of-david"
    "star-of-life"
    "staylinked"
    "steam"
    "steam-symbol"
    "sterling-sign"
    "stethoscope"
    "sticker-mule"
    "stop"
    "stopwatch"
    "stopwatch-20"
    "store"
    "store-slash"
    "strava"
    "street-view"
    "strikethrough"
    "stripe"
    "stripe-s"
    "stroopwafel"
    "stubber"
    "studiovinari"
    "stumbleupon"
    "stumbleupon-circle"
    "subscript"
    "suitcase"
    "suitcase-medical"
    "suitcase-rolling"
    "sun"
    "sun-plant-wilt"
    "superpowers"
    "superscript"
    "supple"
    "suse"
    "swatchbook"
    "swift"
    "symfony"
    "synagogue"
    "syringe"
    "t"
    "table"
    "table-cells"
    "table-cells-column-lock"
    "table-cells-large"
    "table-cells-row-lock"
    "table-cells-row-unlock"
    "table-columns"
    "table-list"
    "table-tennis-paddle-ball"
    "tablet"
    "tablet-button"
    "tablet-screen-button"
    "tablets"
    "tachograph-digital"
    "tag"
    "tags"
    "tape"
    "tarp"
    "tarp-droplet"
    "taxi"
    "teamspeak"
    "teeth"
    "teeth-open"
    "telegram"
    "temperature-arrow-down"
    "temperature-arrow-up"
    "temperature-empty"
    "temperature-full"
    "temperature-half"
    "temperature-high"
    "temperature-low"
    "temperature-quarter"
    "temperature-three-quarters"
    "tencent-weibo"
    "tenge-sign"
    "tent"
    "tent-arrow-down-to-line"
    "tent-arrow-left-right"
    "tent-arrow-turn-left"
    "tent-arrows-down"
    "tents"
    "terminal"
    "tex"
    "text-height"
    "text-slash"
    "text-width"
    "the-red-yeti"
    "themeco"
    "themeisle"
    "thermometer"
    "think-peaks"
    "threads"
    "thumbs-down"
    "thumbs-up"
    "thumbtack"
    "thumbtack-slash"
    "ticket"
    "ticket-simple"
    "tidal"
    "tiktok"
    "timeline"
    "toggle-off"
    "toggle-on"
    "toilet"
    "toilet-paper"
    "toilet-paper-slash"
    "toilet-portable"
    "toilets-portable"
    "toolbox"
    "tooth"
    "torii-gate"
    "tornado"
    "tower-broadcast"
    "tower-cell"
    "tower-observation"
    "tractor"
    "trade-federation"
    "trademark"
    "traffic-light"
    "trailer"
    "train"
    "train-subway"
    "train-tram"
    "transgender"
    "trash"
    "trash-arrow-up"
    "trash-can"
    "trash-can-arrow-up"
    "tree"
    "tree-city"
    "trello"
    "triangle-exclamation"
    "trophy"
    "trowel"
    "trowel-bricks"
    "truck"
    "truck-arrow-right"
    "truck-droplet"
    "truck-fast"
    "truck-field"
    "truck-field-un"
    "truck-front"
    "truck-medical"
    "truck-monster"
    "truck-moving"
    "truck-pickup"
    "truck-plane"
    "truck-ramp-box"
    "tty"
    "tumblr"
    "turkish-lira-sign"
    "turn-down"
    "turn-up"
    "tv"
    "twitch"
    "twitter"
    "typo3"
    "u"
    "uber"
    "ubuntu"
    "uikit"
    "umbraco"
    "umbrella"
    "umbrella-beach"
    "uncharted"
    "underline"
    "uniregistry"
    "unity"
    "universal-access"
    "unlock"
    "unlock-keyhole"
    "unsplash"
    "untappd"
    "up-down"
    "up-down-left-right"
    "up-long"
    "up-right-and-down-left-from-center"
    "up-right-from-square"
    "upload"
    "ups"
    "upwork"
    "usb"
    "user"
    "user-astronaut"
    "user-check"
    "user-clock"
    "user-doctor"
    "user-gear"
    "user-graduate"
    "user-group"
    "user-injured"
    "user-lock"
    "user-minus"
    "user-ninja"
    "user-nurse"
    "user-pen"
    "user-plus"
    "user-secret"
    "user-shield"
    "user-slash"
    "user-tag"
    "user-tie"
    "user-xmark"
    "users"
    "users-between-lines"
    "users-gear"
    "users-line"
    "users-rays"
    "users-rectangle"
    "users-slash"
    "users-viewfinder"
    "usps"
    "ussunnah"
    "utensils"
    "v"
    "vaadin"
    "van-shuttle"
    "vault"
    "venus"
    "venus-double"
    "venus-mars"
    "vest"
    "vest-patches"
    "viacoin"
    "viadeo"
    "vial"
    "vial-circle-check"
    "vial-virus"
    "vials"
    "viber"
    "video"
    "video-slash"
    "vihara"
    "vimeo"
    "vimeo-v"
    "vine"
    "virus"
    "virus-covid"
    "virus-covid-slash"
    "virus-slash"
    "viruses"
    "vk"
    "vnv"
    "voicemail"
    "volcano"
    "volleyball"
    "volume-high"
    "volume-low"
    "volume-off"
    "volume-xmark"
    "vr-cardboard"
    "vsco"
    "vuejs"
    "w"
    "w3c"
    "walkie-talkie"
    "wallet"
    "wand-magic"
    "wand-magic-sparkles"
    "wand-sparkles"
    "warehouse"
    "watchman-monitoring"
    "water"
    "water-ladder"
    "wave-square"
    "waze"
    "web-awesome"
    "webflow"
    "weebly"
    "weibo"
    "weight-hanging"
    "weight-scale"
    "weixin"
    "whatsapp"
    "wheat-awn"
    "wheat-awn-circle-exclamation"
    "wheelchair"
    "wheelchair-move"
    "whiskey-glass"
    "whmcs"
    "wifi"
    "wikipedia-w"
    "wind"
    "window-maximize"
    "window-minimize"
    "window-restore"
    "windows"
    "wine-bottle"
    "wine-glass"
    "wine-glass-empty"
    "wirsindhandwerk"
    "wix"
    "wizards-of-the-coast"
    "wodu"
    "wolf-pack-battalion"
    "won-sign"
    "wordpress"
    "wordpress-simple"
    "worm"
    "wpbeginner"
    "wpexplorer"
    "wpforms"
    "wpressr"
    "wrench"
    "x"
    "x-ray"
    "x-twitter"
    "xbox"
    "xing"
    "xmark"
    "xmarks-lines"
    "y"
    "y-combinator"
    "yahoo"
    "yammer"
    "yandex"
    "yandex-international"
    "yarn"
    "yelp"
    "yen-sign"
    "yin-yang"
    "yoast"
    "youtube"
    "z"
    "zhihu")
  "List of icons provided by the fontawesome7 package.")

(TeX-add-style-hook
 "fontawesome7"
 (lambda ()
   (TeX-add-symbols
    '("faIcon"
      [TeX-arg-completing-read ("solid" "regular") "Style"]
      (TeX-arg-completing-read LaTeX-fontawesome7-icons
                               "Icon")))

   ;; Fontification
   (when (and (featurep 'font-latex)
              (eq TeX-install-font-lock 'font-latex-setup))
     (font-latex-add-keywords '(("faIcon" "[{"))
                              'function)))
 TeX-dialect)

(defvar LaTeX-fontawesome7-package-options '("fixed")
  "Package options for the fontawesome7 package.")

;;; fontawesome7.el ends here
