# Deploying Certomancer

So you've fiddled around with `certomancer animate` long enough to give your configuration a more
permanent home? Fear not, deploying a Certomancer Animator instance on a server with nginx and
uWSGI is extremely easy if you've dealt with WSGI deployment before.


## Some pointers on uWSGI

1. Follow the [uWSGI quickstart](https://uwsgi-docs.readthedocs.io/en/latest/WSGIquickstart.html)
   guide to learn more about deploying WSGI applications.
2. Install Certomancer using `pip install certomancer[web-api]` (either system-wide or in a
   virtualenv).
   install the [pyca/cryptography](https://github.com/pyca/cryptography) library manually.
3. Generate or copy over some testing keys (RSA, DSA, ECDSA and EdDSA are supported).   
4. Set `module = certomancer.integrations.animator:app` in your `uwsgi.ini` file.
5. Make sure that at least the environment variables `CERTOMANCER_CONFIG` and `CERTOMANCER_KEY_DIR`
   are set (you can do that using the `env FOO=bar` syntax in `uwsgi.ini`).
   See [below](#environment-variables) for more information.
6. You're all set!

*Note:* Make sure that `external-url-prefix` in the configuration is set to something sensible,
otherwise the URLs generated by Certomancer might not match the actual endpoints exposed by your
web server.

Obviously, even though Certomancer is a testing tool, standard WSGI deployment best practices
still apply.

 - Do **not** run uWSGI as root (use the `uid` and `gid` settings).
 - Install your dependencies in a virtualenv.
 - For servers that host multiple WSGI applications, you might want to use the
   [uWSGI Emperor](https://uwsgi-docs.readthedocs.io/en/latest/Emperor.html) with Certomancer
   as a vassal (this is how I've set it up on my Raspberry Pi).
   
If you prefer a Docker-based workflow, I recommend using
[this image](https://hub.docker.com/r/tiangolo/uwsgi-nginx/) as the base image for your container
if you just want to get something up and running quickly.
Documentation and examples can be found [here](https://github.com/tiangolo/uwsgi-nginx-docker).

A somewhat more advanced Docker setup that uses Certomancer together with `redis`
to manage on-the-fly configuration is available
[over in this repository](https://github.com/itext/certomancer-as-a-service).
That one also comes with some Java-specific integrations.


## Environment variables

The default WSGI entrypoint for the Animator (i.e. `certomancer.integrations.animator.app`) looks
for the following environment variables. Only `CERTOMANCER_CONFIG` and `CERTOMANCER_KEY_DIR`
are mandatory. All others are optional.

*Note:* These settings run parallel to [some](cli.md#core-config-flags) of the
[options](cli.md#running-the-animator-locally) of the Certomancer [CLI](cli.md).


| Environment variable | Value | Use |
| --- | --- | --- |
| `CERTOMANCER_CONFIG` | path | Path to the [configuration file](config.md). |
| `CERTOMANCER_KEY_DIR` | path | Path to the directory where Certomancer will look for key files. |
| `CERTOMANCER_EXTRA_CONFIG_DIR` | path | Path to the directory where Certomancer will look for external PKI architecture definitions.<br>Default: directory containing the configuration file. |
| `CERTOMANCER_NO_WEB_UI` | 0 or 1 | If 1, disable web UI and only expose PKI services enumerated in config file. |
| `CERTOMANCER_NO_EXTRA_CONFIG` | 0 or 1 | If 1, all PKI architecture definitions must be contained in the main configuration file. |
| `CERTOMANCER_NO_TIME_OVERRIDE` | 0 or 1 | If 1, the Animator's per-request time override functionality is disabled. |


About the last flag: by default, a test client making requests to an Animator instance can include
the `X-Certomancer-Fake-Time` header with an ISO 8601 datetime to tell Certomancer to simulate
a particular point in time when preparing a response for the request. If left out, the current time
will be used.
