/**
* Enums.ts
* @author Abhilash Panwar (abpanwar)
* @copyright Microsoft 2018
* File containing the enums as constants.
*/
import { _eInternalMessageId } from "@microsoft/applicationinsights-core-js";
/**
 * The eValueKind contains a set of values that specify value kind of the property.
 * Either PII (Personal Identifiable Information) or customer content.
 */
export declare const enum eValueKind {
    /**
     * No kind.
     */
    NotSet = 0,
    /**
     * An LDAP distinguished name. For example, CN=Jeff Smith,OU=Sales,DC=Fabrikam,DC=COM.
     */
    Pii_DistinguishedName = 1,
    /**
     * Generic information.
     */
    Pii_GenericData = 2,
    /**
     * An IPV4 Internet address. For example, 192.0.2.1.
     */
    Pii_IPV4Address = 3,
    /**
     * An IPV6 Internet address. For example, 2001:0db8:85a3:0000:0000:8a2e:0370:7334.
     */
    Pii_IPv6Address = 4,
    /**
     * The Subject of an e-mail message.
     */
    Pii_MailSubject = 5,
    /**
     * A telephone number.
     */
    Pii_PhoneNumber = 6,
    /**
     * A query string.
     */
    Pii_QueryString = 7,
    /**
     * An SIP (Session Internet Protocol) address.
     */
    Pii_SipAddress = 8,
    /**
     * An e-mail address.
     */
    Pii_SmtpAddress = 9,
    /**
     * An user ID.
     */
    Pii_Identity = 10,
    /**
     * A URI (Uniform Resource Identifier).
     */
    Pii_Uri = 11,
    /**
     * The fully-qualified domain name.
     */
    Pii_Fqdn = 12,
    /**
     * Scrubs the last octet in a IPV4 Internet address.
     * For example: 10.121.227.147 becomes 10.121.227.*
     */
    Pii_IPV4AddressLegacy = 13,
    /**
     * Generic content.
     */
    CustomerContent_GenericContent = 32
}
/**
 * The ValueKind contains a set of values that specify value kind of the property.
 * Either PII (Personal Identifiable Information) or customer content.
 */
export declare const ValueKind: import("@microsoft/applicationinsights-core-js").EnumValue<typeof eValueKind>;
export type ValueKind = number | eValueKind;
/**
 * The EventLatency contains a set of values that specify the latency with which an event is sent.
 */
export declare const enum EventLatencyValue {
    /**
     * Normal latency.
     */
    Normal = 1,
    /**
     * Cost deferred latency. At the moment this latency is treated as Normal latency.
     */
    CostDeferred = 2,
    /**
     * Real time latency.
     */
    RealTime = 3,
    /**
     * Bypass normal batching/timing and send as soon as possible, this will still send asynchronously.
     * Added in v3.1.1
     */
    Immediate = 4
}
/**
 * The EventLatency contains a set of values that specify the latency with which an event is sent.
 */
export declare const EventLatency: import("@microsoft/applicationinsights-core-js").EnumValue<typeof EventLatencyValue>;
export type EventLatency = number | EventLatencyValue;
/**
 * Enum for property types.
 */
export declare const enum eEventPropertyType {
    Unspecified = 0,
    String = 1,
    Int32 = 2,
    UInt32 = 3,
    Int64 = 4,
    UInt64 = 5,
    Double = 6,
    Bool = 7,
    Guid = 8,
    DateTime = 9
}
/**
 * Enum for property types.
 */
export declare const EventPropertyType: import("@microsoft/applicationinsights-core-js").EnumValue<typeof eEventPropertyType>;
export type EventPropertyType = number | eEventPropertyType;
/**
 * The EventPersistence contains a set of values that specify the event's persistence.
 */
export declare const enum EventPersistenceValue {
    /**
     * Normal persistence.
     */
    Normal = 1,
    /**
     * Critical persistence.
     */
    Critical = 2
}
/**
 * The EventPersistence contains a set of values that specify the event's persistence.
 */
export declare const EventPersistence: import("@microsoft/applicationinsights-core-js").EnumValue<typeof EventPersistenceValue>;
export type EventPersistence = number | EventPersistenceValue;
/**
 * Define a specific way to send an event synchronously
 */
export declare const enum EventSendType {
    /**
     * Batch and send the event asynchronously, this is the same as either setting the event `sync` flag to false or not setting at all.
     */
    Batched = 0,
    /**
     * Attempt to send the event synchronously, this is the same as setting the event `sync` flag to true
     */
    Synchronous = 1,
    /**
     * Attempt to send the event synchronously with a preference for the sendBeacon() API.
     * As per the specification, the payload of the event (when converted to JSON) must not be larger than 64kb,
     * the sendHook is also not supported or used when sendBeacon.
     */
    SendBeacon = 2,
    /**
     * Attempt to send the event synchronously with a preference for the fetch() API with the keepalive flag,
     * the SDK checks to ensure that the fetch() implementation supports the 'keepalive' flag and if not it
     * will fallback to either sendBeacon() or a synchronous XHR request.
     * As per the specification, the payload of the event (when converted to JSON) must not be larger than 64kb.
     * Note: Not all browsers support the keepalive flag so for those environments the events may still fail
     */
    SyncFetch = 3
}
/**
 * The TraceLevel contains a set of values that specify the trace level for the trace messages.
 */
export declare const enum eTraceLevel {
    /**
     * None.
     */
    NONE = 0,
    /**
     * Error trace.
     */
    ERROR = 1,
    /**
     * Warning trace.
     */
    WARNING = 2,
    /**
     * Information trace.
     */
    INFORMATION = 3
}
export declare const TraceLevel: import("@microsoft/applicationinsights-core-js").EnumValue<typeof eTraceLevel>;
export type TraceLevel = number | eTraceLevel;
export declare const enum _eExtendedInternalMessageId {
    AuthHandShakeError = 501,
    AuthRedirectFail = 502,
    BrowserCannotReadLocalStorage = 503,
    BrowserCannotWriteLocalStorage = 504,
    BrowserDoesNotSupportLocalStorage = 505,
    CannotParseBiBlobValue = 506,
    CannotParseDataAttribute = 507,
    CVPluginNotAvailable = 508,
    DroppedEvent = 509,
    ErrorParsingAISessionCookie = 510,
    ErrorProvidedChannels = 511,
    FailedToGetCookies = 512,
    FailedToInitializeCorrelationVector = 513,
    FailedToInitializeSDK = 514,
    InvalidContentBlob = 515,
    InvalidCorrelationValue = 516,
    SessionRenewalDateIsZero = 517,
    SendPostOnCompleteFailure = 518,
    PostResponseHandler = 519,
    SDKNotInitialized = 520
}
export declare const _ExtendedInternalMessageId: {
    [x: number]: string;
    AuthHandShakeError: _eExtendedInternalMessageId.AuthHandShakeError;
    AuthRedirectFail: _eExtendedInternalMessageId.AuthRedirectFail;
    BrowserCannotReadLocalStorage: _eExtendedInternalMessageId.BrowserCannotReadLocalStorage;
    BrowserCannotWriteLocalStorage: _eExtendedInternalMessageId.BrowserCannotWriteLocalStorage;
    BrowserDoesNotSupportLocalStorage: _eExtendedInternalMessageId.BrowserDoesNotSupportLocalStorage;
    CannotParseBiBlobValue: _eExtendedInternalMessageId.CannotParseBiBlobValue;
    CannotParseDataAttribute: _eExtendedInternalMessageId.CannotParseDataAttribute;
    CVPluginNotAvailable: _eExtendedInternalMessageId.CVPluginNotAvailable;
    DroppedEvent: _eExtendedInternalMessageId.DroppedEvent;
    ErrorParsingAISessionCookie: _eExtendedInternalMessageId.ErrorParsingAISessionCookie;
    ErrorProvidedChannels: _eExtendedInternalMessageId.ErrorProvidedChannels;
    FailedToGetCookies: _eExtendedInternalMessageId.FailedToGetCookies;
    FailedToInitializeCorrelationVector: _eExtendedInternalMessageId.FailedToInitializeCorrelationVector;
    FailedToInitializeSDK: _eExtendedInternalMessageId.FailedToInitializeSDK;
    InvalidContentBlob: _eExtendedInternalMessageId.InvalidContentBlob;
    InvalidCorrelationValue: _eExtendedInternalMessageId.InvalidCorrelationValue;
    SessionRenewalDateIsZero: _eExtendedInternalMessageId.SessionRenewalDateIsZero;
    SendPostOnCompleteFailure: _eExtendedInternalMessageId.SendPostOnCompleteFailure;
    PostResponseHandler: _eExtendedInternalMessageId.PostResponseHandler;
    SDKNotInitialized: _eExtendedInternalMessageId.SDKNotInitialized;
    BrowserCannotReadSessionStorage: _eInternalMessageId.BrowserCannotReadSessionStorage;
    BrowserCannotWriteSessionStorage: _eInternalMessageId.BrowserCannotWriteSessionStorage;
    BrowserFailedRemovalFromLocalStorage: _eInternalMessageId.BrowserFailedRemovalFromLocalStorage;
    BrowserFailedRemovalFromSessionStorage: _eInternalMessageId.BrowserFailedRemovalFromSessionStorage;
    CannotSendEmptyTelemetry: _eInternalMessageId.CannotSendEmptyTelemetry;
    ClientPerformanceMathError: _eInternalMessageId.ClientPerformanceMathError;
    ErrorPVCalc: _eInternalMessageId.ErrorPVCalc;
    ExceptionWhileLoggingError: _eInternalMessageId.ExceptionWhileLoggingError;
    FailedAddingTelemetryToBuffer: _eInternalMessageId.FailedAddingTelemetryToBuffer;
    FailedMonitorAjaxAbort: _eInternalMessageId.FailedMonitorAjaxAbort;
    FailedMonitorAjaxDur: _eInternalMessageId.FailedMonitorAjaxDur;
    FailedMonitorAjaxOpen: _eInternalMessageId.FailedMonitorAjaxOpen;
    FailedMonitorAjaxRSC: _eInternalMessageId.FailedMonitorAjaxRSC;
    FailedMonitorAjaxSend: _eInternalMessageId.FailedMonitorAjaxSend;
    FailedMonitorAjaxGetCorrelationHeader: _eInternalMessageId.FailedMonitorAjaxGetCorrelationHeader;
    FailedToAddHandlerForOnBeforeUnload: _eInternalMessageId.FailedToAddHandlerForOnBeforeUnload;
    FailedToSendQueuedTelemetry: _eInternalMessageId.FailedToSendQueuedTelemetry;
    FailedToReportDataLoss: _eInternalMessageId.FailedToReportDataLoss;
    FlushFailed: _eInternalMessageId.FlushFailed;
    MessageLimitPerPVExceeded: _eInternalMessageId.MessageLimitPerPVExceeded;
    MissingRequiredFieldSpecification: _eInternalMessageId.MissingRequiredFieldSpecification;
    NavigationTimingNotSupported: _eInternalMessageId.NavigationTimingNotSupported;
    OnError: _eInternalMessageId.OnError;
    SenderNotInitialized: _eInternalMessageId.SenderNotInitialized;
    StartTrackEventFailed: _eInternalMessageId.StartTrackEventFailed;
    StopTrackEventFailed: _eInternalMessageId.StopTrackEventFailed;
    StartTrackFailed: _eInternalMessageId.StartTrackFailed;
    StopTrackFailed: _eInternalMessageId.StopTrackFailed;
    TelemetrySampledAndNotSent: _eInternalMessageId.TelemetrySampledAndNotSent;
    TrackEventFailed: _eInternalMessageId.TrackEventFailed;
    TrackExceptionFailed: _eInternalMessageId.TrackExceptionFailed;
    TrackMetricFailed: _eInternalMessageId.TrackMetricFailed;
    TrackPVFailed: _eInternalMessageId.TrackPVFailed;
    TrackPVFailedCalc: _eInternalMessageId.TrackPVFailedCalc;
    TrackTraceFailed: _eInternalMessageId.TrackTraceFailed;
    TransmissionFailed: _eInternalMessageId.TransmissionFailed;
    FailedToSetStorageBuffer: _eInternalMessageId.FailedToSetStorageBuffer;
    FailedToRestoreStorageBuffer: _eInternalMessageId.FailedToRestoreStorageBuffer;
    InvalidBackendResponse: _eInternalMessageId.InvalidBackendResponse;
    FailedToFixDepricatedValues: _eInternalMessageId.FailedToFixDepricatedValues;
    InvalidDurationValue: _eInternalMessageId.InvalidDurationValue;
    TelemetryEnvelopeInvalid: _eInternalMessageId.TelemetryEnvelopeInvalid;
    CreateEnvelopeError: _eInternalMessageId.CreateEnvelopeError;
    CannotSerializeObject: _eInternalMessageId.CannotSerializeObject;
    CannotSerializeObjectNonSerializable: _eInternalMessageId.CannotSerializeObjectNonSerializable;
    CircularReferenceDetected: _eInternalMessageId.CircularReferenceDetected;
    ClearAuthContextFailed: _eInternalMessageId.ClearAuthContextFailed;
    ExceptionTruncated: _eInternalMessageId.ExceptionTruncated;
    IllegalCharsInName: _eInternalMessageId.IllegalCharsInName;
    ItemNotInArray: _eInternalMessageId.ItemNotInArray;
    MaxAjaxPerPVExceeded: _eInternalMessageId.MaxAjaxPerPVExceeded;
    MessageTruncated: _eInternalMessageId.MessageTruncated;
    NameTooLong: _eInternalMessageId.NameTooLong;
    SampleRateOutOfRange: _eInternalMessageId.SampleRateOutOfRange;
    SetAuthContextFailed: _eInternalMessageId.SetAuthContextFailed;
    SetAuthContextFailedAccountName: _eInternalMessageId.SetAuthContextFailedAccountName;
    StringValueTooLong: _eInternalMessageId.StringValueTooLong;
    StartCalledMoreThanOnce: _eInternalMessageId.StartCalledMoreThanOnce;
    StopCalledWithoutStart: _eInternalMessageId.StopCalledWithoutStart;
    TelemetryInitializerFailed: _eInternalMessageId.TelemetryInitializerFailed;
    TrackArgumentsNotSpecified: _eInternalMessageId.TrackArgumentsNotSpecified;
    UrlTooLong: _eInternalMessageId.UrlTooLong;
    SessionStorageBufferFull: _eInternalMessageId.SessionStorageBufferFull;
    CannotAccessCookie: _eInternalMessageId.CannotAccessCookie;
    IdTooLong: _eInternalMessageId.IdTooLong;
    InvalidEvent: _eInternalMessageId.InvalidEvent;
    FailedMonitorAjaxSetRequestHeader: _eInternalMessageId.FailedMonitorAjaxSetRequestHeader;
    SendBrowserInfoOnUserInit: _eInternalMessageId.SendBrowserInfoOnUserInit;
    PluginException: _eInternalMessageId.PluginException;
    NotificationException: _eInternalMessageId.NotificationException;
    SnippetScriptLoadFailure: _eInternalMessageId.SnippetScriptLoadFailure;
    InvalidInstrumentationKey: _eInternalMessageId.InvalidInstrumentationKey;
    CannotParseAiBlobValue: _eInternalMessageId.CannotParseAiBlobValue;
    TrackPageActionEventFailed: _eInternalMessageId.TrackPageActionEventFailed;
    FailedAddingCustomDefinedRequestContext: _eInternalMessageId.FailedAddingCustomDefinedRequestContext;
    InMemoryStorageBufferFull: _eInternalMessageId.InMemoryStorageBufferFull;
    InstrumentationKeyDeprecation: _eInternalMessageId.InstrumentationKeyDeprecation;
};
export type _ExtendedInternalMessageId = number | _eExtendedInternalMessageId | _eInternalMessageId;
export declare const enum GuidStyle {
    Numeric = "N",
    Digits = "D",
    Braces = "B",
    Parentheses = "P"
}
export declare const enum FieldValueSanitizerType {
    NotSet = 0,
    String = 1,
    Number = 2,
    Boolean = 3,
    Object = 4,
    Array = 4096,
    EventProperty = 8192
}
/**
 * An enumeration that identifies the transport type that are requested to be used, if the requested
 * transport is not available ir supported the SDK may choose the first available transport or it
 * will log a warning to the diagnostic logger.
 */
export declare const enum TransportType {
    /**
     * Use the default available api
     */
    NotSet = 0,
    /**
     * Use XMLHttpRequest or XMLDomainRequest if available
     */
    Xhr = 1,
    /**
     * Use the Fetch api if available
     */
    Fetch = 2,
    /**
     * Use sendBeacon api if available
     */
    Beacon = 3
}
