(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else if(typeof exports === 'object')
		exports["MobxReactFormValidatorYUP"] = factory();
	else
		root["MobxReactFormValidatorYUP"] = factory();
})(self, () => {
return /******/ (() => { // webpackBootstrap
/******/ 	"use strict";
var __webpack_exports__ = {};
// This entry need to be wrapped in an IIFE because it uses a non-standard name for the exports (exports).
(() => {
var exports = __webpack_exports__;
/*!*******************************!*\
  !*** ./src/validators/YUP.ts ***!
  \*******************************/

Object.defineProperty(exports, "__esModule", ({ value: true }));
/**
  YUP - Dead simple Object schema validation

    const plugins = {
      yup: $yup({
        package: yup,
        schema: (y) => (),
        extend,
      }),
    };

*/
class YUP {
    constructor({ config, state = null, promises = [], }) {
        Object.defineProperty(this, "promises", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: []
        });
        Object.defineProperty(this, "config", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: null
        });
        Object.defineProperty(this, "state", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: null
        });
        Object.defineProperty(this, "extend", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: null
        });
        Object.defineProperty(this, "validator", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: null
        });
        Object.defineProperty(this, "schema", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: null
        });
        this.state = state;
        this.promises = promises;
        this.extend = config === null || config === void 0 ? void 0 : config.extend;
        this.validator = config.package;
        this.schema = config.schema(this.validator);
        this.extendValidator();
    }
    extendValidator() {
        // extend using "extend" callback
        if (typeof this.extend === 'function') {
            this.extend({
                validator: this.validator,
                form: this.state.form,
            });
        }
    }
    validate(field) {
        const $p = new Promise((resolve) => this.validator
            .reach(this.schema, field.path)
            .label(field.label)
            .validate(field.validatedValue, { strict: true })
            .then(() => this.handleAsyncPasses(field, resolve))
            .catch((error) => this.handleAsyncFails(field, resolve, error)));
        this.promises.push($p);
    }
    handleAsyncPasses(field, resolve) {
        field.setValidationAsyncData(true);
        resolve();
    }
    handleAsyncFails(field, resolve, error) {
        field.setValidationAsyncData(false, error.errors[0]);
        this.executeAsyncValidation(field);
        resolve();
    }
    executeAsyncValidation(field) {
        if (field.validationAsyncData.valid === false) {
            field.invalidate(field.validationAsyncData.message, false, true);
        }
    }
}
exports["default"] = (config) => ({
    class: YUP,
    config,
});

})();

/******/ 	return __webpack_exports__;
/******/ })()
;
});
//# sourceMappingURL=MobxReactFormValidatorYUP.umd.js.map