var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { toJS, observable, action, createAtom } from 'mobx';
import localStorage from 'reactive-localstorage';
export class LocalStorage {
    constructor() {
        this[Symbol.toStringTag] = 'Map';
        this._keyBoxes = new Map();
        this._valueBoxes = new Map();
        this._keys = new Set();
        this._keysAtom = createAtom('mobx storage keys');
        this._is_all_keys_observed = false;
        localStorage.on('change', action((key, value) => {
            if (typeof key === 'string') {
                if (typeof value === 'string') {
                    this._set(key, value);
                }
                else {
                    this._delete(key);
                }
            }
            else {
                this._clear();
            }
        }));
    }
    get length() {
        return this.size;
    }
    get size() {
        this._keysAtom.reportObserved();
        this._syncAllKeys();
        return this._keys.size;
    }
    key(index) {
        return localStorage.key(index);
    }
    getItem(key) {
        return this.get(key);
    }
    setItem(key, value) {
        this.set(key, value);
    }
    removeItem(key) {
        this.delete(key);
    }
    has(key) {
        return this._get_key_box(key).get();
    }
    get(key) {
        return this._get_value_box(key).get();
    }
    set(key, value) {
        localStorage.setItem(key, JSON.stringify(toJS(value)));
        return this;
    }
    delete(key) {
        const has = (this._is_all_keys_observed
            ? this._keys.has(key)
            : typeof localStorage.getItem(key) === 'string');
        localStorage.removeItem(key);
        return has;
    }
    clear() {
        localStorage.clear();
    }
    keys() {
        this._keysAtom.reportObserved();
        this._syncAllKeys();
        return this._keys.values();
    }
    *values() {
        for (const key of this.keys()) {
            yield this._get_value_box(key).get();
        }
    }
    *entries() {
        for (const key of this.keys()) {
            yield [key, this._get_value_box(key).get()];
        }
    }
    [Symbol.iterator]() {
        return this.entries();
    }
    forEach(callbackfn, thisArg) {
        this._keysAtom.reportChanged();
        this._syncAllKeys();
        for (const [key, value] of this.entries()) {
            callbackfn.call(thisArg, value, key, this);
        }
    }
    _set(key, value) {
        this._keysAtom.reportChanged();
        this._keys.add(key);
        const keyBox = this._keyBoxes.get(key);
        if (keyBox) {
            keyBox.set(true);
        }
        const valueBox = this._valueBoxes.get(key);
        if (valueBox) {
            valueBox.set(parseValue(value));
        }
    }
    _delete(key) {
        this._keysAtom.reportChanged();
        this._keys.delete(key);
        const keyBox = this._keyBoxes.get(key);
        if (keyBox) {
            keyBox.set(false);
        }
        const valueBox = this._valueBoxes.get(key);
        if (valueBox) {
            valueBox.set(null);
        }
    }
    _clear() {
        this._keysAtom.reportChanged();
        this._keys.clear();
        for (const box of this._keyBoxes.values()) {
            box.set(false);
        }
        for (const box of this._valueBoxes.values()) {
            box.set(null);
        }
    }
    _get_key_box(key) {
        const boxes = this._keyBoxes;
        let box = boxes.get(key);
        if (!box) {
            const value = (this._is_all_keys_observed
                ? false
                : typeof localStorage.getItem(key) === 'string');
            boxes.set(key, box = observable.box(value));
        }
        return box;
    }
    _get_value_box(key) {
        const boxes = this._valueBoxes;
        let box = boxes.get(key);
        if (!box) {
            const value = this._is_all_keys_observed ? null : localStorage.getItem(key);
            boxes.set(key, box = observable.box(parseValue(value)));
        }
        return box;
    }
    _syncAllKeys() {
        if (this._is_all_keys_observed)
            return;
        this._is_all_keys_observed = true;
        const len = localStorage.length;
        const boxes = this._keyBoxes;
        const keys = this._keys;
        keys.clear();
        for (let i = 0; i < len; i++) {
            const key = localStorage.key(i);
            if (typeof key !== 'string')
                continue;
            keys.add(key);
            if (boxes.has(key))
                continue;
            boxes.set(key, observable.box(true));
        }
    }
}
__decorate([
    action,
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Object]),
    __metadata("design:returntype", void 0)
], LocalStorage.prototype, "set", null);
__decorate([
    action,
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], LocalStorage.prototype, "delete", null);
__decorate([
    action,
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], LocalStorage.prototype, "clear", null);
export function parseValue(value) {
    try {
        return JSON.parse(value);
    }
    catch (e) {
        // ignore if cannot parse as JSON
    }
    return value;
}
export default new LocalStorage();
//# sourceMappingURL=data:application/json;base64,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