"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const mobx_1 = require("mobx");
const lodash_1 = __importDefault(require("lodash"));
const utils_1 = require("./utils");
class Options {
    constructor() {
        Object.defineProperty(this, "options", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: {
                uniqueId: utils_1.uniqueId,
                fallback: true,
                fallbackValue: "",
                defaultGenericError: null,
                submitThrowsError: true,
                showErrorsOnInit: false,
                showErrorsOnSubmit: true,
                showErrorsOnBlur: true,
                showErrorsOnChange: true,
                showErrorsOnClear: false,
                showErrorsOnReset: true,
                validateOnInit: true,
                validateOnSubmit: true,
                validateOnBlur: true,
                validateOnChange: false,
                validateOnChangeAfterInitialBlur: false,
                validateOnChangeAfterSubmit: false,
                validateOnClear: false,
                validateOnReset: false,
                validateDisabledFields: false,
                validateDeletedFields: false,
                validatePristineFields: true,
                strictSet: false,
                strictUpdate: false,
                strictDelete: true,
                strictSelect: true,
                softDelete: false,
                retrieveOnlyDirtyFieldsValues: false,
                retrieveOnlyEnabledFieldsValues: false,
                retrieveOnlyEnabledFieldsErrors: false,
                retrieveNullifiedEmptyStrings: false,
                autoTrimValue: false,
                autoParseNumbers: false,
                removeNullishValuesInArrays: false,
                preserveDeletedFieldsValues: false,
                validationDebounceWait: 250,
                validationDebounceOptions: {
                    leading: false,
                    trailing: true,
                },
                stopValidationOnError: false,
                validationPluginsOrder: undefined,
                resetValidationBeforeValidate: true,
                validateTrimmedValue: false,
                applyInputConverterOnInit: true,
                applyInputConverterOnSet: true,
                applyInputConverterOnUpdate: true,
            }
        });
        (0, mobx_1.makeObservable)(this, {
            options: mobx_1.observable,
            set: mobx_1.action,
        });
    }
    get(key, field = null) {
        // handle field option
        if (lodash_1.default.has(field, "path")) {
            if (lodash_1.default.has(field.$options, key)) {
                return field.$options[key];
            }
        }
        // fallback on global form options
        if (key)
            return lodash_1.default.get(this.options, key);
        return (0, mobx_1.toJS)(this.options);
    }
    set(options) {
        if (mobx_1.set) {
            (0, mobx_1.set)(this.options, options);
        }
        else {
            (0, mobx_1.extendObservable)(this.options, options);
        }
    }
}
exports.default = Options;
//# sourceMappingURL=Options.js.map