"use strict";var y=Object.create;var c=Object.defineProperty;var T=Object.getOwnPropertyDescriptor;var L=Object.getOwnPropertyNames;var U=Object.getPrototypeOf;var b=Object.prototype.hasOwnProperty;var _=(r,e)=>c(r,"name",{value:e,configurable:true});var S=(r,e)=>{for(var t in e)c(r,t,{get:e[t],enumerable:true})};var E=(r,e,t,n)=>{if(e&&typeof e==="object"||typeof e==="function"){for(let a of L(e))if(!b.call(r,a)&&a!==t)c(r,a,{get:()=>e[a],enumerable:!(n=T(e,a))||n.enumerable})}return r};var d=(r,e,t)=>(t=r!=null?y(U(r)):{},E(e||!r||!r.__esModule?c(t,"default",{value:r,enumerable:true}):t,r));var A=r=>E(c({},"__esModule",{value:true}),r);var o=(r,e,t,n)=>{var a=n>1?void 0:n?T(e,t):e;for(var u=r.length-1,h;u>=0;u--)if(h=r[u])a=(n?h(e,t,a):h(a))||a;if(n&&a)c(e,t,a);return a};var P={};S(P,{default:()=>i});module.exports=A(P);var f=require("electron");var m=d(require("jsonwebtoken"));var s=require("mobx");var l=d(require("mobx-localstorage"));var g=d(require("moment"));var O=require("../config");var v=require("../environment-remote");var R=d(require("./lib/CachedRequest"));var p=d(require("./lib/Request"));var I=d(require("./lib/TypedStore"));const x=require("../preload-safe-debug")("Ferdium:UserStore");class i extends I.default{BASE_ROUTE="/auth";WELCOME_ROUTE=`${this.BASE_ROUTE}/welcome`;LOGIN_ROUTE=`${this.BASE_ROUTE}/login`;LOGOUT_ROUTE=`${this.BASE_ROUTE}/logout`;SIGNUP_ROUTE=`${this.BASE_ROUTE}/signup`;SETUP_ROUTE=`${this.BASE_ROUTE}/signup/setup`;IMPORT_ROUTE=`${this.BASE_ROUTE}/signup/import`;INVITE_ROUTE=`${this.BASE_ROUTE}/signup/invite`;PASSWORD_ROUTE=`${this.BASE_ROUTE}/password`;CHANGE_SERVER_ROUTE=`${this.BASE_ROUTE}/server`;loginRequest=new p.default(this.api.user,"login");signupRequest=new p.default(this.api.user,"signup");passwordRequest=new p.default(this.api.user,"password");inviteRequest=new p.default(this.api.user,"invite");getUserInfoRequest=new R.default(this.api.user,"getInfo");requestNewTokenRequest=new R.default(this.api.user,"requestNewToken");updateUserInfoRequest=new p.default(this.api.user,"updateInfo");deleteAccountRequest=new R.default(this.api.user,"delete");isImportLegacyServicesExecuting=false;isImportLegacyServicesCompleted=false;isLoggingOut=false;id;authToken=l.default.getItem("authToken")||null;accountType;hasCompletedSignup=false;userData={};logoutReasonTypes={SERVER:"SERVER"};logoutReason=null;constructor(e,t,n){super(e,t,n);(0,s.makeObservable)(this);this.actions.user.login.listen(this._login.bind(this));this.actions.user.retrievePassword.listen(this._retrievePassword.bind(this));this.actions.user.logout.listen(this._logout.bind(this));this.actions.user.signup.listen(this._signup.bind(this));this.actions.user.invite.listen(this._invite.bind(this));this.actions.user.update.listen(this._update.bind(this));this.actions.user.resetStatus.listen(this._resetStatus.bind(this));this.actions.user.importLegacyServices.listen(this._importLegacyServices.bind(this));this.actions.user.delete.listen(this._delete.bind(this));this.registerReactions([this._requireAuthenticatedUser.bind(this),this._getUserData.bind(this)])}setup(){this._migrateUserLocale()}get loginRoute(){return this.LOGIN_ROUTE}get signupRoute(){return this.SIGNUP_ROUTE}get passwordRoute(){return this.PASSWORD_ROUTE}get changeServerRoute(){return this.CHANGE_SERVER_ROUTE}get isLoggedIn(){return Boolean(l.default.getItem("authToken"))}get isTokenExpired(){if(!this.authToken)return false;const e=this._parseToken(this.authToken);return e!==false&&this.authToken!==null&&(0,g.default)(e.tokenExpiry).isBefore((0,g.default)())}get data(){if(!this.isLoggedIn)return{};const e=this._shouldRequestNewToken(this.authToken);if(e){this._requestNewToken()}return this.getUserInfoRequest.execute().result||{}}get team(){return this.data.team||null}async _login({email:e,password:t}){const n=await this.loginRequest.execute(e,t).promise;this._setUserData(n);this.stores.router.push("/")}_tokenLogin(e){this._setUserData(e);this.stores.router.push("/")}async _signup({firstname:e,lastname:t,email:n,password:a,accountType:u,company:h,plan:k,currency:q}){const w=await this.signupRequest.execute({firstname:e,lastname:t,email:n,password:a,accountType:u,company:h,locale:this.stores.app.locale,plan:k,currency:q});this.hasCompletedSignup=true;this._setUserData(w);this.stores.router.push(this.SETUP_ROUTE)}async _retrievePassword({email:e}){const t=this.passwordRequest.execute(e);await t.promise;this.actionStatus=t.result.status||[]}async _invite({invites:e}){const t=e.filter(a=>a.email!=="");const n=await this.inviteRequest.execute(t).promise;this.actionStatus=n.status||[];if(this.stores.router.location.pathname.includes(this.INVITE_ROUTE)){this.stores.router.push("/")}}async _update({userData:e}){if(!this.isLoggedIn)return;const t=await this.updateUserInfoRequest.execute(e).promise;this.getUserInfoRequest.patch(()=>t.data);this.actionStatus=t.status||[]}_resetStatus(){this.actionStatus=[]}_logout(){l.default.removeItem("authToken");window.localStorage.removeItem("authToken");this.getUserInfoRequest.invalidate().reset();this.authToken=null;this.stores.services.allServicesRequest.invalidate().reset();if(this.stores.todos.isTodosEnabled){f.ipcRenderer.send("clear-storage-data",{sessionId:O.TODOS_PARTITION_ID})}}async _importLegacyServices({services:e}){this.isImportLegacyServicesExecuting=true;const t=e.filter((n,a,u)=>u.map(h=>h.recipe.id).indexOf(n.recipe.id)===a).map(n=>n.recipe.id);for(const n of t){await this.stores.recipes._install({recipeId:n})}for(const n of e){this.actions.service.createFromLegacyService({data:n});await this.stores.services.createServiceRequest.promise}this.isImportLegacyServicesExecuting=false;this.isImportLegacyServicesCompleted=true}async _delete(){this.deleteAccountRequest.execute()}_requireAuthenticatedUser=()=>{if(this.isTokenExpired){this._logout()}const{router:e}=this.stores;const t=window.location.hash;if(!this.isLoggedIn&&t.includes("token=")){e.push(this.WELCOME_ROUTE);const n=t.split("=")[1];const a=this._parseToken(n);if(a){setTimeout(()=>{this._tokenLogin(n)},1e3)}}else if(!this.isLoggedIn&&!t.includes(this.BASE_ROUTE)){e.push(this.WELCOME_ROUTE)}else if(this.isLoggedIn&&t===this.LOGOUT_ROUTE){this.actions.user.logout();e.push(this.LOGIN_ROUTE)}else if(this.isLoggedIn&&t.includes(this.BASE_ROUTE)&&(this.hasCompletedSignup||this.hasCompletedSignup===null)&&!v.isDevMode){this.stores.router.push("/")}};async _getUserData(){if(this.isLoggedIn){let e;try{e=await this.getUserInfoRequest.execute().promise}catch{return}this.actions.settings.update({type:"app",data:{beta:e.beta,locale:e.locale}})}}_shouldRequestNewToken(e){try{const t=m.default.decode(e);if(!t){throw new Error("Invalid token")}if(t.uid){return true}return false}catch{return true}}_requestNewToken(){const e=this.requestNewTokenRequest.execute().result;if(e){this.authToken=e.token;l.default.setItem("authToken",e.token)}}_parseToken(e){try{const t=m.default.decode(e);return{id:t.userId,tokenExpiry:g.default.unix(t.exp).toISOString(),authToken:e}}catch{this._logout();return false}}_setUserData(e){const t=this._parseToken(e);if(t!==false&&t.authToken){l.default.setItem("authToken",t.authToken);this.authToken=t.authToken;this.id=t.id}else{this.authToken=null;this.id=null}}getAuthURL(e){const t=new URL(e);const n=new URLSearchParams(t.search.slice(1));n.append("authToken",this.authToken);return`${t.origin}${t.pathname}?${n.toString()}`}async _migrateUserLocale(){try{await this.getUserInfoRequest.promise}catch{return}if(!this.data.locale){x('Migrate "locale" to user data');this.actions.user.update({userData:{locale:this.stores.app.locale}})}}}_(i,"UserStore");o([s.observable],i.prototype,"loginRequest",2);o([s.observable],i.prototype,"signupRequest",2);o([s.observable],i.prototype,"passwordRequest",2);o([s.observable],i.prototype,"inviteRequest",2);o([s.observable],i.prototype,"getUserInfoRequest",2);o([s.observable],i.prototype,"requestNewTokenRequest",2);o([s.observable],i.prototype,"updateUserInfoRequest",2);o([s.observable],i.prototype,"deleteAccountRequest",2);o([s.observable],i.prototype,"isImportLegacyServicesExecuting",2);o([s.observable],i.prototype,"isImportLegacyServicesCompleted",2);o([s.observable],i.prototype,"isLoggingOut",2);o([s.observable],i.prototype,"id",2);o([s.observable],i.prototype,"authToken",2);o([s.observable],i.prototype,"accountType",2);o([s.observable],i.prototype,"hasCompletedSignup",2);o([s.observable],i.prototype,"userData",2);o([s.observable],i.prototype,"logoutReason",2);o([s.computed],i.prototype,"isLoggedIn",1);o([s.computed],i.prototype,"isTokenExpired",1);o([s.computed],i.prototype,"data",1);o([s.computed],i.prototype,"team",1);o([s.action],i.prototype,"_login",1);o([s.action],i.prototype,"_tokenLogin",1);o([s.action],i.prototype,"_signup",1);o([s.action],i.prototype,"_retrievePassword",1);o([s.action],i.prototype,"_invite",1);o([s.action],i.prototype,"_update",1);o([s.action],i.prototype,"_resetStatus",1);o([s.action],i.prototype,"_logout",1);o([s.action],i.prototype,"_importLegacyServices",1);o([s.action],i.prototype,"_delete",1);
