import { getModuleFromFilename as getModuleFromFilename$1 } from '@sentry/node';
import { createStackParser, nodeStackLineParser } from '@sentry/utils';
import { app } from 'electron';
import { normalizeUrl } from '../common/normalize.js';

/** Parses the module name form a filename */
function getModuleFromFilename(filename) {
    if (!filename) {
        return;
    }
    const normalizedFilename = normalizeUrl(filename, app.getAppPath());
    return getModuleFromFilename$1(normalizedFilename);
}
// node.js stack parser but filename normalized before parsing the module
const defaultStackParser = createStackParser(nodeStackLineParser(getModuleFromFilename));

export { defaultStackParser };
//# sourceMappingURL=stack-parse.js.map
