(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports) :
  typeof define === 'function' && define.amd ? define(['exports'], factory) :
  (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.jssPluginCompose = {}));
}(this, (function (exports) { 'use strict';

  function warning(condition, message) {
    {
      if (condition) {
        return;
      }

      var text = "Warning: " + message;

      if (typeof console !== 'undefined') {
        console.warn(text);
      }

      try {
        throw Error(text);
      } catch (x) {}
    }
  }

  /**
   * Set selector.
   *
   * @param original rule
   * @param className class string
   * @return flag indicating function was successfull or not
   */

  function registerClass(rule, className) {
    // Skip falsy values
    if (!className) return true; // Support array of class names `{composes: ['foo', 'bar']}`

    if (Array.isArray(className)) {
      for (var index = 0; index < className.length; index++) {
        var isSetted = registerClass(rule, className[index]);
        if (!isSetted) return false;
      }

      return true;
    } // Support space separated class names `{composes: 'foo bar'}`


    if (className.indexOf(' ') > -1) {
      return registerClass(rule, className.split(' '));
    }

    var parent = rule.options.parent; // It is a ref to a local rule.

    if (className[0] === '$') {
      var refRule = parent.getRule(className.substr(1));

      if (!refRule) {
         warning(false, "[JSS] Referenced rule is not defined. \n" + rule.toString()) ;
        return false;
      }

      if (refRule === rule) {
         warning(false, "[JSS] Cyclic composition detected. \n" + rule.toString()) ;
        return false;
      }

      parent.classes[rule.key] += " " + parent.classes[refRule.key];
      return true;
    }

    parent.classes[rule.key] += " " + className;
    return true;
  }
  /**
   * Convert compose property to additional class, remove property from original styles.
   */


  function jssCompose() {
    function onProcessStyle(style, rule) {
      if (!('composes' in style)) return style;
      registerClass(rule, style.composes); // Remove composes property to prevent infinite loop.

      delete style.composes;
      return style;
    }

    return {
      onProcessStyle: onProcessStyle
    };
  }

  exports.default = jssCompose;

  Object.defineProperty(exports, '__esModule', { value: true });

})));
//# sourceMappingURL=jss-plugin-compose.js.map
