(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory(require("_"));
	else if(typeof define === 'function' && define.amd)
		define(["_"], factory);
	else if(typeof exports === 'object')
		exports["MobxReactFormValidatorVJF"] = factory(require("_"));
	else
		root["MobxReactFormValidatorVJF"] = factory(root["_"]);
})(self, (__WEBPACK_EXTERNAL_MODULE_lodash__) => {
return /******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./src/validators/VJF.ts":
/*!*******************************!*\
  !*** ./src/validators/VJF.ts ***!
  \*******************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.VJF = void 0;
const lodash_1 = __importDefault(__webpack_require__(/*! lodash */ "lodash"));
const isPromise = (obj) => !!obj &&
    typeof obj.then === "function" &&
    (typeof obj === "object" || typeof obj === "function");
/**
  Vanilla JavaScript Functions

    const plugins = {
      vkf: vkf({
        package: validator,
      }),
    };

*/
class VJF {
    constructor({ config, state = null, promises = [], }) {
        Object.defineProperty(this, "promises", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: []
        });
        Object.defineProperty(this, "config", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: null
        });
        Object.defineProperty(this, "state", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: null
        });
        Object.defineProperty(this, "extend", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: null
        });
        Object.defineProperty(this, "validator", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: null
        });
        this.state = state;
        this.promises = promises;
        this.extend = config === null || config === void 0 ? void 0 : config.extend;
        this.validator = config === null || config === void 0 ? void 0 : config.package;
        this.extendValidator();
    }
    extendValidator() {
        // extend using "extend" callback
        if (typeof this.extend === 'function') {
            this.extend({
                validator: this.validator,
                form: this.state.form,
            });
        }
    }
    validate(field) {
        // exit if field does not have validation functions
        if (!field.validators)
            return;
        // get validators from validate property
        const $fn = field.validators;
        // map only if is an array of validator functions
        if (Array.isArray($fn)) {
            $fn.map((fn) => this.collectData(fn, field));
        }
        // it's just one function // DEPRECATED
        // if (typeof $fn === 'function') {
        //   this.collectData($fn, field);
        // }
        // execute the validation function
        this.executeValidation(field);
    }
    collectData($fn, field) {
        const res = this.handleFunctionResult($fn, field);
        // check and execute only if is a promise
        if (isPromise(res)) {
            const $p = res
                .then(($res) => field.setValidationAsyncData($res[0], $res[1]))
                .then(() => this.executeAsyncValidation(field));
            // push the promise into array
            this.promises.push($p);
            return;
        }
        // is a plain function
        field.validationFunctionsData.unshift({
            valid: res[0],
            message: res[1],
        });
    }
    executeValidation(field) {
        // otherwise find an error message to show
        field.validationFunctionsData.map((rule) => rule.valid === false && field.invalidate(rule.message, false));
    }
    executeAsyncValidation(field) {
        if (field.validationAsyncData.valid === false) {
            field.invalidate(field.validationAsyncData.message, false, true);
        }
    }
    handleFunctionResult($fn, field) {
        // executre validation function
        const res = $fn({
            validator: this.validator,
            form: this.state.form,
            field,
        });
        /**
          Handle "array"
        */
        if (Array.isArray(res)) {
            const isValid = res[0] || false;
            const message = res[1] || "Error";
            return [isValid, message];
        }
        /**
          Handle "boolean"
        */
        if (lodash_1.default.isBoolean(res)) {
            return [res, "Error"];
        }
        /**
          Handle "string"
        */
        if (lodash_1.default.isString(res)) {
            return [false, res];
        }
        /**
          Handle "object / promise"
        */
        if (isPromise(res)) {
            return res; // the promise
        }
        /**
          Handle other cases
        */
        return [false, "Error"];
    }
}
exports.VJF = VJF;
exports["default"] = (config) => ({
    class: VJF,
    config,
});


/***/ }),

/***/ "lodash":
/*!********************!*\
  !*** external "_" ***!
  \********************/
/***/ ((module) => {

module.exports = __WEBPACK_EXTERNAL_MODULE_lodash__;

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module is referenced by other modules so it can't be inlined
/******/ 	var __webpack_exports__ = __webpack_require__("./src/validators/VJF.ts");
/******/ 	
/******/ 	return __webpack_exports__;
/******/ })()
;
});
//# sourceMappingURL=MobxReactFormValidatorVJF.umd.js.map