(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define("UAGenerator", [], factory);
	else if(typeof exports === 'object')
		exports["UAGenerator"] = factory();
	else
		root["UAGenerator"] = factory();
})(this, function() {
return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, {
/******/ 				configurable: false,
/******/ 				enumerable: true,
/******/ 				get: getter
/******/ 			});
/******/ 		}
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 2);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


module.exports = {
  WINDOWS_10: 'Windows NT 6.4',
  WINDOWS_8_1: 'Windows NT 6.3',
  WINDOWS_8: 'Windows NT 6.2',
  WINDOWS_8_RT: 'Windows NT 6.2; ARM;',
  WINDOWS_7: 'Windows NT 6.1',

  LINUX: 'Linux',
  UBUNTU: 'X11; Ubuntu;',

  MAC_OSX_10_12: 'Macintosh; Intel Mac OS X 10_12',
  MAC_OSX_10_11: 'Macintosh; Intel Mac OS X 10_11',

  CHROME_OS: 'X11; CrOS x86_64'
};

/***/ }),
/* 1 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


// List of popular devices
module.exports = {
  // mobile
  SAMSUNG_S6_EDGE: 'SM-G925F',
  MICROSOFT_LUMIA_950: 'Lumia 950',
  NEXUS_6: 'Nexus 6',
  PIXEL: 'Pixel',
  XIOMI_REDMI_NOTE_4: 'HM NOTE 1LTE',
  MOTO_G_4: 'Moto G (4)',
  LUMIA_630: 'Lumia 630',

  // Tablet
  KINDLE_FIRE: 'KFTHWI',
  PIXEL_C: 'Pixel C',
  SAMSUNG_TAB_3: 'SM-T210',

  // Apple
  IPOD_TOUCH: 'iPod touch',
  IPHONE: 'iPhone',
  IPAD: 'iPad'
};

/***/ }),
/* 2 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var semver = __webpack_require__(3);
var closestSemver = __webpack_require__(4);
var normalize = __webpack_require__(5);
var OS = __webpack_require__(0);
var DEVICE = __webpack_require__(1);
var tridentVersionMap = __webpack_require__(6);
var chromeWebkitVersionMap = __webpack_require__(7);
var safariWebkitVersionMap = __webpack_require__(8);
var androidWebkitVersions = __webpack_require__(9);

var ANDROID_FLAVOURS = {
  KITKAT: '4.4.0',
  MARSHMELLOW: '6.0.0'
};

var windowsPhoneIEVersionMap = {
  '9.0': 7.0,
  '10.0': 8.0,
  '11.0': 8.1
};

function closestSemverValue(semverString, semverStringMap) {
  var normalSemver = normalize(semverString);
  var normalSemverMap = {};

  Object.keys(semverStringMap).forEach(function (key) {
    normalSemverMap[normalize(key)] = normalize(semverStringMap[key]);
  });
  var normalSemverArray = Object.keys(normalSemverMap);

  var closestKey = closestSemver(normalSemver, normalSemverArray);
  return normalSemverMap[closestKey];
}

var Defaults = {
  ANDROID_VERSION: '7.0.0',
  ANDROID_BUILD_VERSION: 'Unknown',
  ANDROID_PHONE: DEVICE.PIXEL,
  ANDROID_TABLET: DEVICE.PIXEL_C,
  DESKTOP_OS: OS.WINDOWS_10,
  WEBVIEW_CHROME_VERSION: '60.0.0.0',
  IOS_DEVICE: DEVICE.IPHONE,
  IOS_WEBKIT_VERSION: '603.1.30',
  IOS_CHROME_VERSION: '60.0.0.0',
  GOOGLE_BOT_VERSION: '2.1',
  BING_BOT_VERSION: '2.0',
  GECKO_VERSION: '20140303',
  WINDOW_PHONE: DEVICE.LUMIA_630,
  WINDOWS_BUILD_VERSION: '10122',
  EDGE_CHROME_VERSION: '52.0.0.0',
  MAC_OS: OS.MAC_OSX_10_12

  /********************
   *  Google Chrome   *
   /*******************/

};function chrome(opt) {
  var version = normalize(typeof opt === 'number' || typeof opt === 'string' ? opt : opt.version, 4);
  var os = opt.os || Defaults.DESKTOP_OS;
  var webkitVersion = closestSemverValue(version, chromeWebkitVersionMap);

  return 'Mozilla/5.0 (' + os + ') AppleWebKit/' + webkitVersion + ' (KHTML, like Gecko) Chrome/' + version + ' Safari/' + webkitVersion;
}

chrome.androidPhone = function (opt) {
  var version = normalize(typeof opt === 'number' || typeof opt === 'string' ? opt : opt.version, 4);
  var webkitVersion = closestSemverValue(version, chromeWebkitVersionMap);
  var buildVersion = opt.buildVersion || Defaults.ANDROID_BUILD_VERSION;
  var androidVersion = opt.androidVersion || Defaults.ANDROID_VERSION;
  var device = opt.device || Defaults.ANDROID_PHONE;

  return 'Mozilla/5.0 (Linux; Android ' + androidVersion + '; ' + device + ' Build/' + buildVersion + ';) AppleWebKit/' + webkitVersion + ' (KHTML, like Gecko) Chrome/' + version + ' Mobile Safari/' + webkitVersion;
};

chrome.androidTablet = function (opt) {
  var version = normalize(typeof opt === 'number' || typeof opt === 'string' ? opt : opt.version, 4);
  var webkitVersion = closestSemverValue(version, chromeWebkitVersionMap);
  var buildVersion = opt.buildVersion || Defaults.ANDROID_BUILD_VERSION;
  var androidVersion = opt.androidVersion || Defaults.ANDROID_VERSION;
  var device = opt.device || Defaults.ANDROID_TABLET;

  return 'Mozilla/5.0 (Linux; Android ' + androidVersion + '; ' + device + ' Build/' + buildVersion + ') AppleWebKit/' + webkitVersion + ' (KHTML, like Gecko) Chrome/' + version + ' Safari/' + webkitVersion;
};

chrome.androidWebview = function (opt) {
  var androidVersion = normalize(typeof opt === 'number' || typeof opt === 'string' ? opt : opt.androidVersion);
  var chromeVersion = normalize(opt.chromeVersion || Defaults.WEBVIEW_CHROME_VERSION, 4);
  var webkitVersion = closestSemverValue(androidVersion, androidWebkitVersions);
  var buildVersion = opt.buildVersion || Defaults.ANDROID_BUILD_VERSION;
  var device = opt.device || Defaults.ANDROID_PHONE;

  if (semver.lt(androidVersion, ANDROID_FLAVOURS.KITKAT)) {
    return 'Mozilla/5.0 (Linux; U; Android ' + androidVersion + '; ' + device + ' Build/' + buildVersion + ';) AppleWebKit/' + webkitVersion + ' (KHTML, like Gecko) Version/4.0 Safari/' + webkitVersion;
  } else if (semver.gte(androidVersion, ANDROID_FLAVOURS.KITKAT) && semver.lt(androidVersion, ANDROID_FLAVOURS.MARSHMELLOW)) {
    return 'Mozilla/5.0 (Linux; Android ' + androidVersion + '; ' + device + ' Build/' + buildVersion + ';) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/' + chromeVersion + ' Mobile Safari/537.36';
  } else {
    return 'Mozilla/5.0 (Linux; Android ' + androidVersion + '; ' + device + ' Build/' + buildVersion + '; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/' + chromeVersion + ' Mobile Safari/537.36';
  }
};

chrome.chromecast = function (opt) {
  var version = normalize(typeof opt === 'number' || typeof opt === 'string' ? opt : opt.version, 4);

  return 'Mozilla/5.0 (X11; Linux armv7l) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/' + version + ' Safari/537.36 CrKey/1.22.79313"';
};

chrome.iOS = function (opt) {
  var iOSVersion = normalize(typeof opt === 'number' || typeof opt === 'string' ? opt : opt.iOSVersion);
  var webkitVersion = closestSemverValue(iOSVersion, safariWebkitVersionMap);
  var chromeVersion = normalize(opt.chromeVersion || Defaults.IOS_CHROME_VERSION, 4);
  var device = opt.device || Defaults.IOS_DEVICE;
  return 'Mozilla/5.0 (' + device + '; CPU iPhone OS ' + iOSVersion.replace(/\./g, '_') + ' like Mac OS X) AppleWebKit/' + webkitVersion + ' (KHTML, like Gecko) CriOS/' + chromeVersion + ' Mobile/14E5239e Safari/602.1';
};

function chromium(opt) {
  return chrome(opt).replace(/Chrome/g, 'Chromium');
}

/***************
 *   Firefox   *
 /*************/

// @see https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/User-Agent/Firefox

function firefox(opt) {
  var version = normalize(typeof opt === 'number' || typeof opt === 'string' ? opt : opt.version);

  var os = opt.os || Defaults.DESKTOP_OS;
  var geckoVersion = geckoVersion || Defaults.GECKO_VERSION;
  return semver.lt(version, '30.0.0') ? 'Mozilla/5.0 (' + os + '; rv:' + version + ') Gecko/' + (geckoVersion || '20140303') + ' Firefox/' + version : 'Mozilla/5.0 (' + os + '; rv:' + version + ') Gecko/20100101 Firefox/' + version;
}

firefox.androidPhone = function (opt) {
  var version = normalize(typeof opt === 'number' || typeof opt === 'string' ? opt : opt.version);
  var buildVersion = opt.buildVersion || Defaults.ANDROID_BUILD_VERSION;
  var androidVersion = opt.androidVersion || Defaults.ANDROID_VERSION;

  if (semver.lt(version, '41.0.0')) {
    return 'Mozilla/5.0 (Android; Build/' + buildVersion + '; Mobile; rv:' + version + ') Gecko/' + version + ' Firefox/' + version;
  } else {
    return 'Mozilla/5.0 (Android ' + androidVersion + '; Build/' + buildVersion + '; Mobile; rv:' + version + ') Gecko/' + version + ' Firefox/' + version;
  }
};

firefox.androidTablet = function (opt) {
  var version = normalize(typeof opt === 'number' || typeof opt === 'string' ? opt : opt.version);
  var buildVersion = opt.buildVersion || Defaults.ANDROID_BUILD_VERSION;
  var androidVersion = opt.androidVersion || Defaults.ANDROID_VERSION;

  if (semver.lt(version, '41.0.0')) {
    return 'Mozilla/5.0 (Android; Build/' + buildVersion + '; Tablet; rv:' + version + ') Gecko/' + version + ' Firefox/' + version;
  } else {
    return 'Mozilla/5.0 (Android ' + androidVersion + '; Build/' + buildVersion + '; Tablet; rv:' + version + ') Gecko/' + version + ' Firefox/' + version;
  }
};

firefox.iOS = function (opt) {
  var iOSVersion = normalize(typeof opt === 'number' || typeof opt === 'string' ? opt : opt.iOSVersion);
  var device = opt.device || Defaults.IOS_DEVICE;
  return 'Mozilla/5.0 (' + device + '; CPU iPhone OS ' + iOSVersion.replace(/\./g, '_') + ' like Mac OS X) AppleWebKit/600.1.4 (KHTML, like Gecko) FxiOS/1.0 Mobile/12F69 Safari/600.1.4';
};

/**************
 *   Safari   *
 /************/

function safari(opt) {
  var version = normalize(typeof opt === 'number' || typeof opt === 'string' ? opt : opt.version);
  var webkitVersion = closestSemverValue(version, safariWebkitVersionMap);
  var os = opt.os || Defaults.MAC_OS;

  return 'Mozilla/5.0 (' + os + ') AppleWebKit/' + webkitVersion + ' (KHTML, like Gecko) Version/' + version + ' Safari/' + webkitVersion;
}

safari.iOS = function (opt) {
  var iOSVersion = normalize(typeof opt === 'number' || typeof opt === 'string' ? opt : opt.iOSVersion);
  var safariVersion = normalize(opt.safariVersion || iOSVersion);
  var webkitVersion = closestSemverValue(safariVersion, safariWebkitVersionMap);
  var device = opt.device || Defaults.IOS_DEVICE;

  return 'Mozilla/5.0 (' + device + '; CPU iPhone OS ' + iOSVersion.replace(/\./g, '_') + ' like Mac OS X) AppleWebKit/' + webkitVersion + ' (KHTML, like Gecko) Version/' + safariVersion + ' Mobile/14A403 Safari/' + webkitVersion;
};

safari.iOSWebview = function (opt) {
  var iOSVersion = normalize(typeof opt === 'number' || typeof opt === 'string' ? opt : opt.iOSVersion);
  var safariVersion = normalize(opt.safariVersion || iOSVersion);
  var webkitVersion = closestSemverValue(safariVersion, safariWebkitVersionMap);
  var device = opt.device || Defaults.IOS_DEVICE;

  return 'Mozilla/5.0 (' + device + '; CPU iPhone OS ' + iOSVersion.replace(/\./g, '_') + ' like Mac OS X) AppleWebKit/' + webkitVersion + ' (KHTML, like Gecko) Version/' + safariVersion + ' Mobile/14A403 Mobile/' + webkitVersion;
};

//User-Agent: Mozilla/5.0 (iPad; U; CPU OS 4_3_2 like Mac OS X; en-us) AppleWebKit/533.17.9 (KHTML, like Gecko) Mobile


/***********************
 *  Internet Explorer  *
 /*********************/

function ie(opt) {
  var version = normalize(typeof opt === 'number' || typeof opt === 'string' ? opt : opt.version);
  var tridentVersion = closestSemverValue(version, tridentVersionMap);
  var os = opt.os || Defaults.DESKTOP_OS;

  if (semver.gte(version, '11.0.0')) {
    return 'Mozilla/5.0 (Windows NT 6.3; Trident/' + tridentVersion + '; rv:' + version + ') like Gecko';
  }

  return 'Mozilla/5.0 (compatible; MSIE ' + version + '; ' + os + '; Trident/' + tridentVersion + ')';
}

ie.windowsPhone = function (opt) {
  var version = normalize(typeof opt === 'number' || typeof opt === 'string' ? opt : opt.version);
  var tridentVersion = closestSemverValue(version, tridentVersionMap);
  var windowsPhoneVersion = closestSemverValue(version, windowsPhoneIEVersionMap);
  var device = opt.device || Defaults.WINDOW_PHONE;

  return 'Mozilla/5.0 (compatible; MSIE ' + version + '; Windows Phone OS ' + windowsPhoneVersion + '; Trident/' + tridentVersion + '; IEMobile/' + version + '; ' + device;
};

/**********************
 *   Microsoft Edge   *
 /********************/

function edge(opt) {
  var version = normalize(typeof opt === 'number' || typeof opt === 'string' ? opt : opt.version);
  var os = opt.os || Defaults.DESKTOP_OS;
  var windowsBuildVersion = opt.windowsBuildVersion || Defaults.WINDOWS_BUILD_VERSION;
  var chromeVersion = normalize(opt.chromeVersion || Defaults.EDGE_CHROME_VERSION, 4);

  return 'Mozilla/5.0 (' + os + ';) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/' + chromeVersion + ' Safari/537.36 Edge/' + version + '.' + windowsBuildVersion;
}

/************************
 *  Search Engine Bots  *
 /**********************/

function googleBot(opt) {
  var version = normalize(typeof opt === 'number' || typeof opt === 'string' ? opt : Defaults.GOOGLE_BOT_VERSION);

  return 'Mozilla/5.0 (compatible; Googlebot/' + version + '; +http://www.google.com/bot.html)';
}

function bingBot(opt) {
  var version = normalize(typeof opt === 'number' || typeof opt === 'string' ? opt : Defaults.BING_BOT_VERSION);

  return 'Mozilla/5.0 (compatible; bingbot/' + version + '; +http://www.bing.com/bingbot.htm)';
}

function yahooBot() {
  return 'Mozilla/5.0 (compatible; Yahoo! Slurp; http://help.yahoo.com/help/us/ysearch/slurp)';
}

module.exports = {
  chrome: chrome,
  chromium: chromium,
  firefox: firefox,
  safari: safari,
  ie: ie,
  edge: edge,
  googleBot: googleBot,
  bingBot: bingBot,
  yahooBot: yahooBot
};

/***/ }),
/* 3 */
/***/ (function(module, exports) {

module.exports = require("semver");

/***/ }),
/* 4 */
/***/ (function(module, exports) {

module.exports = require("semver-closest");

/***/ }),
/* 5 */
/***/ (function(module, exports) {

module.exports = require("normalize-version");

/***/ }),
/* 6 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


module.exports = {
  '7.0': 3.1,
  '8.0': 4.0,
  '9.0': 5.0,
  '10.0': 6.0,
  '11.0': 7.0
};

/***/ }),
/* 7 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


module.exports = {
  '1.0': 528,
  '2.0': 530,
  '3.0': 532,
  '4.0': 532.5,
  '4.1': 49,
  '5.0': 533,
  '6.0': 534.3,
  '7.0': 534.7,
  '8.0': 534.10,
  '9.0': 534.13,
  '10.0': 534.16,
  '11.0': 534.24,
  '12.0': 534.30,
  '13.0': 535.1,
  '14.0': 535.2,
  '15.0': 535.2,
  '16.0': 535.7,
  '17.0': 535.11,
  '18.0': 535.19,
  '19.0': 536.5,
  '20.0': 536.10,
  '21.0': 537.1,
  '22.0': 537.4,
  '23.0': 537.11,
  '24.0': 537.17,
  '25.0': 537.22,
  '26.0': 537.31,
  '27.0': 537.36
};

/***/ }),
/* 8 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _module$exports;

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

// @see https://en.wikipedia.org/wiki/Safari_version_history
module.exports = (_module$exports = {
  '1.0': '85',
  '1.0.3': '85.8.5',
  '1.1': '100',
  '1.2': '125',
  '1.3': '312',
  '1.3.1': '312.3',
  '1.3.2': '312.5'
}, _defineProperty(_module$exports, '1.3.2', '312.6'), _defineProperty(_module$exports, '2.0', '412'), _defineProperty(_module$exports, '2.0.2', '416.11'), _defineProperty(_module$exports, '2.0.4', '419.3'), _defineProperty(_module$exports, '3.0', '522.11'), _defineProperty(_module$exports, '3.0.2', '522.12'), _defineProperty(_module$exports, '3.0.3', '522.12.1'), _defineProperty(_module$exports, '3.0.4', '523.10'), _defineProperty(_module$exports, '3.1', '525.13'), _defineProperty(_module$exports, '3.1.1', '525.20'), _defineProperty(_module$exports, '3.1.2', '525.21'), _defineProperty(_module$exports, '3.2', '525.26'), _defineProperty(_module$exports, '3.2.1', '525.27'), _defineProperty(_module$exports, '3.2.3', '525.28'), _defineProperty(_module$exports, '4.0', '530.17'), _defineProperty(_module$exports, '4.0.1', '530.18'), _defineProperty(_module$exports, '4.0.2', '530.19'), _defineProperty(_module$exports, '4.0.3', '531.9'), _defineProperty(_module$exports, '4.0.4', '531.21.10'), _defineProperty(_module$exports, '4.0.5', '531.22.7'), _defineProperty(_module$exports, '4.1', '533.16'), _defineProperty(_module$exports, '4.1.1', '533.17.8'), _defineProperty(_module$exports, '4.1.2', '533.18.5'), _defineProperty(_module$exports, '4.1.3', '533.19.4'), _defineProperty(_module$exports, '5.0', '533.16'), _defineProperty(_module$exports, '5.0.1', '533.17.8'), _defineProperty(_module$exports, '5.0.2', '533.18.5'), _defineProperty(_module$exports, '5.0.3', '533.19.4'), _defineProperty(_module$exports, '5.0.4', '533.20.27'), _defineProperty(_module$exports, '5.0.5', '533.21.1'), _defineProperty(_module$exports, '5.0.6', '533.22.3'), _defineProperty(_module$exports, '5.1', '534.48.3'), _defineProperty(_module$exports, '5.1.1', '534.51.22'), _defineProperty(_module$exports, '5.1.2', '534.52.7'), _defineProperty(_module$exports, '5.1.3', '534.53.10'), _defineProperty(_module$exports, '5.1.4', '534.54.16'), _defineProperty(_module$exports, '5.1.5', '534.55.3'), _defineProperty(_module$exports, '5.1.6', '534.56.5'), _defineProperty(_module$exports, '5.1.7', '534.57.2'), _defineProperty(_module$exports, '5.1.8', '534.58.2'), _defineProperty(_module$exports, '5.1.9', '534.59.8'), _defineProperty(_module$exports, '5.1.10', '534.59.10'), _defineProperty(_module$exports, '6.0', '536.25'), _defineProperty(_module$exports, '6.0.1', '536.26'), _defineProperty(_module$exports, '6.0.2', '536.26.17'), _defineProperty(_module$exports, '6.0.3', '536.28.10'), _defineProperty(_module$exports, '6.0.4', '536.29.13'), _defineProperty(_module$exports, '6.0.5', '536.30.1'), _defineProperty(_module$exports, '6.1', '537.43.58'), _defineProperty(_module$exports, '6.1.1', '537.73.11'), _defineProperty(_module$exports, '6.1.6', '537.78.2[24]'), _defineProperty(_module$exports, '6.2.8', '537.85.17'), _defineProperty(_module$exports, '7.0', '537.71'), _defineProperty(_module$exports, '7.0.1', '537.73.11'), _defineProperty(_module$exports, '7.0.3', '537.75.14'), _defineProperty(_module$exports, '7.0.4', '537.76.4'), _defineProperty(_module$exports, '7.0.5', '537.77.4'), _defineProperty(_module$exports, '7.0.6', '537.78.2'), _defineProperty(_module$exports, '7.1.8', '537.85.17'), _defineProperty(_module$exports, '8.0', '538.35.8'), _defineProperty(_module$exports, '8.0.6', '600.6.3'), _defineProperty(_module$exports, '8.0.7', '600.7.12'), _defineProperty(_module$exports, '9.0', '601.1.56'), _defineProperty(_module$exports, '9.0.1', '601.2.7'), _defineProperty(_module$exports, '9.0.2', '601.3.9'), _defineProperty(_module$exports, '9.0.3', '601.4.4'), _defineProperty(_module$exports, '9.1', '601.5.17'), _defineProperty(_module$exports, '9.1.1', '601.6.17'), _defineProperty(_module$exports, '9.1.2', '601.7.1'), _defineProperty(_module$exports, '9.1.3', '601.7.8'), _defineProperty(_module$exports, '10.0', '602.1.50'), _defineProperty(_module$exports, '10.0.1', '602.2.14'), _defineProperty(_module$exports, '10.0.2', '602.3.12'), _defineProperty(_module$exports, '10.0.3', '602.4.8'), _defineProperty(_module$exports, '10.1', '603.1.30'), _defineProperty(_module$exports, '10.1.1', '603.2.4'), _defineProperty(_module$exports, '10.1.2', '603.3.8'), _defineProperty(_module$exports, '11.0.0', '604.1.28'), _module$exports);

/***/ }),
/* 9 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


// @see https://decadecity.net/blog/2013/11/21/android-browser-versions#version-data', 

module.exports = {
  '1.5': '528.5',
  '1.6': '528.5',
  '2.0': '530.17',
  '2.0.1': '530.17',
  '2.1': '530.17',
  '2.2': '533.1',
  '2.3': '?',
  '2.3.3': '533.1',
  '3.0': '534.13',
  '3.1': '534.13',
  '3.2': '534.13',
  '4.0': '534.30',
  '4.0.3': '534.30',
  '4.1': '534.30',
  '4.2': '534.30',
  '4.3': '534.30',
  '4.4': '537.36'
};

/***/ })
/******/ ]);
});