/*
 * Decompiled with CFR 0.152.
 */
package apdu4j.core;

import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class CancellationWaitingFuture<V>
implements RunnableFuture<V> {
    AtomicReference<Thread> runner = new AtomicReference<Object>(null);
    CountDownLatch completed = new CountDownLatch(1);
    AtomicBoolean cancelled = new AtomicBoolean(false);
    private volatile V result;
    private volatile Throwable ex;
    private Callable<V> callable;

    public CancellationWaitingFuture(Callable<V> callable) {
        this.callable = callable;
    }

    @Override
    public void run() {
        if (this.cancelled.get() || !this.runner.compareAndSet(null, Thread.currentThread())) {
            return;
        }
        try {
            Callable<V> c = this.callable;
            if (c != null) {
                try {
                    this.result = c.call();
                }
                catch (Throwable ex) {
                    this.ex = ex;
                }
            }
        }
        finally {
            this.completed.countDown();
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (!mayInterruptIfRunning) {
            throw new IllegalArgumentException("mayInterruptIfRunning must be true");
        }
        if (!this.cancelled.compareAndSet(false, true)) {
            return false;
        }
        Thread t = this.runner.get();
        if (t != null) {
            t.interrupt();
        }
        return true;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled.get();
    }

    @Override
    public boolean isDone() {
        return this.completed.getCount() == 0L;
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        this.completed.await();
        if (this.ex != null) {
            if (this.ex instanceof CancellationException) {
                throw (CancellationException)this.ex;
            }
            if (this.ex instanceof InterruptedException) {
                throw new CancellationException("Interrupted");
            }
            throw new ExecutionException(this.ex);
        }
        return this.result;
    }

    @Override
    public V get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        if (!this.completed.await(l, timeUnit)) {
            throw new TimeoutException();
        }
        if (this.ex != null) {
            if (this.ex instanceof CancellationException) {
                throw (CancellationException)this.ex;
            }
            if (this.ex instanceof InterruptedException) {
                throw new CancellationException("Interrupted");
            }
            throw new ExecutionException(this.ex);
        }
        return this.result;
    }
}

