/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.gp;

import apdu4j.core.APDUBIBO;
import apdu4j.core.CommandAPDU;
import apdu4j.core.HexUtils;
import apdu4j.core.ResponseAPDU;
import com.payneteasy.tlv.BerTag;
import com.payneteasy.tlv.BerTlv;
import com.payneteasy.tlv.BerTlvParser;
import com.payneteasy.tlv.BerTlvs;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.javacard.gp.CPLC;
import pro.javacard.gp.GPDataException;
import pro.javacard.gp.GPException;
import pro.javacard.gp.GPKeyInfo;
import pro.javacard.gp.GPRegistryEntry;
import pro.javacard.gp.GPSecureChannelVersion;
import pro.javacard.gp.GPUtils;
import pro.javacard.gp.data.BitField;

public final class GPData {
    private static final Logger logger = LoggerFactory.getLogger(GPData.class);
    static final byte[] defaultISDBytes = HexUtils.hex2bin("A000000151000000");
    static final Map<Integer, String> sw = new HashMap<Integer, String>();

    private GPData() {
    }

    public static void pretty_print_card_data(byte[] data) {
        BerTlvParser parser = new BerTlvParser();
        BerTlvs tlvs = parser.parse(data);
        GPUtils.trace_tlv(data, logger);
        BerTlv cd = tlvs.find(new BerTag(102));
        if (cd != null && cd.isConstructed()) {
            BerTlv isdd = tlvs.find(new BerTag(115));
            if (isdd != null) {
                for (BerTlv vt : isdd.getValues()) {
                    Object p;
                    Object oid;
                    if (vt.isTag(new BerTag(6))) {
                        oid = GPData.logAndGetOidFromByteArray(vt.getTag().bytes, vt.getBytesValue());
                        if (!((String)oid).equals("1.2.840.114283.1")) continue;
                        System.out.println("-> Global Platform card");
                        continue;
                    }
                    if (vt.isTag(new BerTag(96))) {
                        oid = GPData.logAndGetOidFromByteArray(vt.getTag().bytes, vt.getValues().get(0).getBytesValue());
                        if (!((String)oid).startsWith("1.2.840.114283.2")) continue;
                        p = ((String)oid).substring("1.2.840.114283.2.".length()).split("\\.");
                        System.out.println("-> GP Version: " + String.join((CharSequence)".", (CharSequence[])p));
                        continue;
                    }
                    if (vt.isTag(new BerTag(99))) {
                        oid = GPData.logAndGetOidFromByteArray(vt.getTag().bytes, vt.getValues().get(0).getBytesValue());
                        if (!((String)oid).startsWith("1.2.840.114283.3")) continue;
                        System.out.println("-> GP card is uniquely identified by the Issuer Identification Number (IIN) and Card Image Number (CIN)");
                        continue;
                    }
                    if (vt.isTag(new BerTag(100))) {
                        for (BerTlv ot : vt.getValues()) {
                            byte[] oidBytes = ot.getBytesValue();
                            String oid2 = GPData.logAndGetOidFromByteArray(ot.getTag().bytes, oidBytes);
                            if (!oid2.startsWith("1.2.840.114283.4.")) continue;
                            byte[] scp = Arrays.copyOfRange(oidBytes, oidBytes.length - 2, oidBytes.length);
                            System.out.printf("-> GP %s%n", GPSecureChannelVersion.valueOf(scp[0] & 0xFF, scp[1] & 0xFF));
                        }
                        continue;
                    }
                    if (vt.isTag(new BerTag(101))) continue;
                    if (vt.isTag(new BerTag(102))) {
                        oid = GPData.logAndGetOidFromByteArray(vt.getTag().bytes, vt.getValues().get(0).getBytesValue());
                        if (!((String)oid).startsWith("1.3.6.1.4.1.42.2.110.1") || ((String)(p = ((String)oid).substring("1.3.6.1.4.1.42.2.110.1.".length()))).length() != 1) continue;
                        System.out.println("-> JavaCard v" + (String)p);
                        continue;
                    }
                    if (!vt.isTag(new BerTag(103)) && !vt.isTag(new BerTag(104))) continue;
                }
            }
        } else {
            System.out.println("No Card Data");
        }
    }

    static List<Integer> toUnsignedList(byte[] b) {
        ArrayList<Integer> r = new ArrayList<Integer>();
        for (byte value : b) {
            r.add(value & 0xFF);
        }
        return r;
    }

    public static void pretty_print_card_capabilities(byte[] data) throws GPDataException {
        BerTlv caps;
        if (data[0] == 103 && data[2] == 103) {
            logger.warn("Bogus data detected, fixing double tag");
            data = Arrays.copyOfRange(data, 2, data.length);
        }
        BerTlvParser parser = new BerTlvParser();
        BerTlvs tlvs = parser.parse(data);
        GPUtils.trace_tlv(data, logger);
        if (tlvs != null && (caps = tlvs.find(new BerTag(103))) != null) {
            for (BerTlv v : caps.getValues()) {
                String ciphers;
                Set<GPRegistryEntry.Privilege> privs;
                BerTlv t = v.find(new BerTag(160));
                if (t != null) {
                    BerTlv scp = t.find(new BerTag(128));
                    if (scp != null) {
                        BerTlv keylens;
                        System.out.format("Supports SCP%02X", scp.getIntValue());
                        BerTlv is = t.find(new BerTag(129));
                        if (is != null) {
                            for (byte b : is.getBytesValue()) {
                                System.out.format(" i=%02X", b);
                            }
                        }
                        if ((keylens = t.find(new BerTag(130))) != null) {
                            System.out.print(" with");
                            if ((keylens.getIntValue() & 1) == 1) {
                                System.out.print(" AES-128");
                            }
                            if ((keylens.getIntValue() & 2) == 2) {
                                System.out.print(" AES-196");
                            }
                            if ((keylens.getIntValue() & 4) == 4) {
                                System.out.print(" AES-256");
                            }
                        }
                    }
                    System.out.println();
                    continue;
                }
                t = v.find(new BerTag(129));
                if (t != null) {
                    privs = GPRegistryEntry.Privilege.fromBytes(t.getBytesValue());
                    System.out.println("Supported DOM privileges: " + privs.stream().map(Enum::toString).collect(Collectors.joining(", ")));
                    continue;
                }
                t = v.find(new BerTag(130));
                if (t != null) {
                    privs = GPRegistryEntry.Privilege.fromBytes(t.getBytesValue());
                    System.out.println("Supported APP privileges: " + privs.stream().map(Enum::toString).collect(Collectors.joining(", ")));
                    continue;
                }
                t = v.find(new BerTag(131));
                if (t != null) {
                    String hashes = GPData.toUnsignedList(t.getBytesValue()).stream().map(e -> LFDBH.byValue(e).get().toString()).collect(Collectors.joining(", "));
                    System.out.println("Supported LFDB hash: " + hashes);
                    continue;
                }
                t = v.find(new BerTag(133));
                if (t != null) {
                    ciphers = SIGNATURE.byValue(t.getBytesValue()).stream().map(Enum::toString).collect(Collectors.joining(", "));
                    System.out.println("Supported Token Verification ciphers: " + ciphers);
                    continue;
                }
                t = v.find(new BerTag(134));
                if (t != null) {
                    ciphers = SIGNATURE.byValue(t.getBytesValue()).stream().map(Enum::toString).collect(Collectors.joining(", "));
                    System.out.println("Supported Receipt Generation ciphers: " + ciphers);
                    continue;
                }
                t = v.find(new BerTag(135));
                if (t != null) {
                    ciphers = SIGNATURE.byValue(t.getBytesValue()).stream().map(Enum::toString).collect(Collectors.joining(", "));
                    System.out.println("Supported DAP Verification ciphers: " + ciphers);
                    continue;
                }
                t = v.find(new BerTag(136));
                if (t == null) continue;
                System.out.println("Supported ECC Key Parameters: " + HexUtils.bin2hex(t.getBytesValue()));
            }
        }
    }

    public static void dump(APDUBIBO channel) throws IOException, GPException {
        byte[] keyInfo;
        byte[] ssc;
        byte[] kdd;
        byte[] cin;
        byte[] iin;
        byte[] cplc = GPData.fetchCPLC(channel);
        if (cplc != null) {
            System.out.println(CPLC.fromBytes(cplc).toPrettyString());
        }
        if ((iin = GPData.getData(channel, 0, 66, "IIN", false)) != null) {
            System.out.println("IIN: " + HexUtils.bin2hex(iin));
        }
        if ((cin = GPData.getData(channel, 0, 69, "CIN", false)) != null) {
            System.out.println("CIN: " + HexUtils.bin2hex(cin));
        }
        if ((kdd = GPData.getData(channel, 0, 207, "KDD", false)) != null) {
            System.out.println("KDD: " + HexUtils.bin2hex(kdd));
        }
        if ((ssc = GPData.getData(channel, 0, 193, "SSC", false)) != null) {
            System.out.println("SSC: " + HexUtils.bin2hex(ssc));
        }
        System.out.println("Card Data: ");
        byte[] cardData = GPData.getData(channel, 0, 102, "Card Data", false);
        if (cardData != null) {
            GPData.pretty_print_card_data(cardData);
        }
        System.out.println("Card Capabilities: ");
        byte[] cardCapabilities = GPData.getData(channel, 0, 103, "Card Capabilities", false);
        if (cardCapabilities != null) {
            GPData.pretty_print_card_capabilities(cardCapabilities);
        }
        if ((keyInfo = GPData.fetchKeyInfoTemplate(channel)) != null) {
            System.out.println(GPKeyInfo.toString(GPKeyInfo.parseTemplate(keyInfo)));
        }
    }

    public static byte[] fetchCPLC(APDUBIBO channel) {
        return GPData.getData(channel, 159, 127, "CPLC", true);
    }

    public static byte[] fetchKeyInfoTemplate(APDUBIBO channel) {
        return GPData.getData(channel, 0, 224, "Key Info Template", false);
    }

    public static String sw2str(int sw) {
        String msg = GPData.sw.get(sw);
        if (msg == null) {
            return String.format("0x%04X", sw);
        }
        return String.format("0x%04X (%s)", sw, msg);
    }

    public static String oid2string(byte[] oid) {
        logger.trace("Parsing {} as OID", (Object)HexUtils.bin2hex(oid));
        System.setProperty("org.bouncycastle.asn1.allow_wrong_oid_enc", "true");
        ASN1ObjectIdentifier realoid = ASN1ObjectIdentifier.fromContents(oid);
        System.clearProperty("org.bouncycastle.asn1.allow_wrong_oid_enc");
        if (realoid == null) {
            throw new IllegalArgumentException("Could not parse OID from " + HexUtils.bin2hex(oid));
        }
        return realoid.toString();
    }

    private static String logAndGetOidFromByteArray(byte[] tag, byte[] tlv) {
        String oid = GPData.oid2string(tlv);
        System.out.println("Tag " + new BigInteger(1, tag).toString(16) + ": " + oid);
        return oid;
    }

    public static String oid2version(byte[] bytes) throws GPDataException {
        String oid = GPData.oid2string(bytes);
        return oid.substring("1.2.840.114283.2.".length());
    }

    public static byte[] getData(APDUBIBO channel, int p1, int p2, String name, boolean failsafe) {
        logger.trace("GET DATA({})", (Object)name);
        ResponseAPDU resp = channel.transmit(new CommandAPDU(-128, -54, p1, p2, 256));
        if (failsafe && resp.getSW() != 36864) {
            resp = channel.transmit(new CommandAPDU(0, -54, p1, p2, 256));
        }
        if (resp.getSW() == 36864) {
            return resp.getData();
        }
        if (resp.getSW() == 27272) {
            logger.debug("GET DATA({}): N/A", (Object)name);
            return null;
        }
        logger.warn("GET DATA({}) not supported", (Object)name);
        return null;
    }

    static {
        sw.put(25600, "No specific diagnosis");
        sw.put(26368, "Wrong length (Lc)");
        sw.put(27904, "Invalid INStruction");
        sw.put(28160, "Invalid CLAss");
        sw.put(25219, "Card Life Cycle State is CARD_LOCKED");
        sw.put(25656, "Imported package not available");
        sw.put(25985, "Memory failure");
        sw.put(26754, "Secure messaging not supported");
        sw.put(27010, "Security status not satisfied");
        sw.put(27013, "Conditions of use not satisfied");
        sw.put(27033, "Applet selection failed");
        sw.put(27264, "Wrong data/incorrect values in data");
        sw.put(27265, "Function not supported e.g. card Life Cycle State is CARD_LOCKED");
        sw.put(27266, "Application/file not found");
        sw.put(27268, "Not enough memory space");
        sw.put(27270, "Incorrect P1/P2");
        sw.put(27272, "Referenced data not found");
    }

    public static enum SIGNATURE implements BitField<SIGNATURE>
    {
        RSA1024_SHA1(BitField.byte_mask(0, 1)),
        RSAPSS_SHA256(BitField.byte_mask(0, 2)),
        DES_MAC(BitField.byte_mask(0, 4)),
        CMAC_AES128(BitField.byte_mask(0, 8)),
        CMAC_AES192(BitField.byte_mask(0, 16)),
        CMAC_AES256(BitField.byte_mask(0, 32)),
        ECCP256_SHA256(BitField.byte_mask(0, 64)),
        ECCP384_SHA384(BitField.byte_mask(0, 128)),
        ECCP512_SHA512(BitField.byte_mask(1, 1)),
        ECCP521_SHA512(BitField.byte_mask(1, 2)),
        RFU(new BitField.Def.RFU(BitField.byte_mask(1, 252)));

        private final BitField.Def def;

        private SIGNATURE(BitField.Def def) {
            this.def = def;
        }

        @Override
        public BitField.Def def() {
            return this.def;
        }

        public static Set<SIGNATURE> byValue(byte[] v) {
            return BitField.parse(SIGNATURE.class, v);
        }
    }

    public static enum LFDBH {
        SHA1(1, "SHA-1"),
        SHA256(2, "SHA-256"),
        SHA384(3, "SHA-384"),
        SHA512(4, "SHA-512");

        final int value;
        final String algo;

        private LFDBH(int byteValue, String algo) {
            this.value = byteValue;
            this.algo = algo;
        }

        public static Optional<LFDBH> byValue(int byteValue) {
            return Arrays.stream(LFDBH.values()).filter(e -> e.value == byteValue).findFirst();
        }

        public static Optional<LFDBH> fromString(String s) {
            return Arrays.stream(LFDBH.values()).filter(e -> e.name().equalsIgnoreCase(s)).findFirst();
        }

        public static ArrayList<LFDBH> fromBytes(byte[] v) {
            ArrayList<LFDBH> r = new ArrayList<LFDBH>();
            int i = 0;
            while (i < v.length) {
                int j = i++;
                r.add(Arrays.stream(LFDBH.values()).filter(e -> e.value == (v[j] & 0xFF)).findFirst().orElseThrow(() -> new GPDataException("Invalid value", v)));
            }
            return r;
        }

        public String toString() {
            return this.algo;
        }
    }
}

