/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.gptool;

import apdu4j.core.APDUBIBO;
import apdu4j.core.BIBO;
import apdu4j.core.CommandAPDU;
import apdu4j.core.HexBytes;
import apdu4j.core.HexUtils;
import apdu4j.core.ResponseAPDU;
import apdu4j.core.SimpleSmartCardApp;
import apdu4j.core.SmartCardApp;
import apdu4j.pcsc.CardBIBO;
import apdu4j.pcsc.PCSCReader;
import apdu4j.pcsc.TerminalManager;
import apdu4j.pcsc.terminals.LoggingCardTerminal;
import com.google.auto.service.AutoService;
import com.payneteasy.tlv.BerTag;
import com.payneteasy.tlv.BerTlvParser;
import com.payneteasy.tlv.BerTlvs;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.crypto.Cipher;
import javax.smartcardio.Card;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import pro.javacard.capfile.AID;
import pro.javacard.capfile.CAPFile;
import pro.javacard.gp.CPLC;
import pro.javacard.gp.CardKeysProvider;
import pro.javacard.gp.DAPSigner;
import pro.javacard.gp.DMTokenizer;
import pro.javacard.gp.GPCardKeys;
import pro.javacard.gp.GPCardProfile;
import pro.javacard.gp.GPCommands;
import pro.javacard.gp.GPCrypto;
import pro.javacard.gp.GPData;
import pro.javacard.gp.GPException;
import pro.javacard.gp.GPKeyInfo;
import pro.javacard.gp.GPRegistry;
import pro.javacard.gp.GPRegistryEntry;
import pro.javacard.gp.GPSecureChannelVersion;
import pro.javacard.gp.GPSession;
import pro.javacard.gp.GPUtils;
import pro.javacard.gp.ReceiptVerifier;
import pro.javacard.gp.emv.DGIData;
import pro.javacard.gp.keys.PlaintextKeys;
import pro.javacard.gptool.APDUParsers;
import pro.javacard.gptool.GPCommandLineInterface;
import pro.javacard.gptool.Key;
import pro.javacard.pace.AESSecureChannel;
import pro.javacard.pace.PACE;
import pro.javacard.pace.PACEException;

@AutoService(value={SmartCardApp.class})
public final class GPTool
extends GPCommandLineInterface
implements SimpleSmartCardApp {
    private static boolean isVerbose = false;
    private static boolean isTrace = false;
    static final String ENV_GP_AID = "GP_AID";
    static final String ENV_GP_READER = "GP_READER";
    static final String ENV_GP_READER_IGNORE = "GP_READER_IGNORE";
    static final String ENV_GP_TRACE = "GP_TRACE";
    static final String ENV_GP_PCSC_RESET = "GP_PCSC_RESET";
    static final String ENV_GP_PCSC_EXCLUSIVE = "GP_PCSC_EXCLUSIVE";
    static final String ENV_GP_PCSC_TRANSACT = "GP_PCSC_TRANSACT";
    private static boolean preamble = true;
    static Predicate<GPRegistryEntry.Privilege> dapPrivileges = e -> e == GPRegistryEntry.Privilege.MandatedDAPVerification || e == GPRegistryEntry.Privilege.DAPVerification;
    static Predicate<GPRegistryEntry> dapDomainFilter = e -> e.hasPrivilege(GPRegistryEntry.Privilege.MandatedDAPVerification) || e.hasPrivilege(GPRegistryEntry.Privilege.DAPVerification);

    static void setupLogging(OptionSet args) {
        System.setProperty("org.slf4j.simpleLogger.showThreadName", "false");
        System.setProperty("org.slf4j.simpleLogger.levelInBrackets", "true");
        System.setProperty("org.slf4j.simpleLogger.showShortLogName", "true");
        System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", "warn");
        if (args.has(OPT_VERBOSE)) {
            isVerbose = true;
            System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", "info");
        }
        if (args.has(OPT_DEBUG) && args.has(OPT_VERBOSE)) {
            System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", "debug");
        }
        if (args.has(OPT_DEBUG) && System.getenv().containsKey(ENV_GP_TRACE)) {
            System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", "trace");
            isTrace = true;
        }
    }

    private static void showPreamble(String[] argv, OptionSet args) {
        if (preamble) {
            if (args.has(OPT_VERBOSE) || args.has(OPT_DEBUG) || args.has(OPT_INFO)) {
                List gpenv = System.getenv().entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("GP_")).map(e -> String.format("%s=%s", e.getKey(), e.getValue())).collect(Collectors.toList());
                if (gpenv.size() > 0) {
                    System.out.println("# " + String.join((CharSequence)" ", gpenv));
                }
                System.out.println("# gp " + String.join((CharSequence)" ", argv));
            }
            if (args.has(OPT_VERBOSE) || args.has(OPT_DEBUG) || args.has(OPT_INFO) || args.has(OPT_VERSION)) {
                System.out.printf("# GlobalPlatformPro %s%n", GPSession.getVersion());
                System.out.printf("# Running on %s %s %s", System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"));
                System.out.printf(", Java %s by %s%n", System.getProperty("java.version"), System.getProperty("java.vendor"));
            }
            try {
                if (Cipher.getMaxAllowedKeyLength("AES") == 128) {
                    System.err.println("# Error: unlimited crypto policy is NOT installed!");
                    System.err.println("# Please install and use JDK 11 LTS or later");
                }
            }
            catch (NoSuchAlgorithmException e2) {
                System.err.println("# Error: no AES support in JRE?");
            }
        }
        preamble = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) {
        Card c = null;
        int ret = 1;
        boolean resetOnDisconnect = Boolean.parseBoolean(System.getenv().getOrDefault(ENV_GP_PCSC_RESET, "false"));
        boolean exclusive = Boolean.parseBoolean(System.getenv().getOrDefault(ENV_GP_PCSC_EXCLUSIVE, "false"));
        boolean transact = Boolean.parseBoolean(System.getenv().getOrDefault(ENV_GP_PCSC_TRANSACT, "true"));
        try {
            String ignoreReader;
            String useReader;
            Optional<CardTerminal> reader;
            OptionSet args = GPTool.parseArguments(argv);
            GPTool.setupLogging(args);
            GPTool.showPreamble(argv, args);
            if (GPTool.onlyHasArg(args, OPT_VERSION)) {
                return;
            }
            if (GPTool.onlyHasArg(args, OPT_CAP)) {
                CAPFile cap = CAPFile.fromFile(((File)args.valueOf(OPT_CAP)).toPath());
                cap.dump(System.out);
                return;
            }
            TerminalManager terminalManager = TerminalManager.getDefault();
            List<PCSCReader> readers = TerminalManager.listPCSC(terminalManager.terminals().list(), null, false);
            if (args.has(OPT_READER) && !args.hasArgument(OPT_READER)) {
                System.out.println("Available readers:");
                readers.forEach(r -> System.out.printf("- %s%n", r.getName()));
            }
            if ((reader = TerminalManager.getLucky(TerminalManager.dwimify(readers, useReader = args.hasArgument(OPT_READER) ? (String)args.valueOf(OPT_READER) : System.getenv(ENV_GP_READER), ignoreReader = System.getenv(ENV_GP_READER_IGNORE)), terminalManager.terminals())).isEmpty()) {
                System.err.println("Specify reader with -r/$GP_READER; available readers:");
                readers.forEach(r -> System.err.printf("- %s%n", r.getName()));
                System.exit(1);
            }
            if (args.has(OPT_PCSC_EXCLUSIVE)) {
                exclusive = true;
            }
            reader = reader.map(e -> args.has(OPT_DEBUG) ? LoggingCardTerminal.getInstance(e) : e);
            String protocol = exclusive ? "EXCLUSIVE;*" : "*";
            c = reader.get().connect(protocol);
            if (transact) {
                c.beginExclusive();
            }
            ret = new GPTool().run(CardBIBO.wrap(c), argv);
        }
        catch (IllegalArgumentException e2) {
            System.err.println("Invalid argument: " + e2.getMessage());
            GPTool.trace(e2);
        }
        catch (Exception e3) {
            System.err.println("Error: " + e3.getMessage());
            GPTool.trace(e3);
        }
        finally {
            if (c != null) {
                if (transact) {
                    try {
                        c.endExclusive();
                    }
                    catch (CardException e4) {
                        GPTool.verbose("Exception when ending card transaction: " + e4.getMessage());
                        GPTool.trace(e4);
                    }
                }
                try {
                    c.disconnect(resetOnDisconnect);
                }
                catch (CardException e5) {
                    GPTool.verbose("Exception when disconnecting card: " + e5.getMessage());
                    GPTool.trace(e5);
                }
            }
        }
        System.exit(ret);
    }

    static boolean onlyHasArg(OptionSet args, OptionSpec<?> s) {
        long needle = args.specs().stream().filter(args::has).count();
        long hay = args.specs().stream().filter(e -> args.has((OptionSpec<?>)e) && e != s).count();
        return needle == 1L && hay == 0L;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int run(BIBO bibo, String[] argv) {
        try {
            List<byte[]> blobs;
            List<CAPFile> caps;
            AID aid;
            Object r;
            GPCardKeys keys;
            Optional<GPCardKeys> key;
            GPSession gp;
            OptionSet args = GPTool.parseArguments(argv);
            GPTool.setupLogging(args);
            GPTool.showPreamble(argv, args);
            if (GPTool.onlyHasArg(args, OPT_VERSION)) {
                return 0;
            }
            CAPFile cap = null;
            if (args.has(OPT_CAP)) {
                File capfile = (File)args.valueOf(OPT_CAP);
                cap = CAPFile.fromFile(capfile.toPath());
            }
            APDUBIBO channel = new APDUBIBO(bibo);
            if (args.has(OPT_PACE) || args.has(OPT_PACE_SM)) {
                byte[] aid2 = args.has(OPT_PACE) ? ((AID)args.valueOf(OPT_PACE)).getBytes() : ((AID)args.valueOf(OPT_PACE_SM)).getBytes();
                try {
                    PACE pace = PACE.executePACE(channel, aid2, (String)args.valueOf(OPT_CAN), (PACE.PACECurve)((Object)args.valueOf(OPT_PACE_CURVE)));
                    if (args.has(OPT_PACE_SM)) {
                        channel = new APDUBIBO(new AESSecureChannel(pace.getENC(), pace.getMAC(), bibo));
                    }
                }
                catch (GeneralSecurityException | PACEException e2) {
                    System.err.println("Could not run PACE: " + e2.getMessage());
                    return 1;
                }
            }
            if (args.has(OPT_APDU)) {
                AID target = null;
                if (args.has(OPT_APPLET)) {
                    target = (AID)args.valueOf(OPT_APPLET);
                } else if (cap != null) {
                    target = cap.getAppletAIDs().get(0);
                }
                if (target != null) {
                    GPTool.verbose("Selecting " + String.valueOf(target));
                    channel.transmit(new CommandAPDU(0, -92, 4, 0, target.getBytes()));
                }
                for (byte[] s : args.valuesOf(OPT_APDU).stream().map(APDUParsers::stringToAPDU).collect(Collectors.toList())) {
                    CommandAPDU c = new CommandAPDU(s);
                    ResponseAPDU r2 = channel.transmit(c);
                    if (r2.getSW() != 36864 || r2.getData().length <= 0) continue;
                    System.out.println(APDUParsers.visualize_structure(r2.getData()));
                }
            }
            Map<String, String> env = System.getenv();
            Object mode = GPSession.defaultMode.clone();
            if (args.has(OPT_SC_MODE)) {
                ((AbstractCollection)mode).clear();
                ((AbstractCollection)mode).addAll(args.valuesOf(OPT_SC_MODE));
            }
            if (args.has(OPT_CONNECT)) {
                gp = GPSession.connect(channel, (AID)args.valueOf(OPT_CONNECT));
            } else if (env.containsKey(ENV_GP_AID)) {
                AID aid3 = AID.fromString(env.get(ENV_GP_AID));
                GPTool.verbose(String.format("Connecting to $%s (%s)", ENV_GP_AID, aid3));
                gp = GPSession.connect(channel, aid3);
            } else {
                gp = GPSession.discover(channel);
            }
            GPTool.optional(args, OPT_BS).ifPresent(gp::setBlockSize);
            if (args.has(OPT_DM_KEY)) {
                Optional<PrivateKey> dmkey = ((Key)args.valueOf(OPT_DM_KEY)).getPrivate();
                if (dmkey.isEmpty() || !(dmkey.get() instanceof RSAPrivateKey)) {
                    throw new IllegalArgumentException("Only RSA private keys are supported for DM");
                }
                gp.setTokenizer(DMTokenizer.forPrivateKey((RSAPrivateKey)dmkey.get()));
            } else if (args.has(OPT_DM_TOKEN)) {
                byte[] token = ((HexBytes)args.valueOf(OPT_DM_TOKEN)).value();
                gp.setTokenizer(DMTokenizer.forToken(token));
            }
            if (args.has(OPT_RECEIPT_KEY)) {
                ReceiptVerifier.AESReceiptVerifier verifier = new ReceiptVerifier.AESReceiptVerifier(((HexBytes)args.valueOf(OPT_RECEIPT_KEY)).v(), args.has(OPT_FORCE));
                gp.setVerifier(verifier);
            }
            if (args.has(OPT_INFO)) {
                GPData.dump(channel);
            }
            if ((key = GPTool.keyFromPlugin((String)args.valueOf(OPT_KEY))).isPresent()) {
                keys = key.get();
            } else {
                void var12_23;
                Optional<PlaintextKeys> envKeys = PlaintextKeys.fromEnvironment();
                if (args.has(OPT_KEY_ENC) && args.has(OPT_KEY_MAC) && args.has(OPT_KEY_DEK)) {
                    Optional<PlaintextKeys> optional = Optional.of(PlaintextKeys.fromKeys(((HexBytes)args.valueOf(OPT_KEY_ENC)).v(), ((HexBytes)args.valueOf(OPT_KEY_MAC)).v(), ((HexBytes)args.valueOf(OPT_KEY_DEK)).v()));
                } else {
                    Optional optional = Optional.empty();
                }
                if (envKeys.isPresent() && var12_23.isPresent()) {
                    System.err.println("# Warning: keys set on command line shadow environment!");
                } else if (envKeys.isEmpty() && var12_23.isEmpty()) {
                    if (args.has(OPT_SAD)) {
                        System.err.println("Error: no keys given");
                        return 1;
                    }
                    System.err.println("# Warning: no keys given, defaulting to " + HexUtils.bin2hex(PlaintextKeys.DEFAULT_KEY()));
                }
                keys = var12_23.or(() -> envKeys).orElse(PlaintextKeys.defaultKey());
            }
            if (keys instanceof PlaintextKeys) {
                PlaintextKeys keyz = (PlaintextKeys)keys;
                if (args.has(OPT_KEY_KDF)) {
                    keyz.setDiversifier(PlaintextKeys.kdf_templates.getOrDefault(args.valueOf(OPT_KEY_KDF), (String)args.valueOf(OPT_KEY_KDF)));
                }
                GPTool.optional(args, OPT_KEY_VERSION).ifPresent(keyz::setVersion);
            }
            if (args.has(OPT_PROFILE)) {
                Optional<GPCardProfile> p = GPCardProfile.fromName((String)args.valueOf(OPT_PROFILE));
                if (p.isEmpty()) {
                    System.err.printf("Unknown profile '%s', known profiles: %s%n", args.valueOf(OPT_PROFILE), String.join((CharSequence)", ", GPCardProfile.profiles.keySet()));
                    return 1;
                }
                gp.setProfile(p.get());
            }
            if (!GPTool.needsAuthentication(args)) return 0;
            try {
                gp.openSecureChannel(keys, null, args.has(OPT_S16) ? GPCrypto.random(16) : null, (EnumSet<GPSession.APDUMode>)mode);
            }
            catch (GPException e3) {
                System.err.println("Failed to open secure channel: " + e3.getMessage() + "\nRead more from https://github.com/martinpaljak/GlobalPlatformPro/wiki/Keys");
                return 1;
            }
            if (args.has(OPT_SECURE_APDU)) {
                for (byte[] byArray : args.valuesOf(OPT_SECURE_APDU).stream().map(APDUParsers::stringToAPDU).collect(Collectors.toList())) {
                    CommandAPDU c = new CommandAPDU(byArray);
                    r = gp.transmit(c);
                    if (((ResponseAPDU)r).getData().length <= 0 || ((ResponseAPDU)r).getSW() != 36864) continue;
                    System.out.println(APDUParsers.visualize_structure(((ResponseAPDU)r).getData()));
                }
            }
            if (args.has(OPT_DELETE)) {
                boolean bl;
                if (!args.has(OPT_FORCE) && !args.has(OPT_SAD)) {
                    this.warnIfNoDelegatedManagement(gp);
                }
                GPRegistry reg = gp.getRegistry();
                if (args.has(OPT_DEFAULT)) {
                    Optional<AID> optional = reg.getDefaultSelectedAID();
                    if (optional.isPresent()) {
                        gp.deleteAID(optional.get(), false);
                    } else {
                        System.err.println("Could not identify default selected application!");
                    }
                }
                boolean bl2 = false;
                Iterator<CAPFile> aidList = new ArrayList(args.valuesOf(OPT_DELETE));
                r = aidList.iterator();
                while (r.hasNext()) {
                    aid = (AID)r.next();
                    try {
                        boolean deleteDeps = reg.allPackageAIDs().contains(aid) && args.has(OPT_FORCE);
                        gp.deleteAID(aid, deleteDeps);
                    }
                    catch (GPException e4) {
                        bl = true;
                        if (!reg.allAIDs().contains(aid)) {
                            System.err.println("Could not delete AID (not present on card): " + String.valueOf(aid));
                            continue;
                        }
                        if (e4.sw == 27013) {
                            System.err.printf("Could not delete %s (0x6985). Some app still active?%n", aid);
                            continue;
                        }
                        System.err.printf("Could not delete AID %s: %s%n", aid, GPData.sw2str(e4.sw));
                    }
                }
                if (bl && !args.has(OPT_FORCE)) {
                    return 1;
                }
            }
            if (args.has(OPT_UNINSTALL)) {
                boolean bl;
                if (!args.has(OPT_FORCE) && !args.has(OPT_SAD)) {
                    this.warnIfNoDelegatedManagement(gp);
                }
                caps = GPTool.getCapFileList(args, OPT_UNINSTALL);
                boolean bl3 = false;
                for (CAPFile instcap : caps) {
                    aid = instcap.getPackageAID();
                    if (!gp.getRegistry().allAIDs().contains(aid)) {
                        System.err.println(String.valueOf(aid) + " is not present on card!");
                    }
                    try {
                        gp.deleteAID(aid, true);
                        System.out.println(String.valueOf(aid) + " deleted.");
                    }
                    catch (GPException e5) {
                        bl = true;
                    }
                }
                if (bl && !args.has(OPT_FORCE)) {
                    return 1;
                }
            }
            if (args.has(OPT_LOAD)) {
                if (!args.has(OPT_FORCE) && !args.has(OPT_SAD)) {
                    this.warnIfNoDelegatedManagement(gp);
                }
                caps = GPTool.getCapFileList(args, OPT_LOAD);
                GPRegistry gPRegistry = gp.getRegistry();
                if (args.has(OPT_FORCE)) {
                    for (CAPFile loadcap : caps) {
                        if (!gPRegistry.allPackageAIDs().contains(loadcap.getPackageAID())) continue;
                        GPTool.verbose("removing existing package " + loadcap.getPackageName() + " " + String.valueOf(loadcap.getPackageAID()));
                        gp.deleteAID(loadcap.getPackageAID(), true);
                    }
                }
                for (CAPFile loadcap : caps) {
                    if (isVerbose) {
                        loadcap.dump(System.out);
                    }
                    GPTool.loadCAP(args, gp, loadcap);
                }
            }
            if (args.has(OPT_PUT_KEY) || args.has(OPT_REPLACE_KEY)) {
                Key kv = args.has(OPT_PUT_KEY) ? (Key)args.valueOf(OPT_PUT_KEY) : (Key)args.valueOf(OPT_REPLACE_KEY);
                int n = (Integer)args.valueOf(OPT_NEW_KEY_VERSION);
                if (n < 1 || n > 127) {
                    System.err.println("Invalid key version: " + GPUtils.intString(n) + ", some possible values:");
                    System.err.println(GPKeyInfo.keyVersionPurposes.entrySet().stream().map(e -> String.format("%s - %s", GPUtils.intString((Integer)e.getKey()), e.getValue())).collect(Collectors.joining("\n")));
                    throw new IllegalArgumentException("Invalid key version: " + GPUtils.intString(n));
                }
                boolean replace = args.has(OPT_REPLACE_KEY);
                if (kv.getPublic().isPresent()) {
                    gp.putKey(kv.getPublic().get(), n, replace);
                } else {
                    if (!kv.getSymmetric().isPresent()) throw new IllegalArgumentException("Only public and symmetric keys are supported for put-key");
                    java.security.Key k = kv.getSymmetric().get();
                    gp.putKey(k, n, replace);
                }
            }
            if (args.has(OPT_INSTALL_ONLY)) {
                GPRegistry registry = gp.getRegistry();
                InstallDefinition installDefinition = InstallDefinition.fromOptions(registry, args);
            }
            if (args.has(OPT_INSTALL)) {
                AID appaid;
                if (!args.has(OPT_FORCE) && !args.has(OPT_SAD)) {
                    this.warnIfNoDelegatedManagement(gp);
                }
                CAPFile capfile = CAPFile.fromFile(Path.of((String)args.valueOf(OPT_INSTALL), new String[0]));
                if (args.has(OPT_VERBOSE)) {
                    capfile.dump(System.out);
                }
                GPRegistry gPRegistry = gp.getRegistry();
                if (args.has(OPT_FORCE) && gPRegistry.allPackageAIDs().contains(capfile.getPackageAID())) {
                    gp.deleteAID(capfile.getPackageAID(), true);
                }
                if (capfile.getAppletAIDs().isEmpty()) {
                    throw new IllegalArgumentException("CAP file has no applets!");
                }
                if (capfile.getAppletAIDs().size() > 1) {
                    if (!args.has(OPT_APPLET)) throw new IllegalArgumentException("CAP contains more than one applet, specify the right one with --" + String.valueOf(OPT_APPLET));
                    appaid = (AID)args.valueOf(OPT_APPLET);
                } else {
                    appaid = capfile.getAppletAIDs().get(0);
                }
                AID instanceaid = GPTool.optional(args, OPT_CREATE).orElse(appaid);
                EnumSet<GPRegistryEntry.Privilege> privs = GPTool.getPrivileges(args);
                GPTool.loadCAP(args, gp, capfile);
                if (args.has(OPT_FORCE) && gPRegistry.getDefaultSelectedAID().isPresent() && privs.contains(GPRegistryEntry.Privilege.CardReset)) {
                    System.err.println("NOTE: Force-removing current default selected applet instance: " + String.valueOf(gPRegistry.getDefaultSelectedAID().get()));
                    gp.deleteAID(gPRegistry.getDefaultSelectedAID().get(), false);
                }
                if (gp.getRegistry().allAppletAIDs().contains(instanceaid)) {
                    System.err.println("WARNING: Applet " + String.valueOf(instanceaid) + " already present on card");
                    if (args.has(OPT_FORCE)) {
                        gp.deleteAID(instanceaid, false);
                    }
                }
                byte[] params = args.has(OPT_PARAMS) ? ((HexBytes)args.valueOf(OPT_PARAMS)).value() : new byte[]{};
                gp.installAndMakeSelectable(capfile.getPackageAID(), appaid, instanceaid, privs, params);
            }
            if (args.has(OPT_CREATE) && !args.has(OPT_INSTALL)) {
                void var12_40;
                if (!args.has(OPT_FORCE) && !args.has(OPT_SAD)) {
                    this.warnIfNoDelegatedManagement(gp);
                }
                AID packageAID = null;
                Object var12_36 = null;
                if (cap != null) {
                    packageAID = cap.getPackageAID();
                    if (cap.getAppletAIDs().size() > 1 && !args.has(OPT_APPLET)) {
                        throw new IllegalArgumentException("There should be only one applet in CAP. Use --" + String.valueOf(OPT_APPLET) + " to specify one of " + String.valueOf(cap.getAppletAIDs()));
                    }
                    AID aID = cap.getAppletAIDs().get(0);
                }
                if (args.has(OPT_PACKAGE)) {
                    packageAID = (AID)args.valueOf(OPT_PACKAGE);
                }
                if (args.has(OPT_APPLET)) {
                    AID aID = (AID)args.valueOf(OPT_APPLET);
                }
                if (packageAID == null || var12_40 == null) {
                    throw new IllegalArgumentException("Need --" + String.valueOf(OPT_PACKAGE) + " and --" + String.valueOf(OPT_APPLET) + " or --" + String.valueOf(OPT_CAP));
                }
                AID instanceAID = (AID)args.valueOf(OPT_CREATE);
                if (gp.getRegistry().allAIDs().contains(var12_40)) {
                    System.err.println("WARNING: Applet " + String.valueOf(var12_40) + " already present on card");
                }
                EnumSet<GPRegistryEntry.Privilege> privs = GPTool.getPrivileges(args);
                byte[] params = GPTool.optional(args, OPT_PARAMS).map(HexBytes::value).orElse(new byte[0]);
                gp.installAndMakeSelectable(packageAID, (AID)var12_40, instanceAID, privs, params);
            }
            if (args.has(OPT_DOMAIN)) {
                void var12_44;
                AID appletAID;
                AID packageAID;
                byte[] params;
                BerTlvParser tlvparser = new BerTlvParser();
                Object var12_41 = null;
                if (args.has(OPT_PARAMS)) {
                    params = ((HexBytes)args.valueOf(OPT_PARAMS)).value();
                    try {
                        BerTlvs berTlvs = tlvparser.parse(params);
                    }
                    catch (Exception e6) {
                        if (args.has(OPT_ALLOW_FROM) || args.has(OPT_ALLOW_TO)) {
                            throw new IllegalArgumentException(String.valueOf(OPT_ALLOW_FROM) + " and " + String.valueOf(OPT_ALLOW_TO) + " not available, could not parse parameters: " + HexUtils.bin2hex(params));
                        }
                        System.err.println("Warning: could not parse parameters as TLV: " + HexUtils.bin2hex(params));
                    }
                } else {
                    params = new byte[]{};
                    BerTlvs berTlvs = tlvparser.parse(params);
                }
                if (args.has(OPT_PACKAGE) && args.has(OPT_APPLET)) {
                    packageAID = (AID)args.valueOf(OPT_PACKAGE);
                    appletAID = (AID)args.valueOf(OPT_APPLET);
                } else {
                    packageAID = gp.getRegistry().allPackageAIDs().contains(new AID("A0000000035350")) ? new AID("A0000000035350") : new AID("A0000001515350");
                    appletAID = gp.getRegistry().allPackageAIDs().contains(new AID("A0000000035350")) ? new AID("A000000003535041") : new AID("A000000151535041");
                    GPTool.verbose("Note: using detected default AID-s for SSD instantiation: " + String.valueOf(appletAID) + " from " + String.valueOf(packageAID));
                }
                AID instanceAID = (AID)args.valueOf(OPT_DOMAIN);
                EnumSet<GPRegistryEntry.Privilege> privs = GPTool.getPrivileges(args);
                privs.add(GPRegistryEntry.Privilege.SecurityDomain);
                if (!args.has(OPT_SAD) && !gp.getProfile().oldStyleSSDParameters()) {
                    if (var12_44 != null && var12_44.find(new BerTag(129)) == null) {
                        params = GPUtils.concatenate(params, {-127, 2, gp.getSecureChannel().scp.getValue(), (byte)gp.getSecureChannel().i});
                    } else {
                        System.err.println("Notice: 0x81 (secure channel) already in parameters or no parameters");
                    }
                }
                if (args.has(OPT_ALLOW_TO) && var12_44 != null) {
                    if (var12_44.find(new BerTag(130)) == null) {
                        params = GPUtils.concatenate(params, {-126, 2, 32, 32});
                    } else {
                        System.err.println("Warning: 0x82 already in parameters, " + String.valueOf(OPT_ALLOW_TO) + " not applied");
                    }
                }
                if (args.has(OPT_ALLOW_FROM) && var12_44 != null) {
                    if (var12_44.find(new BerTag(135)) == null) {
                        params = GPUtils.concatenate(params, {-121, 2, 32, 32});
                    } else {
                        System.err.println("Warning: 0x87 already in parameters, " + String.valueOf(OPT_ALLOW_FROM) + " not applied");
                    }
                }
                if (args.has(OPT_ALLOW_TO) && gp.getProfile().oldStyleSSDParameters()) {
                    params = HexUtils.hex2bin("C90145");
                }
                if (var12_44 != null || args.has(OPT_ALLOW_TO) || args.has(OPT_ALLOW_FROM)) {
                    GPTool.verbose(String.format("Final parameters: %s", HexUtils.bin2hex(params)));
                }
                gp.installAndMakeSelectable(packageAID, appletAID, instanceAID, privs, params);
            }
            if (args.has(OPT_MOVE)) {
                if (!args.has(OPT_FORCE) && !args.has(OPT_SAD)) {
                    this.warnIfNoDelegatedManagement(gp);
                }
                AID what = (AID)args.valueOf(OPT_MOVE);
                AID aID = (AID)args.valueOf(OPT_TO);
                gp.extradite(what, aID);
            }
            if (args.has(OPT_STORE_DATA)) {
                blobs = args.valuesOf(OPT_STORE_DATA).stream().map(HexBytes::value).collect(Collectors.toList());
                for (byte[] blob : blobs) {
                    if (args.has(OPT_APPLET)) {
                        gp.personalize((AID)args.valueOf(OPT_APPLET), blob, 1);
                        continue;
                    }
                    gp.storeData(blob, 1);
                }
            }
            if (args.has(OPT_STORE_DATA_CHUNK)) {
                blobs = args.valuesOf(OPT_STORE_DATA_CHUNK).stream().map(HexBytes::value).collect(Collectors.toList());
                if (args.has(OPT_APPLET)) {
                    gp.personalize((AID)args.valueOf(OPT_APPLET), blobs, 1);
                } else {
                    gp.storeData(blobs, 1);
                }
            }
            if (args.has(OPT_STORE_DGI_FILE)) {
                Function<byte[], DGIData.Type> oracle = GPTool.paddingOracle(args);
                List<DGIData> list = DGIData.parse(((File)args.valueOf(OPT_STORE_DGI_FILE)).toPath(), oracle);
                for (int i = 0; i < list.size(); ++i) {
                    byte[] payload;
                    int p1;
                    DGIData dgi = list.get(i);
                    int n = p1 = dgi.type() == DGIData.Type.PLAINTEXT ? 0 : 96;
                    byte[] byArray = dgi.type() == DGIData.Type.PADDING ? GPCrypto.pad80(dgi.value(), gp.getSecureChannel().scp == GPSecureChannelVersion.SCP.SCP03 ? 16 : 8) : (payload = dgi.value());
                    if (dgi.type() != DGIData.Type.PLAINTEXT) {
                        payload = gp.encryptDEK(payload);
                    }
                    payload = GPUtils.concatenate(dgi.tag(), DGIData.length(payload.length), payload);
                    p1 = i == list.size() - 1 ? p1 | 0x80 : p1 & 0x7F;
                    CommandAPDU store = new CommandAPDU(-128, -30, p1, i, payload, 256);
                    GPException.check(gp.transmit(store), "STORE DATA failed", new int[0]);
                }
            }
            if (args.has(OPT_LOCK_CARD)) {
                gp.setCardStatus(GPRegistryEntry.ISDLifeCycle.CARD_LOCKED);
            }
            if (args.has(OPT_UNLOCK_CARD)) {
                gp.setCardStatus(GPRegistryEntry.ISDLifeCycle.SECURED);
            }
            if (args.has(OPT_INITIALIZE_CARD)) {
                gp.setCardStatus(GPRegistryEntry.ISDLifeCycle.INITIALIZED);
            }
            if (args.has(OPT_SECURE_CARD)) {
                GPRegistryEntry isd = gp.getRegistry().getISD().orElseThrow(() -> new GPException("ISD not present, are you in a subtree?"));
                GPRegistryEntry.ISDLifeCycle iSDLifeCycle = GPRegistryEntry.ByteEnum.fromByte(GPRegistryEntry.ISDLifeCycle.class, isd.getLifeCycle());
                if (iSDLifeCycle == GPRegistryEntry.ISDLifeCycle.OP_READY && args.has(OPT_FORCE)) {
                    System.out.println("Note: forcing status to INITIALIZED");
                    gp.setCardStatus(GPRegistryEntry.ISDLifeCycle.INITIALIZED);
                }
                gp.setCardStatus(GPRegistryEntry.ISDLifeCycle.SECURED);
            }
            if (args.has(OPT_LOCK_APPLET)) {
                gp.lockUnlockApplet((AID)args.valueOf(OPT_LOCK_APPLET), true);
            }
            if (args.has(OPT_UNLOCK_APPLET)) {
                gp.lockUnlockApplet((AID)args.valueOf(OPT_UNLOCK_APPLET), false);
            }
            if (args.has(OPT_LIST)) {
                GPCommands.listRegistry(gp.getRegistry(), System.out, args.has(OPT_VERBOSE));
            }
            if (args.has(OPT_DELETE_KEY)) {
                int keyver = (Integer)args.valueOf(OPT_DELETE_KEY);
                System.out.println("Deleting key " + GPUtils.intString(keyver));
                gp.deleteKey(keyver, null);
            }
            if (args.has(OPT_LOCK) || args.has(OPT_LOCK_ENC) || args.has(OPT_LOCK_MAC) || args.has(OPT_LOCK_DEK)) {
                void var12_52;
                Optional<GPCardKeys> lockKey;
                boolean bl = true;
                String kdf = PlaintextKeys.kdf_templates.getOrDefault(args.valueOf(OPT_LOCK_KDF), (String)args.valueOf(OPT_LOCK_KDF));
                if (args.has(OPT_LOCK)) {
                    lockKey = GPTool.keyFromPlugin((String)args.valueOf(OPT_LOCK));
                } else {
                    if (!args.has(OPT_LOCK_ENC) || !args.has(OPT_LOCK_MAC) || !args.has(OPT_LOCK_DEK)) throw new IllegalArgumentException("Use either --lock or --lock-enc/mac/dek");
                    lockKey = Optional.of(PlaintextKeys.fromKeys(((HexBytes)args.valueOf(OPT_LOCK_ENC)).value(), ((HexBytes)args.valueOf(OPT_LOCK_MAC)).value(), ((HexBytes)args.valueOf(OPT_LOCK_DEK)).value()));
                }
                GPCardKeys newKeys = lockKey.orElseThrow(() -> new IllegalArgumentException("Can not lock without keys :)"));
                if (newKeys instanceof PlaintextKeys) {
                    int keyver;
                    PlaintextKeys pk = (PlaintextKeys)newKeys;
                    List<GPKeyInfo> current = gp.getKeyInfoTemplate();
                    if (kdf != null) {
                        pk.setDiversifier(kdf);
                    }
                    if (args.has(OPT_NEW_KEY_VERSION)) {
                        keyver = (Integer)args.valueOf(OPT_NEW_KEY_VERSION);
                        if (current.stream().noneMatch(e -> e.getVersion() == keyver) || gp.getScpKeyVersion() == 255) {
                            boolean bl4 = false;
                        }
                    } else if (current.isEmpty() || gp.getScpKeyVersion() == 255) {
                        keyver = 1;
                        boolean bl5 = false;
                    } else {
                        keyver = gp.getScpKeyVersion();
                    }
                    pk.setVersion(keyver);
                }
                int keyver = newKeys.getKeyInfo().getVersion();
                GPTool.verbose("Keyset version: " + keyver);
                byte[] kdd = newKeys.getKDD().orElseGet(() -> keys.getKDD().get());
                GPTool.verbose("Looking at key version for diversification method");
                if (keyver >= 16 && keyver <= 31) {
                    newKeys.diversify(GPSecureChannelVersion.SCP.SCP01, kdd);
                } else if (keyver >= 32 && keyver <= 47) {
                    newKeys.diversify(GPSecureChannelVersion.SCP.SCP02, kdd);
                } else if (keyver >= 48 && keyver <= 63) {
                    newKeys.diversify(GPSecureChannelVersion.SCP.SCP03, kdd);
                } else {
                    newKeys.diversify(gp.getSecureChannel().scp, kdd);
                }
                gp.putKeys(newKeys, (boolean)var12_52);
                if (args.has(OPT_LOCK) && newKeys instanceof PlaintextKeys) {
                    PlaintextKeys pk = (PlaintextKeys)newKeys;
                    if (pk.getMasterKey().isPresent()) {
                        System.out.println(String.valueOf(gp.getAID()) + " locked with: " + HexUtils.bin2hex(pk.getMasterKey().get()));
                    }
                    if (pk.getTemplate() != null) {
                        System.out.println("Keys were diversified with " + pk.getTemplate() + " and " + HexUtils.bin2hex(kdd));
                    }
                    System.out.println("Write this down, DO NOT FORGET/LOSE IT!");
                } else {
                    System.out.println("Card locked with new keys.");
                    System.out.println("Write them down, DO NOT FORGET/LOSE THEM!");
                }
            }
            if (args.has(OPT_MAKE_DEFAULT)) {
                gp.makeDefaultSelected((AID)args.valueOf(OPT_MAKE_DEFAULT));
            }
            if (args.has(OPT_RENAME_ISD)) {
                gp.renameISD((AID)args.valueOf(OPT_RENAME_ISD));
            }
            if (args.has(OPT_SET_PRE_PERSO)) {
                byte[] payload = ((HexBytes)args.valueOf(OPT_SET_PRE_PERSO)).value();
                if (args.has(OPT_TODAY)) {
                    System.arraycopy(CPLC.today(), 0, payload, 2, 2);
                }
                GPCommands.setPrePerso(gp, payload);
            }
            if (!args.has(OPT_SET_PERSO)) return 0;
            byte[] payload = ((HexBytes)args.valueOf(OPT_SET_PERSO)).value();
            if (args.has(OPT_TODAY)) {
                System.arraycopy(CPLC.today(), 0, payload, 2, 2);
            }
            GPCommands.setPerso(gp, payload);
            return 0;
        }
        catch (IOException e7) {
            System.err.println("ERROR: " + e7.getMessage());
            GPTool.trace(e7);
            return 1;
        }
        catch (ReceiptVerifier.ReceiptVerificationException e8) {
            System.err.println("WARNING: Operation completed, but receipt verification failed");
            return 1;
        }
        catch (GeneralSecurityException e9) {
            throw new RuntimeException(e9);
        }
    }

    private void warnIfNoDelegatedManagement(GPSession session) throws IOException {
        if (session.getCurrentDomain().hasPrivilege(GPRegistryEntry.Privilege.DelegatedManagement) && !session.delegatedManagementEnabled()) {
            System.err.println("# Warning: specify delegated management key or token with --dm-key/--dm-token");
        }
    }

    private static Optional<GPCardKeys> keyFromPlugin(String spec) {
        try {
            ServiceLoader<CardKeysProvider> sl = ServiceLoader.load(CardKeysProvider.class, GPTool.class.getClassLoader());
            ArrayList list = new ArrayList();
            sl.iterator().forEachRemaining(list::add);
            return list.stream().map(e -> e.getCardKeys(spec)).filter(Optional::isPresent).map(Optional::get).findFirst();
        }
        catch (ServiceConfigurationError e2) {
            System.err.println("Could not load key provider: " + e2.getMessage());
            return Optional.empty();
        }
    }

    private static void loadCAP(OptionSet args, GPSession gp, CAPFile capFile) throws GPException, IOException {
        try {
            byte[] signature;
            boolean dapRequired;
            AID to = GPTool.optional(args, OPT_TO).orElse(gp.getAID());
            GPRegistryEntry targetDomain = gp.getRegistry().getDomain(to).orElseThrow(() -> new IllegalArgumentException("Target domain does not exist: " + String.valueOf(to)));
            GPData.LFDBH lfdbh = args.has(OPT_SHA256) ? GPData.LFDBH.SHA256 : (args.has(OPT_HASH) ? (GPData.LFDBH)((Object)args.valueOf(OPT_HASH)) : null);
            AID dapAid = null;
            Optional<GPRegistryEntry> dapDomain = gp.getRegistry().allDomains().stream().filter(dapDomainFilter).findFirst();
            if (dapDomain.isPresent()) {
                GPRegistryEntry entry = dapDomain.get();
                String privs = entry.getPrivileges().stream().filter(dapPrivileges).map(Enum::toString).collect(Collectors.joining(", "));
                System.out.println("# Found DAP domain: " + String.valueOf(entry.getAID()) + " (" + privs + "); override with --" + String.valueOf(OPT_DAP_DOMAIN));
                dapAid = entry.getAID();
            }
            if (args.has(OPT_DAP_DOMAIN)) {
                AID finalDapAid = dapAid = (AID)args.valueOf(OPT_DAP_DOMAIN);
                GPRegistryEntry dapTarget = gp.getRegistry().getDomain(dapAid).orElseThrow(() -> new IllegalArgumentException("DAP domain does not exist: " + String.valueOf(finalDapAid)));
                if (!dapTarget.hasPrivilege(GPRegistryEntry.Privilege.DAPVerification) && !dapTarget.hasPrivilege(GPRegistryEntry.Privilege.MandatedDAPVerification)) {
                    String message = "Specified DAP domain does not have (Mandated)DAPVerification privilege: " + String.valueOf(dapAid);
                    if (args.has(OPT_FORCE)) {
                        System.err.println("Warning: " + message);
                    } else {
                        throw new IllegalArgumentException(message);
                    }
                }
            }
            boolean bl = dapRequired = targetDomain.hasPrivilege(GPRegistryEntry.Privilege.DAPVerification) || gp.getRegistry().allDomains().stream().anyMatch(e -> e.hasPrivilege(GPRegistryEntry.Privilege.MandatedDAPVerification)) || args.has(OPT_DAP_DOMAIN);
            if (dapRequired) {
                if (args.has(OPT_DAP_SIGNATURE)) {
                    signature = ((HexBytes)args.valueOf(OPT_DAP_SIGNATURE)).value();
                } else if (args.has(OPT_DAP_KEY)) {
                    Key dapKey = (Key)args.valueOf(OPT_DAP_KEY);
                    if (dapKey.getPrivate().isEmpty()) {
                        throw new IllegalArgumentException("Invalid DAP key: " + String.valueOf(dapKey));
                    }
                    signature = DAPSigner.sign(capFile, dapKey.getPrivate().get(), Optional.ofNullable(lfdbh).orElse(GPData.LFDBH.SHA256));
                } else {
                    if (!args.has(OPT_FORCE)) {
                        throw new IllegalArgumentException("Need DAP signature!");
                    }
                    signature = null;
                }
            } else {
                signature = null;
            }
            if (targetDomain.hasPrivilege(GPRegistryEntry.Privilege.DelegatedManagement) || dapRequired || lfdbh != null) {
                lfdbh = Optional.ofNullable(lfdbh).orElse(GPData.LFDBH.SHA256);
            }
            gp.loadCapFile(capFile, to, dapAid, signature, lfdbh);
            System.out.printf("%s loaded: %s %s%n", capFile.getFile().map(Path::toString).orElse("CAP"), capFile.getPackageName(), capFile.getPackageAID());
        }
        catch (GPException e2) {
            switch (e2.sw) {
                case 27264: {
                    System.err.println("Applet loading failed. Are you sure the card can handle it?");
                    break;
                }
                case 27013: {
                    System.err.println("Applet loading not allowed. Are you sure the domain can accept it?");
                    break;
                }
            }
            throw e2;
        }
        catch (GeneralSecurityException e3) {
            throw new GPException("Failed to generate DAP signature: " + e3.getMessage(), e3);
        }
    }

    static List<Integer> split(String s) {
        if ((s = s.replaceAll("\\s+", "").replaceAll("0[xX]", "")).contains(",") && s.length() > 4) {
            String[] parts = s.split(",");
            ArrayList<Integer> result = new ArrayList<Integer>();
            for (String part : parts) {
                result.add(GPTool.hex2int(part));
            }
            return result;
        }
        return Collections.singletonList(GPTool.hex2int(s));
    }

    static int hex2int(String s) {
        try {
            int value = Integer.parseInt(s, 16);
            if (value < 0 || value > 65535) {
                throw new IllegalArgumentException("Value out of range (0x0000-0xFFFF): 0x" + Integer.toHexString(value));
            }
            return value;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid hex: " + s);
        }
    }

    private static Function<byte[], DGIData.Type> paddingOracle(OptionSet args) {
        Set padded = args.valuesOf(OPT_DGI_PADDED).stream().flatMap(s -> GPTool.split(s).stream()).collect(Collectors.toSet());
        Set unpadded = args.valuesOf(OPT_DGI_UNPADDED).stream().flatMap(s -> GPTool.split(s).stream()).collect(Collectors.toSet());
        return s -> {
            int k = (s[0] & 0xFF) << 8 | s[1] & 0xFF;
            if (padded.contains(k)) {
                return DGIData.Type.PADDING;
            }
            if (unpadded.contains(k)) {
                return DGIData.Type.NOPADDING;
            }
            return DGIData.Type.PLAINTEXT;
        };
    }

    private static EnumSet<GPRegistryEntry.Privilege> getPrivileges(OptionSet args) {
        EnumSet<GPRegistryEntry.Privilege> privs = EnumSet.noneOf(GPRegistryEntry.Privilege.class);
        if (args.has(OPT_PRIVS)) {
            for (String p : args.valuesOf(OPT_PRIVS)) {
                for (String s : p.split(",")) {
                    privs.add(GPRegistryEntry.Privilege.lookup(s.trim()).orElseThrow(() -> new IllegalArgumentException("Unknown privilege: " + s.trim() + "\nValid values are: " + Arrays.stream(GPRegistryEntry.Privilege.values()).map(Enum::toString).collect(Collectors.joining(", ")))));
                }
            }
        }
        return privs;
    }

    private static List<CAPFile> getCapFileList(OptionSet args, OptionSpec<File> arg) {
        return args.valuesOf(arg).stream().map(File::toPath).map(e -> {
            try {
                return CAPFile.fromFile(e);
            }
            catch (IOException x) {
                throw new IllegalArgumentException("Could not read CAP: " + x.getMessage());
            }
        }).collect(Collectors.toList());
    }

    private static boolean needsAuthentication(OptionSet args) {
        OptionSpec[] yes = new OptionSpec[]{OPT_CONNECT, OPT_LIST, OPT_LOAD, OPT_INSTALL, OPT_INSTALL_ONLY, OPT_DELETE, OPT_DELETE_KEY, OPT_CREATE, OPT_LOCK, OPT_LOCK_ENC, OPT_LOCK_MAC, OPT_LOCK_DEK, OPT_MAKE_DEFAULT, OPT_UNINSTALL, OPT_SECURE_APDU, OPT_DOMAIN, OPT_LOCK_CARD, OPT_UNLOCK_CARD, OPT_LOCK_APPLET, OPT_UNLOCK_APPLET, OPT_STORE_DATA, OPT_STORE_DATA_CHUNK, OPT_INITIALIZE_CARD, OPT_SECURE_CARD, OPT_RENAME_ISD, OPT_SET_PERSO, OPT_SET_PRE_PERSO, OPT_MOVE, OPT_PUT_KEY, OPT_REPLACE_KEY, OPT_STORE_DGI_FILE};
        return Arrays.stream(yes).anyMatch(args::has);
    }

    private static void verbose(String s) {
        if (isVerbose) {
            System.out.println("# " + s);
        }
    }

    private static void trace(Exception e) {
        if (isTrace) {
            e.printStackTrace();
        }
    }

    static class InstallDefinition {
        final CAPFile cap;
        final AID pkg;
        final AID applet;
        final AID instance;

        private InstallDefinition(CAPFile cap, AID pkg, AID applet, AID instance) {
            this.cap = cap;
            this.pkg = pkg;
            this.applet = applet;
            this.instance = instance;
        }

        static InstallDefinition fromOptions(GPRegistry registry, OptionSet args) throws IOException {
            AID instance;
            AID applet;
            AID pkg;
            CAPFile cap;
            String pathOrAid = GPCommandLineInterface.optional(args, GPCommandLineInterface.OPT_INSTALL_ONLY).orElse(args.valueOf(GPCommandLineInterface.OPT_INSTALL));
            Path p = Paths.get(pathOrAid, new String[0]);
            if (Files.exists(p, new LinkOption[0]) || args.has(GPCommandLineInterface.OPT_CAP)) {
                if (Files.exists(p, new LinkOption[0]) && args.has(GPCommandLineInterface.OPT_CAP)) {
                    throw new IllegalArgumentException("Can't have --cap and --install(-only) refer to a capfile");
                }
                if (args.has(GPCommandLineInterface.OPT_CAP)) {
                    p = args.valueOf(GPCommandLineInterface.OPT_CAP).toPath();
                }
                cap = CAPFile.fromFile(p);
                pkg = cap.getPackageAID();
                if (cap.getAppletAIDs().size() == 0) {
                    throw new IllegalArgumentException("Missing UX: load library capfiles with --load");
                }
                if (cap.getAppletAIDs().size() == 1) {
                    if (args.has(GPCommandLineInterface.OPT_APPLET) && !args.valueOf(GPCommandLineInterface.OPT_APPLET).equals(cap.getAppletAIDs().get(0))) {
                        throw new IllegalArgumentException(String.format("Capfile %s does not contain applet %s (has %s)", p, args.valueOf(GPCommandLineInterface.OPT_APPLET), cap.getAppletAIDs()));
                    }
                    applet = cap.getAppletAIDs().get(0);
                } else {
                    AID candidate = GPCommandLineInterface.optional(args, GPCommandLineInterface.OPT_APPLET).orElseThrow(() -> new IllegalArgumentException("Specify applet tp install with --applet"));
                    if (!cap.getAppletAIDs().contains(candidate)) {
                        throw new IllegalArgumentException(String.format("Specify applet to install with --applet (has %s)", cap.getAppletAIDs()));
                    }
                    applet = candidate;
                }
                instance = applet;
            } else {
                instance = AID.fromString(pathOrAid);
                cap = null;
                AID searchFor = GPCommandLineInterface.optional(args, GPCommandLineInterface.OPT_APPLET).orElse(instance);
                pkg = args.has(GPCommandLineInterface.OPT_PACKAGE) ? args.valueOf(GPCommandLineInterface.OPT_PACKAGE) : registry.byModule(searchFor).map(GPRegistryEntry::getAID).orElseThrow(() -> new IllegalArgumentException("Specify applet to load with --applet"));
                applet = searchFor;
            }
            return new InstallDefinition(cap, pkg, applet, instance);
        }
    }
}

