/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.gp;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.javacard.capfile.AID;
import pro.javacard.gp.GPCardProfile;
import pro.javacard.gp.GPDataException;
import pro.javacard.gp.GPException;
import pro.javacard.gp.GPRegistryEntry;
import pro.javacard.gp.GPUtils;
import pro.javacard.gp.data.BitField;
import pro.javacard.tlv.TLV;
import pro.javacard.tlv.Tag;

public final class GPRegistry
implements Iterable<GPRegistryEntry> {
    private static final Logger logger = LoggerFactory.getLogger(GPRegistry.class);
    final ArrayList<GPRegistryEntry> entries = new ArrayList();

    public void add(GPRegistryEntry entry) {
        if (entry.hasPrivilege(GPRegistryEntry.Privilege.SecurityDomain) && entry.getType() == GPRegistryEntry.Kind.APP) {
            entry.setType(GPRegistryEntry.Kind.SSD);
        }
        if (!this.entries.contains(entry)) {
            this.entries.add(entry);
        } else if (entry.getType() != GPRegistryEntry.Kind.PKG) {
            logger.warn("Registry already contains {}", (Object)entry);
        }
    }

    public List<GPRegistryEntry> byDomain(AID domain) {
        return this.entries.stream().filter(e -> e.getDomain().equals(Optional.of(domain))).toList();
    }

    public Optional<GPRegistryEntry> byModule(AID applet) {
        return this.entries.stream().filter(e -> e.getModules().contains(applet)).findFirst();
    }

    @Override
    public Iterator<GPRegistryEntry> iterator() {
        return this.entries.iterator();
    }

    public List<GPRegistryEntry> allPackages() {
        return this.entries.stream().filter(GPRegistryEntry::isPackage).collect(Collectors.toList());
    }

    public List<AID> allPackageAIDs() {
        return this.allPackages().stream().map(GPRegistryEntry::getAID).collect(Collectors.toList());
    }

    public List<AID> allAppletAIDs() {
        return this.allApplets().stream().map(GPRegistryEntry::getAID).collect(Collectors.toList());
    }

    public List<AID> allAIDs() {
        return this.entries.stream().map(GPRegistryEntry::getAID).collect(Collectors.toList());
    }

    public Optional<GPRegistryEntry> getDomain(AID aid) {
        return this.allDomains().stream().filter(e -> e.aid.equals(aid)).reduce(GPRegistry.onlyOne());
    }

    public List<GPRegistryEntry> allApplets() {
        return this.entries.stream().filter(GPRegistryEntry::isApplet).collect(Collectors.toList());
    }

    public List<GPRegistryEntry> allDomains() {
        return this.entries.stream().filter(GPRegistryEntry::isDomain).collect(Collectors.toList());
    }

    public Optional<AID> getDefaultSelectedAID() {
        return this.allApplets().stream().filter(e -> e.hasPrivilege(GPRegistryEntry.Privilege.CardReset)).map(GPRegistryEntry::getAID).reduce(GPRegistry.onlyOne());
    }

    public Optional<AID> getDefaultSelectedPackageAID() {
        Optional<AID> defaultAID = this.getDefaultSelectedAID();
        if (defaultAID.isPresent()) {
            return this.allPackages().stream().filter(e -> e.getModules().contains(defaultAID.get())).map(GPRegistryEntry::getAID).reduce(GPRegistry.onlyOne());
        }
        return defaultAID;
    }

    public Optional<GPRegistryEntry> getISD() {
        return this.allDomains().stream().filter(e -> e.getType() == GPRegistryEntry.Kind.ISD).reduce(GPRegistry.onlyOne());
    }

    private void populate_legacy(int p1, byte[] data, GPRegistryEntry.Kind type, GPCardProfile spec) throws GPDataException {
        int offset = 0;
        try {
            while (offset < data.length) {
                int len = data[offset++];
                AID aid = new AID(data, offset, len);
                offset += len;
                byte lifecycle = data[offset++];
                byte privileges = data[offset++];
                GPRegistryEntry e = new GPRegistryEntry();
                if (type == GPRegistryEntry.Kind.ISD || type == GPRegistryEntry.Kind.APP) {
                    e.setType(type);
                    e.setAID(aid);
                    e.setPrivileges(BitField.parse(GPRegistryEntry.Privilege.class, new byte[]{privileges}, 1, 3));
                    e.setLifeCycle(lifecycle);
                } else if (type == GPRegistryEntry.Kind.PKG) {
                    if (privileges != 0) {
                        throw new GPDataException(String.format("Privileges of Load File is not 0x00 but %02X", privileges & 0xFF));
                    }
                    e.setAID(aid);
                    e.setLifeCycle(lifecycle);
                    e.setType(type);
                    if (spec.doesReportModules() && p1 != 32) {
                        int num = data[offset++];
                        for (int i = 0; i < num; ++i) {
                            len = data[offset++] & 0xFF;
                            aid = new AID(data, offset, len);
                            offset += len;
                            e.addModule(aid);
                        }
                    }
                }
                this.add(e);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new GPDataException("Invalid response to GET STATUS", e);
        }
    }

    private void populate_tags(byte[] data, GPRegistryEntry.Kind type) throws GPDataException {
        List<TLV> tlvs = TLV.parse(data);
        GPUtils.trace_tlv(data, logger);
        for (TLV t : TLV.findAll(tlvs, Tag.ber(227))) {
            GPRegistryEntry e = new GPRegistryEntry();
            if (t.hasChildren()) {
                TLV versiontag;
                Object cfb;
                TLV privstag;
                TLV lifecycletag;
                TLV aid = t.find(Tag.ber(79));
                if (aid != null) {
                    AID aidv = new AID(aid.value());
                    e.setAID(aidv);
                }
                if ((lifecycletag = t.find(Tag.ber(159, 112))) != null) {
                    e.setLifeCycle(lifecycletag.value()[0]);
                }
                if ((privstag = t.find(Tag.ber(197))) != null) {
                    e.setPrivileges(BitField.parse(GPRegistryEntry.Privilege.class, privstag.value(), 1, 3));
                }
                for (TLV cf : t.findAll(Tag.ber(207))) {
                    cfb = cf.value();
                    if (((byte[])cfb).length != 1) {
                        throw new GPDataException("Tag CF not single byte", (byte[])cfb);
                    }
                    int v = cfb[0] & 0xFF;
                    int c = v & 0x1F;
                    if ((v & 0x80) == 128) {
                        e.implicitContactless.add(c);
                        continue;
                    }
                    if ((v & 0x40) != 64) continue;
                    e.implicitContact.add(c);
                }
                TLV loadfiletag = t.find(Tag.ber(196));
                if (loadfiletag != null) {
                    e.setLoadFile(new AID(loadfiletag.value()));
                }
                if ((versiontag = t.find(Tag.ber(206))) != null) {
                    e.setVersion(versiontag.value());
                }
                cfb = t.findAll(Tag.ber(132)).iterator();
                while (cfb.hasNext()) {
                    TLV lf = (TLV)cfb.next();
                    e.addModule(new AID(lf.value()));
                }
                TLV domaintag = t.find(Tag.ber(204));
                if (domaintag != null) {
                    e.setDomain(new AID(domaintag.value()));
                }
            }
            e.setType(type);
            this.add(e);
        }
    }

    public void parse_and_populate(int p1, byte[] data, GPRegistryEntry.Kind type, GPCardProfile profile) throws GPDataException {
        if (profile.getStatusUsesTags()) {
            this.populate_tags(data, type);
        } else {
            this.populate_legacy(p1, data, type, profile);
        }
    }

    public static <T> BinaryOperator<T> onlyOne() {
        return GPRegistry.onlyOne(() -> new GPException("Expected only one"));
    }

    public static <T, E extends RuntimeException> BinaryOperator<T> onlyOne(Supplier<E> exception) {
        return (e, o) -> {
            throw (RuntimeException)exception.get();
        };
    }
}

