/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.tlv;

import java.util.ArrayList;
import pro.javacard.tlv.BERTag;
import pro.javacard.tlv.Len;
import pro.javacard.tlv.TLV;
import pro.javacard.tlv.Tag;

public final class TLVEncoder {
    private TLVEncoder() {
    }

    public static byte[] encode(TLV tlv) {
        byte[] valueBytes;
        Tag tag = tlv.tag();
        byte[] tagBytes = tag.bytes();
        if (tlv.hasChildren()) {
            ArrayList<byte[]> kids = new ArrayList<byte[]>();
            int total = 0;
            for (TLV child : tlv.children()) {
                byte[] kid = TLVEncoder.encode(child);
                total += kid.length;
                kids.add(kid);
            }
            valueBytes = new byte[total];
            int offset = 0;
            for (byte[] kid : kids) {
                System.arraycopy(kid, 0, valueBytes, offset, kid.length);
                offset += kid.length;
            }
        } else {
            valueBytes = tlv.value();
        }
        byte[] lengthBytes = tag instanceof BERTag ? Len.ber(valueBytes.length) : Len.ext(valueBytes.length);
        byte[] result = new byte[tagBytes.length + lengthBytes.length + valueBytes.length];
        System.arraycopy(tagBytes, 0, result, 0, tagBytes.length);
        System.arraycopy(lengthBytes, 0, result, tagBytes.length, lengthBytes.length);
        System.arraycopy(valueBytes, 0, result, tagBytes.length + lengthBytes.length, valueBytes.length);
        return result;
    }
}

