/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.tlv;

import java.util.HexFormat;
import pro.javacard.tlv.BERTag;
import pro.javacard.tlv.DGITag;
import pro.javacard.tlv.SimpleTag;

public interface Tag {
    public byte[] bytes();

    default public String toHex() {
        return "[" + HexFormat.of().withUpperCase().formatHex(this.bytes()) + "]";
    }

    public static Tag ber(byte ... bytes) {
        return new BERTag(bytes);
    }

    public static Tag ber(String hex) {
        return new BERTag(HexFormat.of().parseHex(hex.replaceAll("\\s", "")));
    }

    public static Tag ber(int b1) {
        return new BERTag(new byte[]{(byte)b1});
    }

    public static Tag ber(int b1, int b2) {
        return new BERTag(new byte[]{(byte)b1, (byte)b2});
    }

    public static Tag simple(byte b) {
        return new SimpleTag(b);
    }

    public static Tag dgi(int dgi) {
        return new DGITag(dgi);
    }

    public static enum Type {
        BER,
        SIMPLE,
        DGI;

    }
}

