/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.chardet.prober.sequence;

import org.glavo.chardet.DetectedCharset;

public abstract class SequenceModel {
    protected short[] charToOrderMap;
    protected byte[] precedenceMatrix;
    protected float typicalPositiveRatio;
    protected boolean keepEnglishLetter;
    protected DetectedCharset charset;

    public SequenceModel(short[] charToOrderMap, byte[] precedenceMatrix, float typicalPositiveRatio, boolean keepEnglishLetter, DetectedCharset charset) {
        this.charToOrderMap = (short[])charToOrderMap.clone();
        this.precedenceMatrix = (byte[])precedenceMatrix.clone();
        this.typicalPositiveRatio = typicalPositiveRatio;
        this.keepEnglishLetter = keepEnglishLetter;
        this.charset = charset;
    }

    public short getOrder(byte b) {
        int c = b & 0xFF;
        return this.charToOrderMap[c];
    }

    public byte getPrecedence(int pos) {
        return this.precedenceMatrix[pos];
    }

    public float getTypicalPositiveRatio() {
        return this.typicalPositiveRatio;
    }

    public boolean getKeepEnglishLetter() {
        return this.keepEnglishLetter;
    }

    public DetectedCharset getCharset() {
        return this.charset;
    }
}

