/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.setting;

import java.net.MalformedURLException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.text.Font;
import org.jackhuang.hmcl.Metadata;
import org.jackhuang.hmcl.setting.ConfigHolder;
import org.jackhuang.hmcl.util.Lazy;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.i18n.LocaleUtils;
import org.jackhuang.hmcl.util.io.JarUtils;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jackhuang.hmcl.util.platform.OperatingSystem;
import org.jackhuang.hmcl.util.platform.SystemUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FontManager {
    public static final String[] FONT_EXTENSIONS = new String[]{"ttf", "otf", "woff"};
    public static final double DEFAULT_FONT_SIZE = 12.0;
    private static final Lazy<Font> DEFAULT_FONT = new Lazy<Font>(() -> {
        String fcMatchPattern;
        Font font = FontManager.tryLoadLocalizedFont(Metadata.HMCL_CURRENT_DIRECTORY.resolve("font"));
        if (font != null) {
            return font;
        }
        font = FontManager.tryLoadLocalizedFont(Metadata.HMCL_GLOBAL_DIRECTORY.resolve("font"));
        if (font != null) {
            return font;
        }
        font = FontManager.tryLoadDefaultFont(Metadata.HMCL_CURRENT_DIRECTORY);
        if (font != null) {
            return font;
        }
        font = FontManager.tryLoadDefaultFont(Metadata.CURRENT_DIRECTORY);
        if (font != null) {
            return font;
        }
        font = FontManager.tryLoadDefaultFont(Metadata.HMCL_GLOBAL_DIRECTORY);
        if (font != null) {
            return font;
        }
        Path thisJar = JarUtils.thisJarPath();
        if (thisJar != null && thisJar.getParent() != null && (font = FontManager.tryLoadDefaultFont(thisJar.getParent())) != null) {
            return font;
        }
        if (OperatingSystem.CURRENT_OS.isLinuxOrBSD() && !(fcMatchPattern = I18n.getLocale().getFcMatchPattern()).isEmpty()) {
            return FontManager.findByFcMatch(fcMatchPattern);
        }
        return null;
    });
    private static final ObjectProperty<FontReference> font = new SimpleObjectProperty();

    private static void updateFont() {
        String fontFamily = ConfigHolder.config().getLauncherFontFamily();
        if (fontFamily == null) {
            fontFamily = System.getProperty("hmcl.font.override");
        }
        if (fontFamily == null) {
            fontFamily = System.getenv("HMCL_FONT");
        }
        if (fontFamily == null) {
            Font defaultFont = DEFAULT_FONT.get();
            font.set((Object)(defaultFont != null ? new FontReference(defaultFont) : null));
        } else {
            font.set((Object)new FontReference(fontFamily));
        }
    }

    private static Font tryLoadDefaultFont(Path dir) {
        for (String extension : FONT_EXTENSIONS) {
            Path path = dir.resolve("font." + extension);
            if (!Files.isRegularFile(path, new LinkOption[0])) continue;
            Logger.LOG.info("Load font file: " + String.valueOf(path));
            try {
                Font font = Font.loadFont((String)path.toUri().toURL().toExternalForm(), (double)12.0);
                if (font != null) {
                    return font;
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            Logger.LOG.warning("Failed to load font " + String.valueOf(path));
        }
        return null;
    }

    private static Font tryLoadLocalizedFont(Path dir) {
        Map<String, Map<String, Path>> fontFiles = LocaleUtils.findAllLocalizedFiles(dir, "font", Set.of(FONT_EXTENSIONS));
        if (fontFiles.isEmpty()) {
            return null;
        }
        List<Locale> candidateLocales = I18n.getLocale().getCandidateLocales();
        for (Locale locale : candidateLocales) {
            Map<String, Path> extToFiles = fontFiles.get(LocaleUtils.toLanguageKey(locale));
            if (extToFiles == null) continue;
            for (String ext : FONT_EXTENSIONS) {
                Path fontFile = extToFiles.get(ext);
                if (fontFile == null) continue;
                Logger.LOG.info("Load font file: " + String.valueOf(fontFile));
                try {
                    Font font = Font.loadFont((String)fontFile.toAbsolutePath().normalize().toUri().toURL().toExternalForm(), (double)12.0);
                    if (font != null) {
                        return font;
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                Logger.LOG.warning("Failed to load font " + String.valueOf(fontFile));
            }
        }
        return null;
    }

    public static Font findByFcMatch(String pattern) {
        Path fcMatch = SystemUtils.which("fc-match");
        if (fcMatch == null) {
            return null;
        }
        try {
            String result = SystemUtils.run(fcMatch.toString(), pattern, "--format", "%{family}\\n%{file}").trim();
            String[] results = result.split("\\n");
            if (results.length != 2 || results[0].isEmpty() || results[1].isEmpty()) {
                Logger.LOG.warning("Unexpected output from fc-match: " + result);
                return null;
            }
            String family = results[0].trim();
            String path = results[1];
            Path file = Paths.get(path, new String[0]).toAbsolutePath().normalize();
            if (!Files.isRegularFile(file, new LinkOption[0])) {
                Logger.LOG.warning("Font file does not exist: " + path);
                return null;
            }
            Logger.LOG.info("Load font file: " + path);
            Font[] fonts = Font.loadFonts((String)file.toUri().toURL().toExternalForm(), (double)12.0);
            if (fonts == null) {
                Logger.LOG.warning("Failed to load font from " + path);
                return null;
            }
            if (fonts.length == 0) {
                Logger.LOG.warning("No fonts loaded from " + path);
                return null;
            }
            for (Font font : fonts) {
                if (!font.getFamily().equalsIgnoreCase(family)) continue;
                return font;
            }
            if (family.indexOf(44) >= 0) {
                for (String string : family.split(",")) {
                    for (Font font : fonts) {
                        if (!font.getFamily().equalsIgnoreCase(string)) continue;
                        return font;
                    }
                }
            }
            Logger.LOG.warning(String.format("Family '%s' not found in font file '%s'", family, path));
            return fonts[0];
        }
        catch (Throwable e) {
            Logger.LOG.warning("Failed to get default font with fc-match", e);
            return null;
        }
    }

    public static ReadOnlyObjectProperty<FontReference> fontProperty() {
        return font;
    }

    public static FontReference getFont() {
        return (FontReference)font.get();
    }

    public static void setFontFamily(String fontFamily) {
        ConfigHolder.config().setLauncherFontFamily(fontFamily);
        FontManager.updateFont();
    }

    private FontManager() {
    }

    static {
        FontManager.updateFont();
        Logger.LOG.info("Font: " + (font.get() != null ? ((FontReference)font.get()).family() : "System"));
    }

    public record FontReference(@NotNull String family, @Nullable String style) {
        public FontReference(@NotNull String family, @Nullable String style) {
            Objects.requireNonNull(family);
        }

        public FontReference(@NotNull String family) {
            this(family, null);
        }

        public FontReference(@NotNull Font font) {
            this(font.getFamily(), font.getStyle());
        }
    }
}

